/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.theme.SkyBluer;
import com.jgoodies.looks.windows.WindowsLookAndFeel;
import gnu.dtools.ritopt.BooleanOption;
import gnu.dtools.ritopt.StringOption;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.MetaData;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SplashScreen;
import net.sf.jabref.Util;
import net.sf.jabref.export.AutoSaveManager;
import net.sf.jabref.export.ExportFormats;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.IExportFormat;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.imports.AutosaveStartupPrompter;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspectionCommandLine;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.plugin.PluginCore;
import net.sf.jabref.plugin.PluginInstaller;
import net.sf.jabref.plugin.SidePanePlugin;
import net.sf.jabref.plugin.core.JabRefPlugin;
import net.sf.jabref.plugin.core.generated._JabRefPlugin;
import net.sf.jabref.remote.RemoteListener;
import net.sf.jabref.util.Pair;
import net.sf.jabref.wizard.auximport.AuxCommandLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JabRef {
    public static JabRef singleton;
    public static RemoteListener remoteListener;
    public JabRefFrame jrf;
    public gnu.dtools.ritopt.Options options;
    public Frame splashScreen = null;
    boolean graphicFailure = false;
    StringOption importFile;
    StringOption exportFile;
    StringOption exportPrefs;
    StringOption importPrefs;
    StringOption auxImExport;
    StringOption importToOpenBase;
    StringOption fetcherEngine;
    BooleanOption helpO;
    BooleanOption disableGui;
    BooleanOption blank;
    BooleanOption loadSess;
    BooleanOption showVersion;
    BooleanOption disableSplash;
    public static final int MAX_DIALOG_WARNINGS = 10;

    public static void main(String[] args) {
        new JabRef(args);
    }

    protected JabRef(String[] args) {
        String personalJournalList;
        singleton = this;
        System.setProperty("java.net.useSystemProxies", "true");
        System.getProperties().put("proxySet", "true");
        JabRefPreferences prefs = JabRefPreferences.getInstance();
        if (prefs.hasKey("deletePlugins") && prefs.get("deletePlugins").length() > 0) {
            String[] toDelete = prefs.getStringArray("deletePlugins");
            PluginInstaller.deletePluginsOnStartup(toDelete);
            prefs.put("deletePlugins", "");
        }
        Globals.startBackgroundTasks();
        Globals.prefs = prefs;
        Globals.setLanguage(prefs.get("language"), "");
        BibtexFields.setNumericFieldsFromPrefs();
        Globals.importFormatReader.resetImportFormats();
        BibtexEntryType.loadCustomEntryTypes(prefs);
        ExportFormats.initAllExports();
        Globals.initializeJournalNames();
        if (Globals.prefs.getBoolean("useRemoteServer")) {
            remoteListener = RemoteListener.openRemoteListener(this);
            if (remoteListener == null) {
                if (RemoteListener.sendToActiveJabRefInstance(args)) {
                    System.out.println(Globals.lang("Arguments passed on to running JabRef instance. Shutting down."));
                    System.exit(0);
                }
            } else {
                remoteListener.start();
            }
        }
        if ((personalJournalList = prefs.get("personalJournalList")) != null) {
            try {
                Globals.journalAbbrev.readJournalList(new File(personalJournalList));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.openWindow(this.processArguments(args, true));
    }

    private void setupOptions() {
        this.importFile = new StringOption("");
        this.exportFile = new StringOption("");
        this.helpO = new BooleanOption();
        this.disableGui = new BooleanOption();
        this.disableSplash = new BooleanOption();
        this.blank = new BooleanOption();
        this.loadSess = new BooleanOption();
        this.showVersion = new BooleanOption();
        this.exportPrefs = new StringOption("jabref_prefs.xml");
        this.importPrefs = new StringOption("jabref_prefs.xml");
        this.auxImExport = new StringOption("");
        this.importToOpenBase = new StringOption("");
        this.fetcherEngine = new StringOption("");
        this.options = new gnu.dtools.ritopt.Options("JabRef ");
        this.options.setVersion(GUIGlobals.version);
        this.importFile.setDescription("imopoepuoeu");
        this.options.register("version", 'v', Globals.lang("Display version"), this.showVersion);
        this.options.register("nogui", 'n', Globals.lang("No GUI. Only process command line options."), this.disableGui);
        this.options.register("nosplash", 's', Globals.lang("Do not show splash window at startup"), this.disableSplash);
        this.options.register("import", 'i', Globals.lang("Import file") + ": " + Globals.lang("filename") + "[,import format]", this.importFile);
        this.options.register("output", 'o', Globals.lang("Output or export file") + ": " + Globals.lang("filename") + "[,export format]", this.exportFile);
        this.options.register("help", 'h', Globals.lang("Display help on command line options"), this.helpO);
        this.options.register("loads", 'l', Globals.lang("Load session"), this.loadSess);
        this.options.register("prexp", 'x', Globals.lang("Export preferences to file"), this.exportPrefs);
        this.options.register("primp", 'p', Globals.lang("Import preferences from file"), this.importPrefs);
        this.options.register("aux", 'a', Globals.lang("Subdatabase from aux") + ": " + Globals.lang("file") + "[.aux]" + "," + Globals.lang("new") + "[.bib]", this.auxImExport);
        this.options.register("blank", 'b', Globals.lang("Do not open any files at startup"), this.blank);
        this.options.register("importToOpen", '\u0000', Globals.lang("Import to open tab"), this.importToOpenBase);
        this.options.register("fetch", 'f', Globals.lang("Run Fetcher, e.g. \"--fetch=Medline:cancer\""), this.fetcherEngine);
        this.options.setUseMenu(false);
    }

    public Vector<ParserResult> processArguments(String[] args, boolean initialStartup) {
        ParserResult res;
        ParserResult pr;
        boolean commandmode;
        this.setupOptions();
        String[] leftOver = this.options.process(args);
        if (initialStartup && this.showVersion.isInvoked()) {
            this.options.displayVersion();
            this.disableGui.setInvoked(true);
        }
        if (initialStartup && this.helpO.isInvoked()) {
            System.out.println("jabref [options] [bibtex-file]\n");
            System.out.println(this.options.getHelp());
            String importFormats = Globals.importFormatReader.getImportFormatList();
            System.out.println(Globals.lang("Available import formats") + ":\n" + importFormats);
            String outFormats = ExportFormats.getConsoleExportList(70, 20, "\t");
            System.out.println(Globals.lang("Available export formats") + ": " + outFormats + ".");
            System.exit(0);
        }
        boolean bl = commandmode = this.disableGui.isInvoked() || this.fetcherEngine.isInvoked();
        if (initialStartup && !commandmode && !this.disableSplash.isInvoked()) {
            try {
                this.splashScreen = SplashScreen.splash();
            }
            catch (Throwable ex) {
                this.graphicFailure = true;
                System.err.println(Globals.lang("Unable to create graphical interface") + ".");
            }
        }
        Vector<ParserResult> loaded = new Vector<ParserResult>();
        Vector<String> toImport = new Vector<String>();
        if (!this.blank.isInvoked() && leftOver.length > 0) {
            for (int i = 0; i < leftOver.length; ++i) {
                boolean bibExtension = leftOver[i].toLowerCase().endsWith("bib");
                pr = null;
                if (bibExtension) {
                    pr = JabRef.openBibFile(leftOver[i], false);
                }
                if (pr == null || pr == ParserResult.INVALID_FORMAT) {
                    if (initialStartup) {
                        toImport.add(leftOver[i]);
                        continue;
                    }
                    ParserResult res2 = JabRef.importToOpenBase(leftOver[i]);
                    if (res2 != null) {
                        loaded.add(res2);
                        continue;
                    }
                    loaded.add(ParserResult.INVALID_FORMAT);
                    continue;
                }
                if (pr == ParserResult.FILE_LOCKED) continue;
                loaded.add(pr);
            }
        }
        if (!this.blank.isInvoked() && this.importFile.isInvoked()) {
            toImport.add(this.importFile.getStringValue());
        }
        for (String filenameString : toImport) {
            pr = JabRef.importFile(filenameString);
            if (pr == null) continue;
            loaded.add(pr);
        }
        if (!this.blank.isInvoked() && this.importToOpenBase.isInvoked() && (res = JabRef.importToOpenBase(this.importToOpenBase.getStringValue())) != null) {
            loaded.add(res);
        }
        if (!this.blank.isInvoked() && this.fetcherEngine.isInvoked() && (res = this.fetch(this.fetcherEngine.getStringValue())) != null) {
            loaded.add(res);
        }
        if (this.exportFile.isInvoked()) {
            if (loaded.size() > 0) {
                String[] data = this.exportFile.getStringValue().split(",");
                if (data.length == 1) {
                    if (loaded.size() > 0) {
                        ParserResult pr2 = loaded.elementAt(loaded.size() - 1);
                        try {
                            System.out.println(Globals.lang("Saving") + ": " + data[0]);
                            SaveSession session = FileActions.saveDatabase(pr2.getDatabase(), new MetaData(pr2.getMetaData(), pr2.getDatabase()), new File(data[0]), Globals.prefs, false, false, Globals.prefs.get("defaultEncoding"), false);
                            if (!session.getWriter().couldEncodeAll()) {
                                System.err.println(Globals.lang("Warning") + ": " + Globals.lang("The chosen encoding '%0' could not encode the following characters: ", session.getEncoding()) + session.getWriter().getProblemCharacters());
                            }
                            session.commit();
                        }
                        catch (SaveException ex) {
                            System.err.println(Globals.lang("Could not save file") + " '" + data[0] + "': " + ex.getMessage());
                        }
                    } else {
                        System.err.println(Globals.lang("The output option depends on a valid import option."));
                    }
                } else if (data.length == 2) {
                    ParserResult pr3 = loaded.elementAt(loaded.size() - 1);
                    MetaData metaData = new MetaData(pr3.getMetaData(), pr3.getDatabase());
                    metaData.setFile(pr3.getFile());
                    Globals.prefs.fileDirForDatabase = metaData.getFileDirectory("file");
                    System.out.println(Globals.lang("Exporting") + ": " + data[0]);
                    IExportFormat format = ExportFormats.getExportFormat(data[1]);
                    if (format != null) {
                        try {
                            format.performExport(pr3.getDatabase(), new MetaData(pr3.getMetaData(), pr3.getDatabase()), data[0], pr3.getEncoding(), null);
                        }
                        catch (Exception ex) {
                            System.err.println(Globals.lang("Could not export file") + " '" + data[0] + "': " + ex.getMessage());
                        }
                    } else {
                        System.err.println(Globals.lang("Unknown export format") + ": " + data[1]);
                    }
                }
            } else {
                System.err.println(Globals.lang("The output option depends on a valid import option."));
            }
        }
        if (this.exportPrefs.isInvoked()) {
            try {
                Globals.prefs.exportPreferences(this.exportPrefs.getStringValue());
            }
            catch (IOException ex) {
                Util.pr(ex.getMessage());
            }
        }
        if (this.importPrefs.isInvoked()) {
            try {
                Globals.prefs.importPreferences(this.importPrefs.getStringValue());
                BibtexEntryType.loadCustomEntryTypes(Globals.prefs);
                ExportFormats.initAllExports();
            }
            catch (IOException ex) {
                Util.pr(ex.getMessage());
            }
        }
        if (!this.blank.isInvoked() && this.auxImExport.isInvoked()) {
            boolean usageMsg = false;
            if (loaded.size() > 0) {
                String[] data = this.auxImExport.getStringValue().split(",");
                if (data.length == 2) {
                    pr = loaded.firstElement();
                    AuxCommandLine acl = new AuxCommandLine(data[0], pr.getDatabase());
                    BibtexDatabase newBase = acl.perform();
                    boolean notSavedMsg = false;
                    if (newBase != null && newBase.getEntryCount() > 0) {
                        String subName = Util.getCorrectFileName(data[1], "bib");
                        try {
                            System.out.println(Globals.lang("Saving") + ": " + subName);
                            SaveSession session = FileActions.saveDatabase(newBase, new MetaData(), new File(subName), Globals.prefs, false, false, Globals.prefs.get("defaultEncoding"), false);
                            if (!session.getWriter().couldEncodeAll()) {
                                System.err.println(Globals.lang("Warning") + ": " + Globals.lang("The chosen encoding '%0' could not encode the following characters: ", session.getEncoding()) + session.getWriter().getProblemCharacters());
                            }
                            session.commit();
                        }
                        catch (SaveException ex) {
                            System.err.println(Globals.lang("Could not save file") + " '" + subName + "': " + ex.getMessage());
                        }
                        notSavedMsg = true;
                    }
                    if (!notSavedMsg) {
                        System.out.println(Globals.lang("no database generated"));
                    }
                } else {
                    usageMsg = true;
                }
            } else {
                usageMsg = true;
            }
            if (usageMsg) {
                System.out.println(Globals.lang("no base-bibtex-file specified"));
                System.out.println(Globals.lang("usage") + " :");
                System.out.println("jabref --aux infile[.aux],outfile[.bib] base-bibtex-file");
            }
        }
        return loaded;
    }

    protected ParserResult fetch(String fetchCommand) {
        if (fetchCommand == null || !fetchCommand.contains(":") || fetchCommand.split(":").length != 2) {
            System.out.println(Globals.lang("Expected syntax for --fetch='<name of fetcher>:<query>'"));
            System.out.println(Globals.lang("The following fetchers are available:"));
            return null;
        }
        String engine = fetchCommand.split(":")[0];
        String query = fetchCommand.split(":")[1];
        EntryFetcher fetcher = null;
        for (_JabRefPlugin.EntryFetcherExtension e : JabRefPlugin.getInstance(PluginCore.getManager()).getEntryFetcherExtensions()) {
            if (!engine.toLowerCase().equals(e.getId().replaceAll("Fetcher", "").toLowerCase())) continue;
            fetcher = e.getEntryFetcher();
        }
        if (fetcher == null) {
            System.out.println(Globals.lang("Could not find fetcher '%0'", engine));
            System.out.println(Globals.lang("The following fetchers are available:"));
            for (_JabRefPlugin.EntryFetcherExtension e : JabRefPlugin.getInstance(PluginCore.getManager()).getEntryFetcherExtensions()) {
                System.out.println("  " + e.getId().replaceAll("Fetcher", "").toLowerCase());
            }
            return null;
        }
        System.out.println(Globals.lang("Running Query '%0' with fetcher '%1'.", query, engine) + " " + Globals.lang("Please wait!"));
        Collection<BibtexEntry> result = new ImportInspectionCommandLine().query(query, fetcher);
        if (result == null || result.size() == 0) {
            System.out.println(Globals.lang("Query '%0' with fetcher '%1' did not return any results.", query, engine));
            return null;
        }
        return new ParserResult(result);
    }

    public void openWindow(Vector<ParserResult> loaded) {
        if (!this.graphicFailure && !this.disableGui.isInvoked()) {
            int i;
            ParserResult pr3;
            Util.performCompatibilityUpdate();
            GUIGlobals.setUpIconTheme();
            Globals.prefs.updateExternalFileTypes();
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            if (!Globals.ON_MAC) {
                FontPolicy fixedPolicy;
                FontSet fontSet;
                int fontSizes = Globals.prefs.getInt("menuFontSize");
                boolean overrideDefaultFonts = Globals.prefs.getBoolean("overrideDefaultFonts");
                String defaultLookAndFeel = Globals.ON_WIN ? GUIGlobals.windowsDefaultLookAndFeel : GUIGlobals.linuxDefaultLookAndFeel;
                String lookAndFeel = null;
                lookAndFeel = !Globals.prefs.getBoolean("useDefaultLookAndFeel") ? Globals.prefs.get("lookAndFeel") : defaultLookAndFeel;
                LookAndFeel lnf = null;
                Object objLnf = null;
                try {
                    objLnf = lookAndFeel != null ? Class.forName(lookAndFeel).newInstance() : Class.forName(defaultLookAndFeel).newInstance();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        objLnf = Class.forName(defaultLookAndFeel).newInstance();
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
                if (objLnf != null) {
                    lnf = objLnf;
                }
                if (lnf != null && lnf instanceof Plastic3DLookAndFeel) {
                    MetalLookAndFeel.setCurrentTheme(new SkyBluer());
                    int defaultIconSize = GUIGlobals.getImage("open").getIconWidth();
                    Options.setDefaultIconSize(new Dimension(defaultIconSize, defaultIconSize));
                    if (overrideDefaultFonts) {
                        fontSet = FontSets.createDefaultFontSet(new Font("Tahoma", 0, fontSizes), new Font("Tahoma", 0, fontSizes), new Font("Tahoma", 1, fontSizes));
                        fixedPolicy = FontPolicies.createFixedPolicy(fontSet);
                        Plastic3DLookAndFeel.setFontPolicy(fixedPolicy);
                    }
                } else if (lnf != null && lnf instanceof WindowsLookAndFeel) {
                    int defaultIconSize = GUIGlobals.getImage("open").getIconWidth();
                    Options.setDefaultIconSize(new Dimension(defaultIconSize, defaultIconSize));
                    if (overrideDefaultFonts) {
                        fontSet = FontSets.createDefaultFontSet(new Font("Tahoma", 0, fontSizes), new Font("Tahoma", 0, fontSizes), new Font("Tahoma", 1, fontSizes));
                        fixedPolicy = FontPolicies.createFixedPolicy(fontSet);
                        WindowsLookAndFeel.setFontPolicy(fixedPolicy);
                    }
                }
                if (lnf != null) {
                    try {
                        UIManager.setLookAndFeel(lnf);
                        if (!Globals.ON_WIN) {
                            UIManager.put("SimpleInternalFrame.activeTitleBackground", GUIGlobals.gradientBlue);
                        }
                        if (!Globals.ON_WIN && !Globals.ON_MAC) {
                            UIDefaults def = UIManager.getDefaults();
                            InputMap im = (InputMap)def.get("Button.focusInputMap");
                            im.put(KeyStroke.getKeyStroke(10, 0, false), "pressed");
                            im.put(KeyStroke.getKeyStroke(10, 0, true), "released");
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        System.err.println("Trying to set system default Look&Feel...");
                        try {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (!this.blank.isInvoked() && Globals.prefs.getBoolean("openLastEdited") && Globals.prefs.get("lastEdited") != null) {
                String[] names = Globals.prefs.getStringArray("lastEdited");
                block8: for (int i2 = 0; i2 < names.length; ++i2) {
                    ParserResult pr2;
                    File fileToOpen = new File(names[i2]);
                    for (int j = 0; j < loaded.size(); ++j) {
                        pr3 = loaded.elementAt(j);
                        if (pr3.getFile() != null && pr3.getFile().equals(fileToOpen)) continue block8;
                    }
                    if (!fileToOpen.exists() || (pr2 = JabRef.openBibFile(names[i2], false)) == null) continue;
                    if (pr2 == ParserResult.INVALID_FORMAT) {
                        System.out.println(Globals.lang("Error opening file") + " '" + fileToOpen.getPath() + "'");
                        continue;
                    }
                    if (pr2 == ParserResult.FILE_LOCKED) continue;
                    loaded.add(pr2);
                }
            }
            GUIGlobals.init();
            GUIGlobals.CURRENTFONT = new Font(Globals.prefs.get("fontFamily"), Globals.prefs.getInt("fontStyle"), Globals.prefs.getInt("fontSize"));
            this.jrf = new JabRefFrame();
            boolean first = true;
            ArrayList<File> postponed = new ArrayList<File>();
            ArrayList<ParserResult> failed = new ArrayList<ParserResult>();
            if (loaded.size() > 0) {
                Iterator<ParserResult> i3 = loaded.iterator();
                while (i3.hasNext()) {
                    pr3 = i3.next();
                    if (pr3.isInvalid()) {
                        failed.add(pr3);
                        i3.remove();
                        continue;
                    }
                    if (!pr3.isPostponedAutosaveFound()) {
                        this.jrf.addTab(pr3.getDatabase(), pr3.getFile(), pr3.getMetaData(), pr3.getEncoding(), first);
                        first = false;
                        continue;
                    }
                    i3.remove();
                    postponed.add(pr3.getFile());
                }
            }
            if (this.loadSess.isInvoked()) {
                this.jrf.loadSessionAction.actionPerformed(new ActionEvent(this.jrf, 0, ""));
            }
            if (this.splashScreen != null) {
                this.splashScreen.dispose();
                this.splashScreen = null;
            }
            if (Globals.prefs.getBoolean("autoSave")) {
                Globals.startAutoSaveManager(this.jrf);
            }
            this.jrf.setVisible(true);
            if (Globals.prefs.getBoolean("rememberWindowLocation") && Globals.prefs.getBoolean("windowMaximised")) {
                this.jrf.setExtendedState(6);
            }
            this.startSidePanePlugins(this.jrf);
            for (ParserResult pr3 : failed) {
                String message = "<html>" + Globals.lang("Error opening file '%0'.", pr3.getFile().getName()) + "<p>" + pr3.getErrorMessage() + "</html>";
                JOptionPane.showMessageDialog(this.jrf, message, Globals.lang("Error opening file"), 0);
            }
            for (i = 0; i < loaded.size(); ++i) {
                pr3 = loaded.elementAt(i);
                if (!Globals.prefs.getBoolean("displayKeyWarningDialogAtStartup") || !pr3.hasWarnings()) continue;
                String[] wrns = pr3.warnings();
                StringBuilder wrn = new StringBuilder();
                for (int j = 0; j < Math.min(10, wrns.length); ++j) {
                    wrn.append(j + 1).append(". ").append(wrns[j]).append("\n");
                }
                if (wrns.length > 10) {
                    wrn.append("... ");
                    wrn.append(Globals.lang("%0 warnings", String.valueOf(wrns.length)));
                } else if (wrn.length() > 0) {
                    wrn.deleteCharAt(wrn.length() - 1);
                }
                this.jrf.showBaseAt(i);
                JOptionPane.showMessageDialog(this.jrf, wrn.toString(), Globals.lang("Warnings"), 2);
            }
            for (i = 0; i < loaded.size(); ++i) {
                pr3 = loaded.elementAt(i);
                BasePanel panel = this.jrf.baseAt(i);
                OpenDatabaseAction.performPostOpenActions(panel, pr3, true);
            }
            if (postponed.size() > 0) {
                AutosaveStartupPrompter asp = new AutosaveStartupPrompter(this.jrf, postponed);
                SwingUtilities.invokeLater(asp);
            }
            if (loaded.size() > 0) {
                this.jrf.tabbedPane.setSelectedIndex(0);
                new FocusRequester(((BasePanel)this.jrf.tabbedPane.getComponentAt((int)0)).mainTable);
            }
        } else {
            System.exit(0);
        }
    }

    private void startSidePanePlugins(JabRefFrame jrf) {
        JabRefPlugin jabrefPlugin = JabRefPlugin.getInstance(PluginCore.getManager());
        List<_JabRefPlugin.SidePanePluginExtension> plugins = jabrefPlugin.getSidePanePluginExtensions();
        for (_JabRefPlugin.SidePanePluginExtension extension : plugins) {
            SidePanePlugin plugin = extension.getSidePanePlugin();
            plugin.init(jrf, jrf.sidePaneManager);
            SidePaneComponent comp = plugin.getSidePaneComponent();
            jrf.sidePaneManager.register(comp.getName(), comp);
            jrf.addPluginMenuItem(plugin.getMenuItem());
        }
    }

    public static ParserResult openBibFile(String name, boolean ignoreAutosave) {
        System.out.println(Globals.lang("Opening") + ": " + name);
        File file = new File(name);
        try {
            boolean autoSaveFound;
            if (!ignoreAutosave && (autoSaveFound = AutoSaveManager.newerAutoSaveExists(file))) {
                ParserResult postp = new ParserResult(null, null, null);
                postp.setPostponedAutosaveFound(true);
                postp.setFile(file);
                return postp;
            }
            if (!Util.waitForFileLock(file, 10)) {
                System.out.println(Globals.lang("Error opening file") + " '" + name + "'. " + "File is locked by another JabRef instance.");
                return ParserResult.FILE_LOCKED;
            }
            String encoding = Globals.prefs.get("defaultEncoding");
            ParserResult pr = OpenDatabaseAction.loadDatabase(file, encoding);
            if (pr == null) {
                pr = new ParserResult(null, null, null);
                pr.setFile(file);
                pr.setInvalid(true);
                return pr;
            }
            pr.setFile(file);
            if (pr.hasWarnings()) {
                String[] warn = pr.warnings();
                for (int i = 0; i < warn.length; ++i) {
                    System.out.println(Globals.lang("Warning") + ": " + warn[i]);
                }
            }
            return pr;
        }
        catch (Throwable ex) {
            ParserResult pr = new ParserResult(null, null, null);
            pr.setFile(file);
            pr.setInvalid(true);
            pr.setErrorMessage(ex.getMessage());
            return pr;
        }
    }

    public static ParserResult importFile(String argument) {
        String[] data = argument.split(",");
        try {
            if (data.length > 1 && !"*".equals(data[1])) {
                System.out.println(Globals.lang("Importing") + ": " + data[0]);
                List<BibtexEntry> entries = Globals.ON_WIN ? Globals.importFormatReader.importFromFile(data[1], data[0]) : Globals.importFormatReader.importFromFile(data[1], data[0].replaceAll("~", System.getProperty("user.home")));
                return new ParserResult(entries);
            }
            System.out.println(Globals.lang("Importing in unknown format") + ": " + data[0]);
            Pair<String, ParserResult> importResult = Globals.ON_WIN ? Globals.importFormatReader.importUnknownFormat(data[0]) : Globals.importFormatReader.importUnknownFormat(data[0].replaceAll("~", System.getProperty("user.home")));
            if (importResult != null) {
                System.out.println(Globals.lang("Format used") + ": " + (String)importResult.p);
                return (ParserResult)importResult.v;
            }
            System.out.println(Globals.lang("Could not find a suitable import format."));
        }
        catch (IOException ex) {
            System.err.println(Globals.lang("Error opening file") + " '" + data[0] + "': " + ex.getLocalizedMessage());
        }
        return null;
    }

    public static ParserResult importToOpenBase(String argument) {
        ParserResult result = JabRef.importFile(argument);
        if (result != null) {
            result.setToOpenTab(true);
        }
        return result;
    }

    static {
        remoteListener = null;
    }
}

