/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.Matcher;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif_lite.component.UIFSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BaseAction;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.CallBack;
import net.sf.jabref.CheckBoxMessage;
import net.sf.jabref.ContentSelectorDialog2;
import net.sf.jabref.DuplicateSearch;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.EntryTypeDialog;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreambleEditor;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.ReplaceStringDialog;
import net.sf.jabref.RightClickMenu;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.StringDialog;
import net.sf.jabref.TransferableBibtexEntry;
import net.sf.jabref.Util;
import net.sf.jabref.Worker;
import net.sf.jabref.autocompleter.AbstractAutoCompleter;
import net.sf.jabref.autocompleter.AutoCompleterFactory;
import net.sf.jabref.collab.ChangeScanner;
import net.sf.jabref.collab.FileUpdateListener;
import net.sf.jabref.collab.FileUpdatePanel;
import net.sf.jabref.export.ExportToClipboardAction;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.SaveDatabaseAction;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.external.AutoSetExternalFileForEntries;
import net.sf.jabref.external.ExternalFileMenuItem;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.FindFullTextAction;
import net.sf.jabref.external.RegExpFileSearch;
import net.sf.jabref.external.SynchronizeFileField;
import net.sf.jabref.external.UpgradeExternalLinks;
import net.sf.jabref.external.WriteXMPAction;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.gui.GlazedEntrySorter;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.gui.MainTableFormat;
import net.sf.jabref.gui.MainTableSelectionListener;
import net.sf.jabref.imports.AppendDatabaseAction;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.SPIRESFetcher;
import net.sf.jabref.journals.AbbreviateAction;
import net.sf.jabref.journals.UnabbreviateAction;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.search.NoSearchMatcher;
import net.sf.jabref.search.SearchMatcher;
import net.sf.jabref.sql.DBConnectDialog;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.DbConnectAction;
import net.sf.jabref.sql.SQLutil;
import net.sf.jabref.undo.CountingUndoManager;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableChangeType;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableKeyChange;
import net.sf.jabref.undo.UndoableRemoveEntry;
import net.sf.jabref.wizard.text.gui.TextInputDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasePanel
extends JPanel
implements ClipboardOwner,
FileUpdateListener {
    public static final int SHOWING_NOTHING = 0;
    public static final int SHOWING_PREVIEW = 1;
    public static final int SHOWING_EDITOR = 2;
    public static final int WILL_SHOW_EDITOR = 3;
    BibtexDatabase database;
    private int mode = 0;
    private EntryEditor currentEditor = null;
    private PreviewPanel currentPreview = null;
    boolean tmp = true;
    private MainTableSelectionListener selectionListener = null;
    private ListEventListener<BibtexEntry> groupsHighlightListener;
    UIFSplitPane contentPane = new UIFSplitPane();
    JSplitPane splitPane;
    JabRefFrame frame;
    String fileMonitorHandle = null;
    boolean saving = false;
    boolean updatedExternally = false;
    private String encoding;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    HashMap<String, AbstractAutoCompleter> autoCompleters = new HashMap();
    public CountingUndoManager undoManager = new CountingUndoManager(this);
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();
    private List<BibtexEntry> previousEntries = new ArrayList<BibtexEntry>();
    private List<BibtexEntry> nextEntries = new ArrayList<BibtexEntry>();
    boolean baseChanged = false;
    boolean nonUndoableChange = false;
    public MainTable mainTable = null;
    public MainTableFormat tableFormat = null;
    public FilterList<BibtexEntry> searchFilterList = null;
    public FilterList<BibtexEntry> groupFilterList = null;
    public RightClickMenu rcm;
    BibtexEntry showing = null;
    private boolean backOrForwardInProgress = false;
    public HashMap<String, EntryEditor> entryEditors = new HashMap();
    PreambleEditor preambleEditor = null;
    StringDialog stringDialog = null;
    SaveDatabaseAction saveAction;
    public boolean showingSearch = false;
    public boolean showingGroup = false;
    public boolean sortingBySearchResults = false;
    public boolean coloringBySearchResults = false;
    public boolean hidingNonHits = false;
    public boolean sortingByGroup = false;
    public boolean sortingByCiteSeerResults = false;
    public boolean coloringByGroup = false;
    int lastSearchHits = -1;
    MetaData metaData;
    private boolean suppressOutput = false;
    private HashMap<String, Object> actions = new HashMap();
    private SidePaneManager sidePaneManager;

    public BasePanel(JabRefFrame frame) {
        this.sidePaneManager = Globals.sidePaneManager;
        this.database = new BibtexDatabase();
        this.metaData = new MetaData();
        this.metaData.initializeNewDatabase();
        this.frame = frame;
        this.setupActions();
        this.setupMainPanel();
        this.encoding = Globals.prefs.get("defaultEncoding");
    }

    public BasePanel(JabRefFrame frame, BibtexDatabase db, File file, HashMap<String, String> meta, String encoding) {
        this.database = db;
        if (meta != null) {
            this.parseMetaData(meta);
        } else {
            this.metaData = new MetaData();
            this.metaData.initializeNewDatabase();
        }
        this.init(frame, db, file, this.metaData, encoding);
    }

    public BasePanel(JabRefFrame frame, BibtexDatabase db, File file, MetaData metaData, String encoding) {
        this.init(frame, db, file, metaData, encoding);
    }

    private void init(JabRefFrame frame, BibtexDatabase db, File file, MetaData metaData, String encoding) {
        this.encoding = encoding;
        this.metaData = metaData;
        this.sidePaneManager = Globals.sidePaneManager;
        this.frame = frame;
        this.database = db;
        this.setupActions();
        this.setupMainPanel();
        metaData.setFile(file);
        if (file != null) {
            try {
                this.fileMonitorHandle = Globals.fileUpdateMonitor.addUpdateListener(this, file);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public boolean isBaseChanged() {
        return this.baseChanged;
    }

    public int getMode() {
        return this.mode;
    }

    public BibtexDatabase database() {
        return this.database;
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public JabRefFrame frame() {
        return this.frame;
    }

    public JabRefPreferences prefs() {
        return Globals.prefs;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void output(String s) {
        if (!this.suppressOutput) {
            this.frame.output(s);
        }
    }

    private void setupActions() {
        this.saveAction = new SaveDatabaseAction(this);
        this.actions.put("undo", this.undoAction);
        this.actions.put("redo", this.redoAction);
        this.actions.put("focusTable", new BaseAction(){

            public void action() throws Throwable {
                new FocusRequester(BasePanel.this.mainTable);
            }
        });
        this.actions.put("edit", new BaseAction(){

            public void action() {
                BasePanel.this.selectionListener.editSignalled();
            }
        });
        this.actions.put("test", new FindFullTextAction(this));
        this.actions.put("save", this.saveAction);
        this.actions.put("saveAs", new BaseAction(){

            public void action() throws Throwable {
                BasePanel.this.saveAction.saveAs();
            }
        });
        this.actions.put("saveSelectedAs", new BaseAction(){

            public void action() throws Throwable {
                File expFile;
                String chosenFile = FileDialogs.getNewFile(BasePanel.this.frame, new File(Globals.prefs.get("workingDirectory")), ".bib", 1, false);
                if (!(chosenFile == null || (expFile = new File(chosenFile)).exists() && JOptionPane.showConfirmDialog(BasePanel.this.frame, "'" + expFile.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Save database"), 2) != 0)) {
                    BasePanel.this.saveDatabase(expFile, true, Globals.prefs.get("defaultEncoding"));
                    BasePanel.this.frame.getFileHistory().newFile(expFile.getPath());
                    BasePanel.this.frame.output(Globals.lang("Saved selected to") + " '" + expFile.getPath() + "'.");
                }
            }
        });
        this.actions.put("copy", new BaseAction(){

            public void action() {
                BibtexEntry[] bes = BasePanel.this.mainTable.getSelectedEntries();
                if (bes != null && bes.length > 0) {
                    TransferableBibtexEntry trbe = new TransferableBibtexEntry(bes);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trbe, BasePanel.this);
                    BasePanel.this.output(Globals.lang("Copied") + " " + (bes.length > 1 ? bes.length + " " + Globals.lang("entries") : "1 " + Globals.lang("entry") + "."));
                } else {
                    Object o;
                    int[] rows = BasePanel.this.mainTable.getSelectedRows();
                    int[] cols = BasePanel.this.mainTable.getSelectedColumns();
                    if (cols.length == 1 && rows.length == 1 && (o = BasePanel.this.mainTable.getValueAt(rows[0], cols[0])) != null) {
                        StringSelection ss = new StringSelection(o.toString());
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, BasePanel.this);
                        BasePanel.this.output(Globals.lang("Copied cell contents") + ".");
                    }
                }
            }
        });
        this.actions.put("cut", new BaseAction(){

            public void action() throws Throwable {
                BasePanel.this.runCommand("copy");
                BibtexEntry[] bes = BasePanel.this.mainTable.getSelectedEntries();
                if (bes != null && bes.length > 0) {
                    NamedCompound ce = new NamedCompound(Globals.lang(bes.length > 1 ? "cut entries" : "cut entry"));
                    for (int i = 0; i < bes.length; ++i) {
                        BasePanel.this.database.removeEntry(bes[i].getId());
                        BasePanel.this.ensureNotShowing(bes[i]);
                        ce.addEdit(new UndoableRemoveEntry(BasePanel.this.database, bes[i], BasePanel.this));
                    }
                    BasePanel.this.frame.output(Globals.lang("Cut_pr") + " " + (bes.length > 1 ? bes.length + " " + Globals.lang("entries") : Globals.lang("entry")) + ".");
                    ce.end();
                    BasePanel.this.undoManager.addEdit(ce);
                    BasePanel.this.markBaseChanged();
                }
            }
        });
        this.actions.put("delete", new BaseAction(){

            public void action() {
                BibtexEntry[] bes = BasePanel.this.mainTable.getSelectedEntries();
                if (bes != null && bes.length > 0) {
                    boolean goOn = BasePanel.this.showDeleteConfirmationDialog(bes.length);
                    if (!goOn) {
                        return;
                    }
                    NamedCompound ce = new NamedCompound(Globals.lang(bes.length > 1 ? "delete entries" : "delete entry"));
                    for (int i = 0; i < bes.length; ++i) {
                        BasePanel.this.database.removeEntry(bes[i].getId());
                        BasePanel.this.ensureNotShowing(bes[i]);
                        ce.addEdit(new UndoableRemoveEntry(BasePanel.this.database, bes[i], BasePanel.this));
                    }
                    BasePanel.this.markBaseChanged();
                    BasePanel.this.frame.output(Globals.lang("Deleted") + " " + (bes.length > 1 ? bes.length + " " + Globals.lang("entries") : Globals.lang("entry")) + ".");
                    ce.end();
                    BasePanel.this.undoManager.addEdit(ce);
                }
            }
        });
        this.actions.put("paste", new BaseAction(){

            public void action() {
                Transferable content = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                if (content != null) {
                    BibtexEntry[] bes = null;
                    if (content.isDataFlavorSupported(TransferableBibtexEntry.entryFlavor)) {
                        try {
                            bes = (BibtexEntry[])content.getTransferData(TransferableBibtexEntry.entryFlavor);
                        }
                        catch (UnsupportedFlavorException ex) {
                            ex.printStackTrace();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    } else if (content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        try {
                            BibtexParser bp = new BibtexParser(new StringReader((String)content.getTransferData(DataFlavor.stringFlavor)));
                            BibtexDatabase db = bp.parse().getDatabase();
                            Util.pr("Parsed " + db.getEntryCount() + " entries from clipboard text");
                            if (db.getEntryCount() > 0) {
                                bes = db.getEntries().toArray(new BibtexEntry[db.getEntryCount()]);
                            }
                        }
                        catch (UnsupportedFlavorException ex) {
                            ex.printStackTrace();
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (bes != null && bes.length > 0) {
                        NamedCompound ce = new NamedCompound(Globals.lang(bes.length > 1 ? "paste entries" : "paste entry"));
                        for (int i = 0; i < bes.length; ++i) {
                            try {
                                BibtexEntry be = (BibtexEntry)bes[i].clone();
                                Util.setAutomaticFields(be, Globals.prefs.getBoolean("overwriteOwner"), Globals.prefs.getBoolean("overwriteTimeStamp"));
                                be.setId(Util.createNeutralId());
                                BasePanel.this.database.insertEntry(be);
                                ce.addEdit(new UndoableInsertEntry(BasePanel.this.database, be, BasePanel.this));
                                continue;
                            }
                            catch (KeyCollisionException ex) {
                                Util.pr("KeyCollisionException... this shouldn't happen.");
                            }
                        }
                        ce.end();
                        BasePanel.this.undoManager.addEdit(ce);
                        BasePanel.this.output(Globals.lang("Pasted") + " " + (bes.length > 1 ? bes.length + " " + Globals.lang("entries") : "1 " + Globals.lang("entry")) + ".");
                        BasePanel.this.markBaseChanged();
                    }
                }
            }
        });
        this.actions.put("selectAll", new BaseAction(){

            public void action() {
                BasePanel.this.mainTable.selectAll();
            }
        });
        this.actions.put("editPreamble", new BaseAction(){

            public void action() {
                if (BasePanel.this.preambleEditor == null) {
                    PreambleEditor form = new PreambleEditor(BasePanel.this.frame, BasePanel.this, BasePanel.this.database, Globals.prefs);
                    Util.placeDialog(form, BasePanel.this.frame);
                    form.setVisible(true);
                    BasePanel.this.preambleEditor = form;
                } else {
                    BasePanel.this.preambleEditor.setVisible(true);
                }
            }
        });
        this.actions.put("editStrings", new BaseAction(){

            public void action() {
                if (BasePanel.this.stringDialog == null) {
                    StringDialog form = new StringDialog(BasePanel.this.frame, BasePanel.this, BasePanel.this.database, Globals.prefs);
                    Util.placeDialog(form, BasePanel.this.frame);
                    form.setVisible(true);
                    BasePanel.this.stringDialog = form;
                } else {
                    BasePanel.this.stringDialog.setVisible(true);
                }
            }
        });
        this.actions.put("toggleGroups", new BaseAction(){

            public void action() {
                BasePanel.this.sidePaneManager.toggle("groups");
                BasePanel.this.frame.groupToggle.setSelected(BasePanel.this.sidePaneManager.isComponentVisible("groups"));
            }
        });
        this.actions.put("dbConnect", new DbConnectAction(this));
        this.actions.put("dbExport", new AbstractWorker(){
            String errorMessage = null;
            boolean connectToDB = false;

            public void init() {
                DBStrings dbs = BasePanel.this.metaData.getDBStrings();
                if (!dbs.isConfigValid()) {
                    if (!dbs.isInitialized()) {
                        dbs.initialize();
                    }
                    DBConnectDialog dbd = new DBConnectDialog(BasePanel.this.frame(), dbs);
                    Util.placeDialog(dbd, BasePanel.this);
                    dbd.setVisible(true);
                    this.connectToDB = dbd.getConnectToDB();
                    if (this.connectToDB) {
                        dbs = dbd.getDBStrings();
                        BasePanel.this.metaData.setDBStrings(dbs);
                        dbd.dispose();
                    }
                } else {
                    this.connectToDB = true;
                }
            }

            public void run() {
                if (this.connectToDB) {
                    DBStrings dbs = BasePanel.this.metaData.getDBStrings();
                    try {
                        BasePanel.this.frame.output(Globals.lang("Attempting SQL export..."));
                        SQLutil.exportDatabase(BasePanel.this.database, BasePanel.this.metaData, null, dbs);
                        dbs.isConfigValid(true);
                    }
                    catch (Exception ex) {
                        this.errorMessage = SQLutil.getExceptionMessage(ex, SQLutil.DBTYPE.MYSQL);
                        dbs.isConfigValid(false);
                    }
                    BasePanel.this.metaData.setDBStrings(dbs);
                }
            }

            public void update() {
                String url = SQLutil.createJDBCurl(BasePanel.this.metaData.getDBStrings());
                if (this.errorMessage == null) {
                    if (this.connectToDB) {
                        BasePanel.this.frame.output(Globals.lang("%0 export successful", url));
                    }
                } else {
                    String preamble = "Could not export to SQL database for the following reason:";
                    BasePanel.this.frame.output(Globals.lang(preamble) + "  " + this.errorMessage);
                    JOptionPane.showMessageDialog(BasePanel.this.frame, Globals.lang(preamble) + "\n" + this.errorMessage, Globals.lang("Export to SQL database"), 0);
                    this.errorMessage = null;
                }
            }
        });
        this.actions.put("makeKey", new AbstractWorker(){
            List<BibtexEntry> entries;
            int numSelected;
            boolean cancelled = false;

            public void init() {
                this.entries = new ArrayList<BibtexEntry>(Arrays.asList(BasePanel.this.getSelectedEntries()));
                this.numSelected = this.entries.size();
                if (this.entries.size() == 0) {
                    JOptionPane.showMessageDialog(BasePanel.this.frame, Globals.lang("First select the entries you want keys to be generated for."), Globals.lang("Autogenerate BibTeX key"), 1);
                    return;
                }
                BasePanel.this.frame.block();
                BasePanel.this.output(Globals.lang("Generating BibTeX key for") + " " + this.numSelected + " " + (this.numSelected > 1 ? Globals.lang("entries") : Globals.lang("entry")) + "...");
            }

            public void run() {
                BibtexEntry bes2 = null;
                NamedCompound ce = new NamedCompound(Globals.lang("autogenerate keys"));
                Iterator<BibtexEntry> i = this.entries.iterator();
                while (i.hasNext()) {
                    bes2 = i.next();
                    if (bes2.getField("bibtexkey") == null) continue;
                    if (Globals.prefs.getBoolean("avoidOverwritingKey")) {
                        i.remove();
                        continue;
                    }
                    if (!Globals.prefs.getBoolean("warnBeforeOverwritingKey")) continue;
                    CheckBoxMessage cbm = new CheckBoxMessage(Globals.lang("One or more keys will be overwritten. Continue?"), Globals.lang("Disable this confirmation dialog"), false);
                    int answer = JOptionPane.showConfirmDialog(BasePanel.this.frame, cbm, Globals.lang("Overwrite keys"), 0);
                    if (cbm.isSelected()) {
                        Globals.prefs.putBoolean("warnBeforeOverwritingKey", false);
                    }
                    if (answer != 1) break;
                    this.cancelled = true;
                    return;
                }
                HashMap<BibtexEntry, String> oldvals = new HashMap<BibtexEntry, String>();
                if (!Globals.prefs.getBoolean("avoidOverwritingKey")) {
                    for (BibtexEntry bes2 : this.entries) {
                        oldvals.put(bes2, bes2.getField("bibtexkey"));
                        BasePanel.this.database.setCiteKeyForEntry(bes2.getId(), null);
                    }
                }
                for (BibtexEntry bes2 : this.entries) {
                    bes2 = LabelPatternUtil.makeLabel(Globals.prefs.getKeyPattern(), BasePanel.this.database, bes2);
                    ce.addEdit(new UndoableKeyChange(BasePanel.this.database, bes2.getId(), (String)oldvals.get(bes2), bes2.getField("bibtexkey")));
                }
                ce.end();
                BasePanel.this.undoManager.addEdit(ce);
            }

            public void update() {
                if (this.cancelled) {
                    BasePanel.this.frame.unblock();
                    return;
                }
                BasePanel.this.markBaseChanged();
                this.numSelected = this.entries.size();
                for (final BibtexEntry bibEntry : this.entries) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            int row = BasePanel.this.mainTable.findEntry(bibEntry);
                            if (row >= 0 && BasePanel.this.mainTable.getSelectedRowCount() < entries.size()) {
                                BasePanel.this.mainTable.addRowSelectionInterval(row, row);
                            }
                        }
                    });
                }
                BasePanel.this.output(Globals.lang("Generated BibTeX key for") + " " + this.numSelected + " " + (this.numSelected != 1 ? Globals.lang("entries") : Globals.lang("entry")));
                BasePanel.this.frame.unblock();
            }
        });
        this.actions.put("search", new BaseAction(){

            public void action() {
                BasePanel.this.sidePaneManager.show("search");
                BasePanel.this.frame.searchToggle.setSelected(true);
                BasePanel.this.frame.searchManager.startSearch();
            }
        });
        this.actions.put("toggleSearch", new BaseAction(){

            public void action() {
                BasePanel.this.sidePaneManager.toggle("search");
                boolean on = BasePanel.this.sidePaneManager.isComponentVisible("search");
                BasePanel.this.frame.searchToggle.setSelected(on);
                if (on) {
                    BasePanel.this.frame.searchManager.startSearch();
                }
            }
        });
        this.actions.put("incSearch", new BaseAction(){

            public void action() {
                BasePanel.this.sidePaneManager.show("search");
                BasePanel.this.frame.searchToggle.setSelected(true);
                BasePanel.this.frame.searchManager.startIncrementalSearch();
            }
        });
        this.actions.put("copyKey", new BaseAction(){

            public void action() {
                BibtexEntry[] bes = BasePanel.this.mainTable.getSelectedEntries();
                if (bes != null && bes.length > 0) {
                    BasePanel.this.storeCurrentEdit();
                    Vector<String> keys = new Vector<String>();
                    for (int i = 0; i < bes.length; ++i) {
                        if (bes[i].getField("bibtexkey") == null) continue;
                        keys.add(bes[i].getField("bibtexkey"));
                    }
                    if (keys.size() == 0) {
                        BasePanel.this.output("None of the selected entries have BibTeX keys.");
                        return;
                    }
                    StringBuffer sb = new StringBuffer((String)keys.elementAt(0));
                    for (int i = 1; i < keys.size(); ++i) {
                        sb.append(',');
                        sb.append((String)keys.elementAt(i));
                    }
                    StringSelection ss = new StringSelection(sb.toString());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, BasePanel.this);
                    if (keys.size() == bes.length) {
                        BasePanel.this.output(Globals.lang(bes.length > 1 ? "Copied keys" : "Copied key") + ".");
                    } else {
                        BasePanel.this.output(Globals.lang("Warning") + ": " + (bes.length - keys.size()) + " " + Globals.lang("out of") + " " + bes.length + " " + Globals.lang("entries have undefined BibTeX key") + ".");
                    }
                }
            }
        });
        this.actions.put("copyCiteKey", new BaseAction(){

            public void action() {
                BibtexEntry[] bes = BasePanel.this.mainTable.getSelectedEntries();
                if (bes != null && bes.length > 0) {
                    BasePanel.this.storeCurrentEdit();
                    Vector<String> keys = new Vector<String>();
                    for (int i = 0; i < bes.length; ++i) {
                        if (bes[i].getField("bibtexkey") == null) continue;
                        keys.add(bes[i].getField("bibtexkey"));
                    }
                    if (keys.size() == 0) {
                        BasePanel.this.output("None of the selected entries have BibTeX keys.");
                        return;
                    }
                    StringBuffer sb = new StringBuffer((String)keys.elementAt(0));
                    for (int i = 1; i < keys.size(); ++i) {
                        sb.append(',');
                        sb.append((String)keys.elementAt(i));
                    }
                    StringSelection ss = new StringSelection("\\cite{" + sb.toString() + "}");
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, BasePanel.this);
                    if (keys.size() == bes.length) {
                        BasePanel.this.output(Globals.lang(bes.length > 1 ? "Copied keys" : "Copied key") + ".");
                    } else {
                        BasePanel.this.output(Globals.lang("Warning") + ": " + (bes.length - keys.size()) + " " + Globals.lang("out of") + " " + bes.length + " " + Globals.lang("entries have undefined BibTeX key") + ".");
                    }
                }
            }
        });
        this.actions.put("mergeDatabase", new AppendDatabaseAction(this.frame, this));
        this.actions.put("openFile", new BaseAction(){

            public void action() {
                new Thread(){

                    public void run() {
                        BibtexEntry[] bes = BasePanel.this.mainTable.getSelectedEntries();
                        String field = "ps";
                        if (bes != null && bes.length == 1) {
                            FileListEntry entry = null;
                            FileListTableModel tm = new FileListTableModel();
                            tm.setContent(bes[0].getField("file"));
                            for (int i = 0; i < tm.getRowCount(); ++i) {
                                FileListEntry flEntry = tm.getEntry(i);
                                if (!flEntry.getType().getName().toLowerCase().equals("pdf") && !flEntry.getType().getName().toLowerCase().equals("ps")) continue;
                                entry = flEntry;
                                break;
                            }
                            if (entry != null) {
                                try {
                                    Util.openExternalFileAnyFormat(BasePanel.this.metaData, entry.getLink(), entry.getType());
                                    BasePanel.this.output(Globals.lang("External viewer called") + ".");
                                }
                                catch (IOException e) {
                                    BasePanel.this.output(Globals.lang("Could not open link"));
                                    e.printStackTrace();
                                }
                                return;
                            }
                            String link = bes[0].getField("ps");
                            if (bes[0].getField("pdf") != null) {
                                link = bes[0].getField("pdf");
                                field = "pdf";
                            }
                            String filepath = null;
                            if (link != null) {
                                filepath = link.toString();
                            } else if (Globals.prefs.getBoolean("runAutomaticFileSearch")) {
                                String extension;
                                ExternalFileType type;
                                int index;
                                List<File> res;
                                Map<BibtexEntry, List<File>> result;
                                ArrayList<BibtexEntry> entries = new ArrayList<BibtexEntry>();
                                entries.add(bes[0]);
                                ExternalFileType[] types = Globals.prefs.getExternalFileTypeSelection();
                                ArrayList<File> dirs = new ArrayList<File>();
                                if (BasePanel.this.metaData.getFileDirectory("file") != null) {
                                    dirs.add(new File(BasePanel.this.metaData.getFileDirectory("file")));
                                }
                                ArrayList<String> extensions = new ArrayList<String>();
                                for (int i = 0; i < types.length; ++i) {
                                    ExternalFileType type2 = types[i];
                                    extensions.add(type2.getExtension());
                                }
                                if (Globals.prefs.getBoolean("useRegExpSearch")) {
                                    String regExp = Globals.prefs.get("regExpSearchExpression");
                                    result = RegExpFileSearch.findFilesForSet(entries, extensions, dirs, regExp);
                                } else {
                                    result = Util.findAssociatedFiles(entries, extensions, dirs);
                                }
                                if (result.get(bes[0]) != null && (res = result.get(bes[0])).size() > 0 && (index = (filepath = res.get(0).getPath()).lastIndexOf(46)) >= 0 && index < filepath.length() - 1 && (type = Globals.prefs.getExternalFileTypeByExt(extension = filepath.substring(index + 1))) != null) {
                                    try {
                                        Util.openExternalFileAnyFormat(BasePanel.this.metaData, filepath, type);
                                        BasePanel.this.output(Globals.lang("External viewer called") + ".");
                                        return;
                                    }
                                    catch (IOException ex) {
                                        BasePanel.this.output(Globals.lang("Error") + ": " + ex.getMessage());
                                    }
                                }
                            }
                            if (filepath != null) {
                                try {
                                    Util.openExternalViewer(BasePanel.this.metaData(), filepath, field);
                                    BasePanel.this.output(Globals.lang("External viewer called") + ".");
                                }
                                catch (IOException ex) {
                                    BasePanel.this.output(Globals.lang("Error") + ": " + ex.getMessage());
                                }
                            } else {
                                BasePanel.this.output(Globals.lang("No pdf or ps defined, and no file matching Bibtex key found") + ".");
                            }
                        } else {
                            BasePanel.this.output(Globals.lang("No entries or multiple entries selected."));
                        }
                    }
                }.start();
            }
        });
        this.actions.put("openExternalFile", new BaseAction(){

            public void action() {
                new Thread(){

                    public void run() {
                        BibtexEntry[] bes = BasePanel.this.mainTable.getSelectedEntries();
                        String field = "file";
                        if (bes != null && bes.length == 1) {
                            String link = bes[0].getField(field);
                            if (link == null) {
                                BasePanel.this.runCommand("openFile");
                                return;
                            }
                            FileListTableModel tableModel = new FileListTableModel();
                            tableModel.setContent(link);
                            if (tableModel.getRowCount() == 0) {
                                BasePanel.this.runCommand("openFile");
                                return;
                            }
                            FileListEntry flEntry = tableModel.getEntry(0);
                            ExternalFileMenuItem item = new ExternalFileMenuItem(BasePanel.this.frame(), bes[0], "", flEntry.getLink(), (Icon)flEntry.getType().getIcon(), BasePanel.this.metaData(), flEntry.getType());
                            item.openLink();
                        } else {
                            BasePanel.this.output(Globals.lang("No entries or multiple entries selected."));
                        }
                    }
                }.start();
            }
        });
        this.actions.put("openUrl", new BaseAction(){

            public void action() {
                BibtexEntry[] bes = BasePanel.this.mainTable.getSelectedEntries();
                String field = "doi";
                if (bes != null && bes.length == 1) {
                    String link = bes[0].getField("doi");
                    if (bes[0].getField("url") != null) {
                        link = bes[0].getField("url");
                        field = "url";
                    }
                    if (link != null) {
                        try {
                            Util.openExternalViewer(BasePanel.this.metaData(), link.toString(), field);
                            BasePanel.this.output(Globals.lang("External viewer called") + ".");
                        }
                        catch (IOException ex) {
                            BasePanel.this.output(Globals.lang("Error") + ": " + ex.getMessage());
                        }
                    } else {
                        BasePanel.this.output(Globals.lang("No url defined") + ".");
                    }
                } else {
                    BasePanel.this.output(Globals.lang("No entries or multiple entries selected."));
                }
            }
        });
        this.actions.put("openSpires", new BaseAction(){

            public void action() {
                BibtexEntry[] bes = BasePanel.this.mainTable.getSelectedEntries();
                if (bes != null && bes.length == 1) {
                    String link = null;
                    if (bes[0].getField("eprint") != null) {
                        link = SPIRESFetcher.constructUrlFromEprint(bes[0].getField("eprint").toString());
                    } else if (bes[0].getField("slaccitation") != null) {
                        link = SPIRESFetcher.constructUrlFromSlaccitation(bes[0].getField("slaccitation").toString());
                    }
                    if (link != null) {
                        try {
                            Util.openExternalViewer(BasePanel.this.metaData(), link.toString(), "url");
                            BasePanel.this.output(Globals.lang("External viewer called") + ".");
                        }
                        catch (IOException ex) {
                            BasePanel.this.output(Globals.lang("Error") + ": " + ex.getMessage());
                        }
                    } else {
                        BasePanel.this.output(Globals.lang("No url defined") + ".");
                    }
                } else {
                    BasePanel.this.output(Globals.lang("No entries or multiple entries selected."));
                }
            }
        });
        this.actions.put("replaceAll", new BaseAction(){

            public void action() {
                ReplaceStringDialog rsd = new ReplaceStringDialog(BasePanel.this.frame);
                rsd.setVisible(true);
                if (!rsd.okPressed()) {
                    return;
                }
                int counter = 0;
                NamedCompound ce = new NamedCompound(Globals.lang("Replace string"));
                if (!rsd.selOnly()) {
                    for (BibtexEntry entry : BasePanel.this.database.getEntries()) {
                        counter += rsd.replace(entry, ce);
                    }
                } else {
                    BibtexEntry[] bes = BasePanel.this.mainTable.getSelectedEntries();
                    for (int i = 0; i < bes.length; ++i) {
                        counter += rsd.replace(bes[i], ce);
                    }
                }
                BasePanel.this.output(Globals.lang("Replaced") + " " + counter + " " + Globals.lang(counter == 1 ? "occurence" : "occurences") + ".");
                if (counter > 0) {
                    ce.end();
                    BasePanel.this.undoManager.addEdit(ce);
                    BasePanel.this.markBaseChanged();
                }
            }
        });
        this.actions.put("dupliCheck", new BaseAction(){

            public void action() {
                DuplicateSearch ds = new DuplicateSearch(BasePanel.this);
                ds.start();
            }
        });
        this.actions.put("plainTextImport", new BaseAction(){

            public void action() {
                EntryTypeDialog etd = new EntryTypeDialog(BasePanel.this.frame);
                Util.placeDialog(etd, BasePanel.this);
                etd.setVisible(true);
                BibtexEntryType tp = etd.getChoice();
                if (tp == null) {
                    return;
                }
                String id = Util.createNeutralId();
                BibtexEntry bibEntry = new BibtexEntry(id, tp);
                TextInputDialog tidialog = new TextInputDialog(BasePanel.this.frame, BasePanel.this, "import", true, bibEntry);
                Util.placeDialog(tidialog, BasePanel.this);
                tidialog.setVisible(true);
                if (tidialog.okPressed()) {
                    Util.setAutomaticFields(Arrays.asList(bibEntry), false, false, false);
                    BasePanel.this.insertEntry(bibEntry);
                }
            }
        });
        this.actions.put("markEntries", new AbstractWorker(){
            private int besLength = -1;

            public void run() {
                NamedCompound ce = new NamedCompound(Globals.lang("Mark entries"));
                BibtexEntry[] bes = BasePanel.this.mainTable.getSelectedEntries();
                this.besLength = bes.length;
                for (int i = 0; i < bes.length; ++i) {
                    Util.markEntry(bes[i], ce);
                }
                ce.end();
                BasePanel.this.undoManager.addEdit(ce);
            }

            public void update() {
                BasePanel.this.markBaseChanged();
                BasePanel.this.output(Globals.lang("Marked selected") + " " + Globals.lang(this.besLength > 0 ? "entry" : "entries"));
            }
        });
        this.actions.put("unmarkEntries", new BaseAction(){

            public void action() {
                try {
                    NamedCompound ce = new NamedCompound(Globals.lang("Unmark entries"));
                    BibtexEntry[] bes = BasePanel.this.mainTable.getSelectedEntries();
                    if (bes == null) {
                        return;
                    }
                    for (int i = 0; i < bes.length; ++i) {
                        Util.unmarkEntry(bes[i], BasePanel.this.database, ce);
                    }
                    ce.end();
                    BasePanel.this.undoManager.addEdit(ce);
                    BasePanel.this.markBaseChanged();
                    BasePanel.this.output(Globals.lang("Unmarked selected") + " " + Globals.lang(bes.length > 0 ? "entry" : "entries"));
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.actions.put("unmarkAll", new BaseAction(){

            public void action() {
                NamedCompound ce = new NamedCompound(Globals.lang("Unmark all"));
                for (BibtexEntry be : BasePanel.this.database.getEntries()) {
                    Util.unmarkEntry(be, BasePanel.this.database, ce);
                }
                ce.end();
                BasePanel.this.undoManager.addEdit(ce);
                BasePanel.this.markBaseChanged();
            }
        });
        this.actions.put("togglePreview", new BaseAction(){

            public void action() {
                boolean enabled = !Globals.prefs.getBoolean("previewEnabled");
                Globals.prefs.putBoolean("previewEnabled", enabled);
                BasePanel.this.frame.setPreviewActive(enabled);
                BasePanel.this.frame.previewToggle.setSelected(enabled);
            }
        });
        this.actions.put("toggleHighlightGroupsMatchingAny", new BaseAction(){

            public void action() {
                boolean enabled = !Globals.prefs.getBoolean("highlightGroupsMatchingAny");
                Globals.prefs.putBoolean("highlightGroupsMatchingAny", enabled);
                BasePanel.this.frame.highlightAny.setSelected(enabled);
                if (enabled) {
                    BasePanel.this.frame.highlightAll.setSelected(false);
                    Globals.prefs.putBoolean("highlightGroupsMatchingAll", false);
                }
                BasePanel.this.groupsHighlightListener.listChanged(null);
            }
        });
        this.actions.put("toggleHighlightGroupsMatchingAll", new BaseAction(){

            public void action() {
                boolean enabled = !Globals.prefs.getBoolean("highlightGroupsMatchingAll");
                Globals.prefs.putBoolean("highlightGroupsMatchingAll", enabled);
                BasePanel.this.frame.highlightAll.setSelected(enabled);
                if (enabled) {
                    BasePanel.this.frame.highlightAny.setSelected(false);
                    Globals.prefs.putBoolean("highlightGroupsMatchingAny", false);
                }
                BasePanel.this.groupsHighlightListener.listChanged(null);
            }
        });
        this.actions.put("switchPreview", new BaseAction(){

            public void action() {
                BasePanel.this.selectionListener.switchPreview();
            }
        });
        this.actions.put("manageSelectors", new BaseAction(){

            public void action() {
                ContentSelectorDialog2 csd = new ContentSelectorDialog2(BasePanel.this.frame, BasePanel.this.frame, BasePanel.this, false, BasePanel.this.metaData, null);
                Util.placeDialog(csd, BasePanel.this.frame);
                csd.setVisible(true);
            }
        });
        this.actions.put("exportToClipboard", new ExportToClipboardAction(this.frame, this.database()));
        this.actions.put("writeXMP", new WriteXMPAction(this));
        this.actions.put("abbreviateIso", new AbbreviateAction(this, true));
        this.actions.put("abbreviateMedline", new AbbreviateAction(this, false));
        this.actions.put("unabbreviate", new UnabbreviateAction(this));
        this.actions.put("autoSetPdf", new AutoSetExternalFileForEntries(this, "pdf"));
        this.actions.put("autoSetPs", new AutoSetExternalFileForEntries(this, "ps"));
        this.actions.put("autoSetFile", new SynchronizeFileField(this));
        this.actions.put("upgradeLinks", new UpgradeExternalLinks(this));
        this.actions.put("back", new BaseAction(){

            public void action() throws Throwable {
                BasePanel.this.back();
            }
        });
        this.actions.put("forward", new BaseAction(){

            public void action() throws Throwable {
                BasePanel.this.forward();
            }
        });
        this.actions.put("downloadFullText", new FindFullTextAction(this));
    }

    public void runCommand(String _command) {
        String command = _command;
        if (this.actions.get(command) == null) {
            Util.pr("No action defined for'" + command + "'");
        } else {
            Object o = this.actions.get(command);
            try {
                if (o instanceof BaseAction) {
                    ((BaseAction)o).action();
                } else {
                    Worker wrk = ((AbstractWorker)o).getWorker();
                    CallBack clb = ((AbstractWorker)o).getCallBack();
                    ((AbstractWorker)o).init();
                    wrk.run();
                    clb.update();
                }
            }
            catch (Throwable ex) {
                this.frame.unblock();
                ex.printStackTrace();
            }
        }
    }

    private boolean saveDatabase(File file, boolean selectedOnly, String encoding) throws SaveException {
        SaveSession session;
        this.frame.block();
        try {
            session = !selectedOnly ? FileActions.saveDatabase(this.database, this.metaData, file, Globals.prefs, false, false, encoding, false) : FileActions.savePartOfDatabase(this.database, this.metaData, file, Globals.prefs, this.mainTable.getSelectedEntries(), encoding);
        }
        catch (UnsupportedCharsetException ex2) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not save file. Character encoding '%0' is not supported.", encoding), Globals.lang("Save database"), 0);
            throw new SaveException("rt");
        }
        catch (SaveException ex) {
            if (ex.specificEntry()) {
                int row = this.mainTable.findEntry(ex.getEntry());
                int topShow = Math.max(0, row - 3);
                this.mainTable.setRowSelectionInterval(row, row);
                this.mainTable.scrollTo(topShow);
                this.showEntry(ex.getEntry());
            } else {
                ex.printStackTrace();
            }
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not save file") + ".\n" + ex.getMessage(), Globals.lang("Save database"), 0);
            throw new SaveException("rt");
        }
        finally {
            this.frame.unblock();
        }
        boolean commit = true;
        if (!session.getWriter().couldEncodeAll()) {
            DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref", ""));
            JTextArea ta = new JTextArea(session.getWriter().getProblemCharacters());
            ta.setEditable(false);
            builder.append(Globals.lang("The chosen encoding '%0' could not encode the following characters: ", session.getEncoding()));
            builder.append(ta);
            builder.append(Globals.lang("What do you want to do?"));
            String tryDiff = Globals.lang("Try different encoding");
            int answer = JOptionPane.showOptionDialog(this.frame, builder.getPanel(), Globals.lang("Save database"), 1, 2, null, new String[]{Globals.lang("Save"), tryDiff, Globals.lang("Cancel")}, tryDiff);
            if (answer == 1) {
                Object choice = JOptionPane.showInputDialog(this.frame, Globals.lang("Select encoding"), Globals.lang("Save database"), 3, null, Globals.ENCODINGS, encoding);
                if (choice != null) {
                    String newEncoding = (String)choice;
                    return this.saveDatabase(file, selectedOnly, newEncoding);
                }
                commit = false;
            } else if (answer == 2) {
                commit = false;
            }
        }
        try {
            if (commit) {
                session.commit();
                this.encoding = encoding;
            } else {
                session.cancel();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return commit;
    }

    public BibtexEntry newEntry(BibtexEntryType type) {
        if (type == null) {
            EntryTypeDialog etd = new EntryTypeDialog(this.frame);
            Util.placeDialog(etd, this.frame);
            etd.setVisible(true);
            type = etd.getChoice();
        }
        if (type != null) {
            String id = Util.createNeutralId();
            BibtexEntry be = new BibtexEntry(id, type);
            try {
                int row;
                this.database.insertEntry(be);
                ArrayList<BibtexEntry> list = new ArrayList<BibtexEntry>();
                list.add(be);
                Util.setAutomaticFields(list, true, true, false);
                this.undoManager.addEdit(new UndoableInsertEntry(this.database, be, this));
                this.output(Globals.lang("Added new") + " '" + type.getName().toLowerCase() + "' " + Globals.lang("entry") + ".");
                if (this.mode != 2) {
                    this.mode = 3;
                }
                if ((row = this.mainTable.findEntry(be)) >= 0) {
                    this.highlightEntry(be);
                } else {
                    this.showEntry(be);
                }
                this.markBaseChanged();
                new FocusRequester(this.getEntryEditor(be));
                return be;
            }
            catch (KeyCollisionException ex) {
                Util.pr(ex.getMessage());
            }
        }
        return null;
    }

    public void insertEntry(BibtexEntry bibEntry) {
        if (bibEntry != null) {
            try {
                this.database.insertEntry(bibEntry);
                if (Globals.prefs.getBoolean("useOwner")) {
                    bibEntry.setField("owner", Globals.prefs.get("defaultOwner"));
                }
                this.undoManager.addEdit(new UndoableInsertEntry(this.database, bibEntry, this));
                this.output(Globals.lang("Added new") + " '" + bibEntry.getType().getName().toLowerCase() + "' " + Globals.lang("entry") + ".");
                int row = this.mainTable.findEntry(bibEntry);
                this.mainTable.clearSelection();
                this.mainTable.scrollTo(row);
                this.markBaseChanged();
                if (Globals.prefs.getBoolean("autoOpenForm")) {
                    this.showEntry(bibEntry);
                }
            }
            catch (KeyCollisionException ex) {
                Util.pr(ex.getMessage());
            }
        }
    }

    public void updateTableFont() {
        this.mainTable.updateFont();
    }

    public void createMainTable() {
        GlazedEntrySorter eventList = new GlazedEntrySorter(this.database.getEntryMap());
        this.database.addDatabaseChangeListener(eventList);
        this.groupFilterList = new FilterList<BibtexEntry>(eventList.getTheList(), NoSearchMatcher.INSTANCE);
        this.searchFilterList = new FilterList<BibtexEntry>(this.groupFilterList, NoSearchMatcher.INSTANCE);
        this.tableFormat = new MainTableFormat(this);
        this.tableFormat.updateTableFormat();
        this.mainTable = new MainTable(this.tableFormat, this.searchFilterList, this.frame, this);
        this.selectionListener = new MainTableSelectionListener(this, this.mainTable);
        this.mainTable.updateFont();
        this.mainTable.addSelectionListener(this.selectionListener);
        this.mainTable.addMouseListener(this.selectionListener);
        this.mainTable.addKeyListener(this.selectionListener);
        this.mainTable.addFocusListener(this.selectionListener);
        this.groupsHighlightListener = new ListEventListener<BibtexEntry>(){

            @Override
            public void listChanged(ListEvent<BibtexEntry> listEvent) {
                if (Globals.prefs.getBoolean("highlightGroupsMatchingAny")) {
                    BasePanel.this.getGroupSelector().showMatchingGroups(BasePanel.this.mainTable.getSelectedEntries(), false);
                } else if (Globals.prefs.getBoolean("highlightGroupsMatchingAll")) {
                    BasePanel.this.getGroupSelector().showMatchingGroups(BasePanel.this.mainTable.getSelectedEntries(), true);
                } else {
                    BasePanel.this.getGroupSelector().showMatchingGroups(null, true);
                }
            }
        };
        this.mainTable.addSelectionListener(this.groupsHighlightListener);
        this.mainTable.getActionMap().put("cut", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BasePanel.this.runCommand("cut");
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.mainTable.getActionMap().put("copy", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BasePanel.this.runCommand("copy");
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.mainTable.getActionMap().put("paste", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BasePanel.this.runCommand("paste");
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.mainTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                GroupTreeNode node;
                int keyCode = e.getKeyCode();
                TreePath path = BasePanel.this.frame.groupSelector.getSelectionPath();
                GroupTreeNode groupTreeNode = node = path == null ? null : (GroupTreeNode)path.getLastPathComponent();
                if (e.isControlDown()) {
                    switch (keyCode) {
                        case 38: {
                            e.consume();
                            if (node == null) break;
                            BasePanel.this.frame.groupSelector.moveNodeUp(node, true);
                            break;
                        }
                        case 40: {
                            e.consume();
                            if (node == null) break;
                            BasePanel.this.frame.groupSelector.moveNodeDown(node, true);
                            break;
                        }
                        case 37: {
                            e.consume();
                            if (node == null) break;
                            BasePanel.this.frame.groupSelector.moveNodeLeft(node, true);
                            break;
                        }
                        case 39: {
                            e.consume();
                            if (node == null) break;
                            BasePanel.this.frame.groupSelector.moveNodeRight(node, true);
                            break;
                        }
                        case 34: {
                            BasePanel.this.frame.nextTab.actionPerformed(null);
                            e.consume();
                            break;
                        }
                        case 33: {
                            BasePanel.this.frame.prevTab.actionPerformed(null);
                            e.consume();
                        }
                    }
                } else if (keyCode == 10) {
                    e.consume();
                    try {
                        BasePanel.this.runCommand("edit");
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    public void setupMainPanel() {
        this.splitPane = new JSplitPane(0);
        this.splitPane.setDividerSize(4);
        this.createMainTable();
        this.splitPane.setTopComponent(this.mainTable.getPane());
        if (this.mode == 1) {
            this.mode = 0;
            int row = this.mainTable.findEntry(this.currentPreview.entry);
            if (row >= 0) {
                this.mainTable.setRowSelectionInterval(row, row);
            }
        } else if (this.mode == 2) {
            this.mode = 0;
        } else {
            this.splitPane.setBottomComponent(null);
        }
        this.setLayout(new BorderLayout());
        this.removeAll();
        this.add((Component)this.splitPane, "Center");
        if (Globals.prefs.getBoolean("autoComplete")) {
            this.instantiateAutoCompleters();
        }
        this.splitPane.revalidate();
        this.revalidate();
        this.repaint();
    }

    public HashMap<String, AbstractAutoCompleter> getAutoCompleters() {
        return this.autoCompleters;
    }

    public AbstractAutoCompleter getAutoCompleter(String fieldName) {
        return this.autoCompleters.get(fieldName);
    }

    private void instantiateAutoCompleters() {
        this.autoCompleters.clear();
        String[] completeFields = Globals.prefs.getStringArray("autoCompleteFields");
        for (int i = 0; i < completeFields.length; ++i) {
            String field = completeFields[i];
            AbstractAutoCompleter autoCompleter = AutoCompleterFactory.getFor(field);
            this.autoCompleters.put(field, autoCompleter);
        }
        for (BibtexEntry entry : this.database.getEntries()) {
            Util.updateCompletersForEntry(this.autoCompleters, entry);
        }
        this.addJournalListToAutoCompleter();
        this.addContentSelectorValuesToAutoCompleters();
    }

    public void addContentSelectorValuesToAutoCompleters() {
        for (String field : this.autoCompleters.keySet()) {
            Vector<String> items;
            AbstractAutoCompleter ac = this.autoCompleters.get(field);
            if (this.metaData.getData("selector_" + field) == null || (items = this.metaData.getData("selector_" + field)) == null) continue;
            Iterator<String> i = items.iterator();
            while (i.hasNext()) {
                ac.addWordToIndex(i.next());
            }
        }
    }

    public void addJournalListToAutoCompleter() {
        if (this.autoCompleters.containsKey("journal")) {
            AbstractAutoCompleter ac = this.autoCompleters.get("journal");
            Set<String> journals = Globals.journalAbbrev.getJournals().keySet();
            for (String journal : journals) {
                ac.addWordToIndex(journal);
            }
        }
    }

    public void parseMetaData(HashMap<String, String> meta) {
        this.metaData = new MetaData(meta, this.database());
    }

    public void updatePreamble() {
        if (this.preambleEditor != null) {
            this.preambleEditor.updatePreamble();
        }
    }

    public void assureStringDialogNotEditing() {
        if (this.stringDialog != null) {
            this.stringDialog.assureNotEditing();
        }
    }

    public void updateStringDialog() {
        if (this.stringDialog != null) {
            this.stringDialog.refreshTable();
        }
    }

    public void updateEntryPreviewToRow(BibtexEntry e) {
    }

    public void adjustSplitter() {
        int mode = this.getMode();
        if (mode == 1) {
            this.splitPane.setDividerLocation(this.splitPane.getHeight() - 200);
        } else {
            this.splitPane.setDividerLocation(0.4);
        }
    }

    public boolean entryEditorAllowsChange() {
        Component c = this.splitPane.getBottomComponent();
        if (c != null && c instanceof EntryEditor) {
            return ((EntryEditor)c).lastSourceAccepted();
        }
        return true;
    }

    public void moveFocusToEntryEditor() {
        Component c = this.splitPane.getBottomComponent();
        if (c != null && c instanceof EntryEditor) {
            new FocusRequester(c);
        }
    }

    public boolean isShowingEditor() {
        return this.splitPane.getBottomComponent() != null && this.splitPane.getBottomComponent() instanceof EntryEditor;
    }

    public void showEntry(BibtexEntry be) {
        if (this.getShowing() == be) {
            if (this.splitPane.getBottomComponent() == null) {
                this.newEntryShowing(null);
                this.showEntry(be);
            } else {
                ((EntryEditor)this.splitPane.getBottomComponent()).updateAllFields();
            }
            return;
        }
        int divLoc = -1;
        String visName = null;
        if (this.getShowing() != null) {
            visName = ((EntryEditor)this.splitPane.getBottomComponent()).getVisiblePanelName();
        }
        if (this.getShowing() != null) {
            divLoc = this.splitPane.getDividerLocation();
        }
        if (this.entryEditors.containsKey(be.getType().getName())) {
            EntryEditor form = this.entryEditors.get(be.getType().getName());
            form.switchTo(be);
            if (visName != null) {
                form.setVisiblePanel(visName);
            }
            this.splitPane.setBottomComponent(form);
        } else {
            EntryEditor form = new EntryEditor(this.frame, this, be);
            if (visName != null) {
                form.setVisiblePanel(visName);
            }
            this.splitPane.setBottomComponent(form);
            this.entryEditors.put(be.getType().getName(), form);
        }
        if (divLoc > 0) {
            this.splitPane.setDividerLocation(divLoc);
        } else {
            this.splitPane.setDividerLocation(0.4);
        }
        this.newEntryShowing(be);
        this.setEntryEditorEnabled(true);
    }

    public EntryEditor getEntryEditor(BibtexEntry entry) {
        EntryEditor form;
        if (this.entryEditors.containsKey(entry.getType().getName())) {
            EntryEditor visibleNow = this.currentEditor;
            form = this.entryEditors.get(entry.getType().getName());
            if (visibleNow != null && form != visibleNow) {
                visibleNow.storeCurrentEdit();
            }
            form.switchTo(entry);
        } else {
            this.storeCurrentEdit();
            form = new EntryEditor(this.frame, this, entry);
            this.entryEditors.put(entry.getType().getName(), form);
        }
        return form;
    }

    public EntryEditor getCurrentEditor() {
        return this.currentEditor;
    }

    public void showEntryEditor(EntryEditor editor) {
        int oldSplitterLocation = -1;
        if (this.mode == 2) {
            oldSplitterLocation = this.splitPane.getDividerLocation();
        }
        boolean adjustSplitter = this.mode == 3;
        this.mode = 2;
        this.currentEditor = editor;
        this.splitPane.setBottomComponent(editor);
        if (editor.getEntry() != this.getShowing()) {
            this.newEntryShowing(editor.getEntry());
        }
        if (oldSplitterLocation > 0) {
            this.splitPane.setDividerLocation(oldSplitterLocation);
        }
        if (adjustSplitter) {
            this.adjustSplitter();
        }
    }

    public void showPreview(PreviewPanel preview) {
        this.mode = 1;
        this.currentPreview = preview;
        this.splitPane.setBottomComponent(preview);
    }

    public void hideBottomComponent() {
        this.mode = 0;
        this.splitPane.setBottomComponent(null);
    }

    public void highlightEntry(BibtexEntry be) {
        int row = this.mainTable.findEntry(be);
        if (row >= 0) {
            this.mainTable.setRowSelectionInterval(row, row);
            this.mainTable.ensureVisible(row);
        }
    }

    public void entryEditorClosing(EntryEditor editor) {
        this.selectionListener.entryEditorClosing(editor);
    }

    public void ensureNotShowing(BibtexEntry be) {
        if (this.mode == 2 && this.currentEditor.getEntry() == be) {
            this.selectionListener.entryEditorClosing(this.currentEditor);
        }
    }

    public void updateEntryEditorIfShowing() {
        if (this.mode == 2) {
            if (this.currentEditor.getType() != this.currentEditor.getEntry().getType()) {
                this.newEntryShowing(null);
                EntryEditor newEditor = this.getEntryEditor(this.currentEditor.getEntry());
                this.showEntryEditor(newEditor);
            } else {
                this.currentEditor.updateAllFields();
                this.currentEditor.updateSource();
            }
        }
    }

    public void storeCurrentEdit() {
        if (this.isShowingEditor()) {
            EntryEditor editor = (EntryEditor)this.splitPane.getBottomComponent();
            editor.storeCurrentEdit();
        }
    }

    public void updateAllContentSelectors() {
        Iterator<String> i = this.entryEditors.keySet().iterator();
        while (i.hasNext()) {
            EntryEditor ed = this.entryEditors.get(i.next());
            ed.updateAllContentSelectors();
        }
    }

    public void rebuildAllEntryEditors() {
        Iterator<String> i = this.entryEditors.keySet().iterator();
        while (i.hasNext()) {
            EntryEditor ed = this.entryEditors.get(i.next());
            ed.rebuildPanels();
        }
    }

    public void markBaseChanged() {
        this.baseChanged = true;
        String oldTitle = this.frame.getTabTitle(this);
        if (!oldTitle.endsWith("*")) {
            this.frame.setTabTitle(this, oldTitle + "*", this.frame.getTabTooltip(this));
        }
        if (this.frame.statusLine.getText().startsWith("Saved database")) {
            this.frame.output(" ");
        }
    }

    public void markNonUndoableBaseChanged() {
        this.nonUndoableChange = true;
        this.markBaseChanged();
    }

    public synchronized void markChangedOrUnChanged() {
        if (this.undoManager.hasChanged()) {
            if (!this.baseChanged) {
                this.markBaseChanged();
            }
        } else if (this.baseChanged && !this.nonUndoableChange) {
            this.baseChanged = false;
            if (this.getFile() != null) {
                this.frame.setTabTitle(this, this.getFile().getName(), this.getFile().getAbsolutePath());
            } else {
                this.frame.setTabTitle(this, Globals.lang("untitled"), null);
            }
        }
    }

    public void selectSingleEntry(int pos) {
        this.mainTable.clearSelection();
        this.mainTable.addRowSelectionInterval(pos, pos);
        this.mainTable.scrollToCenter(pos, 0);
    }

    public void setSearchMatcher(SearchMatcher matcher) {
        this.searchFilterList.setMatcher(matcher);
        this.showingSearch = true;
    }

    public void setGroupMatcher(Matcher<BibtexEntry> matcher) {
        this.groupFilterList.setMatcher(matcher);
        this.showingGroup = true;
    }

    public void stopShowingSearchResults() {
        this.searchFilterList.setMatcher(NoSearchMatcher.INSTANCE);
        this.showingSearch = false;
    }

    public void stopShowingGroup() {
        this.groupFilterList.setMatcher(NoSearchMatcher.INSTANCE);
        this.showingGroup = false;
    }

    public boolean isShowingFloatSearch() {
        return this.mainTable.isShowingFloatSearch();
    }

    public boolean isShowingFilterSearch() {
        return this.showingSearch;
    }

    public BibtexDatabase getDatabase() {
        return this.database;
    }

    public void preambleEditorClosing() {
        this.preambleEditor = null;
    }

    public void stringsClosing() {
        this.stringDialog = null;
    }

    public void changeType(BibtexEntry entry, BibtexEntryType type) {
        this.changeType(new BibtexEntry[]{entry}, type);
    }

    public void changeType(BibtexEntryType type) {
        BibtexEntry[] bes = this.mainTable.getSelectedEntries();
        this.changeType(bes, type);
    }

    public void changeType(BibtexEntry[] bes, BibtexEntryType type) {
        int choice;
        if (bes == null || bes.length == 0) {
            this.output("First select the entries you wish to change type for.");
            return;
        }
        if (bes.length > 1 && (choice = JOptionPane.showConfirmDialog(this, "Multiple entries selected. Do you want to change\nthe type of all these to '" + type.getName() + "'?", "Change type", 0, 2)) == 1) {
            return;
        }
        NamedCompound ce = new NamedCompound(Globals.lang("change type"));
        for (int i = 0; i < bes.length; ++i) {
            ce.addEdit(new UndoableChangeType(bes[i], bes[i].getType(), type));
            bes[i].setType(type);
        }
        this.output(Globals.lang("Changed type to") + " '" + type.getName() + "' " + Globals.lang("for") + " " + bes.length + " " + Globals.lang("entries") + ".");
        ce.end();
        this.undoManager.addEdit(ce);
        this.markBaseChanged();
        this.updateEntryEditorIfShowing();
    }

    public boolean showDeleteConfirmationDialog(int numberOfEntries) {
        if (Globals.prefs.getBoolean("confirmDelete")) {
            String msg = Globals.lang("Really delete the selected") + " " + Globals.lang("entry") + "?";
            String title = Globals.lang("Delete entry");
            if (numberOfEntries > 1) {
                msg = Globals.lang("Really delete the selected") + " " + numberOfEntries + " " + Globals.lang("entries") + "?";
                title = Globals.lang("Delete multiple entries");
            }
            CheckBoxMessage cb = new CheckBoxMessage(msg, Globals.lang("Disable this confirmation dialog"), false);
            int answer = JOptionPane.showConfirmDialog(this.frame, cb, title, 0, 3);
            if (cb.isSelected()) {
                Globals.prefs.putBoolean("confirmDelete", false);
            }
            return answer == 0;
        }
        return true;
    }

    public void autoGenerateKeysBeforeSaving() {
        if (Globals.prefs.getBoolean("generateKeysBeforeSaving")) {
            NamedCompound ce = new NamedCompound(Globals.lang("autogenerate keys"));
            boolean any = false;
            for (BibtexEntry bes : this.database.getEntries()) {
                String oldKey = bes.getCiteKey();
                if (oldKey != null && !oldKey.equals("")) continue;
                LabelPatternUtil.makeLabel(Globals.prefs.getKeyPattern(), this.database, bes);
                ce.addEdit(new UndoableKeyChange(this.database, bes.getId(), null, bes.getField("bibtexkey")));
                any = true;
            }
            if (any) {
                ce.end();
                this.undoManager.addEdit(ce);
            }
        }
    }

    public void setPreviewActive(boolean enabled) {
        this.selectionListener.setPreviewActive(enabled);
    }

    public void setSelectionListenerEnabled(boolean enabled) {
        this.selectionListener.setEnabled(enabled);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setEntryEditorEnabled(boolean enabled) {
        EntryEditor ed;
        if (this.getShowing() != null && this.splitPane.getBottomComponent() instanceof EntryEditor && (ed = (EntryEditor)this.splitPane.getBottomComponent()).isEnabled() != enabled) {
            ed.setEnabled(enabled);
        }
    }

    public String fileMonitorHandle() {
        return this.fileMonitorHandle;
    }

    @Override
    public void fileUpdated() {
        if (this.saving) {
            return;
        }
        this.updatedExternally = true;
        final ChangeScanner scanner = new ChangeScanner(this.frame, this);
        Thread t = new Thread(){

            public void run() {
                boolean hasAlready = BasePanel.this.sidePaneManager.hasComponent("fileUpdate");
                if (hasAlready) {
                    BasePanel.this.sidePaneManager.hideComponent("fileUpdate");
                    BasePanel.this.sidePaneManager.unregisterComponent("fileUpdate");
                }
                FileUpdatePanel pan = new FileUpdatePanel(BasePanel.this.frame, BasePanel.this, BasePanel.this.sidePaneManager, BasePanel.this.getFile(), scanner);
                BasePanel.this.sidePaneManager.register("fileUpdate", pan);
                BasePanel.this.sidePaneManager.show("fileUpdate");
            }
        };
        if (this.getFile() != null && !Util.waitForFileLock(this.getFile(), 10)) {
            System.err.println("File updated externally, but change scan failed because the file is locked.");
            Globals.fileUpdateMonitor.perturbTimestamp(this.getFileMonitorHandle());
            return;
        }
        scanner.changeScan(this.getFile());
        try {
            scanner.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (scanner.changesFound()) {
            SwingUtilities.invokeLater(t);
        } else {
            this.setUpdatedExternally(false);
        }
    }

    @Override
    public void fileRemoved() {
        Util.pr("File '" + this.getFile().getPath() + "' has been deleted.");
    }

    public void cleanUp() {
        FileUpdatePanel fup;
        if (this.fileMonitorHandle != null) {
            Globals.fileUpdateMonitor.removeUpdateListener(this.fileMonitorHandle);
        }
        if (this.sidePaneManager.hasComponent("fileUpdate") && (fup = (FileUpdatePanel)this.sidePaneManager.getComponent("fileUpdate")).getPanel() == this) {
            this.sidePaneManager.hideComponent("fileUpdate");
        }
    }

    public void setUpdatedExternally(boolean b) {
        this.updatedExternally = b;
    }

    public BibtexEntry[] getSelectedEntries() {
        return this.mainTable.getSelectedEntries();
    }

    public File getFile() {
        return this.metaData.getFile();
    }

    public String getKeysForSelection() {
        StringBuffer result = new StringBuffer();
        String citeKey = "";
        boolean first = true;
        for (BibtexEntry bes : this.mainTable.getSelected()) {
            citeKey = bes.getField("bibtexkey");
            if (citeKey == null || citeKey.equals("")) continue;
            if (first) {
                result.append(citeKey);
                first = false;
                continue;
            }
            result.append(",").append(citeKey);
        }
        return result.toString();
    }

    public GroupSelector getGroupSelector() {
        return this.frame.groupSelector;
    }

    public boolean isUpdatedExternally() {
        return this.updatedExternally;
    }

    public String getFileMonitorHandle() {
        return this.fileMonitorHandle;
    }

    public void setFileMonitorHandle(String fileMonitorHandle) {
        this.fileMonitorHandle = fileMonitorHandle;
    }

    public SidePaneManager getSidePaneManager() {
        return this.sidePaneManager;
    }

    public void setNonUndoableChange(boolean nonUndoableChange) {
        this.nonUndoableChange = nonUndoableChange;
    }

    public void setBaseChanged(boolean baseChanged) {
        this.baseChanged = baseChanged;
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    public BibtexEntry getShowing() {
        return this.showing;
    }

    public void newEntryShowing(BibtexEntry entry) {
        if (this.backOrForwardInProgress) {
            this.showing = entry;
            this.backOrForwardInProgress = false;
            this.setBackAndForwardEnabledState();
            return;
        }
        this.nextEntries.clear();
        if (entry != this.showing) {
            if (this.showing != null) {
                this.previousEntries.add(this.showing);
                if (this.previousEntries.size() > 10) {
                    this.previousEntries.remove(0);
                }
            }
            this.showing = entry;
            this.setBackAndForwardEnabledState();
        }
    }

    private void back() {
        if (this.previousEntries.size() > 0) {
            BibtexEntry toShow = this.previousEntries.get(this.previousEntries.size() - 1);
            this.previousEntries.remove(this.previousEntries.size() - 1);
            if (this.showing != null) {
                this.nextEntries.add(this.showing);
            }
            this.backOrForwardInProgress = true;
            this.highlightEntry(toShow);
        }
    }

    private void forward() {
        if (this.nextEntries.size() > 0) {
            BibtexEntry toShow = this.nextEntries.get(this.nextEntries.size() - 1);
            this.nextEntries.remove(this.nextEntries.size() - 1);
            if (this.showing != null) {
                this.previousEntries.add(this.showing);
            }
            this.backOrForwardInProgress = true;
            this.highlightEntry(toShow);
        }
    }

    public void setBackAndForwardEnabledState() {
        this.frame.back.setEnabled(this.previousEntries.size() > 0);
        this.frame.forward.setEnabled(this.nextEntries.size() > 0);
    }

    class RedoAction
    extends BaseAction {
        RedoAction() {
        }

        public void action() {
            try {
                JComponent focused = Globals.focusListener.getFocused();
                if (focused != null && focused instanceof FieldEditor && focused.hasFocus()) {
                    BasePanel.this.storeCurrentEdit();
                }
                String name = BasePanel.this.undoManager.getRedoPresentationName();
                BasePanel.this.undoManager.redo();
                BasePanel.this.markBaseChanged();
                BasePanel.this.frame.output(name);
            }
            catch (CannotRedoException ex) {
                BasePanel.this.frame.output(Globals.lang("Nothing to redo") + ".");
            }
            BasePanel.this.markChangedOrUnChanged();
        }
    }

    class UndoAction
    extends BaseAction {
        UndoAction() {
        }

        public void action() {
            try {
                JComponent focused = Globals.focusListener.getFocused();
                if (focused != null && focused instanceof FieldEditor && focused.hasFocus()) {
                    if (BasePanel.this.preambleEditor != null && focused == BasePanel.this.preambleEditor.getFieldEditor()) {
                        BasePanel.this.preambleEditor.storeCurrentEdit();
                    } else {
                        BasePanel.this.storeCurrentEdit();
                    }
                }
                String name = BasePanel.this.undoManager.getUndoPresentationName();
                BasePanel.this.undoManager.undo();
                BasePanel.this.markBaseChanged();
                BasePanel.this.frame.output(name);
            }
            catch (CannotUndoException ex) {
                BasePanel.this.frame.output(Globals.lang("Nothing to undo") + ".");
            }
            BasePanel.this.markChangedOrUnChanged();
        }
    }
}

