/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.Transition;
import org.antlr.misc.IntSet;
import org.antlr.misc.Utils;
import org.antlr.tool.Grammar;

public class RandomPhrase {
    protected static Random random;

    protected static void randomPhrase(Grammar g, List tokenTypes, String startRule) {
        NFAState state = g.getRuleStartState(startRule);
        NFAState stopState = g.getRuleStopState(startRule);
        Stack<NFAState> ruleInvocationStack = new Stack<NFAState>();
        while (state != stopState || ruleInvocationStack.size() != 0) {
            if (state.getNumberOfTransitions() == 0) {
                return;
            }
            if (state.isAcceptState()) {
                NFAState invokingState = (NFAState)ruleInvocationStack.pop();
                RuleClosureTransition invokingTransition = (RuleClosureTransition)invokingState.transition(0);
                state = invokingTransition.getFollowState();
                continue;
            }
            if (state.getNumberOfTransitions() == 1) {
                Transition t0 = state.transition(0);
                if (t0 instanceof RuleClosureTransition) {
                    ruleInvocationStack.push(state);
                    int ruleIndex = ((RuleClosureTransition)t0).getRuleIndex();
                } else if (!t0.label.isEpsilon()) {
                    tokenTypes.add(RandomPhrase.getTokenType(t0.label));
                }
                state = (NFAState)t0.target;
                continue;
            }
            int decisionNumber = state.getDecisionNumber();
            if (decisionNumber == 0) {
                System.out.println("weird: no decision number but a choice node");
                continue;
            }
            int n = g.getNumberOfAltsForDecisionNFA(state);
            int randomAlt = random.nextInt(n) + 1;
            NFAState altStartState = g.getNFAStateForAltOfDecision(state, randomAlt);
            Transition t = altStartState.transition(0);
            state = (NFAState)t.target;
        }
    }

    protected static Integer getTokenType(Label label) {
        if (label.isSet()) {
            IntSet typeSet = label.getSet();
            List typeList = typeSet.toList();
            int randomIndex = random.nextInt(typeList.size());
            return (Integer)typeList.get(randomIndex);
        }
        return Utils.integer(label.getAtom());
    }

    public static void main(String[] args) throws Exception {
        String grammarFileName = args[0];
        String startRule = args[1];
        long seed = System.currentTimeMillis();
        if (args.length == 3) {
            String seedStr = args[2];
            seed = Integer.parseInt(seedStr);
        }
        random = new Random(seed);
        Grammar parser = new Grammar(null, grammarFileName, new BufferedReader(new FileReader(grammarFileName)));
        parser.createNFAs();
        List leftRecursiveRules = parser.checkAllRulesForLeftRecursion();
        if (leftRecursiveRules.size() > 0) {
            return;
        }
        if (parser.getRule(startRule) == null) {
            System.out.println("undefined start rule " + startRule);
            return;
        }
        String lexerGrammarText = parser.getLexerGrammar();
        Grammar lexer = new Grammar();
        lexer.importTokenVocabulary(parser);
        if (lexerGrammarText != null) {
            lexer.setGrammarContent(lexerGrammarText);
        } else {
            System.err.println("no lexer grammar found in " + grammarFileName);
        }
        lexer.createNFAs();
        leftRecursiveRules = lexer.checkAllRulesForLeftRecursion();
        if (leftRecursiveRules.size() > 0) {
            return;
        }
        ArrayList tokenTypes = new ArrayList(100);
        RandomPhrase.randomPhrase(parser, tokenTypes, startRule);
        int i = 0;
        while (i < tokenTypes.size()) {
            Integer ttypeI = (Integer)tokenTypes.get(i);
            int ttype = ttypeI;
            String ttypeDisplayName = parser.getTokenDisplayName(ttype);
            if (Character.isUpperCase(ttypeDisplayName.charAt(0))) {
                ArrayList charsInToken = new ArrayList(10);
                RandomPhrase.randomPhrase(lexer, charsInToken, ttypeDisplayName);
                System.out.print(" ");
                int j = 0;
                while (j < charsInToken.size()) {
                    Integer cI = (Integer)charsInToken.get(j);
                    System.out.print((char)cI.intValue());
                    ++j;
                }
            } else {
                String literal = ttypeDisplayName.substring(1, ttypeDisplayName.length() - 1);
                System.out.print(" " + literal);
            }
            ++i;
        }
        System.out.println();
    }
}

