/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.integrity.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.wizard.integrity.IntegrityCheck;
import net.sf.jabref.wizard.integrity.IntegrityMessage;
import net.sf.jabref.wizard.text.gui.HintListModel;

public class IntegrityMessagePanel
extends JPanel
implements ListSelectionListener,
KeyListener,
ActionListener {
    private JList warnings;
    private HintListModel warningData;
    private IntegrityCheck validChecker;
    private JTextField content;
    private JButton applyButton;
    private JButton fixButton;
    private BasePanel basePanel;

    public IntegrityMessagePanel(BasePanel basePanel) {
        this.basePanel = basePanel;
        this.validChecker = new IntegrityCheck();
        this.warningData = new HintListModel();
        this.warnings = new JList(this.warningData);
        this.warnings.setCellRenderer(new IntegrityListRenderer());
        this.warnings.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.warnings);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(540, 255));
        jScrollPane.setMinimumSize(new Dimension(10, 10));
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(Globals.lang("Field_content"));
        this.content = new JTextField(40);
        this.content.addKeyListener(this);
        this.applyButton = new JButton(Globals.lang("Apply"));
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        this.fixButton = new JButton(Globals.lang("Suggest"));
        this.fixButton.setEnabled(false);
        jPanel.add(jLabel);
        jPanel.add(this.content);
        jPanel.add(this.applyButton);
        jPanel.add(this.fixButton);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "South");
    }

    public void updateView(BibtexEntry bibtexEntry) {
        this.warningData.clear();
        IntegrityMessage.setPrintMode(IntegrityMessage.SINLGE_MODE);
        this.warningData.setData(this.validChecker.checkBibtexEntry(bibtexEntry));
    }

    public void updateView(BibtexDatabase bibtexDatabase) {
        this.warningData.clear();
        IntegrityMessage.setPrintMode(IntegrityMessage.FULL_MODE);
        this.warningData.setData(this.validChecker.checkBibtexDatabase(bibtexDatabase));
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            IntegrityMessage integrityMessage;
            BibtexEntry bibtexEntry;
            Object e = this.warnings.getSelectedValue();
            String string = "";
            if (e != null && (bibtexEntry = (integrityMessage = (IntegrityMessage)e).getEntry()) != null) {
                string = (String)bibtexEntry.getField(integrityMessage.getFieldName());
                this.basePanel.highlightEntry(bibtexEntry);
            }
            this.content.setText(string);
            this.applyButton.setEnabled(false);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.applyButton.setEnabled(true);
        if (keyEvent.getKeyCode() == 10) {
            this.applyButton.doClick();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.applyButton) {
            IntegrityMessage integrityMessage;
            BibtexEntry bibtexEntry;
            Object e = this.warnings.getSelectedValue();
            if (e != null && (bibtexEntry = (integrityMessage = (IntegrityMessage)e).getEntry()) != null) {
                Object object2 = bibtexEntry.getField(integrityMessage.getFieldName());
                UndoableFieldChange undoableFieldChange = new UndoableFieldChange(bibtexEntry, integrityMessage.getFieldName(), object2, this.content.getText());
                bibtexEntry.setField(integrityMessage.getFieldName(), this.content.getText());
                this.basePanel.undoManager.addEdit(undoableFieldChange);
                this.basePanel.markBaseChanged();
                integrityMessage.setFixed(true);
                this.warningData.valueUpdated(this.warnings.getSelectedIndex());
            }
            this.applyButton.setEnabled(false);
        }
    }

    class IntegrityListRenderer
    extends DefaultListCellRenderer {
        final ImageIcon warnIcon = GUIGlobals.getImage("integrityWarn");
        final ImageIcon infoIcon = GUIGlobals.getImage("integrityInfo");
        final ImageIcon failIcon = GUIGlobals.getImage("integrityFail");
        final ImageIcon fixedIcon = GUIGlobals.getImage("complete");

        IntegrityListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                IntegrityMessage integrityMessage = (IntegrityMessage)object;
                if (integrityMessage.getFixed()) {
                    this.setIcon(this.fixedIcon);
                } else {
                    int n2 = integrityMessage.getType();
                    if (n2 < 1000) {
                        this.setIcon(this.infoIcon);
                    } else if (n2 < 2000) {
                        this.setIcon(this.warnIcon);
                    } else {
                        this.setIcon(this.failIcon);
                    }
                }
            }
            return this;
        }
    }
}

