/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.integrity;

import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;

public class IntegrityMessage
implements Cloneable {
    public static final int GENERIC_HINT = 1;
    public static final int UPPER_AND_LOWER_HINT = 10;
    public static final int FOUR_DIGITS_HINT = 11;
    public static final int GENERIC_WARNING = 1001;
    public static final int NAME_START_WARNING = 1010;
    public static final int NAME_END_WARNING = 1011;
    public static final int NAME_SEMANTIC_WARNING = 1012;
    public static final int UNKNONW_FAILURE = 2001;
    public static final int UNEXPECTED_CLOSING_BRACE_FAILURE = 2010;
    public static int FULL_MODE = 1;
    public static int SINLGE_MODE;
    private static int printMode;
    private int type;
    private BibtexEntry entry;
    private String fieldName;
    private Object additionalInfo;
    private String msg;
    private boolean fixed;

    public static final synchronized void setPrintMode(int n) {
        printMode = n;
    }

    public IntegrityMessage(int n, BibtexEntry bibtexEntry, String string, Object object) {
        this.type = n;
        this.entry = bibtexEntry;
        this.fieldName = string;
        this.additionalInfo = object;
        this.fixed = false;
        this.msg = this.getMessage();
    }

    public String getMessage() {
        String string = Globals.getIntegrityMessage("ITEXT_" + this.type);
        if (string != null && this.fieldName != null) {
            string = string.replaceAll("\\$FIELD", this.fieldName);
        }
        return string;
    }

    public String toString() {
        String string = this.msg;
        if (printMode == FULL_MODE) {
            string = "[" + this.entry.getCiteKey() + "] " + this.msg;
        }
        return string;
    }

    public int getType() {
        return this.type;
    }

    public BibtexEntry getEntry() {
        return this.entry;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getAdditionalInfo() {
        return this.additionalInfo;
    }

    public boolean getFixed() {
        return this.fixed;
    }

    public void setFixed(boolean bl) {
        this.fixed = bl;
    }

    static {
        printMode = SINLGE_MODE = 2;
    }
}

