/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.integrity;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.wizard.integrity.IntegrityMessage;

public class IntegrityCheck {
    private Vector messages = new Vector();

    public Vector checkBibtexDatabase(BibtexDatabase bibtexDatabase) {
        this.messages.clear();
        if (bibtexDatabase != null) {
            Collection collection = bibtexDatabase.getEntries();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null) continue;
                this.checkSingleEntry((BibtexEntry)e);
            }
        }
        return (Vector)this.messages.clone();
    }

    public Vector checkBibtexEntry(BibtexEntry bibtexEntry) {
        this.messages.clear();
        this.checkSingleEntry(bibtexEntry);
        return (Vector)this.messages.clone();
    }

    public void checkSingleEntry(BibtexEntry bibtexEntry) {
        if (bibtexEntry == null) {
            return;
        }
        Object object = bibtexEntry.getField("author");
        if (object != null) {
            this.authorNameCheck(object.toString(), "author", bibtexEntry);
        }
        if ((object = bibtexEntry.getField("editor")) != null) {
            this.authorNameCheck(object.toString(), "editor", bibtexEntry);
        }
        if ((object = bibtexEntry.getField("title")) != null) {
            this.titleCheck(object.toString(), "title", bibtexEntry);
        }
        if ((object = bibtexEntry.getField("year")) != null) {
            this.yearCheck(object.toString(), "year", bibtexEntry);
        }
    }

    private void authorNameCheck(String string, String string2, BibtexEntry bibtexEntry) {
        char c;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        int n3 = -1;
        block7: for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            switch (c) {
                case ',': {
                    if (n3 == 5) {
                        stringBuffer.append('a');
                    } else {
                        stringBuffer.append('N');
                    }
                    stringBuffer.append(',');
                    n3 = 0;
                    continue block7;
                }
                case ' ': {
                    if (n3 == 5) {
                        stringBuffer.append('a');
                    } else if (n3 != 0) {
                        stringBuffer.append('N');
                    }
                    n3 = -1;
                    continue block7;
                }
                case 'a': {
                    if (n3 != -1) continue block7;
                    n3 = 2;
                    continue block7;
                }
                case 'n': {
                    if (n3 != 2) continue block7;
                    n3 = 3;
                    continue block7;
                }
                case 'd': {
                    if (n3 != 3) continue block7;
                    n3 = 5;
                    continue block7;
                }
                default: {
                    n3 = 1;
                }
            }
        }
        if (n3 == 5) {
            stringBuffer.append('a');
        } else if (n3 != 0) {
            stringBuffer.append('N');
        }
        n2 = stringBuffer.length();
        if (n2 > 0) {
            n = 0;
            c = stringBuffer.charAt(0);
            if (stringBuffer.charAt(0) != 'N') {
                this.messages.add(new IntegrityMessage(1010, bibtexEntry, string2, null));
                n = 1;
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) != 'N') {
                this.messages.add(new IntegrityMessage(1011, bibtexEntry, string2, null));
                n = 1;
            }
            if (stringBuffer.indexOf("NN,NN") > -1) {
                this.messages.add(new IntegrityMessage(1012, bibtexEntry, string2, null));
                n = 1;
            }
        }
    }

    private void titleCheck(String string, String string2, BibtexEntry bibtexEntry) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '}': {
                    if (n2 == 0) {
                        this.messages.add(new IntegrityMessage(2010, bibtexEntry, string2, null));
                        continue block5;
                    }
                    --n2;
                    continue block5;
                }
                case '{': {
                    ++n2;
                    continue block5;
                }
                case ' ': {
                    continue block5;
                }
                default: {
                    if (n2 != 0 || !Character.isUpperCase(c) || i <= 1) continue block5;
                    ++n3;
                }
            }
        }
        if (n3 > 0) {
            // empty if block
        }
    }

    private void yearCheck(String string, String string2, BibtexEntry bibtexEntry) {
        int n = string.length();
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) {
                if (++n2 == 4) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            if (bl) {
                bl2 = true;
            }
            n2 = 0;
        }
        if (!bl2 && !bl) {
            this.messages.add(new IntegrityMessage(11, bibtexEntry, string2, null));
        }
    }
}

