/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.auximport.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.wizard.auximport.AuxSubGenerator;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog_Cancel_actionAdapter;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog_generate_actionAdapter;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog_ok_actionAdapter;

public class FromAuxDialog
extends JDialog {
    private JPanel statusPanel = new JPanel();
    private JPanel buttons = new JPanel();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton generateButton = new JButton();
    private JComboBox dbChooser = new JComboBox();
    private JTextField auxFileField;
    private JButton browseAuxFileButton;
    private JList notFoundList;
    private JTextArea statusInfos;
    private JTabbedPane parentTabbedPane;
    private boolean okPressed = false;
    private AuxSubGenerator auxParser;

    public FromAuxDialog(JabRefFrame jabRefFrame, String string, boolean bl, JTabbedPane jTabbedPane) {
        super(jabRefFrame, string, bl);
        this.parentTabbedPane = jTabbedPane;
        this.auxParser = new AuxSubGenerator(null);
        try {
            this.jbInit(jabRefFrame);
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit(JabRefFrame jabRefFrame) {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.okButton.setText(Globals.lang("Ok"));
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new FromAuxDialog_ok_actionAdapter(this));
        this.cancelButton.setText(Globals.lang("Cancel"));
        this.cancelButton.addActionListener(new FromAuxDialog_Cancel_actionAdapter(this));
        this.generateButton.setText(Globals.lang("Generate"));
        this.generateButton.addActionListener(new FromAuxDialog_generate_actionAdapter(this));
        this.initOptionsPanel(jabRefFrame);
        this.initStatusPanel();
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        JPanel jPanel2 = buttonBarBuilder.getPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGridded(this.generateButton);
        buttonBarBuilder.addGridded(this.okButton);
        buttonBarBuilder.addGridded(this.cancelButton);
        buttonBarBuilder.addGlue();
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(Globals.lang("AUX file import"));
        this.getContentPane().add(jPanel);
        JPanel jPanel3 = this.getDescriptionPanel();
        if (jPanel3 != null) {
            jPanel.add((Component)jPanel3, "North");
            jPanel.add((Component)jPanel2, "South");
            serializable = new JPanel(new BorderLayout());
            ((Container)serializable).add(this.buttons, "North");
            ((Container)serializable).add(this.statusPanel, "Center");
            jPanel.add((Component)serializable, "Center");
        } else {
            jPanel.add((Component)this.buttons, "North");
            jPanel.add((Component)jPanel2, "South");
            jPanel.add((Component)this.statusPanel, "Center");
        }
        serializable = this.statusPanel.getActionMap();
        InputMap inputMap = this.statusPanel.getInputMap(2);
        inputMap.put(jabRefFrame.prefs().getKey("Close dialog"), "close");
        ((ActionMap)serializable).put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FromAuxDialog.this.dispose();
            }
        });
    }

    private void initOptionsPanel(JabRefFrame jabRefFrame) {
        int n = this.parentTabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            this.dbChooser.addItem(this.parentTabbedPane.getTitleAt(i));
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagConstraints.fill = 2;
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), Globals.lang("Options"));
        this.buttons.setBorder(titledBorder);
        this.buttons.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(Globals.lang("Reference database") + ":");
        jLabel.setHorizontalAlignment(2);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.buttons.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.dbChooser, gridBagConstraints);
        this.buttons.add(this.dbChooser);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 15, 10);
        gridBagConstraints.fill = 1;
        jLabel = new JLabel(Globals.lang("LaTeX AUX file") + ":");
        jLabel.setHorizontalAlignment(2);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.buttons.add(jLabel);
        gridBagConstraints.weightx = 1.0;
        this.auxFileField = new JTextField("", 25);
        gridBagLayout.setConstraints(this.auxFileField, gridBagConstraints);
        this.buttons.add(this.auxFileField);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 15, 2);
        this.browseAuxFileButton = new JButton(Globals.lang("Browse"));
        this.browseAuxFileButton.addActionListener(new BrowseAction(this.auxFileField, jabRefFrame));
        gridBagLayout.setConstraints(this.browseAuxFileButton, gridBagConstraints);
        this.buttons.add(this.browseAuxFileButton);
    }

    private void initStatusPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagConstraints.fill = 2;
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), Globals.lang("Results"));
        this.statusPanel.setLayout(gridBagLayout);
        this.statusPanel.setBorder(titledBorder);
        JLabel jLabel = new JLabel(Globals.lang("Unknown bibtex entries") + ":");
        jLabel.setHorizontalAlignment(2);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.statusPanel.add(jLabel);
        jLabel = new JLabel(Globals.lang("Messages") + ":");
        jLabel.setHorizontalAlignment(2);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.statusPanel.add(jLabel);
        this.notFoundList = new JList();
        JScrollPane jScrollPane = new JScrollPane(this.notFoundList);
        jScrollPane.setPreferredSize(new Dimension(250, 120));
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 10, 15, 10);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.statusPanel.add(jScrollPane);
        this.statusInfos = new JTextArea("", 5, 20);
        this.statusInfos.setBorder(BorderFactory.createEtchedBorder());
        this.statusInfos.setEditable(false);
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.statusInfos, gridBagConstraints);
        this.statusPanel.add(this.statusInfos);
    }

    private JPanel getDescriptionPanel() {
        JPanel jPanel = null;
        JEditorPane jEditorPane = null;
        URL uRL = JabRef.class.getResource(GUIGlobals.getLocaleHelpPath() + GUIGlobals.shortAuxImport);
        if (uRL != null) {
            try {
                jEditorPane = new JEditorPane();
                jEditorPane.setEditable(false);
                jEditorPane.setPreferredSize(new Dimension(240, 50));
                jEditorPane.setMinimumSize(new Dimension(180, 50));
                jEditorPane.setPage(uRL);
                jEditorPane.setBackground(GUIGlobals.infoField);
                jEditorPane.setBorder(new EtchedBorder(1));
                jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                if (jEditorPane != null) {
                    jPanel.add((Component)jEditorPane, "First");
                }
            }
            catch (IOException iOException) {
                jPanel = null;
            }
        }
        return jPanel;
    }

    void ok_actionPerformed(ActionEvent actionEvent) {
        this.okPressed = true;
        this.dispose();
    }

    void Cancel_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void generate_actionPerformed(ActionEvent actionEvent) {
        this.generateButton.setEnabled(false);
        BasePanel basePanel = (BasePanel)this.parentTabbedPane.getComponentAt(this.dbChooser.getSelectedIndex());
        this.notFoundList.removeAll();
        this.statusInfos.setText(null);
        BibtexDatabase bibtexDatabase = basePanel.getDatabase();
        String string = this.auxFileField.getText();
        if (string != null && bibtexDatabase != null && string.length() > 0) {
            this.auxParser.clear();
            this.notFoundList.setListData(this.auxParser.generate(string, bibtexDatabase));
            this.statusInfos.append(Globals.lang("keys in database") + " " + bibtexDatabase.getEntryCount());
            this.statusInfos.append("\n" + Globals.lang("found in aux file") + " " + this.auxParser.getFoundKeysInAux());
            this.statusInfos.append("\n" + Globals.lang("resolved") + " " + this.auxParser.getResolvedKeysCount());
            this.statusInfos.append("\n" + Globals.lang("not found") + " " + this.auxParser.getNotResolvedKeysCount());
            this.statusInfos.append("\n" + Globals.lang("crossreferenced entries included") + " " + this.auxParser.getCrossreferencedEntriesCount());
            int n = this.auxParser.getNestedAuxCounter();
            if (n > 0) {
                this.statusInfos.append("\n" + Globals.lang("nested_aux_files") + " " + n);
            }
            this.okButton.setEnabled(true);
        }
        if (this.auxParser.getGeneratedDatabase().getEntryCount() < 1) {
            this.statusInfos.append("\n" + Globals.lang("empty database"));
            this.okButton.setEnabled(false);
        }
        this.generateButton.setEnabled(true);
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public BibtexDatabase getGenerateDB() {
        return this.auxParser.getGeneratedDatabase();
    }

    class BrowseAction
    extends AbstractAction {
        private JTextField comp;
        private JabRefFrame _frame;

        public BrowseAction(JTextField jTextField, JabRefFrame jabRefFrame) {
            super(Globals.lang("Browse"));
            this._frame = jabRefFrame;
            this.comp = jTextField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            string = Globals.getNewFile(this._frame, new File(this.comp.getText()), ".aux", 0, false);
            if (string != null) {
                File file = new File(string);
                this.comp.setText(file.getPath());
            }
        }
    }
}

