/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.Util;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.util.EncryptionNotSupportedException;
import net.sf.jabref.util.XMPSchemaBibtex;
import org.jempbox.impl.DateConverter;
import org.jempbox.impl.XMLUtil;
import org.jempbox.xmp.XMPMetadata;
import org.jempbox.xmp.XMPSchema;
import org.jempbox.xmp.XMPSchemaDublinCore;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.pdmodel.common.PDMetadata;
import org.w3c.dom.Node;

public class XMPUtil {
    public static List readXMP(String string) throws IOException {
        return XMPUtil.readXMP(new File(string));
    }

    public static void writeXMP(String string, BibtexEntry bibtexEntry) throws IOException, TransformerException {
        XMPUtil.writeXMP(new File(string), bibtexEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List readXMP(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            List list = XMPUtil.readXMP(fileInputStream);
            return list;
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List readXMP(InputStream inputStream) throws IOException {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        PDDocument pDDocument = null;
        try {
            Object object;
            pDDocument = PDDocument.load(inputStream);
            if (pDDocument.isEncrypted()) {
                throw new EncryptionNotSupportedException("Error: Cannot read metadata from encrypted document.");
            }
            XMPMetadata xMPMetadata = XMPUtil.getXMPMetadata(pDDocument);
            if (xMPMetadata == null) {
                List list = null;
                return list;
            }
            List list = xMPMetadata.getSchemasByNamespaceURI("http://jabref.sourceforge.net/bibteXMP/");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (XMPSchemaBibtex)iterator.next();
                linkedList.add(((XMPSchemaBibtex)object).getBibtexEntry());
            }
            if (linkedList.size() == 0) {
                list = xMPMetadata.getSchemasByNamespaceURI("http://purl.org/dc/elements/1.1/");
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    object = (XMPSchemaDublinCore)iterator.next();
                    BibtexEntry bibtexEntry = XMPUtil.getBibtexEntryFromDublinCore((XMPSchemaDublinCore)object);
                    if (bibtexEntry == null) continue;
                    linkedList.add(bibtexEntry);
                }
            }
            if (linkedList.size() == 0 && (object = XMPUtil.getBibtexEntryFromDocumentInformation(pDDocument.getDocumentInformation())) != null) {
                linkedList.add(object);
            }
        }
        finally {
            if (pDDocument != null) {
                pDDocument.close();
            }
        }
        return linkedList;
    }

    public static BibtexEntry getBibtexEntryFromDocumentInformation(PDDocumentInformation pDDocumentInformation) {
        BibtexEntry bibtexEntry = new BibtexEntry();
        String string = pDDocumentInformation.getAuthor();
        if (string != null) {
            bibtexEntry.setField("author", string);
        }
        if ((string = pDDocumentInformation.getTitle()) != null) {
            bibtexEntry.setField("title", string);
        }
        if ((string = pDDocumentInformation.getKeywords()) != null) {
            bibtexEntry.setField("keywords", string);
        }
        if ((string = pDDocumentInformation.getSubject()) != null) {
            bibtexEntry.setField("abstract", string);
        }
        COSDictionary cOSDictionary = pDDocumentInformation.getDictionary();
        Iterator iterator = cOSDictionary.keyList().iterator();
        while (iterator.hasNext()) {
            String string2 = ((COSName)iterator.next()).getName();
            if (!string2.startsWith("bibtex/")) continue;
            String string3 = cOSDictionary.getString(string2);
            if ((string2 = string2.substring("bibtex/".length())).equals("entrytype")) {
                BibtexEntryType bibtexEntryType = BibtexEntryType.getStandardType(string3);
                if (bibtexEntryType == null) continue;
                bibtexEntry.setType(bibtexEntryType);
                continue;
            }
            bibtexEntry.setField(string2, string3);
        }
        return bibtexEntry.getAllFields().length > 0 ? bibtexEntry : null;
    }

    public static BibtexEntry getBibtexEntryFromDublinCore(XMPSchemaDublinCore xMPSchemaDublinCore) {
        List list;
        Comparable<StringBuffer> comparable;
        Object object;
        Object object2;
        Object object3;
        CharSequence charSequence;
        Object object4;
        Object object5;
        BibtexEntry bibtexEntry = new BibtexEntry();
        List list2 = xMPSchemaDublinCore.getContributors();
        if (list2 != null) {
            object5 = list2.iterator();
            object4 = null;
            while (object5.hasNext()) {
                if (object4 != null) {
                    ((StringBuffer)object4).append(" and ");
                } else {
                    object4 = new StringBuffer();
                }
                ((StringBuffer)object4).append(object5.next());
            }
            if (object4 != null) {
                bibtexEntry.setField("editor", ((StringBuffer)object4).toString());
            }
        }
        if ((object5 = xMPSchemaDublinCore.getCreators()) != null) {
            object4 = object5.iterator();
            charSequence = null;
            while (object4.hasNext()) {
                if (charSequence != null) {
                    ((StringBuffer)charSequence).append(" and ");
                } else {
                    charSequence = new StringBuffer();
                }
                ((StringBuffer)charSequence).append(object4.next());
            }
            if (charSequence != null) {
                bibtexEntry.setField("author", ((StringBuffer)charSequence).toString());
            }
        }
        if ((object4 = xMPSchemaDublinCore.getSequenceList("dc:date")) != null && object4.size() > 0) {
            charSequence = ((String)object4.get(0)).trim();
            object3 = null;
            try {
                object3 = DateConverter.toCalendar((String)charSequence);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object3 != null) {
                bibtexEntry.setField("year", String.valueOf(((Calendar)object3).get(1)));
                if (((String)charSequence).length() > 4) {
                    bibtexEntry.setField("month", Globals.MONTHS[((Calendar)object3).get(2)]);
                }
            }
        }
        if ((charSequence = xMPSchemaDublinCore.getDescription()) != null) {
            bibtexEntry.setField("abstract", charSequence);
        }
        if ((charSequence = xMPSchemaDublinCore.getIdentifier()) != null) {
            bibtexEntry.setField("doi", charSequence);
        }
        if ((object3 = xMPSchemaDublinCore.getPublishers()) != null) {
            object2 = xMPSchemaDublinCore.getPublishers().iterator();
            object = null;
            while (object2.hasNext()) {
                if (object != null) {
                    ((StringBuffer)object).append(" and ");
                } else {
                    object = new StringBuffer();
                }
                ((StringBuffer)object).append(object2.next());
            }
            if (object != null) {
                bibtexEntry.setField("publishers", ((StringBuffer)object).toString());
            }
        }
        if ((object2 = xMPSchemaDublinCore.getRelationships()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                int n;
                charSequence = (String)object.next();
                if (!((String)charSequence).startsWith("bibtex/") || (n = ((String)(charSequence = ((String)charSequence).substring("bibtex/".length()))).indexOf(47)) == -1) continue;
                bibtexEntry.setField(((String)charSequence).substring(0, n), ((String)charSequence).substring(n + 1));
            }
        }
        if ((charSequence = xMPSchemaDublinCore.getRights()) != null) {
            bibtexEntry.setField("rights", charSequence);
        }
        if ((charSequence = xMPSchemaDublinCore.getSource()) != null) {
            bibtexEntry.setField("source", charSequence);
        }
        if ((object = xMPSchemaDublinCore.getSubjects()) != null) {
            Iterator iterator = object.iterator();
            comparable = null;
            while (iterator.hasNext()) {
                if (comparable != null) {
                    comparable.append(", ");
                } else {
                    comparable = new StringBuffer();
                }
                comparable.append(iterator.next());
            }
            if (comparable != null) {
                bibtexEntry.setField("keywords", comparable.toString());
            }
        }
        if ((charSequence = xMPSchemaDublinCore.getTitle()) != null) {
            bibtexEntry.setField("title", charSequence);
        }
        if ((list = xMPSchemaDublinCore.getTypes()) != null && list.size() > 0 && (charSequence = (String)list.get(0)) != null && (comparable = BibtexEntryType.getStandardType((String)charSequence)) != null) {
            bibtexEntry.setType((BibtexEntryType)comparable);
        }
        return bibtexEntry.getAllFields().length > 0 ? bibtexEntry : null;
    }

    public static void writeXMP(File file, BibtexEntry bibtexEntry) throws IOException, TransformerException {
        LinkedList<BibtexEntry> linkedList = new LinkedList<BibtexEntry>();
        linkedList.add(bibtexEntry);
        XMPUtil.writeXMP(file, linkedList, true);
    }

    public static void toXMP(Collection collection, OutputStream outputStream) throws IOException, TransformerException {
        XMPMetadata xMPMetadata = new XMPMetadata();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
            XMPSchemaBibtex xMPSchemaBibtex = new XMPSchemaBibtex(xMPMetadata);
            xMPMetadata.addSchema(xMPSchemaBibtex);
            xMPSchemaBibtex.setBibtexEntry(bibtexEntry);
        }
        xMPMetadata.save(outputStream);
    }

    public static String toXMP(Collection collection) throws TransformerException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMPUtil.toXMP(collection, byteArrayOutputStream);
            return byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMPMetadata readRawXMP(InputStream inputStream) throws IOException {
        PDDocument pDDocument = null;
        try {
            pDDocument = PDDocument.load(inputStream);
            if (pDDocument.isEncrypted()) {
                throw new EncryptionNotSupportedException("Error: Cannot read metadata from encrypted document.");
            }
            XMPMetadata xMPMetadata = XMPUtil.getXMPMetadata(pDDocument);
            return xMPMetadata;
        }
        finally {
            if (pDDocument != null) {
                pDDocument.close();
            }
        }
    }

    protected static XMPMetadata getXMPMetadata(PDDocument pDDocument) throws IOException {
        PDDocumentCatalog pDDocumentCatalog = pDDocument.getDocumentCatalog();
        PDMetadata pDMetadata = pDDocumentCatalog.getMetadata();
        if (pDMetadata == null) {
            return null;
        }
        XMPMetadata xMPMetadata = new XMPMetadata(XMLUtil.parse(pDMetadata.createInputStream()));
        xMPMetadata.addXMLNSMapping("http://jabref.sourceforge.net/bibteXMP/", XMPSchemaBibtex.class);
        return xMPMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMPMetadata readRawXMP(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            XMPMetadata xMPMetadata = XMPUtil.readRawXMP(fileInputStream);
            return xMPMetadata;
        }
        finally {
            fileInputStream.close();
        }
    }

    protected static void writeToDCSchema(XMPSchemaDublinCore xMPSchemaDublinCore, BibtexEntry bibtexEntry) {
        Object[] objectArray = bibtexEntry.getAllFields();
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            int n2;
            String[] stringArray;
            String string;
            if (objectArray[i].equals("editor")) {
                string = bibtexEntry.getField(objectArray[i].toString()).toString();
                stringArray = string.toString();
                AuthorList authorList = AuthorList.getAuthorList((String)stringArray);
                n2 = authorList.size();
                for (n = 0; n < n2; ++n) {
                    xMPSchemaDublinCore.addContributor(authorList.getAuthor(n).getFirstLast(false));
                }
                continue;
            }
            if (objectArray[i].equals("author")) {
                string = bibtexEntry.getField(objectArray[i].toString()).toString();
                stringArray = string.toString();
                AuthorList authorList = AuthorList.getAuthorList((String)stringArray);
                n2 = authorList.size();
                for (n = 0; n < n2; ++n) {
                    xMPSchemaDublinCore.addCreator(authorList.getAuthor(n).getFirstLast(false));
                }
                continue;
            }
            if (objectArray[i].equals("month")) continue;
            if (objectArray[i].equals("year")) {
                string = Util.getPublicationDate(bibtexEntry);
                if (string == null) continue;
                xMPSchemaDublinCore.addSequenceValue("dc:date", string);
                continue;
            }
            if (objectArray[i].equals("abstract")) {
                string = bibtexEntry.getField(objectArray[i].toString()).toString();
                xMPSchemaDublinCore.setDescription(string.toString());
                continue;
            }
            if (objectArray[i].equals("doi")) {
                string = bibtexEntry.getField(objectArray[i].toString()).toString();
                xMPSchemaDublinCore.setIdentifier(string.toString());
                continue;
            }
            if (objectArray[i].equals("publisher")) {
                string = bibtexEntry.getField(objectArray[i].toString()).toString();
                xMPSchemaDublinCore.addPublisher(string.toString());
                continue;
            }
            if (objectArray[i].equals("keywords")) {
                string = bibtexEntry.getField(objectArray[i].toString()).toString();
                stringArray = string.toString().split(",");
                for (int j = 0; j < stringArray.length; ++j) {
                    xMPSchemaDublinCore.addSubject(stringArray[j].trim());
                }
                continue;
            }
            if (objectArray[i].equals("title")) {
                string = bibtexEntry.getField(objectArray[i].toString()).toString();
                xMPSchemaDublinCore.setTitle(string.toString());
                continue;
            }
            string = bibtexEntry.getField(objectArray[i].toString()).toString();
            xMPSchemaDublinCore.addRelation("bibtex/" + objectArray[i].toString() + "/" + string);
        }
        xMPSchemaDublinCore.setFormat("application/pdf");
        String string = bibtexEntry.getType().getName();
        if (string != null) {
            xMPSchemaDublinCore.addType(string.toString());
        }
    }

    public static void writeDublinCore(PDDocument pDDocument, BibtexEntry bibtexEntry) throws IOException, TransformerException {
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        arrayList.add(bibtexEntry);
        XMPUtil.writeDublinCore(pDDocument, arrayList);
    }

    public static void writeDublinCore(PDDocument pDDocument, Collection collection) throws IOException, TransformerException {
        Object object;
        Object object2;
        PDDocumentCatalog pDDocumentCatalog = pDDocument.getDocumentCatalog();
        PDMetadata pDMetadata = pDDocumentCatalog.getMetadata();
        XMPMetadata xMPMetadata = pDMetadata != null ? new XMPMetadata(XMLUtil.parse(pDMetadata.createInputStream())) : new XMPMetadata();
        List list = xMPMetadata.getSchemasByNamespaceURI("http://purl.org/dc/elements/1.1/");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (XMPSchema)iterator.next();
            ((XMPSchema)object2).getElement().getParentNode().removeChild(((XMPSchema)object2).getElement());
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            object2 = (BibtexEntry)iterator.next();
            object = new XMPSchemaDublinCore(xMPMetadata);
            XMPUtil.writeToDCSchema((XMPSchemaDublinCore)object, (BibtexEntry)object2);
            xMPMetadata.addSchema((XMPSchema)object);
        }
        object2 = new ByteArrayOutputStream();
        xMPMetadata.save((OutputStream)object2);
        object = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
        PDMetadata pDMetadata2 = new PDMetadata(pDDocument, (InputStream)object, false);
        pDDocumentCatalog.setMetadata(pDMetadata2);
    }

    public static void writeDocumentInformation(PDDocument pDDocument, BibtexEntry bibtexEntry) {
        PDDocumentInformation pDDocumentInformation = pDDocument.getDocumentInformation();
        Object[] objectArray = bibtexEntry.getAllFields();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].equals("author")) {
                pDDocumentInformation.setAuthor(bibtexEntry.getField("author").toString());
                continue;
            }
            if (objectArray[i].equals("title")) {
                pDDocumentInformation.setTitle(bibtexEntry.getField("title").toString());
                continue;
            }
            if (objectArray[i].equals("keywords")) {
                pDDocumentInformation.setKeywords(bibtexEntry.getField("keywords").toString());
                continue;
            }
            if (objectArray[i].equals("abstract")) {
                pDDocumentInformation.setSubject(bibtexEntry.getField("abstract").toString());
                continue;
            }
            pDDocumentInformation.setCustomMetadataValue("bibtex/" + objectArray[i].toString(), bibtexEntry.getField(objectArray[i].toString()).toString());
        }
        pDDocumentInformation.setCustomMetadataValue("bibtex/entrytype", bibtexEntry.getType().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXMP(File file, Collection collection, boolean bl) throws IOException, TransformerException {
        PDDocument pDDocument = null;
        try {
            Object object;
            Object object2;
            PDDocumentCatalog pDDocumentCatalog;
            PDMetadata pDMetadata;
            pDDocument = PDDocument.load(file.getAbsoluteFile());
            if (pDDocument.isEncrypted()) {
                throw new EncryptionNotSupportedException("Error: Cannot add metadata to encrypted document.");
            }
            if (bl && collection.size() == 1) {
                XMPUtil.writeDocumentInformation(pDDocument, (BibtexEntry)collection.iterator().next());
                XMPUtil.writeDublinCore(pDDocument, collection);
            }
            XMPMetadata xMPMetadata = (pDMetadata = (pDDocumentCatalog = pDDocument.getDocumentCatalog()).getMetadata()) != null ? new XMPMetadata(XMLUtil.parse(pDMetadata.createInputStream())) : new XMPMetadata();
            xMPMetadata.addXMLNSMapping("http://jabref.sourceforge.net/bibteXMP/", XMPSchemaBibtex.class);
            List list = xMPMetadata.getSchemasByNamespaceURI("http://jabref.sourceforge.net/bibteXMP/");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object2 = (XMPSchemaBibtex)iterator.next();
                ((XMPSchema)object2).getElement().getParentNode().removeChild(((XMPSchema)object2).getElement());
            }
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                object2 = (BibtexEntry)iterator.next();
                object = new XMPSchemaBibtex(xMPMetadata);
                xMPMetadata.addSchema((XMPSchema)object);
                ((XMPSchemaBibtex)object).setBibtexEntry((BibtexEntry)object2);
            }
            object2 = new ByteArrayOutputStream();
            xMPMetadata.save((OutputStream)object2);
            object = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
            PDMetadata pDMetadata2 = new PDMetadata(pDDocument, (InputStream)object, false);
            pDDocumentCatalog.setMetadata(pDMetadata2);
            try {
                pDDocument.save(file.getAbsolutePath());
            }
            catch (COSVisitorException cOSVisitorException) {
                throw new TransformerException("Could not write XMP-metadata: " + cOSVisitorException.getLocalizedMessage());
            }
        }
        finally {
            if (pDDocument != null) {
                pDDocument.close();
            }
        }
    }

    protected static void usage() {
        System.out.println("Read or write XMP-metadata from or to pdf file.");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("Read from PDF and print as bibtex:");
        System.out.println("  xmpUtil <pdf>");
        System.out.println("Read from PDF and print raw XMP:");
        System.out.println("  xmpUtil -x <pdf>");
        System.out.println("Write the entry in <bib> given by <key> to the PDF:");
        System.out.println("  xmpUtil <key> <bib> <pdf>");
        System.out.println("Write all entries in <bib> to the PDF:");
        System.out.println("  xmpUtil <bib> <pdf>");
        System.out.println("");
        System.out.println("To report bugs visit http://jabref.sourceforge.net");
    }

    public static void main(String[] stringArray) throws IOException, TransformerException {
        if (Globals.prefs == null) {
            Globals.prefs = JabRefPreferences.getInstance();
        }
        switch (stringArray.length) {
            case 0: {
                XMPUtil.usage();
                break;
            }
            case 1: {
                if (stringArray[0].endsWith(".pdf")) {
                    List list = XMPUtil.readXMP(new File(stringArray[0]));
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
                        StringWriter stringWriter = new StringWriter();
                        bibtexEntry.write(stringWriter, new LatexFieldFormatter(), false);
                        System.out.println(stringWriter.getBuffer().toString());
                    }
                    break;
                }
                if (stringArray[0].endsWith(".bib")) {
                    ParserResult parserResult = BibtexParser.parse(new FileReader(stringArray[0]));
                    Collection collection = parserResult.getDatabase().getEntries();
                    if (collection.size() == 0) {
                        System.err.println("Could not find BibtexEntry in " + stringArray[0]);
                        break;
                    }
                    System.out.println(XMPUtil.toXMP(collection));
                    break;
                }
                XMPUtil.usage();
                break;
            }
            case 2: {
                if (stringArray[0].equals("-x") && stringArray[1].endsWith(".pdf")) {
                    XMPMetadata xMPMetadata = XMPUtil.readRawXMP(new File(stringArray[1]));
                    if (xMPMetadata == null) {
                        System.err.println("The given pdf does not contain any XMP-metadata.");
                        break;
                    }
                    XMLUtil.save((Node)xMPMetadata.getXMPDocument(), System.out, "UTF-8");
                    break;
                }
                if (stringArray[0].endsWith(".bib") && stringArray[1].endsWith(".pdf")) {
                    ParserResult parserResult = BibtexParser.parse(new FileReader(stringArray[0]));
                    Collection collection = parserResult.getDatabase().getEntries();
                    if (collection.size() == 0) {
                        System.err.println("Could not find BibtexEntry in " + stringArray[0]);
                        break;
                    }
                    XMPUtil.writeXMP(new File(stringArray[1]), collection, false);
                    System.out.println("XMP written.");
                    break;
                }
                XMPUtil.usage();
                break;
            }
            case 3: {
                if (!stringArray[1].endsWith(".bib") && !stringArray[2].endsWith(".pdf")) {
                    XMPUtil.usage();
                    break;
                }
                ParserResult parserResult = BibtexParser.parse(new FileReader(stringArray[1]));
                BibtexEntry bibtexEntry = parserResult.getDatabase().getEntryByKey(stringArray[0]);
                if (bibtexEntry == null) {
                    System.err.println("Could not find BibtexEntry " + stringArray[0] + " in " + stringArray[0]);
                    break;
                }
                XMPUtil.writeXMP(new File(stringArray[2]), bibtexEntry);
                System.out.println("XMP written.");
                break;
            }
            default: {
                XMPUtil.usage();
            }
        }
    }

    public static boolean hasMetadata(InputStream inputStream) {
        try {
            List list = XMPUtil.readXMP(inputStream);
            return list.size() > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

