/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CaseChanger {
    public static final int LOWER = 0;
    public static final int UPPER = 1;
    public static final int UPPER_FIRST = 2;
    public static final int UPPER_EACH_FIRST = 3;
    private static final Pattern UF_PATTERN = Pattern.compile("\\b\\w");
    private static final int numModes = 4;
    private static final String[] modeNames = new String[]{"lower", "UPPER", "Upper first", "Upper Each First"};

    public static String getModeName(int n) {
        return modeNames[n];
    }

    public static String[] getModeNames() {
        return modeNames;
    }

    public static int getNumModes() {
        return 4;
    }

    public static String[] changeCase(String[] stringArray, int n) {
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray2[i] = CaseChanger.changeCase(stringArray[i], n);
        }
        return stringArray2;
    }

    public static String changeCase(String string, int n) {
        switch (n) {
            case 1: {
                return string.toUpperCase();
            }
            case 0: {
                return string.toLowerCase();
            }
            case 2: {
                String string2 = string.toLowerCase();
                Matcher matcher = UF_PATTERN.matcher(string2);
                if (matcher.find()) {
                    return matcher.replaceFirst(matcher.group(0).toUpperCase());
                }
                return string;
            }
            case 3: {
                String string3 = string.toLowerCase();
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                Matcher matcher = UF_PATTERN.matcher(string3);
                while (matcher.find()) {
                    matcher.appendReplacement(stringBuffer, matcher.group(0).toUpperCase());
                    bl = true;
                }
                if (bl) {
                    matcher.appendTail(stringBuffer);
                    return stringBuffer.toString();
                }
                return string;
            }
        }
        return string;
    }
}

