/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.undo;

import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import net.sf.jabref.BasePanel;

public class CountingUndoManager
extends UndoManager {
    private int unchangedPoint = 0;
    private int current = 0;
    private BasePanel panel = null;

    public CountingUndoManager(BasePanel basePanel) {
        this.panel = basePanel;
    }

    public synchronized boolean addEdit(UndoableEdit undoableEdit) {
        ++this.current;
        return super.addEdit(undoableEdit);
    }

    public synchronized void undo() throws CannotUndoException {
        super.undo();
        --this.current;
        this.panel.updateEntryEditorIfShowing();
    }

    public synchronized void redo() throws CannotUndoException {
        super.redo();
        ++this.current;
        this.panel.updateEntryEditorIfShowing();
    }

    public synchronized void markUnchanged() {
        this.unchangedPoint = this.current;
    }

    public boolean hasChanged() {
        return this.current != this.unchangedPoint;
    }
}

