/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.search;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.SearchRule;
import net.sf.jabref.search.SearchExpressionLexer;
import net.sf.jabref.search.SearchExpressionParser;
import net.sf.jabref.search.SearchExpressionTreeParser;

public class SearchExpression
implements SearchRule {
    private SearchExpressionTreeParser treeParser = new SearchExpressionTreeParser();
    private AST ast = null;
    private JabRefPreferences prefs = null;

    public SearchExpression(JabRefPreferences jabRefPreferences, Hashtable hashtable) throws TokenStreamException, RecognitionException, PatternSyntaxException {
        this.prefs = jabRefPreferences;
        SearchExpressionParser searchExpressionParser = new SearchExpressionParser(new SearchExpressionLexer(new StringReader(hashtable.elements().nextElement().toString())));
        searchExpressionParser.caseSensitive = this.prefs.getBoolean("caseSensitiveSearch");
        searchExpressionParser.regex = this.prefs.getBoolean("regExpSearch");
        searchExpressionParser.searchExpression();
        this.ast = searchExpressionParser.getAST();
    }

    public int applyRule(Map map, BibtexEntry bibtexEntry) {
        try {
            return this.treeParser.apply(this.ast, bibtexEntry);
        }
        catch (RecognitionException recognitionException) {
            return 0;
        }
    }
}

