/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.label;

import java.util.Hashtable;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Util;
import net.sf.jabref.label.ArticleLabelRule;
import net.sf.jabref.label.LabelRule;

public class LabelMaker {
    protected LabelRule defaultRule = new ArticleLabelRule();
    protected Hashtable ruleTable = new Hashtable();

    public BibtexEntry applyRule(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) {
        String string = "";
        string = this.ruleTable.containsKey(bibtexEntry.getType().getName()) ? ((LabelRule)this.ruleTable.get(bibtexEntry.getType().getName())).applyRule(bibtexEntry) : this.applyDefaultRule(bibtexEntry);
        string = Util.checkLegalKey(string);
        if (bibtexDatabase.setCiteKeyForEntry(bibtexEntry.getId(), string)) {
            char c = 'b';
            String string2 = string + "a";
            while (bibtexDatabase.setCiteKeyForEntry(bibtexEntry.getId(), string2)) {
                char c2 = c;
                c = (char)(c + 1);
                string2 = string + c2;
            }
        }
        return bibtexEntry;
    }

    public void setDefaultRule(LabelRule labelRule) {
        this.defaultRule = labelRule;
    }

    public String applyDefaultRule(BibtexEntry bibtexEntry) {
        return this.defaultRule.applyRule(bibtexEntry);
    }

    public void addRule(LabelRule labelRule, BibtexEntryType bibtexEntryType) {
        this.ruleTable.put(bibtexEntryType.getName(), labelRule);
    }
}

