/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.util.CaseChanger;

public class JournalAbbreviations {
    static String TOOLTIPTEXT = "<HTML>" + Globals.lang("Switches between full and abbreviated journal name if the journal name is known.") + "<BR>" + Globals.lang("To set up, go to <B>Tools -> Manage journal abbreviations</B>") + ".</HTML>";
    TreeMap fullNameKeyed = new TreeMap();
    HashMap abbrNameKeyed = new HashMap();
    HashMap abbrNoDotsToAbbr = new HashMap();
    TreeMap all = new TreeMap();
    CaseChanger caseChanger = new CaseChanger();

    public JournalAbbreviations() {
    }

    public JournalAbbreviations(String string) {
        this.readJournalList(string);
    }

    public JournalAbbreviations(File file) throws FileNotFoundException {
        this.readJournalList(file);
    }

    public Iterator fullNameIterator() {
        return this.fullNameKeyed.keySet().iterator();
    }

    public boolean isKnownName(String string) {
        String string2 = string.toLowerCase();
        return this.fullNameKeyed.get(string2) != null || this.abbrNameKeyed.get(string2) != null || this.abbrNoDotsToAbbr.get(string2) != null;
    }

    public boolean isAbbreviatedName(String string) {
        String string2 = string.toLowerCase();
        return this.abbrNameKeyed.get(string2) != null || this.abbrNoDotsToAbbr.get(string2) != null;
    }

    public String dotsToNodots(String string) {
        return string.replaceAll("\\.", " ").replaceAll("  ", " ").trim();
    }

    public String getAbbreviatedName(String string, boolean bl) {
        String string2;
        String string3 = string.toLowerCase();
        if (this.fullNameKeyed.containsKey(string3)) {
            string2 = (String)this.fullNameKeyed.get(string3);
        } else if (this.abbrNameKeyed.containsKey(string3)) {
            string2 = string;
        } else if (this.abbrNoDotsToAbbr.containsKey(string3)) {
            string2 = (String)this.abbrNoDotsToAbbr.get(string3);
        } else {
            return null;
        }
        if (!bl) {
            string2 = this.dotsToNodots(string2);
        }
        return string2;
    }

    public String getFullName(String string) {
        String string2 = this.getAbbreviatedName(string, true);
        if (string2 == null) {
            return null;
        }
        string2 = string2.toLowerCase();
        Object object = this.abbrNameKeyed.get(string2);
        if (object == null) {
            if (this.fullNameKeyed.containsKey(string2)) {
                object = string2;
            } else {
                return null;
            }
        }
        string2 = (String)object;
        return string2;
    }

    public void readJournalList(String string) {
        URL uRL = JournalAbbreviations.class.getResource(string);
        try {
            this.readJournalList(new InputStreamReader(uRL.openStream()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void readJournalList(File file) throws FileNotFoundException {
        this.readJournalList(new FileReader(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readJournalList(Reader reader) throws FileNotFoundException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                String[] stringArray2;
                if (string.startsWith("#") || (stringArray2 = string.split("=")).length != 2) continue;
                String string2 = stringArray2[0].trim();
                String string3 = string2.toLowerCase();
                String string4 = stringArray2[1].trim();
                if (string4.indexOf(59) >= 0) {
                    stringArray = string4.split(";");
                    string4 = stringArray[0];
                }
                stringArray = string4.toLowerCase();
                String string5 = this.dotsToNodots(string4);
                String string6 = string5.toLowerCase();
                if (string2.length() <= 0 || string4.length() <= 0) continue;
                this.fullNameKeyed.put(string3, string4);
                this.abbrNameKeyed.put(stringArray, string2);
                this.abbrNoDotsToAbbr.put(string6, string4);
                this.all.put(string2, string4);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public boolean abbreviate(BibtexEntry bibtexEntry, String string, CompoundEdit compoundEdit, boolean bl) {
        Object object = bibtexEntry.getField(string);
        if (object == null) {
            return false;
        }
        String string2 = (String)object;
        if (this.isKnownName(string2) && !this.isAbbreviatedName(string2)) {
            String string3 = this.getAbbreviatedName(string2, bl);
            if (string3 == null) {
                return false;
            }
            bibtexEntry.setField(string, string3);
            compoundEdit.addEdit(new UndoableFieldChange(bibtexEntry, string, string2, string3));
            return true;
        }
        String string4 = this.getFullName(string2);
        if (string4 != null) {
            String string5 = this.getAbbreviatedName(string4, bl);
            if (string5 == null) {
                return false;
            }
            bibtexEntry.setField(string, string5);
            compoundEdit.addEdit(new UndoableFieldChange(bibtexEntry, string, string2, string5));
            return true;
        }
        return false;
    }

    public boolean unabbreviate(BibtexEntry bibtexEntry, String string, CompoundEdit compoundEdit) {
        Object object = bibtexEntry.getField(string);
        if (object == null) {
            return false;
        }
        String string2 = (String)object;
        if (this.isKnownName(string2) && this.isAbbreviatedName(string2)) {
            String string3 = this.getFullName(string2);
            if (string3 == null) {
                return false;
            }
            bibtexEntry.setField(string, string3);
            compoundEdit.addEdit(new UndoableFieldChange(bibtexEntry, string, string2, string3));
            return true;
        }
        return false;
    }

    public Map getJournals() {
        return Collections.unmodifiableMap(this.all);
    }

    public static JComponent getNameSwitcher(final EntryEditor entryEditor, final FieldEditor fieldEditor, final UndoManager undoManager) {
        JButton jButton = new JButton(Globals.lang("Toggle abbreviation"));
        jButton.setToolTipText(TOOLTIPTEXT);
        jButton.addActionListener(new ActionListener(){
            boolean withDots = true;

            public void actionPerformed(ActionEvent actionEvent) {
                String string = fieldEditor.getText();
                if (Globals.journalAbbrev.isKnownName(string)) {
                    String string2;
                    if (Globals.journalAbbrev.isAbbreviatedName(string)) {
                        if (!this.withDots) {
                            string2 = Globals.journalAbbrev.getAbbreviatedName(string, false);
                            this.withDots = true;
                        } else {
                            string2 = Globals.journalAbbrev.getFullName(string);
                        }
                    } else {
                        string2 = Globals.journalAbbrev.getAbbreviatedName(string, true);
                        this.withDots = false;
                    }
                    if (string2 != null) {
                        fieldEditor.setText(string2);
                        entryEditor.storeFieldAction.actionPerformed(new ActionEvent(fieldEditor, 0, ""));
                        undoManager.addEdit(new UndoableFieldChange(entryEditor.getEntry(), fieldEditor.getFieldName(), string, string2));
                    }
                }
            }
        });
        return jButton;
    }

    public TableModel getTableModel() {
        Object[][] objectArray = new Object[this.fullNameKeyed.size()][2];
        int n = 0;
        Object object = this.fullNameIterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            objectArray[n][0] = this.getFullName(string);
            objectArray[n][1] = this.getAbbreviatedName(string, true);
            ++n;
        }
        object = new DefaultTableModel(objectArray, new Object[]{Globals.lang("Full name"), Globals.lang("Abbreviation")}){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        return object;
    }
}

