/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class RisImporter
extends ImportFormat {
    public String getFormatName() {
        return "RIS";
    }

    public String getCLIId() {
        return "ris";
    }

    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        Pattern pattern = Pattern.compile("AU  - .*");
        Pattern pattern2 = Pattern.compile("A1  - .*");
        while ((string = bufferedReader.readLine()) != null) {
            if (!pattern.matcher(string).find() && !pattern2.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    public List importEntries(InputStream inputStream) throws IOException {
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        String[] stringArray = stringBuffer.toString().split("ER  -");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            String string2;
            String string3;
            Serializable serializable;
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray2 = stringArray[i].split("\n");
            for (int j = 0; j < stringArray2.length; ++j) {
                Object object;
                serializable = new StringBuffer(stringArray2[j]);
                boolean bl = false;
                while (!bl && j < stringArray2.length - 1) {
                    if (stringArray2[j + 1].length() >= 6 && !stringArray2[j + 1].substring(2, 6).equals("  - ")) {
                        if (((StringBuffer)serializable).length() > 0 && !Character.isWhitespace(((StringBuffer)serializable).charAt(((StringBuffer)serializable).length() - 1)) && !Character.isWhitespace(stringArray2[j + 1].charAt(0))) {
                            ((StringBuffer)serializable).append(' ');
                        }
                        ((StringBuffer)serializable).append(stringArray2[j + 1]);
                        ++j;
                        continue;
                    }
                    bl = true;
                }
                string3 = ((StringBuffer)serializable).toString();
                if (string3.length() < 6) continue;
                string2 = string3.substring(0, 2);
                String string10 = string3.substring(6).trim();
                if (string2.equals("TY")) {
                    if (string10.equals("BOOK")) {
                        string4 = "book";
                        continue;
                    }
                    if (string10.equals("JOUR") || string10.equals("MGZN")) {
                        string4 = "article";
                        continue;
                    }
                    if (string10.equals("THES")) {
                        string4 = "phdthesis";
                        continue;
                    }
                    if (string10.equals("UNPB")) {
                        string4 = "unpublished";
                        continue;
                    }
                    if (string10.equals("RPRT")) {
                        string4 = "techreport";
                        continue;
                    }
                    if (string10.equals("CONF")) {
                        string4 = "inproceedings";
                        continue;
                    }
                    if (string10.equals("CHAP")) {
                        string4 = "incollection";
                        continue;
                    }
                    string4 = "other";
                    continue;
                }
                if (string2.equals("T1") || string2.equals("TI")) {
                    hashMap.put("title", string10);
                    continue;
                }
                if (string2.equals("T2") || string2.equals("T3") || string2.equals("BT")) {
                    hashMap.put("booktitle", string10);
                    continue;
                }
                if (string2.equals("A1") || string2.equals("AU")) {
                    if (string5.equals("")) {
                        string5 = string10;
                        continue;
                    }
                    string5 = string5 + " and " + string10;
                    continue;
                }
                if (string2.equals("A2")) {
                    if (string6.equals("")) {
                        string6 = string10;
                        continue;
                    }
                    string6 = string6 + " and " + string10;
                    continue;
                }
                if (string2.equals("JA") || string2.equals("JF") || string2.equals("JO")) {
                    if (string4.equals("inproceedings")) {
                        hashMap.put("booktitle", string10);
                        continue;
                    }
                    hashMap.put("journal", string10);
                    continue;
                }
                if (string2.equals("SP")) {
                    string7 = string10;
                    continue;
                }
                if (string2.equals("PB")) {
                    hashMap.put("publisher", string10);
                    continue;
                }
                if (string2.equals("AD") || string2.equals("CY")) {
                    hashMap.put("address", string10);
                    continue;
                }
                if (string2.equals("EP")) {
                    string8 = string10;
                    continue;
                }
                if (string2.equals("SN")) {
                    hashMap.put("issn", string10);
                    continue;
                }
                if (string2.equals("VL")) {
                    hashMap.put("volume", string10);
                    continue;
                }
                if (string2.equals("IS")) {
                    hashMap.put("number", string10);
                    continue;
                }
                if (string2.equals("N2") || string2.equals("AB")) {
                    hashMap.put("abstract", string10);
                    continue;
                }
                if (string2.equals("UR")) {
                    hashMap.put("url", string10);
                    continue;
                }
                if ((string2.equals("Y1") || string2.equals("PY")) && string10.length() >= 4) {
                    object = string10.split("/");
                    hashMap.put("year", object[0]);
                    if (((String[])object).length <= 1 || object[1].length() <= 0) continue;
                    try {
                        int n = Integer.parseInt(object[1]);
                        if (n <= 0 || n > 12) continue;
                        hashMap.put("month", "#" + Globals.MONTHS[n - 1] + "#");
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (string2.equals("KW")) {
                    if (!hashMap.containsKey("keywords")) {
                        hashMap.put("keywords", string10);
                        continue;
                    }
                    object = (String)hashMap.get("keywords");
                    hashMap.put("keywords", (String)object + ", " + string10);
                    continue;
                }
                if (string2.equals("U1") || string2.equals("U2") || string2.equals("N1")) {
                    if (string9.length() > 0) {
                        string9 = string9 + "\n";
                    }
                    string9 = string9 + string10;
                    continue;
                }
                if (!string2.equals("ID")) continue;
                hashMap.put("refid", string10);
            }
            if (string5.length() > 0) {
                string5 = AuthorList.fixAuthor_lastNameFirst(string5);
                hashMap.put("author", string5);
            }
            if (string6.length() > 0) {
                string6 = AuthorList.fixAuthor_lastNameFirst(string6);
                hashMap.put("editor", string6);
            }
            if (string9.length() > 0) {
                hashMap.put("comment", string9);
            }
            hashMap.put("pages", string7 + "--" + string8);
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType(string4));
            serializable = new ArrayList();
            Iterator<Object> iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                string3 = iterator.next();
                string2 = (String)hashMap.get(string3);
                if (string2 != null && string2.trim().length() != 0) continue;
                ((ArrayList)serializable).add(string3);
            }
            iterator = ((ArrayList)serializable).iterator();
            while (iterator.hasNext()) {
                hashMap.remove(iterator.next());
            }
            bibtexEntry.setField(hashMap);
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }
}

