/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.Util;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.imports.ParserResult;

public class OpenDatabaseAction
extends MnemonicAwareAction {
    boolean showDialog;
    private JabRefFrame frame;

    public OpenDatabaseAction(JabRefFrame jabRefFrame, boolean bl) {
        super(GUIGlobals.getImage("open"));
        this.frame = jabRefFrame;
        this.showDialog = bl;
        this.putValue("Name", "Open database");
        this.putValue("AcceleratorKey", Globals.prefs.getKey("Open database"));
        this.putValue("ShortDescription", Globals.lang("Open BibTeX database"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.showDialog) {
            object = Globals.getMultipleFiles(this.frame, new File(Globals.prefs.get("workingDirectory")), ".bib", true);
            if (object != null) {
                for (int i = 0; i < ((String[])object).length; ++i) {
                    if (object[i] == null) continue;
                    arrayList.add(new File((String)object[i]));
                }
            }
        } else {
            Util.pr("Name");
            Util.pr(actionEvent.getActionCommand());
            arrayList.add(new File(Util.checkName(actionEvent.getActionCommand())));
        }
        if (arrayList.size() > 0) {
            object = Collections.unmodifiableList(arrayList);
            new Thread((List)object){
                private final /* synthetic */ List val$theFiles;
                {
                    this.val$theFiles = list;
                }

                public void run() {
                    Iterator iterator = this.val$theFiles.iterator();
                    while (iterator.hasNext()) {
                        OpenDatabaseAction.this.openIt((File)iterator.next(), true);
                    }
                }
            }.start();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                this.frame.getFileHistory().newFile(((File)iterator.next()).getPath());
            }
        }
    }

    public void openIt(File file, boolean bl) {
        if (file != null && file.exists()) {
            this.frame.output(Globals.lang("Opening") + ": '" + file.getPath() + "'");
            try {
                String string = file.getPath();
                Globals.prefs.put("workingDirectory", file.getPath());
                String string2 = Globals.prefs.get("defaultEncoding");
                ParserResult parserResult = OpenDatabaseAction.loadDatabase(file, string2);
                if (parserResult == null || parserResult == ParserResult.INVALID_FORMAT) {
                    JOptionPane.showMessageDialog(null, Globals.lang("Error opening file '" + string + "'"), Globals.lang("Error"), 0);
                    return;
                }
                this.addNewDatabase(parserResult, file, bl);
            }
            catch (Exception exception) {
                Util.showQuickErrorDialog(this.frame, Globals.lang("Open database"), exception);
            }
        }
    }

    public void addNewDatabase(ParserResult parserResult, File file, boolean bl) {
        Object[] objectArray;
        Object object;
        String string = file.getPath();
        BibtexDatabase bibtexDatabase = parserResult.getDatabase();
        HashMap hashMap = parserResult.getMetaData();
        if (parserResult.hasWarnings()) {
            object = parserResult.warnings();
            new Thread((String[])object){
                private final /* synthetic */ String[] val$wrns;
                {
                    this.val$wrns = stringArray;
                }

                public void run() {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < this.val$wrns.length; ++i) {
                        stringBuffer.append(i + 1).append(". ").append(this.val$wrns[i]).append("\n");
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    }
                    JOptionPane.showMessageDialog(OpenDatabaseAction.this.frame, stringBuffer.toString(), Globals.lang("Warnings"), 2);
                }
            }.start();
        }
        object = new BasePanel(this.frame, bibtexDatabase, file, hashMap, parserResult.getEncoding());
        SwingUtilities.invokeLater(new OpenItSwingHelper((BasePanel)object, file, bl));
        Object object2 = parserResult.getEntryTypes().keySet().iterator();
        while (object2.hasNext()) {
            objectArray = ((String)object2.next()).toLowerCase();
            if (BibtexEntryType.ALL_TYPES.get(objectArray) == null) continue;
            object2.remove();
        }
        if (parserResult.getEntryTypes().size() > 0) {
            object2 = new StringBuffer(Globals.lang("Custom entry types found in file") + ": ");
            objectArray = parserResult.getEntryTypes().keySet().toArray();
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                ((StringBuffer)object2).append(objectArray[i].toString()).append(", ");
            }
            String string2 = ((StringBuffer)object2).toString();
            int n = JOptionPane.showConfirmDialog(this.frame, string2.substring(0, string2.length() - 2) + ".\n" + Globals.lang("Remember these entry types?"), Globals.lang("Custom entry types"), 0, 3);
            if (n == 0) {
                HashMap hashMap2 = parserResult.getEntryTypes();
                Iterator iterator = hashMap2.keySet().iterator();
                while (iterator.hasNext()) {
                    BibtexEntryType bibtexEntryType = (BibtexEntryType)hashMap2.get(iterator.next());
                    BibtexEntryType.ALL_TYPES.put(bibtexEntryType.getName().toLowerCase(), bibtexEntryType);
                }
            }
        }
        this.frame.output(Globals.lang("Opened database") + " '" + string + "' " + Globals.lang("with") + " " + bibtexDatabase.getEntryCount() + " " + Globals.lang("entries") + ".");
    }

    public static ParserResult loadDatabase(File file, String string) throws IOException {
        Reader reader;
        Object object;
        Reader reader2 = ImportFormatReader.getReader(file, "UTF8");
        String string2 = OpenDatabaseAction.checkForEncoding(reader2);
        reader2.close();
        if (string2 == null) {
            object = ImportFormatReader.getReader(file, "UTF-16");
            string2 = OpenDatabaseAction.checkForEncoding((Reader)object);
            ((Reader)object).close();
        }
        if (string2 != null) {
            try {
                reader = ImportFormatReader.getReader(file, string2);
                string = string2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                reader = ImportFormatReader.getReader(file, string);
            }
        } else {
            reader = ImportFormatReader.getReader(file, string);
        }
        object = new BibtexParser(reader);
        ParserResult parserResult = ((BibtexParser)object).parse();
        parserResult.setEncoding(string);
        return parserResult;
    }

    private static String checkForEncoding(Reader reader) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            boolean bl = true;
            int n = 0;
            block2: while (bl) {
                int n2 = reader.read();
                stringBuffer.append((char)n2);
                if (n == 0 && Character.isWhitespace((char)n2) || n2 == "This file was created with JabRef".charAt(n)) {
                    ++n;
                } else {
                    bl = false;
                }
                if (n != "This file was created with JabRef".length()) continue;
                bl = false;
                while (reader.read() != 10) {
                }
                for (int i = 0; i < GUIGlobals.encPrefix.length(); ++i) {
                    if (reader.read() != GUIGlobals.encPrefix.charAt(i)) continue block2;
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                while ((n2 = reader.read()) != 10) {
                    stringBuffer2.append((char)n2);
                }
                string = stringBuffer2.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string != null ? string.trim() : null;
    }

    class OpenItSwingHelper
    implements Runnable {
        BasePanel bp;
        boolean raisePanel;
        File file;

        OpenItSwingHelper(BasePanel basePanel, File file, boolean bl) {
            this.bp = basePanel;
            this.raisePanel = bl;
            this.file = file;
        }

        public void run() {
            OpenDatabaseAction.this.frame.addTab(this.bp, this.file, this.raisePanel);
        }
    }
}

