/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import net.sf.jabref.BibtexEntry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OAI2Handler
extends DefaultHandler {
    BibtexEntry be;
    String nextField;
    String authors = "";
    String keyname;
    String forenames;
    String key = "";
    String year = "";
    boolean assigned = false;

    public OAI2Handler(BibtexEntry bibtexEntry) {
        this.be = bibtexEntry;
    }

    public void endDocument() throws SAXException {
        this.be.setField("author", this.authors);
        if (this.year.length() > 0) {
            this.key = this.key + this.year.substring(this.year.length() - 2, this.year.length());
        }
        this.be.setField("bibtexkey", this.key);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("id")) {
            this.nextField = "id";
            this.assigned = true;
        } else if (string2.equals("keyname")) {
            this.nextField = "keyname";
            this.assigned = true;
        } else if (string2.equals("author")) {
            this.keyname = "";
            this.forenames = "";
        } else if (string2.equals("forenames")) {
            this.nextField = "forenames";
            this.assigned = true;
        } else if (string2.equals("journal-ref")) {
            this.nextField = "journal-ref";
            this.assigned = true;
        } else if (string2.equals("datestamp")) {
            this.nextField = "datestamp";
            this.assigned = true;
        } else if (string2.equals("title")) {
            this.nextField = "title";
            this.assigned = true;
        } else if (string2.equals("abstract")) {
            this.nextField = "abstract";
            this.assigned = true;
        } else if (string2.equals("comments")) {
            this.nextField = "comments";
            this.assigned = true;
        } else if (string2.equals("report-no")) {
            this.nextField = "reportno";
            this.assigned = true;
        } else if (string2.equals("error")) {
            this.nextField = "error";
            this.assigned = true;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equals("author")) {
            String string4 = this.forenames + " " + this.keyname;
            if (!this.authors.equals("")) {
                this.authors = this.authors + " and ";
            }
            this.authors = this.authors + string4;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.assigned) {
            if (this.nextField.equals("error")) {
                throw new RuntimeException(string);
            }
            if (this.nextField.equals("id")) {
                this.be.setField("eprint", string);
            } else if (this.nextField.equals("keyname")) {
                this.keyname = string;
                this.key = this.key + string.substring(0, 3);
            } else if (this.nextField.equals("forenames")) {
                this.forenames = string;
            } else if (this.nextField.equals("journal-ref")) {
                String string2 = string.replaceFirst("[0-9].*", "");
                this.be.setField("journal", string2);
                String string3 = string.replaceFirst(string2, "");
                string3 = string3.replaceFirst(" .*", "");
                this.be.setField("volume", string3);
                this.year = string.replaceFirst(".*?\\(", "");
                this.year = this.year.replaceFirst("\\).*", "");
                this.be.setField("year", this.year);
                String string4 = string.replaceFirst(string2, "");
                string4 = string4.replaceFirst(string3, "");
                string4 = string4.replaceFirst("\\(" + this.year + "\\)", "");
                string4 = string4.replaceAll(" ", "");
                this.be.setField("pages", string4);
            } else if (this.nextField.equals("datestamp")) {
                if (this.year.equals("")) {
                    this.year = string.replaceFirst("-.*", "");
                }
                this.be.setField("year", this.year);
            } else if (this.nextField.equals("title")) {
                this.be.setField("title", string);
            } else if (this.nextField.equals("abstract")) {
                this.be.setField("abstract", string);
            } else if (this.nextField.equals("comments")) {
                this.be.setField("comments", string);
            } else if (this.nextField.equals("reportno")) {
                this.be.setField("reportno", string);
            }
            this.assigned = false;
        }
    }
}

