/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.util.ArrayList;
import java.util.TreeSet;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.imports.ImportFormatReader;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class MedlineHandler
extends DefaultHandler {
    ArrayList bibitems = new ArrayList();
    boolean inTitle = false;
    boolean inYear = false;
    boolean inJournal = false;
    boolean inMonth = false;
    boolean inVolume = false;
    boolean inAuthorList = false;
    boolean inAuthor = false;
    boolean inLastName = false;
    boolean inInitials = false;
    boolean inMedlinePgn = false;
    boolean inMedlineID = false;
    boolean inURL = false;
    boolean inIssue = false;
    boolean inPubDate = false;
    boolean inUrl = false;
    boolean inForename = false;
    boolean inAbstractText = false;
    boolean inMedlineDate = false;
    boolean inPubMedID = false;
    boolean inDescriptorName = false;
    boolean inDoi = false;
    boolean inPii = false;
    String title = "";
    String journal = "";
    String keywords = "";
    String author = "";
    String lastName = "";
    String year = "";
    String forename = "";
    String abstractText = "";
    String month = "";
    String volume = "";
    String lastname = "";
    String initials = "";
    String number = "";
    String page = "";
    String medlineID = "";
    String url = "";
    String MedlineDate = "";
    String series = "";
    String editor = "";
    String booktitle = "";
    String type = "article";
    String key = "";
    String address = "";
    String pubmedid = "";
    String doi = "";
    String pii = "";
    ArrayList authors = new ArrayList();
    TreeSet descriptors = new TreeSet();
    int rowNum = 0;
    private static final String KEYWORD_SEPARATOR = "; ";

    public ArrayList getItems() {
        return this.bibitems;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (!string2.equals("PubmedArticle")) {
            if (string2.equals("ArticleTitle")) {
                this.inTitle = true;
                this.title = "";
            } else if (string2.equals("PubDate")) {
                this.inPubDate = true;
            } else if (string2.equals("Year") && this.inPubDate) {
                this.inYear = true;
            } else if (string2.equals("MedlineDate") && this.inPubDate) {
                this.inMedlineDate = true;
            } else if (string2.equals("MedlineTA")) {
                this.inJournal = true;
                this.journal = "";
            } else if (string2.equals("Month") && this.inPubDate) {
                this.inMonth = true;
            } else if (string2.equals("Volume")) {
                this.inVolume = true;
            } else if (string2.equals("AuthorList")) {
                this.inAuthorList = true;
                this.authors.clear();
            } else if (string2.equals("DescriptorName")) {
                this.inDescriptorName = true;
            } else if (string2.equals("Author")) {
                this.inAuthor = true;
                this.author = "";
            } else if (string2.equals("CollectiveName")) {
                this.inForename = true;
                this.forename = "";
            } else if (string2.equals("PMID")) {
                if (this.pubmedid.length() == 0) {
                    this.inPubMedID = true;
                    this.pubmedid = "";
                }
            } else if (string2.equals("LastName")) {
                this.inLastName = true;
                this.lastName = "";
            } else if (string2.equals("ForeName") || string2.equals("FirstName")) {
                this.inForename = true;
                this.forename = "";
            } else if (string2.equals("Issue")) {
                this.inIssue = true;
            } else if (string2.equals("MedlinePgn")) {
                this.inMedlinePgn = true;
            } else if (string2.equals("URL")) {
                this.inUrl = true;
            } else if (string2.equals("Initials")) {
                this.inInitials = true;
            } else if (string2.equals("AbstractText")) {
                this.inAbstractText = true;
            } else if (string2.equals("ArticleId")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string4 = attributes.getQName(i);
                    String string5 = attributes.getType(i);
                    String string6 = attributes.getValue(i);
                    if (string6.equals("doi")) {
                        this.inDoi = true;
                        continue;
                    }
                    if (!string6.equals("pii")) continue;
                    this.inPii = true;
                }
            }
        }
    }

    String join(Object[] objectArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(objectArray[0].toString());
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuffer.append(string);
            stringBuffer.append(objectArray[i].toString());
        }
        return stringBuffer.toString();
    }

    String makeBibtexString() {
        String string = "";
        string = "article{,\n author = { " + this.author + " },\n title = { " + this.title + "},\n journal ={ " + this.journal + "},\n year = " + this.year + "},\n volume = { " + this.volume + "},\n number = { " + this.number + "},\n pages = { " + this.fixPageRange(this.page) + "},\n abstract = { " + this.abstractText + "},\n}";
        return string;
    }

    public void endElement(String string, String string2, String string3) {
        if (string2.equals("PubmedArticle")) {
            if (this.year.equals("") && !this.MedlineDate.equals("")) {
                this.year = this.MedlineDate.substring(0, 4);
            }
            StringBuffer stringBuffer = new StringBuffer();
            Object object = this.descriptors.iterator();
            while (object.hasNext()) {
                String string4 = (String)object.next();
                stringBuffer.append(string4);
                if (!object.hasNext()) continue;
                stringBuffer.append(KEYWORD_SEPARATOR);
            }
            this.keywords = stringBuffer.toString();
            object = new BibtexEntry(Util.createNeutralId(), Globals.getEntryType("article"));
            if (!this.author.equals("")) {
                ((BibtexEntry)object).setField("author", ImportFormatReader.expandAuthorInitials(this.author));
                this.author = "";
            }
            if (!this.title.equals("")) {
                ((BibtexEntry)object).setField("title", this.title);
            }
            if (!this.journal.equals("")) {
                ((BibtexEntry)object).setField("journal", this.journal);
            }
            if (!this.year.equals("")) {
                ((BibtexEntry)object).setField("year", this.year);
            }
            if (!this.page.equals("")) {
                ((BibtexEntry)object).setField("pages", this.fixPageRange(this.page));
            }
            if (!this.volume.equals("")) {
                ((BibtexEntry)object).setField("volume", this.volume);
            }
            if (!this.abstractText.equals("")) {
                ((BibtexEntry)object).setField("abstract", this.abstractText.replaceAll("%", "\\\\%"));
            }
            if (!this.keywords.equals("")) {
                ((BibtexEntry)object).setField("keywords", this.keywords);
            }
            if (!this.month.equals("")) {
                ((BibtexEntry)object).setField("month", this.month);
            }
            if (!this.number.equals("")) {
                ((BibtexEntry)object).setField("number", this.number);
            }
            if (!this.doi.equals("")) {
                ((BibtexEntry)object).setField("doi", this.doi);
                ((BibtexEntry)object).setField("url", "http://dx.doi.org/" + this.doi);
            }
            if (!this.pii.equals("")) {
                ((BibtexEntry)object).setField("pii", this.pii);
            }
            if (!this.pubmedid.equals("")) {
                ((BibtexEntry)object).setField("pmid", this.pubmedid);
            }
            this.bibitems.add(object);
            this.abstractText = "";
            this.author = "";
            this.title = "";
            this.journal = "";
            this.keywords = "";
            this.doi = "";
            this.pii = "";
            this.year = "";
            this.forename = "";
            this.lastName = "";
            this.abstractText = "";
            this.pubmedid = "";
            this.month = "";
            this.volume = "";
            this.lastname = "";
            this.initials = "";
            this.number = "";
            this.page = "";
            this.medlineID = "";
            this.url = "";
            this.MedlineDate = "";
            this.descriptors.clear();
        } else if (string2.equals("ArticleTitle")) {
            this.inTitle = false;
        } else if (string2.equals("PubDate")) {
            this.inPubDate = false;
        } else if (string2.equals("Year")) {
            this.inYear = false;
        } else if (string2.equals("PMID")) {
            this.inPubMedID = false;
        } else if (string2.equals("MedlineDate")) {
            this.inMedlineDate = false;
        } else if (string2.equals("MedlineTA")) {
            this.inJournal = false;
        } else if (string2.equals("Month")) {
            this.inMonth = false;
        } else if (string2.equals("Volume")) {
            this.inVolume = false;
        } else if (string2.equals("AuthorList")) {
            this.author = this.join(this.authors.toArray(), " and ");
            this.inAuthorList = false;
        } else if (string2.equals("Author")) {
            if (this.forename.length() == 3 && this.forename.charAt(1) == ' ') {
                this.forename = this.initials;
            }
            this.author = this.forename + " " + this.lastname;
            this.authors.add(this.author);
            this.inAuthor = false;
            this.forename = "";
            this.initials = "";
            this.lastname = "";
        } else if (string2.equals("DescriptorName")) {
            this.inDescriptorName = false;
        } else if (string2.equals("LastName")) {
            this.inLastName = false;
        } else if (string2.equals("ForeName") || string2.equals("FirstName")) {
            this.inForename = false;
        } else if (string2.equals("Issue")) {
            this.inIssue = false;
        } else if (string2.equals("MedlinePgn")) {
            this.inMedlinePgn = false;
        } else if (string2.equals("URL")) {
            this.inUrl = false;
        } else if (string2.equals("Initials")) {
            this.inInitials = false;
        } else if (string2.equals("AbstractText")) {
            this.inAbstractText = false;
        } else if (string2.equals("ArticleId")) {
            if (this.inDoi) {
                this.inDoi = false;
            } else if (this.inPii) {
                this.inPii = false;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.inTitle) {
            this.title = this.title + new String(cArray, n, n2);
        } else if (this.inYear) {
            this.year = this.year + new String(cArray, n, n2);
        } else if (this.inJournal) {
            this.journal = this.journal + new String(cArray, n, n2);
        } else if (this.inMonth) {
            this.month = this.month + new String(cArray, n, n2);
        } else if (this.inVolume) {
            this.volume = this.volume + new String(cArray, n, n2);
        } else if (this.inLastName) {
            this.lastname = this.lastname + new String(cArray, n, n2);
        } else if (this.inInitials) {
            this.initials = this.initials + new String(cArray, n, n2);
        } else if (this.inIssue) {
            this.number = this.number + new String(cArray, n, n2);
        } else if (this.inMedlinePgn) {
            this.page = this.page + new String(cArray, n, n2);
        } else if (this.inMedlineID) {
            this.medlineID = this.medlineID + new String(cArray, n, n2);
        } else if (this.inURL) {
            this.url = this.url + new String(cArray, n, n2);
        } else if (this.inPubMedID) {
            this.pubmedid = new String(cArray, n, n2);
        } else if (this.inDescriptorName) {
            this.descriptors.add(new String(cArray, n, n2));
        } else if (this.inForename) {
            this.forename = this.forename + new String(cArray, n, n2);
        } else if (this.inAbstractText) {
            this.abstractText = this.abstractText + new String(cArray, n, n2);
        } else if (this.inMedlineDate) {
            this.MedlineDate = this.MedlineDate + new String(cArray, n, n2);
        } else if (this.inDoi) {
            this.doi = new String(cArray, n, n2);
        } else if (this.inPii) {
            this.pii = new String(cArray, n, n2);
        }
    }

    public String fixPageRange(String string) {
        int n;
        int n2 = string.indexOf(45);
        if (n2 < 0) {
            return string;
        }
        String string2 = string.substring(0, n2).trim();
        String string3 = string.substring(n2 + 1).trim();
        int n3 = string3.length();
        if (n3 < (n = string2.length())) {
            string3 = string2.substring(0, n - n3) + string3;
        }
        return string2 + "--" + string3;
    }
}

