/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class CsaImporter
extends ImportFormat {
    private int line;
    private static final Pattern FIELD_PATTERN = Pattern.compile("^([A-Z][A-Z]): ([A-Z].*)$");
    private static final Pattern VOLNOPP_PATTERN = Pattern.compile("[;,\\.]\\s+(\\d+[A-Za-z]?)\\((\\d+(?:-\\d+)?)\\)(?:,\\s+|:)(\\d+-\\d+)");
    private static final Pattern PAGES_PATTERN = Pattern.compile("[;,\\.]\\s+(?:(\\[?[vn]\\.?p\\.?\\]?)|(?:pp?\\.?\\s+)(\\d+[A-Z]?(?:-\\d+[A-Z]?)?)|(\\d+[A-Z]?(?:-\\d+[A-Z]?)?)(?:\\s+pp?))");
    private static final Pattern VOLUME_PATTERN = Pattern.compile("[;,\\.]?\\s+[vV][oO][lL]\\.?\\s+(\\d+[A-Z]?(?:-\\d+[A-Z]?)?)");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[;,\\.]\\s+(?:No|no|Part|part|NUMB)\\.?\\s+([A-Z]?\\d+(?:[/-]\\d+)?)");
    private static final Pattern DATE_PATTERN = Pattern.compile("[;,\\.]\\s+(?:(\\d+)\\s)?(?:([A-Z][a-z][a-z])[\\.,]*\\s)?\\(?(\\d\\d\\d\\d)\\)?(?:\\s([A-Z][a-z][a-z]))?(?:\\s+(\\d+))?");
    private static final Pattern LT_PATTERN = Pattern.compile("\\[Lt\\]");
    private static final String MONS = "jan feb mar apr may jun jul aug sep oct nov dec";
    private static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public String getFormatName() {
        return "CSA";
    }

    public String getCLIId() {
        return "csa";
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string != null) {
            ++this.line;
        }
        return string;
    }

    private void addNote(HashMap hashMap, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (hashMap.get("note") != null) {
            stringBuffer.append((String)hashMap.get("note"));
            stringBuffer.append("\n");
        }
        stringBuffer.append(string);
        hashMap.put("note", stringBuffer.toString());
    }

    private String parseDate(HashMap hashMap, String string) {
        String string2;
        int n = -1;
        Matcher matcher = DATE_PATTERN.matcher(string);
        while (matcher.find()) {
            n = matcher.start();
        }
        if (n == -1) {
            return string;
        }
        if (!matcher.find(n)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = matcher.group(1);
        if (string3 == null) {
            string3 = matcher.group(5);
        } else if (matcher.group(5) != null) {
            return string;
        }
        if (string3 != null && !string3.equals("0")) {
            stringBuffer.append(string3);
            stringBuffer.append(" ");
        } else {
            string3 = null;
        }
        String string4 = matcher.group(2);
        if (string4 == null) {
            string4 = matcher.group(4);
        } else if (matcher.group(4) != null) {
            return string;
        }
        int n2 = -1;
        if (string4 != null) {
            string2 = string4.toLowerCase();
            n2 = MONS.indexOf(string2);
            if (n2 == -1) {
                return string;
            }
            stringBuffer.append(string4);
            stringBuffer.append(" ");
            hashMap.put("month", MONTHS[n2 /= 4]);
        } else if (string3 != null) {
            return string;
        }
        string2 = matcher.group(3);
        stringBuffer.append(string2);
        StringBuffer stringBuffer2 = new StringBuffer();
        if (string3 != null && !string3.equals("0")) {
            stringBuffer2.append("Source Date: ");
            stringBuffer2.append(stringBuffer);
            stringBuffer2.append(".");
            this.addNote(hashMap, stringBuffer2.toString());
        }
        if (hashMap.get("year") != null) {
            String string5 = (String)hashMap.get("year");
            if (!string2.equals(string5)) {
                stringBuffer2.setLength(0);
                stringBuffer2.append("Source Year: ");
                stringBuffer2.append(string2);
                stringBuffer2.append(".");
                this.addNote(hashMap, stringBuffer2.toString());
            }
        } else {
            hashMap.put("year", string2);
        }
        int n3 = string.length();
        StringBuffer stringBuffer3 = new StringBuffer();
        if (matcher.start() > 0) {
            stringBuffer3.append(string.substring(0, matcher.start()));
        }
        if (matcher.end() < n3) {
            stringBuffer3.append(string.substring(matcher.end(), n3));
        }
        return stringBuffer3.toString();
    }

    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.equals("DN: Database Name")) continue;
            return true;
        }
        return false;
    }

    public List importEntries(InputStream inputStream) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        String string = null;
        boolean bl = true;
        int n = 1;
        this.line = 1;
        String string2 = this.readLine(bufferedReader);
        while (true) {
            if (string2 == null || string2.length() == 0) {
                if (!hashMap.isEmpty()) {
                    Object object;
                    if (string == null) {
                        this.addNote(hashMap, "Publication Type: [NOT SPECIFIED]");
                        this.addNote(hashMap, "[PERHAPS NOT FULL FORMAT]");
                        string = "article";
                    }
                    if (string.equals("article") && hashMap.get("booktitle") != null) {
                        object = (String)hashMap.get("booktitle");
                        hashMap.remove("booktitle");
                        hashMap.put("journal", object);
                    }
                    object = new BibtexEntry("__ID", Globals.getEntryType(string));
                    ((BibtexEntry)object).setField(hashMap);
                    arrayList.add(object);
                }
                hashMap.clear();
                bl = true;
                if (string2 == null) break;
                string2 = this.readLine(bufferedReader);
                n = this.line;
                continue;
            }
            int n2 = this.line;
            Matcher matcher = FIELD_PATTERN.matcher(string2);
            if (matcher.find()) {
                Object object;
                String string3;
                String string4 = matcher.group(1);
                String string5 = matcher.group(2);
                stringBuffer.setLength(0);
                while ((string2 = this.readLine(bufferedReader)) != null && string2.startsWith("    ")) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(string2.substring(4));
                }
                String string6 = stringBuffer.toString();
                if (string6 == null || string6.length() == 0) {
                    int n3 = this.line - 1;
                    throw new IOException("illegal empty field at line " + n3);
                }
                matcher = LT_PATTERN.matcher(string6);
                if (matcher.find()) {
                    string6 = matcher.replaceAll("<");
                }
                if (string4.equals("DN") && string5.equalsIgnoreCase("Database Name")) {
                    if (!bl) {
                        throw new IOException("format error at line " + n2 + ": DN out of order");
                    }
                    bl = false;
                    n = n2;
                } else if (bl) {
                    throw new IOException("format error at line " + n2 + ": missing DN");
                }
                if (string4.equals("PT")) {
                    string = null;
                    string3 = string6.toLowerCase();
                    object = string3.split("; ");
                    if (object[0].equals("article") || object[0].equals("journal article")) {
                        string = "article";
                    } else if (((String)object[0]).equals("dissertation")) {
                        string = "phdthesis";
                    } else {
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            if (((String)object[i]).equals("conference")) {
                                string = "inproceedings";
                                break;
                            }
                            if (((String)object[i]).equals("book monograph") && string == null) {
                                string = "book";
                                continue;
                            }
                            if (!((String)object[i]).equals("report") || string != null) continue;
                            string = "techreport";
                        }
                        if (string == null) {
                            string = "misc";
                        }
                    }
                }
                string3 = null;
                if (string4.equals("AB")) {
                    string3 = "abstract";
                } else if (string4.equals("AF")) {
                    string3 = "affiliation";
                } else if (string4.equals("AU")) {
                    string3 = "author";
                } else if (string4.equals("CA")) {
                    string3 = "organization";
                } else if (string4.equals("DE")) {
                    string3 = "keywords";
                } else if (string4.equals("DO")) {
                    string3 = "doi";
                } else if (string4.equals("ED")) {
                    string3 = "editor";
                } else if (string4.equals("IB")) {
                    string3 = "ISBN";
                } else if (string4.equals("IS")) {
                    string3 = "ISSN";
                } else if (string4.equals("JN")) {
                    string3 = "journal";
                } else if (string4.equals("LA")) {
                    string3 = "language";
                } else if (string4.equals("PB")) {
                    string3 = "publisher";
                } else if (string4.equals("PY")) {
                    string3 = "year";
                    if (hashMap.get("year") != null && !string6.equals(object = (String)hashMap.get("year"))) {
                        StringBuffer stringBuffer2 = new StringBuffer();
                        stringBuffer2.append("Source Year: ");
                        stringBuffer2.append((String)object);
                        stringBuffer2.append(".");
                        this.addNote(hashMap, stringBuffer2.toString());
                    }
                } else if (string4.equals("RL")) {
                    string3 = "url";
                    object = string6.split(" ");
                    StringBuffer stringBuffer3 = new StringBuffer();
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        if (((String)object[i]).startsWith("[URL:")) {
                            stringBuffer3.append(((String)object[i]).substring(5));
                            continue;
                        }
                        if (((String)object[i]).endsWith("]")) {
                            int n4 = ((String)object[i]).length();
                            stringBuffer3.append(((String)object[i]).substring(0, n4 - 1));
                            if (i >= ((Object)object).length - 1) continue;
                            stringBuffer3.append("\n");
                            continue;
                        }
                        stringBuffer3.append((String)object[i]);
                    }
                    string6 = stringBuffer3.toString();
                } else if (string4.equals("SO")) {
                    string3 = "booktitle";
                    object = VOLNOPP_PATTERN.matcher(string6);
                    if (((Matcher)object).find()) {
                        hashMap.put("volume", ((Matcher)object).group(1));
                        hashMap.put("number", ((Matcher)object).group(2));
                        hashMap.put("pages", ((Matcher)object).group(3));
                        string6 = ((Matcher)object).replaceFirst("");
                    }
                    object = PAGES_PATTERN.matcher(string6);
                    StringBuffer stringBuffer4 = new StringBuffer();
                    while (((Matcher)object).find()) {
                        String string7;
                        if (stringBuffer4.length() > 0) {
                            stringBuffer4.append(",");
                        }
                        if ((string7 = ((Matcher)object).group(1)) == null) {
                            string7 = ((Matcher)object).group(2);
                        }
                        if (string7 == null) {
                            string7 = ((Matcher)object).group(3);
                        }
                        stringBuffer4.append(string7);
                        string6 = ((Matcher)object).replaceFirst("");
                        object = PAGES_PATTERN.matcher(string6);
                    }
                    if (stringBuffer4.length() > 0) {
                        hashMap.put("pages", stringBuffer4.toString());
                    }
                    if (((Matcher)(object = VOLUME_PATTERN.matcher(string6))).find()) {
                        hashMap.put("volume", ((Matcher)object).group(1));
                        string6 = ((Matcher)object).replaceFirst("");
                    }
                    if (((Matcher)(object = NUMBER_PATTERN.matcher(string6))).find()) {
                        hashMap.put("number", ((Matcher)object).group(1));
                        string6 = ((Matcher)object).replaceFirst("");
                    }
                    string6 = this.parseDate(hashMap, string6);
                    Pattern pattern = Pattern.compile(",?\\s*$");
                    object = pattern.matcher(string6);
                    if (((Matcher)object).find()) {
                        string6 = ((Matcher)object).replaceFirst("");
                    }
                    if (string6.equals("")) {
                        continue;
                    }
                } else if (string4.equals("TI")) {
                    string3 = "title";
                } else if (string4.equals("RE")) continue;
                if (string3 != null) {
                    hashMap.put(string3, string6);
                    continue;
                }
                object = new StringBuffer();
                ((StringBuffer)object).append(string5);
                ((StringBuffer)object).append(": ");
                ((StringBuffer)object).append(string6);
                ((StringBuffer)object).append(".");
                this.addNote(hashMap, ((StringBuffer)object).toString());
                continue;
            }
            string2 = this.readLine(bufferedReader);
        }
        return arrayList;
    }
}

