/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.Util;
import net.sf.jabref.imports.BooleanAssign;
import net.sf.jabref.imports.CiteSeerCitationHandler;
import net.sf.jabref.imports.CiteSeerUndoHandler;
import net.sf.jabref.undo.NamedCompound;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CiteSeerFetcher
extends SidePaneComponent {
    static final String CITESEER_HOST = "citeseer.ist.psu.edu";
    static final String PREFIX_URL = "http://citeseer.ist.psu.edu/";
    static final String PREFIX_IDENTIFIER = "oai:CiteSeerPSU:";
    static final String OAI_HOST = "http://cs1.ist.psu.edu/";
    static final String OAI_URL = "http://cs1.ist.psu.edu/cgi-bin/oai.cgi?";
    static final String OAI_ACTION = "verb=GetRecord";
    static final String OAI_METADATAPREFIX = "metadataPrefix=oai_citeseer";
    protected SAXParserFactory parserFactory;
    protected SAXParser saxParser;
    boolean citationFetcherActive;
    boolean importFetcherActive;
    JProgressBar progressBar;
    JProgressBar progressBar2;
    JLabel citeSeerProgress;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    SidePaneManager sidePaneManager;

    public CiteSeerFetcher(SidePaneManager sidePaneManager) {
        super(sidePaneManager, GUIGlobals.getIconUrl("citeseer"), Globals.lang("CiteSeer Transfer"));
        this.sidePaneManager = sidePaneManager;
        this.progressBar = new JProgressBar();
        this.progressBar2 = new JProgressBar();
        this.citeSeerProgress = new JLabel();
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setStringPainted(true);
        this.progressBar2.setValue(0);
        this.progressBar2.setMinimum(0);
        this.progressBar2.setMaximum(100);
        this.progressBar2.setStringPainted(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.gbl);
        this.con.gridwidth = 0;
        this.con.fill = 1;
        this.con.weightx = 1.0;
        this.con.insets = new Insets(0, 0, 2, 0);
        this.con.insets = new Insets(0, 0, 0, 0);
        this.con.fill = 2;
        this.gbl.setConstraints(this.progressBar, this.con);
        jPanel.add(this.progressBar);
        this.gbl.setConstraints(this.progressBar2, this.con);
        jPanel.add(this.progressBar2);
        this.gbl.setConstraints(this.citeSeerProgress, this.con);
        jPanel.add(this.citeSeerProgress);
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)jPanel, "Center");
        try {
            this.citationFetcherActive = false;
            this.importFetcherActive = false;
            this.parserFactory = SAXParserFactory.newInstance();
            this.saxParser = this.parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public ShowEmptyFetchSetDialog getEmptyFetchSetDialog() {
        return new ShowEmptyFetchSetDialog();
    }

    public synchronized boolean activateCitationFetcher() {
        if (this.citationFetcherActive) {
            return false;
        }
        this.citationFetcherActive = true;
        return true;
    }

    public synchronized void deactivateCitationFetcher() {
        this.citationFetcherActive = false;
    }

    public synchronized boolean activateImportFetcher() {
        if (this.importFetcherActive) {
            return false;
        }
        this.importFetcherActive = true;
        return true;
    }

    public synchronized void deactivateImportFetcher() {
        this.importFetcherActive = false;
    }

    public void beginImportCiteSeerProgress() {
        this.progressBar.setIndeterminate(true);
        this.progressBar.setString("");
        this.progressBar2.setVisible(false);
        this.citeSeerProgress.setText("");
        this.sidePaneManager.show("CiteSeerProgress");
    }

    public void endImportCiteSeerProgress() {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setValue(100);
    }

    public int populate(BibtexDatabase bibtexDatabase, BibtexDatabase bibtexDatabase2) {
        Runnable runnable;
        int n = 0;
        Iterator iterator = bibtexDatabase2.getKeySet().iterator();
        boolean bl = false;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        InitializeProgressBar initializeProgressBar = new InitializeProgressBar();
        InitializeProgressBarTwo initializeProgressBarTwo = new InitializeProgressBarTwo();
        UpdateProgressBarMaximum updateProgressBarMaximum = new UpdateProgressBarMaximum(bibtexDatabase2.getEntryCount());
        this.progressBar2.setVisible(true);
        SwingUtilities.invokeLater(initializeProgressBar);
        SwingUtilities.invokeLater(initializeProgressBarTwo);
        SwingUtilities.invokeLater(updateProgressBarMaximum);
        int n2 = 0;
        UpdateProgressStatus updateProgressStatus = new UpdateProgressStatus(Globals.lang("Fetching Identifiers"));
        SwingUtilities.invokeLater(updateProgressStatus);
        while (iterator.hasNext() && !bl) {
            String string = (String)iterator.next();
            BibtexEntry bibtexEntry = bibtexDatabase2.getEntryById(string);
            bl = this.generateIdentifierList(bibtexEntry, hashtable, hashtable2);
            runnable = new UpdateProgressBarValue(++n2);
            SwingUtilities.invokeLater(runnable);
        }
        if (hashtable2.size() > 0) {
            n = -1;
            runnable = new ShowBadIdentifiersDialog(hashtable2);
            SwingUtilities.invokeLater(runnable);
        }
        if (hashtable.size() > 0) {
            runnable = new UpdateProgressBarTwoMaximum(hashtable.size());
            SwingUtilities.invokeLater(runnable);
        }
        updateProgressStatus = new UpdateProgressStatus(Globals.lang("Fetching Citations"));
        SwingUtilities.invokeLater(updateProgressStatus);
        this.generateCitationList(hashtable, bibtexDatabase);
        Enumeration enumeration = hashtable.elements();
        updateProgressStatus = new UpdateProgressStatus(Globals.lang("Done"));
        SwingUtilities.invokeLater(updateProgressStatus);
        if (bl) {
            n = -2;
        }
        return n;
    }

    private Hashtable generateCitationList(Hashtable hashtable, BibtexDatabase bibtexDatabase) {
        try {
            NamedCompound namedCompound = new NamedCompound(Globals.lang("Import Data from CiteSeer Database"));
            BooleanAssign booleanAssign = new BooleanAssign(false);
            if (hashtable != null && hashtable.size() > 0) {
                int n = 0;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = Util.createNeutralId();
                    BibtexEntry bibtexEntry = new BibtexEntry(string2);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(OAI_URL);
                    stringBuffer.append(OAI_ACTION);
                    stringBuffer.append("&metadataPrefix=oai_citeseer");
                    stringBuffer.append("&identifier=").append(string);
                    URL uRL = new URL(stringBuffer.toString());
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    this.saxParser.parse(httpURLConnection.getInputStream(), (DefaultHandler)new CiteSeerUndoHandler(namedCompound, bibtexEntry, this.panel, booleanAssign));
                    bibtexDatabase.insertEntry(bibtexEntry);
                    UpdateProgressBarTwoValue updateProgressBarTwoValue = new UpdateProgressBarTwoValue(++n);
                    SwingUtilities.invokeLater(updateProgressBarTwoValue);
                }
            }
        }
        catch (SAXException sAXException) {
            System.out.println("SAXException: " + sAXException.getLocalizedMessage());
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            ShowNoConnectionDialog showNoConnectionDialog = new ShowNoConnectionDialog(OAI_HOST);
            SwingUtilities.invokeLater(showNoConnectionDialog);
        }
        catch (KeyCollisionException keyCollisionException) {
            System.out.println("KeyCollisionException: " + keyCollisionException.getLocalizedMessage());
            keyCollisionException.printStackTrace();
        }
        return hashtable;
    }

    public static String generateCanonicalNumber(BibtexEntry bibtexEntry) {
        return CiteSeerFetcher.generateCanonicalNumber((String)bibtexEntry.getField("citeseerurl"));
    }

    public static String generateCanonicalNumber(String string) {
        Pattern pattern;
        Matcher matcher;
        String string2 = null;
        if (string != null && (matcher = (pattern = Pattern.compile("[0-9]+")).matcher(string)).find()) {
            string2 = matcher.group();
        }
        return string2;
    }

    public String generateCanonicalIdentifier(BibtexEntry bibtexEntry) {
        String string = null;
        String string2 = CiteSeerFetcher.generateCanonicalNumber(bibtexEntry);
        if (string2 != null) {
            string = PREFIX_IDENTIFIER + string2;
        }
        return string;
    }

    public static String generateCanonicalURL(String string) {
        String string2 = null;
        String string3 = CiteSeerFetcher.generateCanonicalNumber(string);
        if (string3 != null) {
            string2 = PREFIX_URL + string3 + ".html";
        }
        return string2;
    }

    public static String generateCanonicalURL(BibtexEntry bibtexEntry) {
        return CiteSeerFetcher.generateCanonicalURL((String)bibtexEntry.getField("citeseerurl"));
    }

    private boolean generateIdentifierList(BibtexEntry bibtexEntry, Hashtable hashtable, Hashtable hashtable2) {
        boolean bl = false;
        String string = this.generateCanonicalIdentifier(bibtexEntry);
        try {
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(OAI_URL);
                stringBuffer.append(OAI_ACTION);
                stringBuffer.append("&metadataPrefix=oai_citeseer");
                stringBuffer.append("&identifier=").append(string);
                URL uRL = new URL(stringBuffer.toString());
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                this.saxParser.parse(httpURLConnection.getInputStream(), (DefaultHandler)new CiteSeerCitationHandler(hashtable));
            } else {
                int n = this.panel.mainTable.findEntry(bibtexEntry);
                hashtable2.put(new Integer(n + 1), bibtexEntry);
            }
        }
        catch (SAXException sAXException) {
            System.out.println("SAXException: " + sAXException.getLocalizedMessage());
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getLocalizedMessage());
            ShowNoConnectionDialog showNoConnectionDialog = new ShowNoConnectionDialog(OAI_HOST);
            bl = true;
            SwingUtilities.invokeLater(showNoConnectionDialog);
        }
        return bl;
    }

    public boolean importCiteSeerEntries(int[] nArray, NamedCompound namedCompound) {
        boolean bl = false;
        boolean bl2 = false;
        Vector<Integer> vector = new Vector<Integer>();
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < nArray.length; ++i) {
            vector.add(new Integer(nArray[i]));
        }
        Iterator iterator = vector.iterator();
        BooleanAssign booleanAssign = new BooleanAssign(false);
        BooleanAssign booleanAssign2 = new BooleanAssign(false);
        while (iterator.hasNext() && !bl2) {
            int n = (Integer)iterator.next();
            BooleanAssign booleanAssign3 = new BooleanAssign(false);
            BibtexEntry bibtexEntry = this.panel.mainTable.getEntryAt(n);
            bl2 = this.importCiteSeerEntry(bibtexEntry, namedCompound, booleanAssign, booleanAssign2, booleanAssign3, hashtable);
            if (!booleanAssign3.getValue()) continue;
            bl = true;
        }
        if (hashtable.size() > 0) {
            ShowBadIdentifiersDialog showBadIdentifiersDialog = new ShowBadIdentifiersDialog(hashtable);
            SwingUtilities.invokeLater(showBadIdentifiersDialog);
        }
        return bl;
    }

    public boolean importCiteSeerEntry(BibtexEntry bibtexEntry, NamedCompound namedCompound, BooleanAssign booleanAssign, BooleanAssign booleanAssign2, BooleanAssign booleanAssign3, Hashtable hashtable) {
        boolean bl = false;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        String string = this.generateCanonicalIdentifier(bibtexEntry);
        try {
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(OAI_URL);
                stringBuffer.append(OAI_ACTION);
                stringBuffer.append("&metadataPrefix=oai_citeseer");
                stringBuffer.append("&identifier=").append(string);
                URL uRL = new URL(stringBuffer.toString());
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                InputStream inputStream = httpURLConnection.getInputStream();
                CiteSeerUndoHandler citeSeerUndoHandler = new CiteSeerUndoHandler(namedCompound, bibtexEntry, this.panel, booleanAssign3, booleanAssign, booleanAssign2);
                this.saxParser.parse(inputStream, (DefaultHandler)citeSeerUndoHandler);
            } else {
                int n = this.panel.mainTable.findEntry(bibtexEntry);
                hashtable.put(new Integer(n + 1), bibtexEntry);
            }
        }
        catch (IOException iOException) {
            ShowNoConnectionDialog showNoConnectionDialog = new ShowNoConnectionDialog(OAI_HOST);
            SwingUtilities.invokeLater(showNoConnectionDialog);
            bl = true;
        }
        catch (SAXException sAXException) {
            System.out.println("SAXException: " + sAXException.getLocalizedMessage());
            sAXException.printStackTrace();
            bl = true;
        }
        return bl;
    }

    class UpdateProgressStatus
    implements Runnable {
        protected String status;

        UpdateProgressStatus(String string) {
            this.status = string;
        }

        public void run() {
            CiteSeerFetcher.this.citeSeerProgress.setText(this.status);
        }
    }

    class UpdateProgressBarTwoValue
    implements Runnable {
        protected int counter;

        UpdateProgressBarTwoValue(int n) {
            this.counter = n;
        }

        public void run() {
            CiteSeerFetcher.this.progressBar2.setValue(this.counter);
        }
    }

    class UpdateProgressBarValue
    implements Runnable {
        protected int counter;

        UpdateProgressBarValue(int n) {
            this.counter = n;
        }

        public void run() {
            CiteSeerFetcher.this.progressBar.setValue(this.counter);
        }
    }

    class InitializeProgressBarTwo
    implements Runnable {
        InitializeProgressBarTwo() {
        }

        public void run() {
            CiteSeerFetcher.this.progressBar2.setValue(0);
            CiteSeerFetcher.this.progressBar2.setMinimum(0);
            CiteSeerFetcher.this.progressBar2.setMaximum(100);
            CiteSeerFetcher.this.progressBar2.setString(null);
        }
    }

    class InitializeProgressBar
    implements Runnable {
        InitializeProgressBar() {
        }

        public void run() {
            CiteSeerFetcher.this.progressBar.setValue(0);
            CiteSeerFetcher.this.progressBar.setMinimum(0);
            CiteSeerFetcher.this.progressBar.setMaximum(100);
            CiteSeerFetcher.this.progressBar.setString(null);
        }
    }

    class UpdateProgressBarTwoMaximum
    implements Runnable {
        protected int maximum;

        UpdateProgressBarTwoMaximum(int n) {
            this.maximum = n;
        }

        public void run() {
            CiteSeerFetcher.this.progressBar2.setMaximum(this.maximum);
        }
    }

    class UpdateProgressBarMaximum
    implements Runnable {
        protected int maximum;

        UpdateProgressBarMaximum(int n) {
            this.maximum = n;
        }

        public void run() {
            CiteSeerFetcher.this.progressBar.setMaximum(this.maximum);
        }
    }

    class ShowMissingURLDialog
    implements Runnable {
        protected int rowNumber;

        ShowMissingURLDialog(int n) {
            this.rowNumber = n;
        }

        public void run() {
            JOptionPane.showMessageDialog(CiteSeerFetcher.this.panel.frame(), Globals.lang("The URL field appears to be empty on entry number ") + (this.rowNumber + 1) + ".  " + Globals.lang("Please refer to the JabRef help manual on using the CiteSeer tools."), Globals.lang("CiteSeer Error"), 0);
        }
    }

    class ShowBadURLDialog
    implements Runnable {
        protected String badURL = "";
        protected int rowNumber;

        ShowBadURLDialog(String string, int n) {
            this.badURL = string;
            this.rowNumber = n;
        }

        public void run() {
            JOptionPane.showMessageDialog(CiteSeerFetcher.this.panel.frame(), Globals.lang("Unable to parse the following URL") + ": \"" + this.badURL + '\"' + Globals.lang(" on entry number ") + (this.rowNumber + 1) + ".  " + Globals.lang("Please refer to the JabRef help manual on using the CiteSeer tools."), Globals.lang("CiteSeer Error"), 0);
        }
    }

    class ShowBadIdentifierDialog
    implements Runnable {
        protected String badURL = "";
        protected int rowNumber;

        ShowBadIdentifierDialog(String string, int n) {
            this.badURL = string;
            this.rowNumber = n;
        }

        public void run() {
            JOptionPane.showMessageDialog(CiteSeerFetcher.this.panel.frame(), Globals.lang("Couldn't find an entry associated with this URL") + ": \"" + this.badURL + '\"' + Globals.lang(" on entry number ") + (this.rowNumber + 1) + ".  " + Globals.lang("Please refer to the JabRef help manual on using the CiteSeer tools."), Globals.lang("CiteSeer Error"), 0);
        }
    }

    class ShowBadIdentifiersDialog
    implements Runnable {
        Hashtable rejectedEntries;

        ShowBadIdentifiersDialog(Hashtable hashtable) {
            this.rejectedEntries = hashtable;
        }

        public void run() {
            if (this.rejectedEntries.size() != 1 && this.rejectedEntries.size() > 1) {
                int n;
                String string = "";
                String string2 = "";
                TreeSet treeSet = new TreeSet(this.rejectedEntries.keySet());
                int n2 = treeSet.size();
                for (n = 0; n < n2 - 1 && n < 100; ++n) {
                    Integer n3 = (Integer)treeSet.first();
                    if (string2.equals("")) {
                        string2 = n3.toString();
                    } else {
                        if ((string2 = string2 + ", ").length() > 50) {
                            string2 = string2 + "\n";
                            string = string + string2;
                            string2 = "";
                        }
                        string2 = string2 + n3.toString();
                    }
                    treeSet.remove(n3);
                }
                string = string + string2;
                string = n == 100 ? string + ".." : string + " " + Globals.lang("and") + " " + ((Integer)treeSet.first()).toString();
                JOptionPane.showMessageDialog(CiteSeerFetcher.this.panel.frame(), Globals.lang("Couldn't parse the 'citeseerurl' field of the following entries") + ':' + '\n' + string + ".\n" + Globals.lang("Please refer to the JabRef help manual on using the CiteSeer tools."), Globals.lang("Warning"), 2);
            }
        }
    }

    class ShowNoConnectionDialog
    implements Runnable {
        protected String targetURL = "";

        ShowNoConnectionDialog(String string) {
            this.targetURL = string;
        }

        public void run() {
            JOptionPane.showMessageDialog(CiteSeerFetcher.this.panel.frame(), Globals.lang("Could not connect to host") + " " + this.targetURL + ".  " + Globals.lang("Please check your network connection to this machine."), Globals.lang("CiteSeer Error"), 0);
        }
    }

    class ShowEmptyFetchSetDialog
    implements Runnable {
        ShowEmptyFetchSetDialog() {
        }

        public void run() {
            JOptionPane.showMessageDialog(CiteSeerFetcher.this.panel.frame(), Globals.lang("The CiteSeer fetch operation returned zero results."), "CiteSeer", 1);
            CiteSeerFetcher.this.deactivateCitationFetcher();
        }
    }
}

