/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class BiblioscapeImporter
extends ImportFormat {
    public String getFormatName() {
        return "Biblioscape";
    }

    public String getCLIId() {
        return "biblioscape";
    }

    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        return true;
    }

    public List importEntries(InputStream inputStream) throws IOException {
        String string;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, StringBuffer> hashMap2 = new HashMap<String, StringBuffer>();
        StringBuffer stringBuffer = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() == 0) continue;
            if (string.equals("------")) {
                Object object;
                String[] stringArray = new String[2];
                String[] stringArray2 = new String[2];
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                Vector<String> vector = new Vector<String>();
                Object[] objectArray = hashMap2.entrySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    object = (Map.Entry)objectArray[i];
                    if (object.getKey().equals("AU")) {
                        hashMap.put("author", object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("TI")) {
                        string5 = object.getValue().toString();
                        continue;
                    }
                    if (object.getKey().equals("ST")) {
                        string4 = object.getValue().toString();
                        continue;
                    }
                    if (object.getKey().equals("YP")) {
                        hashMap.put("year", object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("VL")) {
                        hashMap.put("volume", object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("NB")) {
                        hashMap.put("number", object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("PS")) {
                        stringArray2[0] = object.getValue().toString();
                        continue;
                    }
                    if (object.getKey().equals("PE")) {
                        stringArray2[1] = object.getValue().toString();
                        continue;
                    }
                    if (object.getKey().equals("KW")) {
                        hashMap.put("keywords", object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("RT")) {
                        stringArray[0] = object.getValue().toString();
                        continue;
                    }
                    if (object.getKey().equals("SB")) {
                        vector.add("Subject: " + object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("SA")) {
                        vector.add("Secondary Authors: " + object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("NT")) {
                        hashMap.put("note", object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("PB")) {
                        hashMap.put("publisher", object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("TA")) {
                        vector.add("Tertiary Authors: " + object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("TT")) {
                        vector.add("Tertiary Title: " + object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("ED")) {
                        hashMap.put("edition", object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("TW")) {
                        stringArray[1] = object.getValue().toString();
                        continue;
                    }
                    if (object.getKey().equals("QA")) {
                        vector.add("Quaternary Authors: " + object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("QT")) {
                        vector.add("Quaternary Title: " + object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("IS")) {
                        hashMap.put("isbn", object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("AB")) {
                        hashMap.put("abstract", object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("AD")) {
                        string3 = object.getValue().toString();
                        continue;
                    }
                    if (object.getKey().equals("LG")) {
                        hashMap.put("language", object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("CO")) {
                        string2 = object.getValue().toString();
                        continue;
                    }
                    if (object.getKey().equals("UR") || object.getKey().equals("AT")) {
                        String string6 = object.getValue().toString().trim();
                        hashMap.put(string6.startsWith("http://") || string6.startsWith("ftp://") ? "url" : "pdf", object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("C1")) {
                        vector.add("Custom1: " + object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("C2")) {
                        vector.add("Custom2: " + object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("C3")) {
                        vector.add("Custom3: " + object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("C4")) {
                        vector.add("Custom4: " + object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("C5")) {
                        vector.add("Custom5: " + object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("C6")) {
                        vector.add("Custom6: " + object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("DE")) {
                        hashMap.put("annote", object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("CA")) {
                        vector.add("Categories: " + object.getValue().toString());
                        continue;
                    }
                    if (object.getKey().equals("TH")) {
                        vector.add("Short Title: " + object.getValue().toString());
                        continue;
                    }
                    if (!object.getKey().equals("SE")) continue;
                    hashMap.put("chapter", object.getValue().toString());
                }
                String string7 = "misc";
                for (int i = 1; i >= 0 && string7.equals("misc"); --i) {
                    if (stringArray[i] == null) continue;
                    stringArray[i] = stringArray[i].toLowerCase();
                    if (stringArray[i].indexOf("article") >= 0) {
                        string7 = "article";
                        continue;
                    }
                    if (stringArray[i].indexOf("journal") >= 0) {
                        string7 = "article";
                        continue;
                    }
                    if (stringArray[i].indexOf("book section") >= 0) {
                        string7 = "inbook";
                        continue;
                    }
                    if (stringArray[i].indexOf("book") >= 0) {
                        string7 = "book";
                        continue;
                    }
                    if (stringArray[i].indexOf("conference") >= 0) {
                        string7 = "inproceedings";
                        continue;
                    }
                    if (stringArray[i].indexOf("proceedings") >= 0) {
                        string7 = "inproceedings";
                        continue;
                    }
                    if (stringArray[i].indexOf("report") >= 0) {
                        string7 = "techreport";
                        continue;
                    }
                    if (stringArray[i].indexOf("thesis") >= 0 && stringArray[i].indexOf("master") >= 0) {
                        string7 = "mastersthesis";
                        continue;
                    }
                    if (stringArray[i].indexOf("thesis") < 0) continue;
                    string7 = "phdthesis";
                }
                if (string7.equals("article")) {
                    if (string4 != null) {
                        hashMap.put("journal", string4);
                    }
                    if (string5 != null) {
                        hashMap.put("title", string5);
                    }
                } else if (string7.equals("inbook")) {
                    if (string4 != null) {
                        hashMap.put("booktitle", string4);
                    }
                    if (string5 != null) {
                        hashMap.put("title", string5);
                    }
                } else {
                    if (string4 != null) {
                        hashMap.put("booktitle", string4);
                    }
                    if (string5 != null) {
                        hashMap.put("title", string5);
                    }
                }
                if (stringArray2[0] != null || stringArray2[1] != null) {
                    hashMap.put("pages", (stringArray2[0] != null ? stringArray2[0] : "") + (stringArray2[1] != null ? "--" + stringArray2[1] : ""));
                }
                if (string3 != null) {
                    hashMap.put("address", string3 + (string2 != null ? ", " + string2 : ""));
                }
                if (vector.size() > 0) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    for (int i = 0; i < vector.size(); ++i) {
                        stringBuffer2.append(i > 0 ? "; " : "").append(vector.elementAt(i).toString());
                    }
                    hashMap.put("comment", stringBuffer2.toString());
                }
                object = new BibtexEntry("__ID", Globals.getEntryType(string7));
                ((BibtexEntry)object).setField(hashMap);
                arrayList.add(object);
                hashMap.clear();
                hashMap2.clear();
                stringBuffer = null;
                continue;
            }
            if (string.startsWith("--") && string.length() >= 7 && string.substring(4, 7).equals("-- ")) {
                stringBuffer = new StringBuffer(string.substring(7));
                hashMap2.put(string.substring(2, 4), stringBuffer);
                continue;
            }
            if (stringBuffer == null) {
                return null;
            }
            stringBuffer.append(string.trim());
        }
        return arrayList;
    }
}

