/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.uif_lite.component.UIFSplitPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.CheckBoxMessage;
import net.sf.jabref.DuplicateResolverDialog;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.GeneralRenderer;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.UndoableChangeAssignment;
import net.sf.jabref.gui.AttachFileDialog;
import net.sf.jabref.gui.IconComparator;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableRemoveEntry;

public class ImportInspectionDialog
extends JDialog {
    private ImportInspectionDialog ths = this;
    private BasePanel panel;
    private JabRefFrame frame;
    private MetaData metaData;
    private UIFSplitPane contentPane = new UIFSplitPane(0);
    private JTable glTable;
    private TableComparatorChooser comparatorChooser;
    private EventSelectionModel selectionModel;
    private String[] fields;
    private JProgressBar progressBar = new JProgressBar(0);
    private JButton ok = new JButton(Globals.lang("Ok"));
    private JButton cancel = new JButton(Globals.lang("Cancel"));
    private JButton generate = new JButton(Globals.lang("Generate now"));
    private EventList entries = new BasicEventList();
    private SortedList sortedList;
    private List entriesToDelete = new ArrayList();
    private String undoName;
    private ArrayList callBacks = new ArrayList();
    private boolean newDatabase;
    private JMenu groupsAdd = new JMenu(Globals.lang("Add to group"));
    private JPopupMenu popup = new JPopupMenu();
    private JButton selectAll = new JButton(Globals.lang("Select all"));
    private JButton deselectAll = new JButton(Globals.lang("Deselect all"));
    private JButton deselectAllDuplicates = new JButton(Globals.lang("Deselect all duplicates"));
    private JButton stop = new JButton(Globals.lang("Stop"));
    private JButton delete = new JButton(Globals.lang("Delete"));
    private JButton help = new JButton(Globals.lang("Help"));
    private PreviewPanel preview;
    private boolean generatedKeys = false;
    private boolean defaultSelected = true;
    private Rectangle toRect = new Rectangle(0, 0, 1, 1);
    private Map groupAdditions = new HashMap();
    private JCheckBox autoGenerate = new JCheckBox(Globals.lang("Generate keys"), Globals.prefs.getBoolean("generateKeysAfterInspection"));
    private JLabel duplLabel = new JLabel(GUIGlobals.getImage("duplicate"));
    private JLabel pdfLabel = new JLabel(GUIGlobals.getImage("pdfSmall"));
    private JLabel psLabel = new JLabel(GUIGlobals.getImage("psSmall"));
    private JLabel urlLabel = new JLabel(GUIGlobals.getImage("wwwSmall"));
    private final int DUPL_COL = 1;
    private final int PDF_COL = 2;
    private final int PS_COL = 3;
    private final int URL_COL = 4;
    private final int PAD = 5;
    static /* synthetic */ Class class$java$lang$Boolean;

    public void setDefaultSelected(boolean bl) {
        this.defaultSelected = bl;
    }

    public ImportInspectionDialog(JabRefFrame jabRefFrame, BasePanel basePanel, String[] stringArray, String string, boolean bl) {
        Object object;
        this.frame = jabRefFrame;
        this.panel = basePanel;
        this.metaData = basePanel != null ? basePanel.metaData() : new MetaData();
        this.fields = stringArray;
        this.undoName = string;
        this.newDatabase = bl;
        this.preview = new PreviewPanel(this.metaData, Globals.prefs.get("preview1"));
        this.duplLabel.setToolTipText(Globals.lang("Possible duplicate of existing entry. Click to resolve."));
        this.sortedList = new SortedList(this.entries);
        EventTableModel eventTableModel = new EventTableModel(this.sortedList, new EntryTableFormat());
        this.glTable = new EntryTable(eventTableModel);
        GeneralRenderer generalRenderer = new GeneralRenderer(Color.white, true);
        this.glTable.setDefaultRenderer(JLabel.class, generalRenderer);
        this.glTable.setDefaultRenderer(String.class, generalRenderer);
        this.glTable.getInputMap().put(Globals.prefs.getKey("Delete"), "delete");
        DeleteListener deleteListener = new DeleteListener();
        this.glTable.getActionMap().put("delete", deleteListener);
        this.selectionModel = new EventSelectionModel(this.sortedList);
        this.glTable.setSelectionModel(this.selectionModel);
        this.selectionModel.getSelected().addListEventListener(new EntrySelectionListener());
        this.comparatorChooser = new TableComparatorChooser(this.glTable, this.sortedList, TableComparatorChooser.MULTIPLE_COLUMN_KEYBOARD);
        this.setupComparatorChooser();
        this.glTable.addMouseListener(new TableClickListener());
        this.setWidths();
        this.getContentPane().setLayout(new BorderLayout());
        this.progressBar.setIndeterminate(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.contentPane.setTopComponent(new JScrollPane(this.glTable));
        this.contentPane.setBottomComponent(new JScrollPane(this.preview));
        jPanel.add((Component)this.contentPane, "Center");
        jPanel.add((Component)this.progressBar, "South");
        this.popup.add(deleteListener);
        this.popup.addSeparator();
        if (!bl) {
            object = this.metaData.getGroups();
            this.groupsAdd.setEnabled(false);
            this.insertNodes(this.groupsAdd, (GroupTreeNode)object, true);
            this.popup.add(this.groupsAdd);
        }
        this.popup.add(new AttachFile("pdf"));
        this.popup.add(new AttachFile("ps"));
        this.popup.add(new AttachUrl());
        this.getContentPane().add((Component)jPanel, "Center");
        object = new ButtonBarBuilder();
        ((ButtonBarBuilder)object).addGlue();
        ((ButtonBarBuilder)object).addGridded(this.ok);
        ((ButtonBarBuilder)object).addGridded(this.stop);
        ((ButtonBarBuilder)object).addGridded(this.cancel);
        ((ButtonBarBuilder)object).addRelatedGap();
        ((ButtonBarBuilder)object).addGridded(this.help);
        ((ButtonBarBuilder)object).addGlue();
        ((PanelBuilder)object).getPanel().setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addGridded(this.selectAll);
        buttonStackBuilder.addGridded(this.deselectAll);
        buttonStackBuilder.addGridded(this.deselectAllDuplicates);
        buttonStackBuilder.addRelatedGap();
        buttonStackBuilder.addGridded(this.delete);
        buttonStackBuilder.addRelatedGap();
        buttonStackBuilder.addGridded(this.autoGenerate);
        buttonStackBuilder.addGridded(this.generate);
        buttonStackBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel.add((Component)buttonStackBuilder.getPanel(), "West");
        this.ok.setEnabled(false);
        this.generate.setEnabled(false);
        this.ok.addActionListener(new OkListener());
        this.cancel.addActionListener(new CancelListener());
        this.generate.addActionListener(new GenerateListener());
        this.stop.addActionListener(new StopListener());
        this.selectAll.addActionListener(new SelectionButton(true));
        this.deselectAll.addActionListener(new SelectionButton(false));
        this.deselectAllDuplicates.addActionListener(new DeselectDuplicatesButtonListener());
        this.deselectAllDuplicates.setEnabled(false);
        this.delete.addActionListener(deleteListener);
        this.help.addActionListener(new HelpAction(jabRefFrame.helpDiag, GUIGlobals.importInspectionHelp));
        this.getContentPane().add((Component)((PanelBuilder)object).getPanel(), "South");
        this.setSize(new Dimension(650, 650));
    }

    public void setProgress(int n, int n2) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(n2);
        this.progressBar.setValue(n);
    }

    public void addEntry(BibtexEntry bibtexEntry) {
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        arrayList.add(bibtexEntry);
        this.addEntries(arrayList);
    }

    public void addEntries(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
            bibtexEntry.setSearchHit(this.defaultSelected);
            if (this.panel != null && Util.containsDuplicate(this.panel.database(), bibtexEntry) != null || this.internalDuplicate(this.entries, bibtexEntry) != null) {
                bibtexEntry.setGroupHit(true);
                this.deselectAllDuplicates.setEnabled(true);
            }
            this.entries.getReadWriteLock().writeLock().lock();
            this.entries.add(bibtexEntry);
            this.entries.getReadWriteLock().writeLock().unlock();
        }
    }

    protected BibtexEntry internalDuplicate(Collection collection, BibtexEntry bibtexEntry) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry2 = (BibtexEntry)iterator.next();
            if (bibtexEntry2 == bibtexEntry || !Util.isDuplicate(bibtexEntry, bibtexEntry2, Globals.duplicateThreshold)) continue;
            return bibtexEntry2;
        }
        return null;
    }

    public void removeSelectedEntries() {
        int n = this.glTable.getSelectedRow();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.selectionModel.getSelected());
        this.entries.getReadWriteLock().writeLock().lock();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.entries.remove(iterator.next());
        }
        this.entries.getReadWriteLock().writeLock().unlock();
        this.glTable.clearSelection();
        if (n >= 0 && this.entries.size() > 0) {
            n = Math.min(this.entries.size() - 1, n);
            this.glTable.addRowSelectionInterval(n, n);
        }
    }

    public void entryListComplete() {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setVisible(false);
        this.ok.setEnabled(true);
        if (!this.generatedKeys) {
            this.generate.setEnabled(true);
        }
        this.stop.setEnabled(false);
    }

    public List getSelectedEntries() {
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
            if (!bibtexEntry.isSearchHit()) continue;
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }

    public void generateKeys(boolean bl) {
        BibtexEntry bibtexEntry;
        this.entries.getReadWriteLock().writeLock().lock();
        BibtexDatabase bibtexDatabase = null;
        bibtexDatabase = this.panel != null ? this.panel.database() : new BibtexDatabase();
        ArrayList<String> arrayList = new ArrayList<String>(this.entries.size());
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            bibtexEntry = (BibtexEntry)iterator.next();
            try {
                bibtexEntry.setId(Util.createNeutralId());
                bibtexDatabase.insertEntry(bibtexEntry);
            }
            catch (KeyCollisionException keyCollisionException) {
                keyCollisionException.printStackTrace();
            }
            LabelPatternUtil.makeLabel(Globals.prefs.getKeyPattern(), bibtexDatabase, bibtexEntry);
            arrayList.add(bibtexEntry.getCiteKey());
        }
        iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            bibtexEntry = (BibtexEntry)iterator.next();
            bibtexDatabase.removeEntry(bibtexEntry.getId());
        }
        this.entries.getReadWriteLock().writeLock().lock();
        this.glTable.repaint();
    }

    public void insertNodes(JMenu jMenu, GroupTreeNode groupTreeNode, boolean bl) {
        AbstractAction abstractAction = this.getAction(groupTreeNode, bl);
        if (groupTreeNode.getChildCount() == 0) {
            jMenu.add(abstractAction);
            if (abstractAction.isEnabled()) {
                jMenu.setEnabled(true);
            }
            return;
        }
        JMenu jMenu2 = null;
        if (groupTreeNode.getGroup() instanceof AllEntriesGroup) {
            for (int i = 0; i < groupTreeNode.getChildCount(); ++i) {
                this.insertNodes(jMenu, (GroupTreeNode)groupTreeNode.getChildAt(i), bl);
            }
        } else {
            jMenu2 = new JMenu("[" + groupTreeNode.getGroup().getName() + "]");
            jMenu2.setEnabled(abstractAction.isEnabled());
            jMenu2.add(abstractAction);
            jMenu2.add(new JPopupMenu.Separator());
            for (int i = 0; i < groupTreeNode.getChildCount(); ++i) {
                this.insertNodes(jMenu2, (GroupTreeNode)groupTreeNode.getChildAt(i), bl);
            }
            jMenu.add(jMenu2);
            if (jMenu2.isEnabled()) {
                jMenu.setEnabled(true);
            }
        }
    }

    private AbstractAction getAction(GroupTreeNode groupTreeNode, boolean bl) {
        AbstractAction abstractAction = bl ? new AddToGroupAction(groupTreeNode) : new RemoveFromGroupAction(groupTreeNode);
        AbstractGroup abstractGroup = groupTreeNode.getGroup();
        abstractAction.setEnabled(abstractGroup.supportsAdd());
        return abstractAction;
    }

    public void addCallBack(CallBack callBack) {
        this.callBacks.add(callBack);
    }

    private void signalStopFetching() {
        Iterator iterator = this.callBacks.iterator();
        while (iterator.hasNext()) {
            ((CallBack)iterator.next()).stopFetching();
        }
    }

    private void setWidths() {
        int n;
        TableColumnModel tableColumnModel = this.glTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(55);
        tableColumnModel.getColumn(0).setMinWidth(55);
        tableColumnModel.getColumn(0).setMaxWidth(55);
        for (n = 1; n < 5; ++n) {
            tableColumnModel.getColumn(n).setPreferredWidth(GUIGlobals.WIDTH_ICON_COL);
            tableColumnModel.getColumn(n).setMinWidth(GUIGlobals.WIDTH_ICON_COL);
            tableColumnModel.getColumn(n).setMaxWidth(GUIGlobals.WIDTH_ICON_COL);
        }
        for (n = 0; n < this.fields.length; ++n) {
            int n2 = BibtexFields.getFieldLength(this.fields[n]);
            this.glTable.getColumnModel().getColumn(n + 5).setPreferredWidth(n2);
        }
    }

    private void setupComparatorChooser() {
        int n;
        List list = this.comparatorChooser.getComparatorsForColumn(0);
        list.clear();
        list = this.comparatorChooser.getComparatorsForColumn(1);
        list.clear();
        for (n = 2; n < 5; ++n) {
            list = this.comparatorChooser.getComparatorsForColumn(n);
            list.clear();
            if (n == 2) {
                list.add(new IconComparator(new String[]{"pdf"}));
                continue;
            }
            if (n == 3) {
                list.add(new IconComparator(new String[]{"ps"}));
                continue;
            }
            if (n != 4) continue;
            list.add(new IconComparator(new String[]{"url"}));
        }
        for (n = 5; n < 5 + this.fields.length; ++n) {
            list = this.comparatorChooser.getComparatorsForColumn(n);
            list.clear();
            list.add(new FieldComparator(this.fields[n - 5]));
        }
        this.sortedList.getReadWriteLock().writeLock().lock();
        this.comparatorChooser.appendComparator(5, 0, false);
        this.sortedList.getReadWriteLock().writeLock().unlock();
    }

    class EntryTableFormat
    implements TableFormat {
        EntryTableFormat() {
        }

        public int getColumnCount() {
            return 5 + ImportInspectionDialog.this.fields.length;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return Globals.lang("Keep");
            }
            if (n >= 5) {
                return Util.nCase(ImportInspectionDialog.this.fields[n - 5]);
            }
            return "";
        }

        public Object getColumnValue(Object object, int n) {
            BibtexEntry bibtexEntry = (BibtexEntry)object;
            if (n == 0) {
                return bibtexEntry.isSearchHit() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (n < 5) {
                switch (n) {
                    case 1: {
                        return bibtexEntry.isGroupHit() ? ImportInspectionDialog.this.duplLabel : null;
                    }
                    case 2: {
                        Object object2 = bibtexEntry.getField("pdf");
                        if (object2 != null) {
                            ImportInspectionDialog.this.pdfLabel.setToolTipText((String)object2);
                            return ImportInspectionDialog.this.pdfLabel;
                        }
                        return null;
                    }
                    case 3: {
                        Object object3 = bibtexEntry.getField("ps");
                        if (object3 != null) {
                            ImportInspectionDialog.this.psLabel.setToolTipText((String)object3);
                            return ImportInspectionDialog.this.psLabel;
                        }
                        return null;
                    }
                    case 4: {
                        Object object4 = bibtexEntry.getField("url");
                        if (object4 != null) {
                            ImportInspectionDialog.this.urlLabel.setToolTipText((String)object4);
                            return ImportInspectionDialog.this.urlLabel;
                        }
                        return null;
                    }
                }
                return null;
            }
            String string = ImportInspectionDialog.this.fields[n - 5];
            if (string.equals("author") || string.equals("editor")) {
                String string2 = (String)bibtexEntry.getField(string);
                return string2 != null ? AuthorList.fixAuthor_Natbib(string2) : "";
            }
            return bibtexEntry.getField(string);
        }
    }

    class EntryTable
    extends JTable {
        GeneralRenderer renderer;

        public EntryTable(TableModel tableModel) {
            super(tableModel);
            this.renderer = new GeneralRenderer(Color.white, true);
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            return n2 == 0 ? this.getDefaultRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ImportInspectionDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean) : this.renderer;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ImportInspectionDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (n < 5) {
                return class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = ImportInspectionDialog.class$("javax.swing.JLabel")) : class$javax$swing$JLabel;
            }
            return class$java$lang$String == null ? (class$java$lang$String = ImportInspectionDialog.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            BibtexEntry bibtexEntry = (BibtexEntry)ImportInspectionDialog.this.sortedList.get(n);
            bibtexEntry.setSearchHit((Boolean)object);
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
        }
    }

    public static interface CallBack {
        public void done(int var1);

        public void cancelled();

        public void stopFetching();
    }

    class AttachFile
    extends JMenuItem
    implements ActionListener {
        String fileType;

        public AttachFile(String string) {
            super(Globals.lang("Attach %0 file", new String[]{string.toUpperCase()}));
            this.fileType = string;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            BibtexEntry bibtexEntry = (BibtexEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            AttachFileDialog attachFileDialog = new AttachFileDialog((Dialog)ImportInspectionDialog.this.ths, ImportInspectionDialog.this.metaData, bibtexEntry, this.fileType);
            Util.placeDialog(attachFileDialog, ImportInspectionDialog.this.ths);
            attachFileDialog.setVisible(true);
            if (!attachFileDialog.cancelled()) {
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                bibtexEntry.setField(this.fileType, attachFileDialog.getValue());
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                ImportInspectionDialog.this.glTable.repaint();
            }
        }
    }

    class AttachUrl
    extends JMenuItem
    implements ActionListener {
        public AttachUrl() {
            super(Globals.lang("Attach URL"));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            BibtexEntry bibtexEntry = (BibtexEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            String string = JOptionPane.showInputDialog(ImportInspectionDialog.this.ths, Globals.lang("Enter URL"), bibtexEntry.getField("url"));
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            if (string != null) {
                if (string.equals("")) {
                    bibtexEntry.clearField("url");
                } else {
                    bibtexEntry.setField("url", string);
                }
            }
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    class TableClickListener
    implements MouseListener {
        TableClickListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ImportInspectionDialog.this.popup.show(ImportInspectionDialog.this.glTable, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ImportInspectionDialog.this.popup.show(ImportInspectionDialog.this.glTable, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            int n = ImportInspectionDialog.this.glTable.columnAtPoint(mouseEvent.getPoint());
            int n2 = ImportInspectionDialog.this.glTable.rowAtPoint(mouseEvent.getPoint());
            if (n == 1 && ImportInspectionDialog.this.glTable.getValueAt(n2, n) != null) {
                BibtexEntry bibtexEntry = (BibtexEntry)ImportInspectionDialog.this.sortedList.get(n2);
                BibtexEntry bibtexEntry2 = Util.containsDuplicate(ImportInspectionDialog.this.panel.database(), bibtexEntry);
                if (bibtexEntry2 != null) {
                    DuplicateResolverDialog duplicateResolverDialog = new DuplicateResolverDialog(ImportInspectionDialog.this, bibtexEntry2, bibtexEntry, 3);
                    Util.placeDialog(duplicateResolverDialog, ImportInspectionDialog.this);
                    duplicateResolverDialog.setVisible(true);
                    ImportInspectionDialog.this.toFront();
                    if (duplicateResolverDialog.getSelected() == 1) {
                        ImportInspectionDialog.this.entriesToDelete.add(bibtexEntry2);
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        bibtexEntry.setGroupHit(false);
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                    } else if (duplicateResolverDialog.getSelected() == 2) {
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        ImportInspectionDialog.this.entries.remove(bibtexEntry);
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                    } else if (duplicateResolverDialog.getSelected() == 0) {
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        bibtexEntry.setGroupHit(false);
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                    }
                }
                if ((bibtexEntry2 = ImportInspectionDialog.this.internalDuplicate(ImportInspectionDialog.this.entries, bibtexEntry)) != null) {
                    int n3 = DuplicateResolverDialog.resolveDuplicate(ImportInspectionDialog.this, bibtexEntry, bibtexEntry2);
                    if (n3 == 1) {
                        ImportInspectionDialog.this.entries.remove(bibtexEntry2);
                        bibtexEntry.setGroupHit(false);
                    } else if (n3 == 2) {
                        ImportInspectionDialog.this.entries.remove(bibtexEntry);
                    } else if (n3 == 0) {
                        bibtexEntry.setGroupHit(false);
                    }
                }
            }
        }
    }

    class EntrySelectionListener
    implements ListEventListener {
        EntrySelectionListener() {
        }

        public void listChanged(ListEvent listEvent) {
            if (listEvent.getSourceList().size() == 1) {
                ImportInspectionDialog.this.preview.setEntry((BibtexEntry)listEvent.getSourceList().get(0));
                ImportInspectionDialog.this.contentPane.setDividerLocation(0.5);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ImportInspectionDialog.this.preview.scrollRectToVisible(ImportInspectionDialog.this.toRect);
                    }
                });
            }
        }
    }

    class DeselectDuplicatesButtonListener
    implements ActionListener {
        DeselectDuplicatesButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < ImportInspectionDialog.this.glTable.getRowCount(); ++i) {
                if (ImportInspectionDialog.this.glTable.getValueAt(i, 1) == null) continue;
                ImportInspectionDialog.this.glTable.setValueAt(false, i, 0);
            }
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    class SelectionButton
    implements ActionListener {
        private Boolean enable;

        public SelectionButton(boolean bl) {
            this.enable = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < ImportInspectionDialog.this.glTable.getRowCount(); ++i) {
                ImportInspectionDialog.this.glTable.setValueAt(this.enable, i, 0);
            }
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    class MyTableModel
    extends DefaultTableModel {
        MyTableModel() {
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ImportInspectionDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            return class$java$lang$String == null ? (class$java$lang$String = ImportInspectionDialog.class$("java.lang.String")) : class$java$lang$String;
        }
    }

    class MyTable
    extends JTable {
        public MyTable(TableModel tableModel) {
            super(tableModel);
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }

    class DeleteListener
    extends AbstractAction
    implements ActionListener {
        public DeleteListener() {
            super(Globals.lang("Delete"), GUIGlobals.getImage("delete"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImportInspectionDialog.this.removeSelectedEntries();
        }
    }

    class GenerateListener
    implements ActionListener {
        GenerateListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImportInspectionDialog.this.generate.setEnabled(false);
            ImportInspectionDialog.this.generatedKeys = true;
            ImportInspectionDialog.this.generateKeys(true);
        }
    }

    class CancelListener
    implements ActionListener {
        CancelListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImportInspectionDialog.this.signalStopFetching();
            ImportInspectionDialog.this.dispose();
            Iterator iterator = ImportInspectionDialog.this.callBacks.iterator();
            while (iterator.hasNext()) {
                ((CallBack)iterator.next()).cancelled();
            }
        }
    }

    class StopListener
    implements ActionListener {
        StopListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImportInspectionDialog.this.signalStopFetching();
            ImportInspectionDialog.this.entryListComplete();
        }
    }

    class OkListener
    implements ActionListener {
        OkListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            Object object3;
            if (Globals.prefs.getBoolean("warnAboutDuplicatesInInspection")) {
                object3 = ImportInspectionDialog.this.entries.iterator();
                while (object3.hasNext()) {
                    object2 = (BibtexEntry)object3.next();
                    if (!((BibtexEntry)object2).isSearchHit() || !((BibtexEntry)object2).isGroupHit()) continue;
                    object = new CheckBoxMessage(Globals.lang("There are possible duplicates (marked with a 'D' icon) that haven't been resolved. Continue?"), Globals.lang("Disable this confirmation dialog"), false);
                    int n = JOptionPane.showConfirmDialog(ImportInspectionDialog.this, object, Globals.lang("Duplicates found"), 0);
                    if (((CheckBoxMessage)object).isSelected()) {
                        Globals.prefs.putBoolean("warnAboutDuplicatesInInspection", false);
                    }
                    if (n != 1) break;
                    return;
                }
            }
            object3 = new NamedCompound(ImportInspectionDialog.this.undoName);
            if (ImportInspectionDialog.this.entriesToDelete.size() > 0) {
                object2 = ImportInspectionDialog.this.entriesToDelete.iterator();
                while (object2.hasNext()) {
                    object = (BibtexEntry)object2.next();
                    ((CompoundEdit)object3).addEdit(new UndoableRemoveEntry(ImportInspectionDialog.this.panel.database(), (BibtexEntry)object, ImportInspectionDialog.this.panel));
                    ImportInspectionDialog.this.panel.database().removeEntry(((BibtexEntry)object).getId());
                }
            }
            if (ImportInspectionDialog.this.autoGenerate.isSelected() && !ImportInspectionDialog.this.generatedKeys) {
                ImportInspectionDialog.this.generateKeys(false);
            }
            Globals.prefs.putBoolean("generateKeysAfterInspection", ImportInspectionDialog.this.autoGenerate.isSelected());
            object2 = ImportInspectionDialog.this.getSelectedEntries();
            if (object2.size() > 0) {
                if (ImportInspectionDialog.this.newDatabase) {
                    object = new BibtexDatabase();
                    ImportInspectionDialog.this.panel = new BasePanel(ImportInspectionDialog.this.frame, (BibtexDatabase)object, null, new HashMap(), Globals.prefs.get("defaultEncoding"));
                }
                boolean bl = false;
                Util.setAutomaticFields((List)object2);
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
                    bibtexEntry.setSearchHit(false);
                    bibtexEntry.setGroupHit(false);
                    Set set = (Set)ImportInspectionDialog.this.groupAdditions.get(bibtexEntry);
                    if (!bl && set != null) {
                        if (bibtexEntry.getField("bibtexkey") == null) {
                            int n = JOptionPane.showConfirmDialog(ImportInspectionDialog.this, Globals.lang("Cannot add entries to group without generating keys. Generate keys now?"), Globals.lang("Add to group"), 0);
                            if (n == 0) {
                                ImportInspectionDialog.this.generateKeys(false);
                            } else {
                                bl = true;
                            }
                        }
                        if (bibtexEntry.getField("bibtexkey") != null) {
                            Iterator iterator2 = set.iterator();
                            while (iterator2.hasNext()) {
                                GroupTreeNode groupTreeNode = (GroupTreeNode)iterator2.next();
                                if (!groupTreeNode.getGroup().supportsAdd()) continue;
                                AbstractUndoableEdit abstractUndoableEdit = groupTreeNode.getGroup().add(new BibtexEntry[]{bibtexEntry});
                                if (abstractUndoableEdit instanceof UndoableChangeAssignment) {
                                    ((UndoableChangeAssignment)abstractUndoableEdit).setEditedNode(groupTreeNode);
                                }
                                ((CompoundEdit)object3).addEdit(abstractUndoableEdit);
                            }
                        }
                    }
                    try {
                        bibtexEntry.setId(Util.createNeutralId());
                        ImportInspectionDialog.this.panel.database().insertEntry(bibtexEntry);
                        ((CompoundEdit)object3).addEdit(new UndoableInsertEntry(ImportInspectionDialog.this.panel.database(), bibtexEntry, ImportInspectionDialog.this.panel));
                    }
                    catch (KeyCollisionException keyCollisionException) {
                        keyCollisionException.printStackTrace();
                    }
                }
                ((CompoundEdit)object3).end();
                ((ImportInspectionDialog)ImportInspectionDialog.this).panel.undoManager.addEdit((UndoableEdit)object3);
            }
            ImportInspectionDialog.this.dispose();
            SwingUtilities.invokeLater(new Thread((List)object2){
                private final /* synthetic */ List val$selected;
                {
                    this.val$selected = list;
                }

                public void run() {
                    if (ImportInspectionDialog.this.newDatabase) {
                        ImportInspectionDialog.this.frame.addTab(ImportInspectionDialog.this.panel, null, true);
                    }
                    ImportInspectionDialog.this.panel.markBaseChanged();
                    Iterator iterator = ImportInspectionDialog.this.callBacks.iterator();
                    while (iterator.hasNext()) {
                        ((CallBack)iterator.next()).done(this.val$selected.size());
                    }
                }
            });
        }
    }

    class RemoveFromGroupAction
    extends AbstractAction {
        private GroupTreeNode node;

        public RemoveFromGroupAction(GroupTreeNode groupTreeNode) {
            this.node = groupTreeNode;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class AddToGroupAction
    extends AbstractAction {
        private GroupTreeNode node;

        public AddToGroupAction(GroupTreeNode groupTreeNode) {
            super(groupTreeNode.getGroup().getName());
            this.node = groupTreeNode;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImportInspectionDialog.this.selectionModel.getSelected().getReadWriteLock().writeLock().lock();
            Iterator iterator = ImportInspectionDialog.this.selectionModel.getSelected().iterator();
            while (iterator.hasNext()) {
                BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
                HashSet<GroupTreeNode> hashSet = (HashSet<GroupTreeNode>)ImportInspectionDialog.this.groupAdditions.get(bibtexEntry);
                if (hashSet == null) {
                    hashSet = new HashSet<GroupTreeNode>();
                    ImportInspectionDialog.this.groupAdditions.put(bibtexEntry, hashSet);
                }
                hashSet.add(this.node);
            }
            ImportInspectionDialog.this.selectionModel.getSelected().getReadWriteLock().writeLock().unlock();
        }
    }
}

