/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.RegExpRule;
import net.sf.jabref.SearchRule;
import net.sf.jabref.SimpleSearchRule;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.UnsupportedVersionException;
import net.sf.jabref.search.SearchExpressionLexer;
import net.sf.jabref.search.SearchExpressionParser;
import net.sf.jabref.search.SearchExpressionTreeParser;
import net.sf.jabref.util.QuotedStringTokenizer;

public class SearchGroup
extends AbstractGroup
implements SearchRule {
    public static final String ID = "SearchGroup:";
    private final String m_searchExpression;
    private final boolean m_caseSensitive;
    private final boolean m_regExp;
    private final AST m_ast;
    private static final SearchExpressionTreeParser m_treeParser = new SearchExpressionTreeParser();
    private final SearchRule m_searchRule;

    public SearchGroup(String string, String string2, boolean bl, boolean bl2, int n) {
        super(string, n);
        this.m_searchExpression = string2;
        this.m_caseSensitive = bl;
        this.m_regExp = bl2;
        AST aST = null;
        try {
            SearchExpressionParser searchExpressionParser = new SearchExpressionParser(new SearchExpressionLexer(new StringReader(this.m_searchExpression)));
            searchExpressionParser.caseSensitive = this.m_caseSensitive;
            searchExpressionParser.regex = this.m_regExp;
            searchExpressionParser.searchExpression();
            aST = searchExpressionParser.getAST();
        }
        catch (Exception exception) {
            aST = null;
        }
        this.m_ast = aST;
        this.m_searchRule = this.m_ast != null ? this : (this.m_regExp ? new RegExpRule(this.m_caseSensitive) : new SimpleSearchRule(this.m_caseSensitive));
    }

    public static AbstractGroup fromString(String string, BibtexDatabase bibtexDatabase, int n) throws Exception {
        if (!string.startsWith(ID)) {
            throw new Exception("Internal error: SearchGroup cannot be created from \"" + string + "\". " + "Please report this on www.sf.net/projects/jabref");
        }
        QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string.substring(ID.length()), ";", '\\');
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                String string2 = quotedStringTokenizer.nextToken();
                String string3 = quotedStringTokenizer.nextToken();
                boolean bl = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                boolean bl2 = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                return new SearchGroup(Util.unquote(string2, '\\'), Util.unquote(string3, '\\'), bl, bl2, 0);
            }
            case 3: {
                String string4 = quotedStringTokenizer.nextToken();
                int n2 = Integer.parseInt(quotedStringTokenizer.nextToken());
                String string5 = quotedStringTokenizer.nextToken();
                boolean bl = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                boolean bl3 = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                return new SearchGroup(Util.unquote(string4, '\\'), Util.unquote(string5, '\\'), bl, bl3, n2);
            }
        }
        throw new UnsupportedVersionException("SearchGroup", n);
    }

    public SearchRule getSearchRule() {
        return this;
    }

    public String toString() {
        return ID + Util.quote(this.m_name, ";", '\\') + ";" + this.m_context + ";" + Util.quote(this.m_searchExpression, ";", '\\') + ";" + (this.m_caseSensitive ? "1" : "0") + ";" + (this.m_regExp ? "1" : "0") + ";";
    }

    public String getSearchExpression() {
        return this.m_searchExpression;
    }

    public boolean supportsAdd() {
        return false;
    }

    public boolean supportsRemove() {
        return false;
    }

    public AbstractUndoableEdit add(BibtexEntry[] bibtexEntryArray) {
        return null;
    }

    public AbstractUndoableEdit remove(BibtexEntry[] bibtexEntryArray) {
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SearchGroup)) {
            return false;
        }
        SearchGroup searchGroup = (SearchGroup)object;
        return this.m_name.equals(searchGroup.m_name) && this.m_searchExpression.equals(searchGroup.m_searchExpression) && this.m_caseSensitive == searchGroup.m_caseSensitive && this.m_regExp == searchGroup.m_regExp && this.getHierarchicalContext() == searchGroup.getHierarchicalContext();
    }

    public boolean contains(Map map, BibtexEntry bibtexEntry) {
        return this.applyRule(map, bibtexEntry) != 0;
    }

    public boolean contains(BibtexEntry bibtexEntry) {
        return this.contains(new HashMap(), bibtexEntry);
    }

    public int applyRule(Map map, BibtexEntry bibtexEntry) {
        if (this.m_ast == null) {
            map.put("option", this.m_searchExpression);
            return this.m_searchRule.applyRule(map, bibtexEntry);
        }
        try {
            return m_treeParser.apply(this.m_ast, bibtexEntry);
        }
        catch (RecognitionException recognitionException) {
            return 0;
        }
    }

    public AbstractGroup deepCopy() {
        try {
            return new SearchGroup(this.m_name, this.m_searchExpression, this.m_caseSensitive, this.m_regExp, this.m_context);
        }
        catch (Throwable throwable) {
            System.err.println("Internal error: Exception " + throwable + " in SearchGroup.deepCopy(). " + "Please report this on www.sf.net/projects/jabref");
            return null;
        }
    }

    public boolean isCaseSensitive() {
        return this.m_caseSensitive;
    }

    public boolean isRegExp() {
        return this.m_regExp;
    }

    public boolean isDynamic() {
        return true;
    }

    public String getDescription() {
        return SearchGroup.getDescriptionForPreview(this.m_searchExpression, this.m_ast, this.m_caseSensitive, this.m_regExp);
    }

    public static String getDescriptionForPreview(String string, AST aST, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (aST == null) {
            stringBuffer.append(bl2 ? Globals.lang("This group contains entries in which any field contains the regular expression <b>%0</b>", Util.quoteForHTML(string)) : Globals.lang("This group contains entries in which any field contains the term <b>%0</b>", Util.quoteForHTML(string)));
            stringBuffer.append(" (").append(bl ? Globals.lang("case sensitive") : Globals.lang("case insensitive")).append("). ");
            stringBuffer.append(Globals.lang("Entries cannot be manually assigned to or removed from this group."));
            stringBuffer.append("<p><br>").append(Globals.lang("Hint%c To search specific fields only, enter for example%c<p><tt>author%esmith and title%eelectrical</tt>"));
            return stringBuffer.toString();
        }
        stringBuffer.append(Globals.lang("This group contains entries in which")).append(" ");
        stringBuffer.append(SearchGroup.describeNode(aST, bl2, false, false, false));
        stringBuffer.append(". ");
        stringBuffer.append(bl ? Globals.lang("The search is case sensitive.") : Globals.lang("The search is case insensitive."));
        return stringBuffer.toString();
    }

    protected static String describeNode(AST aST, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (aST.getType()) {
            case 20: {
                if (bl2) {
                    stringBuffer.append(Globals.lang("not")).append(" ");
                }
                if (bl4 || bl2) {
                    stringBuffer.append("(");
                }
                stringBuffer.append(SearchGroup.describeNode(aST.getFirstChild(), bl, false, true, false)).append(" ").append(Globals.lang("and")).append(" ").append(SearchGroup.describeNode(aST.getFirstChild().getNextSibling(), bl, false, true, false));
                if (bl4 || bl2) {
                    stringBuffer.append(")");
                }
                return stringBuffer.toString();
            }
            case 21: {
                if (bl2) {
                    stringBuffer.append(Globals.lang("not")).append(" ");
                }
                if (bl3 || bl2) {
                    stringBuffer.append("(");
                }
                stringBuffer.append(SearchGroup.describeNode(aST.getFirstChild(), bl, false, false, true)).append(" ").append(Globals.lang("or")).append(" ").append(SearchGroup.describeNode(aST.getFirstChild().getNextSibling(), bl, false, false, true));
                if (bl3 || bl2) {
                    stringBuffer.append(")");
                }
                return stringBuffer.toString();
            }
            case 22: {
                return SearchGroup.describeNode(aST.getFirstChild(), bl, !bl2, bl3, bl4);
            }
        }
        aST = aST.getFirstChild();
        String string = aST.getText();
        boolean bl5 = !Pattern.matches("\\w+", string);
        aST = aST.getNextSibling();
        int n = aST.getType();
        aST = aST.getNextSibling();
        String string2 = Util.quoteForHTML(aST.getText());
        String string3 = bl5 ? Globals.lang("any field that matches the regular expression <b>%0</b>", Util.quoteForHTML(string)) : Globals.lang("the field <b>%0</b>", Util.quoteForHTML(string));
        switch (n) {
            case 7: 
            case 12: {
                if (bl) {
                    return bl2 ? Globals.lang("%0 doesn't contain the Regular Expression <b>%1</b>", string3, string2) : Globals.lang("%0 contains the Regular Expression <b>%1</b>", string3, string2);
                }
                return bl2 ? Globals.lang("%0 doesn't contain the term <b>%1</b>", string3, string2) : Globals.lang("%0 contains the term <b>%1</b>", string3, string2);
            }
            case 8: 
            case 13: {
                if (bl) {
                    return bl2 ? Globals.lang("%0 doesn't match the Regular Expression <b>%1</b>", string3, string2) : Globals.lang("%0 matches the Regular Expression <b>%1</b>", string3, string2);
                }
                return bl2 ? Globals.lang("%0 doesn't match the term <b>%1</b>", string3, string2) : Globals.lang("%0 matches the term <b>%1</b>", string3, string2);
            }
            case 14: {
                if (bl) {
                    return bl2 ? Globals.lang("%0 contains the Regular Expression <b>%1</b>", string3, string2) : Globals.lang("%0 doesn't contain the Regular Expression <b>%1</b>", string3, string2);
                }
                return bl2 ? Globals.lang("%0 contains the term <b>%1</b>", string3, string2) : Globals.lang("%0 doesn't contain the term <b>%1</b>", string3, string2);
            }
        }
        return "Internal error: Unknown AST node type. Please report this on www.sf.net/projects/jabref";
    }

    public String getShortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<b>");
        if (Globals.prefs.getBoolean("groupShowDynamic")) {
            stringBuffer.append("<i>").append(Util.quoteForHTML(this.getName())).append("</i>");
        } else {
            stringBuffer.append(Util.quoteForHTML(this.getName()));
        }
        stringBuffer.append("</b> - dynamic group (search expression: <b>").append(Util.quoteForHTML(this.m_searchExpression)).append("</b>)");
        switch (this.getHierarchicalContext()) {
            case 2: {
                stringBuffer.append(", includes subgroups");
                break;
            }
            case 1: {
                stringBuffer.append(", refines supergroup");
                break;
            }
        }
        return stringBuffer.toString();
    }
}

