/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.SearchRule;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.UnsupportedVersionException;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.util.QuotedStringTokenizer;

public class KeywordGroup
extends AbstractGroup
implements SearchRule {
    public static final String ID = "KeywordGroup:";
    private final String m_searchField;
    private final String m_searchExpression;
    private final boolean m_caseSensitive;
    private final boolean m_regExp;
    private Pattern m_pattern = null;

    public KeywordGroup(String string, String string2, String string3, boolean bl, boolean bl2, int n) throws IllegalArgumentException, PatternSyntaxException {
        super(string, n);
        this.m_searchField = string2;
        this.m_searchExpression = string3;
        this.m_caseSensitive = bl;
        this.m_regExp = bl2;
        if (this.m_regExp) {
            this.compilePattern();
        }
    }

    protected void compilePattern() throws IllegalArgumentException, PatternSyntaxException {
        this.m_pattern = this.m_caseSensitive ? Pattern.compile(this.m_searchExpression) : Pattern.compile(this.m_searchExpression, 2);
    }

    public static AbstractGroup fromString(String string, BibtexDatabase bibtexDatabase, int n) throws Exception {
        if (!string.startsWith(ID)) {
            throw new Exception("Internal error: KeywordGroup cannot be created from \"" + string + "\". " + "Please report this on www.sf.net/projects/jabref");
        }
        QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string.substring(ID.length()), ";", '\\');
        switch (n) {
            case 0: {
                String string2 = quotedStringTokenizer.nextToken();
                String string3 = quotedStringTokenizer.nextToken();
                String string4 = quotedStringTokenizer.nextToken();
                return new KeywordGroup(Util.unquote(string2, '\\'), Util.unquote(string3, '\\'), Util.unquote(string4, '\\'), false, true, 0);
            }
            case 1: 
            case 2: {
                String string5 = quotedStringTokenizer.nextToken();
                String string6 = quotedStringTokenizer.nextToken();
                String string7 = quotedStringTokenizer.nextToken();
                boolean bl = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                boolean bl2 = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                return new KeywordGroup(Util.unquote(string5, '\\'), Util.unquote(string6, '\\'), Util.unquote(string7, '\\'), bl, bl2, 0);
            }
            case 3: {
                String string8 = quotedStringTokenizer.nextToken();
                int n2 = Integer.parseInt(quotedStringTokenizer.nextToken());
                String string9 = quotedStringTokenizer.nextToken();
                String string10 = quotedStringTokenizer.nextToken();
                boolean bl = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                boolean bl3 = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                return new KeywordGroup(Util.unquote(string8, '\\'), Util.unquote(string9, '\\'), Util.unquote(string10, '\\'), bl, bl3, n2);
            }
        }
        throw new UnsupportedVersionException("KeywordGroup", n);
    }

    public SearchRule getSearchRule() {
        return this;
    }

    public String toString() {
        return ID + Util.quote(this.m_name, ";", '\\') + ";" + this.m_context + ";" + Util.quote(this.m_searchField, ";", '\\') + ";" + Util.quote(this.m_searchExpression, ";", '\\') + ";" + (this.m_caseSensitive ? "1" : "0") + ";" + (this.m_regExp ? "1" : "0") + ";";
    }

    public boolean supportsAdd() {
        return !this.m_regExp;
    }

    public boolean supportsRemove() {
        return !this.m_regExp;
    }

    public AbstractUndoableEdit add(BibtexEntry[] bibtexEntryArray) {
        if (!this.supportsAdd()) {
            return null;
        }
        if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
            NamedCompound namedCompound = new NamedCompound(Globals.lang("add entries to group"));
            boolean bl = false;
            for (int i = 0; i < bibtexEntryArray.length; ++i) {
                if (this.applyRule(null, bibtexEntryArray[i]) != 0) continue;
                String string = (String)bibtexEntryArray[i].getField(this.m_searchField);
                String string2 = Globals.prefs.get("groupKeywordSeparator");
                String string3 = (string == null ? "" : string + string2) + this.m_searchExpression;
                bibtexEntryArray[i].setField(this.m_searchField, string3);
                namedCompound.addEdit(new UndoableFieldChange(bibtexEntryArray[i], this.m_searchField, string, string3));
                bl = true;
            }
            if (bl) {
                namedCompound.end();
            }
            return bl ? namedCompound : null;
        }
        return null;
    }

    public AbstractUndoableEdit remove(BibtexEntry[] bibtexEntryArray) {
        if (!this.supportsRemove()) {
            return null;
        }
        if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
            NamedCompound namedCompound = new NamedCompound(Globals.lang("remove from group"));
            boolean bl = false;
            for (int i = 0; i < bibtexEntryArray.length; ++i) {
                if (this.applyRule(null, bibtexEntryArray[i]) <= 0) continue;
                String string = (String)bibtexEntryArray[i].getField(this.m_searchField);
                this.removeMatches(bibtexEntryArray[i]);
                namedCompound.addEdit(new UndoableFieldChange(bibtexEntryArray[i], this.m_searchField, string, bibtexEntryArray[i].getField(this.m_searchField)));
                bl = true;
            }
            if (bl) {
                namedCompound.end();
            }
            return bl ? namedCompound : null;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeywordGroup)) {
            return false;
        }
        KeywordGroup keywordGroup = (KeywordGroup)object;
        return this.m_name.equals(keywordGroup.m_name) && this.m_searchField.equals(keywordGroup.m_searchField) && this.m_searchExpression.equals(keywordGroup.m_searchExpression) && this.m_caseSensitive == keywordGroup.m_caseSensitive && this.m_regExp == keywordGroup.m_regExp && this.getHierarchicalContext() == keywordGroup.getHierarchicalContext();
    }

    public boolean contains(Map map, BibtexEntry bibtexEntry) {
        return this.contains(bibtexEntry);
    }

    public boolean contains(BibtexEntry bibtexEntry) {
        String string = (String)bibtexEntry.getField(this.m_searchField);
        if (string == null) {
            return false;
        }
        if (this.m_regExp) {
            return this.m_pattern.matcher(string).find();
        }
        if (this.m_caseSensitive) {
            return string.indexOf(this.m_searchExpression) >= 0;
        }
        return (string = string.toLowerCase()).indexOf(this.m_searchExpression.toLowerCase()) >= 0;
    }

    private void removeMatches(BibtexEntry bibtexEntry) {
        int n;
        String string = (String)bibtexEntry.getField(this.m_searchField);
        if (string == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer(string.toLowerCase());
        StringBuffer stringBuffer3 = this.m_caseSensitive ? stringBuffer : stringBuffer2;
        String string2 = this.m_caseSensitive ? this.m_searchExpression : this.m_searchExpression.toLowerCase();
        String string3 = Globals.prefs.get("groupKeywordSeparator");
        while ((n = stringBuffer3.indexOf(string2)) >= 0) {
            stringBuffer.replace(n, n + string2.length(), "");
            stringBuffer2.replace(n, n + string2.length(), "");
            int n2 = n;
            int n3 = n;
            while (n2 - 1 >= 0 && string3.indexOf(stringBuffer3.charAt(n2 - 1)) >= 0) {
                --n2;
            }
            while (n3 < stringBuffer3.length() && string3.indexOf(stringBuffer3.charAt(n3)) >= 0) {
                ++n3;
            }
            stringBuffer.replace(n2, n3, n2 >= 0 && n3 < stringBuffer.length() ? string3 : "");
            stringBuffer2.replace(n2, n3, n2 >= 0 && n3 < stringBuffer.length() ? string3 : "");
        }
        String string4 = stringBuffer.toString().trim();
        bibtexEntry.setField(this.m_searchField, string4.length() > 0 ? string4 : null);
    }

    public int applyRule(Map map, BibtexEntry bibtexEntry) {
        return this.contains(map, bibtexEntry) ? 1 : 0;
    }

    public AbstractGroup deepCopy() {
        try {
            return new KeywordGroup(this.m_name, this.m_searchField, this.m_searchExpression, this.m_caseSensitive, this.m_regExp, this.m_context);
        }
        catch (Throwable throwable) {
            System.err.println("Internal error: Exception " + throwable + " in KeywordGroup.deepCopy(). " + "Please report this on www.sf.net/projects/jabref");
            return null;
        }
    }

    public boolean isCaseSensitive() {
        return this.m_caseSensitive;
    }

    public boolean isRegExp() {
        return this.m_regExp;
    }

    public String getSearchExpression() {
        return this.m_searchExpression;
    }

    public String getSearchField() {
        return this.m_searchField;
    }

    public boolean isDynamic() {
        return true;
    }

    public String getDescription() {
        return KeywordGroup.getDescriptionForPreview(this.m_searchField, this.m_searchExpression, this.m_caseSensitive, this.m_regExp);
    }

    public static String getDescriptionForPreview(String string, String string2, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bl2 ? Globals.lang("This group contains entries whose <b>%0</b> field contains the regular expression <b>%1</b>", string, Util.quoteForHTML(string2)) : Globals.lang("This group contains entries whose <b>%0</b> field contains the keyword <b>%1</b>", string, Util.quoteForHTML(string2)));
        stringBuffer.append(" (").append(bl ? Globals.lang("case sensitive") : Globals.lang("case insensitive")).append("). ");
        stringBuffer.append(bl2 ? Globals.lang("Entries cannot be manually assigned to or removed from this group.") : Globals.lang("Additionally, entries whose <b>%0</b> field does not contain <b>%1</b> can be assigned manually to this group by selecting them then using either drag and drop or the context menu. This process adds the term <b>%1</b> to each entry's <b>%0</b> field. Entries can be removed manually from this group by selecting them then using the context menu. This process removes the term <b>%1</b> from each entry's <b>%0</b> field.", string, Util.quoteForHTML(string2)));
        return stringBuffer.toString();
    }

    public String getShortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<b>");
        if (Globals.prefs.getBoolean("groupShowDynamic")) {
            stringBuffer.append("<i>").append(Util.quoteForHTML(this.getName())).append("</i>");
        } else {
            stringBuffer.append(Util.quoteForHTML(this.getName()));
        }
        stringBuffer.append("</b> - dynamic group (<b>").append(this.m_searchField).append("</b> contains <b>").append(Util.quoteForHTML(this.m_searchExpression)).append("</b>)");
        switch (this.getHierarchicalContext()) {
            case 2: {
                stringBuffer.append(", includes subgroups");
                break;
            }
            case 1: {
                stringBuffer.append(", refines supergroup");
                break;
            }
        }
        return stringBuffer.toString();
    }
}

