/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import antlr.collections.AST;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FieldContentSelector;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.ExplicitGroup;
import net.sf.jabref.groups.KeywordGroup;
import net.sf.jabref.groups.SearchGroup;
import net.sf.jabref.search.SearchExpressionParser;

class GroupDialog
extends JDialog {
    private static final int INDEX_EXPLICITGROUP = 0;
    private static final int INDEX_KEYWORDGROUP = 1;
    private static final int INDEX_SEARCHGROUP = 2;
    private static final int TEXTFIELD_LENGTH = 30;
    private JTextField m_name = new JTextField(30);
    private JRadioButton m_explicitRadioButton = new JRadioButton(Globals.lang("Statically group entries by manual assignment"));
    private JRadioButton m_keywordsRadioButton = new JRadioButton(Globals.lang("Dynamically group entries by searching a field for a keyword"));
    private JRadioButton m_searchRadioButton = new JRadioButton(Globals.lang("Dynamically group entries by a free-form search expression"));
    private JRadioButton m_independentButton = new JRadioButton(Globals.lang("Independent group: When selected, view only this group's entries"));
    private JRadioButton m_intersectionButton = new JRadioButton(Globals.lang("Refine supergroup: When selected, view entries contained in both this group and its supergroup"));
    private JRadioButton m_unionButton = new JRadioButton(Globals.lang("Include subgroups: When selected, view entries contained in this group or its subgroups"));
    private JTextField m_kgSearchField = new JTextField(30);
    private FieldTextField m_kgSearchTerm = new FieldTextField("keywords", "", false);
    private JCheckBox m_kgCaseSensitive = new JCheckBox(Globals.lang("Case sensitive"));
    private JCheckBox m_kgRegExp = new JCheckBox(Globals.lang("Regular Expression"));
    private JTextField m_sgSearchExpression = new JTextField(30);
    private JCheckBox m_sgCaseSensitive = new JCheckBox(Globals.lang("Case sensitive"));
    private JCheckBox m_sgRegExp = new JCheckBox(Globals.lang("Regular Expression"));
    private JButton m_ok = new JButton(Globals.lang("Ok"));
    private JButton m_cancel = new JButton(Globals.lang("Cancel"));
    private JPanel m_optionsPanel = new JPanel();
    private JLabel m_description = new JLabel(){

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = 1;
            return dimension;
        }
    };
    private boolean m_okPressed = false;
    private final JabRefFrame m_parent;
    private final BasePanel m_basePanel;
    private AbstractGroup m_resultingGroup;
    private AbstractUndoableEdit m_undoAddPreviousEntires = null;
    private final AbstractGroup m_editedGroup;
    private CardLayout m_optionsLayout = new CardLayout();

    public GroupDialog(JabRefFrame jabRefFrame, BasePanel basePanel, AbstractGroup abstractGroup) {
        super(jabRefFrame, Globals.lang("Edit group"), true);
        this.m_basePanel = basePanel;
        this.m_parent = jabRefFrame;
        this.m_editedGroup = abstractGroup;
        this.m_kgSearchField.setText(jabRefFrame.prefs().get("groupsDefaultField"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_explicitRadioButton);
        buttonGroup.add(this.m_keywordsRadioButton);
        buttonGroup.add(this.m_searchRadioButton);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.m_independentButton);
        buttonGroup2.add(this.m_intersectionButton);
        buttonGroup2.add(this.m_unionButton);
        this.m_description.setVerticalAlignment(1);
        this.getRootPane().setDefaultButton(this.m_ok);
        this.m_optionsPanel.setLayout(this.m_optionsLayout);
        this.m_optionsPanel.add((Component)new JPanel(), "0");
        FormLayout formLayout = new FormLayout("right:pref, 4dlu, fill:1dlu:grow, 2dlu, left:pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.append(Globals.lang("Field"));
        defaultFormBuilder.append((Component)this.m_kgSearchField, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Keyword"));
        defaultFormBuilder.append(this.m_kgSearchTerm);
        defaultFormBuilder.append(new FieldContentSelector(this.m_parent, this.m_basePanel, this, this.m_kgSearchTerm, this.m_basePanel.metaData(), null, true, ", "));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.m_kgCaseSensitive, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.m_kgRegExp, 3);
        this.m_optionsPanel.add((Component)defaultFormBuilder.getPanel(), "1");
        FormLayout formLayout2 = new FormLayout("right:pref, 4dlu, fill:1dlu:grow");
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(formLayout2);
        defaultFormBuilder2.append(Globals.lang("Search expression"));
        defaultFormBuilder2.append(this.m_sgSearchExpression);
        defaultFormBuilder2.nextLine();
        defaultFormBuilder2.append((Component)this.m_sgCaseSensitive, 3);
        defaultFormBuilder2.nextLine();
        defaultFormBuilder2.append((Component)this.m_sgRegExp, 3);
        this.m_optionsPanel.add((Component)defaultFormBuilder2.getPanel(), "2");
        FormLayout formLayout3 = new FormLayout("pref, 4dlu, pref", "p");
        formLayout3.setColumnGroups(new int[][]{{1, 3}});
        DefaultFormBuilder defaultFormBuilder3 = new DefaultFormBuilder(formLayout3);
        defaultFormBuilder3.append(this.m_ok);
        defaultFormBuilder3.add(this.m_cancel);
        FormLayout formLayout4 = new FormLayout("right:pref, 4dlu, fill:600px, 4dlu, fill:pref", "p, 3dlu, p, 3dlu, p, 0dlu, p, 0dlu, p, 3dlu, p, 3dlu, p, 0dlu, p, 0dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, top:80dlu, 9dlu, p, , 9dlu, p");
        DefaultFormBuilder defaultFormBuilder4 = new DefaultFormBuilder(formLayout4);
        defaultFormBuilder4.setDefaultDialogBorder();
        defaultFormBuilder4.appendSeparator(Globals.lang("General"));
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.append(Globals.lang("Name"));
        defaultFormBuilder4.append(this.m_name);
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.append((Component)this.m_explicitRadioButton, 5);
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.append((Component)this.m_keywordsRadioButton, 5);
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.append((Component)this.m_searchRadioButton, 5);
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.appendSeparator(Globals.lang("Hierarchical context"));
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.append((Component)this.m_independentButton, 5);
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.append((Component)this.m_intersectionButton, 5);
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.append((Component)this.m_unionButton, 5);
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.appendSeparator(Globals.lang("Options"));
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.append((Component)this.m_optionsPanel, 5);
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.appendSeparator(Globals.lang("Description"));
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.nextLine();
        JScrollPane jScrollPane = new JScrollPane(this.m_description, 20, 30){

            public Dimension getPreferredSize() {
                return this.getMaximumSize();
            }
        };
        defaultFormBuilder4.append((Component)jScrollPane, 5);
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.appendSeparator();
        defaultFormBuilder4.nextLine();
        defaultFormBuilder4.nextLine();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder4.add((Component)defaultFormBuilder3.getPanel(), cellConstraints.xyw(defaultFormBuilder4.getColumn(), defaultFormBuilder4.getRow(), 5, "center, fill"));
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(defaultFormBuilder4.getPanel());
        this.pack();
        this.setResizable(false);
        this.updateComponents();
        this.setLayoutForSelectedGroup();
        Util.placeDialog(this, this.m_parent);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                GroupDialog.this.setLayoutForSelectedGroup();
                GroupDialog.this.updateComponents();
            }
        };
        this.m_explicitRadioButton.addItemListener(itemListener);
        this.m_keywordsRadioButton.addItemListener(itemListener);
        this.m_searchRadioButton.addItemListener(itemListener);
        this.m_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupDialog.this.dispose();
            }
        });
        this.m_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupDialog.this.m_okPressed = true;
                if (GroupDialog.this.m_explicitRadioButton.isSelected()) {
                    if (GroupDialog.this.m_editedGroup instanceof ExplicitGroup) {
                        GroupDialog.this.m_resultingGroup = GroupDialog.this.m_editedGroup.deepCopy();
                        GroupDialog.this.m_resultingGroup.setName(GroupDialog.this.m_name.getText().trim());
                        GroupDialog.this.m_resultingGroup.setHierarchicalContext(GroupDialog.this.getContext());
                    } else {
                        GroupDialog.this.m_resultingGroup = new ExplicitGroup(GroupDialog.this.m_name.getText().trim(), GroupDialog.this.getContext());
                        if (GroupDialog.this.m_editedGroup != null) {
                            GroupDialog.this.addPreviousEntries();
                        }
                    }
                } else if (GroupDialog.this.m_keywordsRadioButton.isSelected()) {
                    GroupDialog.this.m_resultingGroup = new KeywordGroup(GroupDialog.this.m_name.getText().trim(), GroupDialog.this.m_kgSearchField.getText().trim(), GroupDialog.this.m_kgSearchTerm.getText().trim(), GroupDialog.this.m_kgCaseSensitive.isSelected(), GroupDialog.this.m_kgRegExp.isSelected(), GroupDialog.this.getContext());
                    if ((GroupDialog.this.m_editedGroup instanceof ExplicitGroup || GroupDialog.this.m_editedGroup instanceof SearchGroup) && GroupDialog.this.m_resultingGroup.supportsAdd()) {
                        GroupDialog.this.addPreviousEntries();
                    }
                } else if (GroupDialog.this.m_searchRadioButton.isSelected()) {
                    try {
                        GroupDialog.this.m_resultingGroup = new SearchGroup(GroupDialog.this.m_name.getText().trim(), GroupDialog.this.m_sgSearchExpression.getText().trim(), GroupDialog.this.m_sgCaseSensitive.isSelected(), GroupDialog.this.m_sgRegExp.isSelected(), GroupDialog.this.getContext());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                GroupDialog.this.dispose();
            }
        });
        CaretListener caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                GroupDialog.this.updateComponents();
            }
        };
        ItemListener itemListener2 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                GroupDialog.this.updateComponents();
            }
        };
        this.m_name.addCaretListener(caretListener);
        this.m_kgSearchField.addCaretListener(caretListener);
        this.m_kgSearchTerm.addCaretListener(caretListener);
        this.m_kgCaseSensitive.addItemListener(itemListener2);
        this.m_kgRegExp.addItemListener(itemListener2);
        this.m_sgSearchExpression.addCaretListener(caretListener);
        this.m_sgRegExp.addItemListener(itemListener2);
        this.m_sgCaseSensitive.addItemListener(itemListener2);
        if (abstractGroup instanceof KeywordGroup) {
            KeywordGroup keywordGroup = (KeywordGroup)abstractGroup;
            this.m_name.setText(keywordGroup.getName());
            this.m_kgSearchField.setText(keywordGroup.getSearchField());
            this.m_kgSearchTerm.setText(keywordGroup.getSearchExpression());
            this.m_kgCaseSensitive.setSelected(keywordGroup.isCaseSensitive());
            this.m_kgRegExp.setSelected(keywordGroup.isRegExp());
            this.m_keywordsRadioButton.setSelected(true);
            this.setContext(abstractGroup.getHierarchicalContext());
        } else if (abstractGroup instanceof SearchGroup) {
            SearchGroup searchGroup = (SearchGroup)abstractGroup;
            this.m_name.setText(searchGroup.getName());
            this.m_sgSearchExpression.setText(searchGroup.getSearchExpression());
            this.m_sgCaseSensitive.setSelected(searchGroup.isCaseSensitive());
            this.m_sgRegExp.setSelected(searchGroup.isRegExp());
            this.m_searchRadioButton.setSelected(true);
            this.setContext(abstractGroup.getHierarchicalContext());
        } else if (abstractGroup instanceof ExplicitGroup) {
            this.m_name.setText(abstractGroup.getName());
            this.m_explicitRadioButton.setSelected(true);
            this.setContext(abstractGroup.getHierarchicalContext());
        } else {
            this.m_explicitRadioButton.setSelected(true);
            this.setContext(0);
        }
    }

    public boolean okPressed() {
        return this.m_okPressed;
    }

    public AbstractGroup getResultingGroup() {
        return this.m_resultingGroup;
    }

    private void setLayoutForSelectedGroup() {
        if (this.m_explicitRadioButton.isSelected()) {
            this.m_optionsLayout.show(this.m_optionsPanel, String.valueOf(0));
        } else if (this.m_keywordsRadioButton.isSelected()) {
            this.m_optionsLayout.show(this.m_optionsPanel, String.valueOf(1));
        } else if (this.m_searchRadioButton.isSelected()) {
            this.m_optionsLayout.show(this.m_optionsPanel, String.valueOf(2));
        }
    }

    private void updateComponents() {
        boolean bl;
        boolean bl2 = bl = this.m_name.getText().trim().length() > 0;
        if (!bl) {
            this.setDescription(Globals.lang("Please enter a name for the group."));
            this.m_ok.setEnabled(false);
            return;
        }
        if (this.m_keywordsRadioButton.isSelected()) {
            String string = this.m_kgSearchField.getText().trim();
            bl = bl && string.matches("\\w+");
            String string2 = this.m_kgSearchTerm.getText().trim();
            boolean bl3 = bl = bl && string2.length() > 0;
            if (!bl) {
                this.setDescription(Globals.lang("Please enter the field to search (e.g. <b>keywords</b>) and the keyword to search it for (e.g. <b>electrical</b>)."));
            } else if (this.m_kgRegExp.isSelected()) {
                try {
                    Pattern.compile(string2);
                    this.setDescription(KeywordGroup.getDescriptionForPreview(string, string2, this.m_kgCaseSensitive.isSelected(), this.m_kgRegExp.isSelected()));
                }
                catch (Exception exception) {
                    bl = false;
                    this.setDescription(this.formatRegExException(string2, exception));
                }
            } else {
                this.setDescription(KeywordGroup.getDescriptionForPreview(string, string2, this.m_kgCaseSensitive.isSelected(), this.m_kgRegExp.isSelected()));
            }
            this.setNameFontItalic(true);
        } else if (this.m_searchRadioButton.isSelected()) {
            String string = this.m_sgSearchExpression.getText().trim();
            if (!(bl &= string.length() > 0)) {
                this.setDescription(Globals.lang("Please enter a search term. For example, to search all fields for <b>Smith</b>, enter%c<p><tt>smith</tt><p>To search the field <b>Author</b> for <b>Smith</b> and the field <b>Title</b> for <b>electrical</b>, enter%c<p><tt>author%esmith and title%eelectrical</tt>"));
            } else {
                AST aST = SearchExpressionParser.checkSyntax(string, this.m_sgCaseSensitive.isSelected(), this.m_sgRegExp.isSelected());
                this.setDescription(SearchGroup.getDescriptionForPreview(string, aST, this.m_sgCaseSensitive.isSelected(), this.m_sgRegExp.isSelected()));
                if (this.m_sgRegExp.isSelected()) {
                    try {
                        Pattern.compile(string);
                    }
                    catch (Exception exception) {
                        bl = false;
                        this.setDescription(this.formatRegExException(string, exception));
                    }
                }
            }
            this.setNameFontItalic(true);
        } else if (this.m_explicitRadioButton.isSelected()) {
            this.setDescription(ExplicitGroup.getDescriptionForPreview());
            this.setNameFontItalic(false);
        }
        this.m_ok.setEnabled(bl);
    }

    private void addPreviousEntries() {
        int n = JOptionPane.showConfirmDialog(this.m_basePanel.frame(), Globals.lang("Assign the original group's entries to this group?"), Globals.lang("Change of Grouping Method"), 0, 3);
        if (n == 1) {
            return;
        }
        Vector<BibtexEntry> vector = new Vector<BibtexEntry>();
        BibtexEntry[] bibtexEntryArray = this.m_basePanel.database().getEntries().iterator();
        while (bibtexEntryArray.hasNext()) {
            BibtexEntry bibtexEntry = (BibtexEntry)bibtexEntryArray.next();
            if (!this.m_editedGroup.contains(bibtexEntry)) continue;
            vector.add(bibtexEntry);
        }
        if (vector.size() > 0) {
            bibtexEntryArray = new BibtexEntry[vector.size()];
            vector.toArray(bibtexEntryArray);
            if (!Util.warnAssignmentSideEffects(new AbstractGroup[]{this.m_resultingGroup}, bibtexEntryArray, this.m_basePanel.getDatabase(), this)) {
                return;
            }
            if (!(this.m_resultingGroup instanceof ExplicitGroup)) {
                this.m_undoAddPreviousEntires = this.m_resultingGroup.add(bibtexEntryArray);
            }
        }
    }

    protected void setDescription(String string) {
        this.m_description.setText("<html>" + string + "</html>");
    }

    protected String formatRegExException(String string, Exception exception) {
        String[] stringArray = exception.getMessage().split("\\n");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("<br>");
            }
            stringBuffer.append(Util.quoteForHTML(stringArray[i]));
        }
        String string2 = Globals.lang("The regular expression <b>%0</b> is invalid%c", Util.quoteForHTML(string)) + "<p><tt>" + stringBuffer.toString() + "</tt>";
        if (!(exception instanceof PatternSyntaxException)) {
            return string2;
        }
        int n = string2.lastIndexOf("<br>");
        int n2 = string2.lastIndexOf("^");
        if (n >= 0 && n2 >= 0 && n2 > n) {
            return string2.substring(0, n + 4) + string2.substring(n + 4).replaceAll(" ", "&nbsp;");
        }
        return string2;
    }

    public AbstractUndoableEdit getUndoForAddPreviousEntries() {
        return this.m_undoAddPreviousEntires;
    }

    protected void setNameFontItalic(boolean bl) {
        Font font = this.m_name.getFont();
        if (font.isItalic() != bl) {
            font = font.deriveFont(bl ? 2 : 0);
            this.m_name.setFont(font);
        }
    }

    protected int getContext() {
        if (this.m_independentButton.isSelected()) {
            return 0;
        }
        if (this.m_intersectionButton.isSelected()) {
            return 1;
        }
        if (this.m_unionButton.isSelected()) {
            return 2;
        }
        return 0;
    }

    protected void setContext(int n) {
        switch (n) {
            case 1: {
                this.m_intersectionButton.setSelected(true);
                return;
            }
            case 2: {
                this.m_unionButton.setSelected(true);
                return;
            }
        }
        this.m_independentButton.setSelected(true);
    }
}

