/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.io.IOException;
import javax.swing.Icon;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.external.PushToApplication;

public class PushToWinEdt
implements PushToApplication {
    private boolean couldNotCall = false;

    public String getName() {
        return Globals.lang("Insert selected citations into WinEdt");
    }

    public String getApplicationName() {
        return "WinEdt";
    }

    public String getTooltip() {
        return Globals.lang("Push selection to WinEdt");
    }

    public Icon getIcon() {
        return GUIGlobals.getImage("winedt");
    }

    public String getKeyStrokeName() {
        return "Push to WinEdt";
    }

    public void pushEntries(BibtexEntry[] bibtexEntryArray, String string) {
        this.couldNotCall = false;
        String string2 = Globals.prefs.get("winEdtPath");
        try {
            StringBuffer stringBuffer = new StringBuffer("\"[InsText('\\").append(Globals.prefs.get("citeCommand")).append("{").append(string).append("}');]\"");
            Runtime.getRuntime().exec(string2 + " " + stringBuffer.toString());
        }
        catch (IOException iOException) {
            this.couldNotCall = true;
            iOException.printStackTrace();
        }
    }

    public void operationCompleted(BasePanel basePanel) {
        if (this.couldNotCall) {
            basePanel.output(Globals.lang("Error") + ": " + Globals.lang("Could not call executable") + " '" + Globals.prefs.get("winEdtPath") + "'.");
        } else {
            Globals.lang("Pushed citations to WinEdt");
        }
    }

    public boolean requiresBibtexKeys() {
        return true;
    }
}

