/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.util.XMPUtil;

public class DroppedFileHandler {
    private JabRefFrame frame;
    private BasePanel panel;
    private JRadioButton linkInPlace = new JRadioButton();
    private JRadioButton copyRadioButton = new JRadioButton();
    private JRadioButton moveRadioButton = new JRadioButton();
    private JLabel destDirLabel = new JLabel();
    private JCheckBox renameCheckBox = new JCheckBox();
    private JPanel optionsPanel = new JPanel();
    private JPanel importAsNewPanel = new JPanel();

    public DroppedFileHandler(JabRefFrame jabRefFrame, BasePanel basePanel) {
        this.frame = jabRefFrame;
        this.panel = basePanel;
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.linkInPlace);
        buttonGroup.add(this.copyRadioButton);
        buttonGroup.add(this.moveRadioButton);
        this.copyRadioButton.setSelected(true);
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(this.optionsPanel, new FormLayout("left:pref", ""));
        defaultFormBuilder.append(this.linkInPlace);
        defaultFormBuilder.append(this.destDirLabel);
        defaultFormBuilder.append(this.copyRadioButton);
        defaultFormBuilder.append(this.moveRadioButton);
        defaultFormBuilder.append(this.renameCheckBox);
    }

    public void handleDroppedfile(String string, ExternalFileType externalFileType, boolean bl, MainTable mainTable, int n) {
        String string2;
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Drop %0", externalFileType.extension));
        if (this.tryXmpImport(string, externalFileType, bl, mainTable, namedCompound)) {
            this.panel.undoManager.addEdit(namedCompound);
            return;
        }
        BibtexEntry bibtexEntry = mainTable.getEntryAt(n);
        boolean bl2 = false;
        boolean bl3 = bibtexEntry.getCiteKey() != null && bibtexEntry.getCiteKey().length() > 0;
        String string3 = bl3 ? bibtexEntry.getCiteKey() : "Entry has no citekey";
        int n2 = this.showLinkMoveCopyRenameDialog(Globals.lang("Link to file %0", string), externalFileType, bl3, string3, bl2, false);
        if (n2 != 0) {
            return;
        }
        boolean bl4 = true;
        if (this.linkInPlace.isSelected()) {
            string2 = string;
        } else {
            String string4 = string2 = this.renameCheckBox.isSelected() ? bibtexEntry.getCiteKey() + "." + externalFileType.extension : string;
            if (this.copyRadioButton.isSelected()) {
                bl4 = this.doCopy(string, externalFileType, string2, namedCompound);
            } else if (this.moveRadioButton.isSelected()) {
                bl4 = this.doRename(string, externalFileType, string2, namedCompound);
            }
        }
        if (bl4) {
            this.doLink(bibtexEntry, externalFileType, string2, namedCompound);
            this.panel.markBaseChanged();
        }
        this.panel.undoManager.addEdit(namedCompound);
    }

    private boolean tryXmpImport(String string, ExternalFileType externalFileType, boolean bl, MainTable mainTable, NamedCompound namedCompound) {
        String string2;
        if (!externalFileType.extension.equals("pdf")) {
            return false;
        }
        List list = null;
        try {
            list = XMPUtil.readXMP(string);
        }
        catch (Exception exception) {
            return false;
        }
        if (list == null || list.size() == 0) {
            return false;
        }
        JLabel jLabel = new JLabel(Globals.lang("The PDF contains one or several bibtex-records.\nDo you want to import these as new entries into the current database database?"));
        int n = JOptionPane.showConfirmDialog(this.frame, jLabel, Globals.lang("XMP metadata found in PDF: %0", string), 1, 3);
        if (n == 2) {
            return true;
        }
        if (n == 1) {
            return false;
        }
        boolean bl2 = list.size() == 1;
        BibtexEntry bibtexEntry = bl2 ? (BibtexEntry)list.get(0) : null;
        n = this.showLinkMoveCopyRenameDialog(Globals.lang("Link to PDF %0", string), externalFileType, bl2, bl2 ? bibtexEntry.getCiteKey() : "Cannot rename for several entries.", false, !bl2);
        boolean bl3 = true;
        if (this.linkInPlace.isSelected()) {
            string2 = string;
        } else {
            string2 = this.renameCheckBox.isSelected() ? string : bibtexEntry.getCiteKey() + "." + externalFileType.extension;
            if (this.copyRadioButton.isSelected()) {
                bl3 = this.doCopy(string, externalFileType, string2, namedCompound);
            } else if (this.moveRadioButton.isSelected()) {
                bl3 = this.doRename(string, externalFileType, string2, namedCompound);
            }
        }
        if (bl3) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    BibtexEntry bibtexEntry2 = (BibtexEntry)iterator.next();
                    bibtexEntry2.setId(Util.createNeutralId());
                    this.panel.getDatabase().insertEntry(bibtexEntry2);
                    this.doLink(bibtexEntry2, externalFileType, string2, namedCompound);
                }
                catch (KeyCollisionException keyCollisionException) {}
            }
            this.panel.markBaseChanged();
            this.panel.updateEntryEditorIfShowing();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showLinkMoveCopyRenameDialog(String string, ExternalFileType externalFileType, final boolean bl, String string2, boolean bl2, final boolean bl3) {
        String string3 = this.panel.metaData().getFileDirectory(externalFileType.getFieldName());
        if (string3 == null || !new File(string3).exists()) {
            this.destDirLabel.setText(Globals.lang("%0 directory is not set or does not exist!", externalFileType.getName()));
            this.copyRadioButton.setEnabled(false);
            this.moveRadioButton.setEnabled(false);
            this.linkInPlace.setSelected(true);
        } else {
            this.destDirLabel.setText(Globals.lang("%0 directory is '%1':", externalFileType.getName(), string3));
            this.copyRadioButton.setEnabled(true);
            this.moveRadioButton.setEnabled(true);
        }
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DroppedFileHandler.this.renameCheckBox.setEnabled(!DroppedFileHandler.this.linkInPlace.isSelected() && bl && !bl3);
            }
        };
        if (bl2) {
            if (bl3) {
                this.linkInPlace.setText(Globals.lang("Link from new entries."));
                this.copyRadioButton.setText(Globals.lang("Copy to %0 directory and link from new entries.", externalFileType.getName()));
                this.moveRadioButton.setText(Globals.lang("Move to %0 directory and link from new entries.", externalFileType.getName()));
            } else {
                this.linkInPlace.setText(Globals.lang("Link from new entry"));
                this.copyRadioButton.setText(Globals.lang("Copy to %0 directory and link from new entry.", externalFileType.getName()));
                this.moveRadioButton.setText(Globals.lang("Move to %0 directory and link from new entry.", externalFileType.getName()));
            }
        } else if (bl3) {
            this.linkInPlace.setText(Globals.lang("Link from entries."));
            this.copyRadioButton.setText(Globals.lang("Copy to %0 directory and link from entries.", externalFileType.getName()));
            this.moveRadioButton.setText(Globals.lang("Move to %0 directory and link from entries.", externalFileType.getName()));
        } else {
            this.linkInPlace.setText(Globals.lang("Link from entry"));
            this.copyRadioButton.setText(Globals.lang("Copy to %0 directory and link from entry.", externalFileType.getName()));
            this.moveRadioButton.setText(Globals.lang("Move to %0 directory and link from entry.", externalFileType.getName()));
        }
        this.renameCheckBox.setText("Rename to match citekey: " + string2);
        this.linkInPlace.addChangeListener(changeListener);
        changeListener.stateChanged(new ChangeEvent(this.linkInPlace));
        try {
            int n = JOptionPane.showConfirmDialog(this.frame, this.optionsPanel, string, 2, 3);
            return n;
        }
        finally {
            this.linkInPlace.removeChangeListener(changeListener);
        }
    }

    private void doLink(BibtexEntry bibtexEntry, ExternalFileType externalFileType, String string, NamedCompound namedCompound) {
        UndoableFieldChange undoableFieldChange = new UndoableFieldChange(bibtexEntry, externalFileType.getFieldName(), bibtexEntry.getField(externalFileType.getFieldName()), string);
        bibtexEntry.setField(externalFileType.getFieldName(), string);
        if (namedCompound == null) {
            this.panel.undoManager.addEdit(undoableFieldChange);
        } else {
            namedCompound.addEdit(undoableFieldChange);
        }
    }

    private boolean doRename(String string, ExternalFileType externalFileType, String string2, NamedCompound namedCompound) {
        String string3 = this.panel.metaData().getFileDirectory(externalFileType.getFieldName());
        if (string3 == null || !new File(string3).exists()) {
            return false;
        }
        string2 = new File(string2).getName();
        File file = new File(string);
        File file2 = new File(string3 + System.getProperty("file.separator") + string2);
        file.renameTo(file2);
        return true;
    }

    private boolean doCopy(String string, ExternalFileType externalFileType, String string2, NamedCompound namedCompound) {
        int n;
        String string3 = this.panel.metaData().getFileDirectory(externalFileType.getFieldName());
        if (string3 == null || !new File(string3).exists()) {
            System.out.println("dir: " + string3 + "\t ext: " + externalFileType.getExtension());
            return false;
        }
        string2 = new File(string2).getName();
        File file = new File(string3 + System.getProperty("file.separator") + string2);
        if (file.equals(new File(string))) {
            return true;
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this.frame, "'" + file.getPath() + "' " + Globals.lang("exists.Overwrite?"), Globals.lang("File exists"), 0, 3)) == 1) {
            return false;
        }
        try {
            Util.copyFile(new File(string), file, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }
}

