/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFilePanel;
import net.sf.jabref.gui.AttachFileDialog;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;

public class AutoSetExternalFileForEntries
extends AbstractWorker {
    private String fieldName;
    private BasePanel panel;
    private BibtexEntry[] sel = null;
    private OptionsDialog optDiag = null;
    Object[] brokenLinkOptions = new Object[]{Globals.lang("Ignore"), Globals.lang("Assign new file"), Globals.lang("Clear field"), Globals.lang("Quit synchronization")};
    private boolean goOn = true;
    private boolean autoSet = true;
    private boolean overWriteAllowed = true;
    private boolean checkExisting = true;
    private int skipped = 0;
    private int entriesChanged = 0;
    private int brokenLinks = 0;

    public AutoSetExternalFileForEntries(BasePanel basePanel, String string) {
        this.fieldName = string;
        this.panel = basePanel;
    }

    public void init() {
        this.sel = this.panel.getSelectedEntries();
        if (this.sel.length < 1) {
            Collection collection = this.panel.database().getEntries();
            this.sel = new BibtexEntry[collection.size()];
            this.sel = collection.toArray(this.sel);
        }
        if (this.optDiag == null) {
            this.optDiag = new OptionsDialog(this.panel.frame(), this.fieldName);
        }
        Util.placeDialog(this.optDiag, this.panel.frame());
        this.optDiag.setVisible(true);
        if (this.optDiag.canceled()) {
            this.goOn = false;
            return;
        }
        this.autoSet = !this.optDiag.autoSetNone.isSelected();
        this.overWriteAllowed = this.optDiag.autoSetAll.isSelected();
        this.checkExisting = this.optDiag.checkLinks.isSelected();
        this.panel.output(Globals.lang("Synchronizing %0 links...", this.fieldName.toUpperCase()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object object;
        Object object2;
        int n;
        if (!this.goOn) {
            this.panel.output(Globals.lang("No entries selected."));
            return;
        }
        this.panel.frame().setProgressBarValue(0);
        this.panel.frame().setProgressBarVisible(true);
        int n2 = 10;
        int n3 = (this.autoSet ? n2 * this.sel.length : 0) + (this.checkExisting ? this.sel.length : 0);
        this.panel.frame().setProgressBarMaximum(n3);
        int n4 = 0;
        this.skipped = 0;
        this.entriesChanged = 0;
        this.brokenLinks = 0;
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Autoset %0 field", this.fieldName));
        OpenFileFilter openFileFilter = Util.getFileFilterForField(this.fieldName);
        ExternalFilePanel externalFilePanel = new ExternalFilePanel(this.fieldName, this.panel.metaData(), null, null, openFileFilter);
        FieldTextField fieldTextField = new FieldTextField(this.fieldName, "", false);
        String string = this.panel.metaData().getFileDirectory(this.fieldName);
        if (this.autoSet) {
            for (n = 0; n < this.sel.length; ++n) {
                this.panel.frame().setProgressBarValue(n4 += n2);
                object2 = this.sel[n].getField(this.fieldName);
                if (object2 != null && !object2.equals("") && !this.overWriteAllowed) continue;
                externalFilePanel.setEntry(this.sel[n]);
                fieldTextField.setText(object2 != null ? (String)object2 : "");
                object = externalFilePanel.autoSetFile(this.fieldName, fieldTextField);
                if (object != null) {
                    try {
                        ((Thread)object).join();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                if (fieldTextField.getText().equals("") || fieldTextField.getText().equals(object2)) continue;
                namedCompound.addEdit(new UndoableFieldChange(this.sel[n], this.fieldName, object2, fieldTextField.getText()));
                this.sel[n].setField(this.fieldName, fieldTextField.getText());
                ++this.entriesChanged;
            }
        }
        if (this.checkExisting) {
            block8: for (n = 0; n < this.sel.length; ++n) {
                this.panel.frame().setProgressBarValue(n4++);
                object2 = this.sel[n].getField(this.fieldName);
                if (object2 == null || ((String)object2).equals("") || (object = Util.expandFilename((String)object2, new String[]{string, "."})) != null && ((File)object).exists()) continue;
                int n5 = JOptionPane.showOptionDialog(this.panel.frame(), Globals.lang("<HTML>Could not find file '%0'<BR>linked from entry '%1'</HTML>", new String[]{(String)object2, this.sel[n].getCiteKey()}), Globals.lang("Broken link"), 1, 3, null, this.brokenLinkOptions, this.brokenLinkOptions[0]);
                switch (n5) {
                    case 1: {
                        AttachFileDialog attachFileDialog = new AttachFileDialog((Frame)this.panel.frame(), this.panel.metaData(), this.sel[n], this.fieldName);
                        Util.placeDialog(attachFileDialog, this.panel.frame());
                        attachFileDialog.setVisible(true);
                        if (attachFileDialog.cancelled()) break;
                        namedCompound.addEdit(new UndoableFieldChange(this.sel[n], this.fieldName, object2, attachFileDialog.getValue()));
                        this.sel[n].setField(this.fieldName, attachFileDialog.getValue());
                        ++this.entriesChanged;
                        break;
                    }
                    case 2: {
                        namedCompound.addEdit(new UndoableFieldChange(this.sel[n], this.fieldName, object2, null));
                        this.sel[n].setField(this.fieldName, null);
                        ++this.entriesChanged;
                        break;
                    }
                    case 3: {
                        break block8;
                    }
                }
                ++this.brokenLinks;
            }
        }
        if (this.entriesChanged > 0) {
            namedCompound.end();
            this.panel.undoManager.addEdit(namedCompound);
        }
    }

    public void update() {
        if (!this.goOn) {
            return;
        }
        this.panel.output(Globals.lang("Finished synchronizing %0 links. Entries changed%c %1.", new String[]{this.fieldName.toUpperCase(), String.valueOf(this.entriesChanged)}));
        this.panel.frame().setProgressBarVisible(false);
        if (this.entriesChanged > 0) {
            this.panel.markBaseChanged();
        }
    }

    static class OptionsDialog
    extends JDialog {
        JRadioButton autoSetUnset;
        JRadioButton autoSetAll;
        JRadioButton autoSetNone;
        JCheckBox checkLinks;
        JButton ok = new JButton(Globals.lang("Ok"));
        JButton cancel = new JButton(Globals.lang("Cancel"));
        JLabel description;
        private boolean canceled = true;
        private String fieldName;

        public OptionsDialog(JFrame jFrame, String string) {
            super(jFrame, Globals.lang("Synchronize %0 links", string.toUpperCase()), true);
            String string2 = string.toUpperCase();
            this.fieldName = string;
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.this.canceled = false;
                    OptionsDialog.this.dispose();
                }
            });
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.this.dispose();
                }
            };
            this.cancel.addActionListener(abstractAction);
            InputMap inputMap = this.cancel.getInputMap(2);
            ActionMap actionMap = this.cancel.getActionMap();
            inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
            actionMap.put("close", abstractAction);
            string = string.toUpperCase();
            this.autoSetUnset = new JRadioButton(Globals.lang("Autoset %0 links. Do not overwrite existing links.", string2), true);
            this.autoSetAll = new JRadioButton(Globals.lang("Autoset %0 links. Allow overwriting existing links.", string2), false);
            this.autoSetNone = new JRadioButton(Globals.lang("Do not autoset"), false);
            this.checkLinks = new JCheckBox(Globals.lang("Check existing %0 links", string2), true);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.autoSetUnset);
            buttonGroup.add(this.autoSetNone);
            buttonGroup.add(this.autoSetAll);
            FormLayout formLayout = new FormLayout("fill:pref", "");
            DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
            this.description = new JLabel("<HTML>" + Globals.lang("Attempt to autoset %0 links for your entries. Autoset works if a %0 file in your %0 directory or a subdirectory<BR>is named identically to an entry's BibTeX key, plus extension.", string2) + "</HTML>");
            defaultFormBuilder.appendSeparator(Globals.lang("Autoset"));
            defaultFormBuilder.append(this.description);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.autoSetUnset);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.autoSetAll);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.autoSetNone);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.appendSeparator(Globals.lang("Check links"));
            this.description = new JLabel("<HTML>" + Globals.lang("This makes JabRef look up each %0 link and check if the file exists. If not, you will be given options<BR>to resolve the problem.", string2) + "</HTML>");
            defaultFormBuilder.append(this.description);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.checkLinks);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.appendSeparator();
            JPanel jPanel = defaultFormBuilder.getPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
            buttonBarBuilder.addGlue();
            buttonBarBuilder.addGridded(this.ok);
            buttonBarBuilder.addGridded(this.cancel);
            buttonBarBuilder.addGlue();
            this.getContentPane().add((Component)jPanel, "Center");
            this.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
            this.pack();
        }

        public void setVisible(boolean bl) {
            String string;
            if (bl) {
                this.canceled = true;
            }
            if ((string = Globals.prefs.get(this.fieldName + "Directory")) == null || string.trim().length() == 0) {
                this.autoSetNone.setSelected(true);
                this.autoSetNone.setEnabled(false);
                this.autoSetAll.setEnabled(false);
                this.autoSetUnset.setEnabled(false);
            } else {
                this.autoSetNone.setEnabled(true);
                this.autoSetAll.setEnabled(true);
                this.autoSetUnset.setEnabled(true);
            }
            new FocusRequester(this.ok);
            super.setVisible(bl);
        }

        public boolean canceled() {
            return this.canceled;
        }
    }
}

