/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;
import java.util.TreeSet;

public class VerifyingWriter
extends OutputStreamWriter {
    CharsetEncoder encoder;
    private boolean couldEncodeAll = true;
    private TreeSet problemCharacters = new TreeSet();

    public VerifyingWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
        this.encoder = Charset.forName(string).newEncoder();
    }

    public void write(String string) throws IOException {
        super.write(string);
        if (!this.encoder.canEncode(string)) {
            for (int i = 0; i < string.length(); ++i) {
                if (this.encoder.canEncode(string.charAt(i))) continue;
                this.problemCharacters.add(new Character(string.charAt(i)));
            }
            this.couldEncodeAll = false;
        }
    }

    public boolean couldEncodeAll() {
        return this.couldEncodeAll;
    }

    public String getProblemCharacters() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.problemCharacters.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Character)iterator.next()).charValue());
        }
        return stringBuffer.toString();
    }
}

