/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.export.ExportFormat;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.export.VerifyingWriter;
import net.sf.jabref.mods.MODSDatabase;

class ModsExportFormat
extends ExportFormat {
    public ModsExportFormat() {
        super(Globals.lang("MODS"), "mods", null, null, ".xml");
    }

    public void performExport(BibtexDatabase bibtexDatabase, String string, String string2, Set set) throws IOException {
        SaveSession saveSession = this.getSaveSession(string2, new File(string));
        VerifyingWriter verifyingWriter = saveSession.getWriter();
        MODSDatabase mODSDatabase = new MODSDatabase(bibtexDatabase, set);
        try {
            DOMSource dOMSource = new DOMSource(mODSDatabase.getDOMrepresentation());
            StreamResult streamResult = new StreamResult(verifyingWriter);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        try {
            this.finalizeSaveSession(saveSession);
        }
        catch (SaveException saveException) {
            throw new IOException(saveException.getMessage());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }
}

