/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.util.Vector;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.export.FieldFormatter;

public class LatexFieldFormatter
implements FieldFormatter {
    StringBuffer sb;
    int col;
    final int STARTCOL = 4;

    public String format(String string, String string2) throws IllegalArgumentException {
        if (Globals.prefs.putBracesAroundCapitals(string2) && !"__string".equals(string2)) {
            string = Util.putBracesAroundCapitals(string);
        }
        if (!BibtexFields.isStandardField(string2) && !"__string".equals(string2)) {
            int n = 0;
            boolean bl = true;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '{') {
                    ++n;
                }
                if (c == '}') {
                    --n;
                }
                if (n >= 0) continue;
                bl = false;
                break;
            }
            if (n > 0) {
                bl = false;
            }
            if (!bl) {
                throw new IllegalArgumentException("Curly braces { and } must be balanced.");
            }
            this.sb = new StringBuffer(Globals.getOpeningBrace());
            if (!Globals.prefs.isNonWrappableField(string2)) {
                this.sb.append(Util.wrap2(string, 65));
            } else {
                this.sb.append(string);
            }
            this.sb.append(Globals.getClosingBrace());
            return this.sb.toString();
        }
        this.sb = new StringBuffer();
        int n = 0;
        this.col = 4;
        this.checkBraces(string);
        while (n < string.length()) {
            int n2;
            int n3 = n;
            int n4 = n;
            while (n3 == n4) {
                n4 = string.indexOf(35, n3);
                if (n4 > 0 && string.charAt(n4 - 1) == '\\') {
                    n3 = n4 + 1;
                    ++n4;
                    continue;
                }
                n3 = n4 - 1;
            }
            if (n4 == -1) {
                n4 = string.length();
                n2 = -1;
            } else {
                n2 = string.indexOf(35, n4 + 1);
                if (n2 == -1) {
                    throw new IllegalArgumentException(Globals.lang("The # character is not allowed in BibTeX fields") + ".\n" + Globals.lang("In JabRef, use pairs of # characters to indicate a string.") + "\n" + Globals.lang("Note that the entry causing the problem has been selected."));
                }
            }
            if (n4 > n) {
                this.writeText(string, n, n4);
            }
            if (n4 < string.length() && n2 - 1 > n4) {
                this.writeStringLabel(string, n4 + 1, n2, n4 == n, n2 + 1 == string.length());
            }
            if (n2 > -1) {
                n = n2 + 1;
                continue;
            }
            n = n4 + 1;
        }
        if (!Globals.prefs.isNonWrappableField(string2)) {
            return Util.wrap2(this.sb.toString(), 65);
        }
        return this.sb.toString();
    }

    private void writeText(String string, int n, int n2) {
        this.sb.append(Globals.getOpeningBrace());
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c) && (bl || bl2)) {
                bl2 = true;
                if (!bl4) {
                    stringBuffer.append(c);
                }
            } else if ((!Character.isWhitespace(c) || !bl3 && !bl4) && bl2) {
                if (c == '[') {
                    bl4 = true;
                } else if (bl4 && c == ']') {
                    bl4 = false;
                } else if (!bl4 && c == '{') {
                    bl2 = false;
                    bl3 = true;
                } else {
                    stringBuffer.delete(0, stringBuffer.length());
                    bl2 = false;
                }
            }
            if (bl3 && c == '}') {
                stringBuffer.delete(0, stringBuffer.length());
                bl3 = false;
            }
            if (!(c != '&' || bl || bl3 && stringBuffer.toString().equals("url"))) {
                this.sb.append("\\&");
            } else {
                this.sb.append(c);
            }
            bl = c == '\\';
        }
        this.sb.append(Globals.getClosingBrace());
    }

    private void writeStringLabel(String string, int n, int n2, boolean bl, boolean bl2) {
        this.putIn((bl ? "" : " # ") + string.substring(n, n2) + (bl2 ? "" : " # "));
    }

    private void putIn(String string) {
        this.sb.append(Util.wrap2(string, 65));
    }

    private void checkBraces(String string) throws IllegalArgumentException {
        Vector<Integer> vector = new Vector<Integer>(5, 3);
        Vector<Integer> vector2 = new Vector<Integer>(5, 3);
        int n = -1;
        while ((n = string.indexOf(123, n + 1)) != -1) {
            vector.add(new Integer(n));
        }
        while ((n = string.indexOf(125, n + 1)) != -1) {
            vector2.add(new Integer(n));
        }
        if (vector2.size() > 0 && vector.size() == 0) {
            throw new IllegalArgumentException("'}' character ends string prematurely.");
        }
        if (vector2.size() > 0 && (Integer)vector2.elementAt(0) < (Integer)vector.elementAt(0)) {
            throw new IllegalArgumentException("'}' character ends string prematurely.");
        }
        if (vector.size() != vector2.size()) {
            throw new IllegalArgumentException("Braces don't match.");
        }
    }
}

