/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.BibtexString;
import net.sf.jabref.BibtexStringComparator;
import net.sf.jabref.CrossRefEntryComparator;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.FieldComparatorStack;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.IdComparator;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.MetaData;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.export.VerifyingWriter;
import net.sf.jabref.export.layout.LayoutFormatter;
import net.sf.jabref.export.layout.format.AuthorLastFirst;
import net.sf.jabref.export.layout.format.RemoveLatexCommands;
import net.sf.jabref.export.layout.format.ResolvePDF;

public class FileActions {
    private static Pattern refPat = Pattern.compile("(#[A-Za-z]+#)");

    private static void writePreamble(Writer writer, String string) throws IOException {
        if (string != null) {
            writer.write("@PREAMBLE{");
            writer.write(string);
            writer.write("}" + Globals.NEWLINE + Globals.NEWLINE);
        }
    }

    private static void writeStrings(Writer writer, BibtexDatabase bibtexDatabase) throws IOException {
        BibtexString bibtexString;
        ArrayList<BibtexString> arrayList = new ArrayList<BibtexString>();
        Object object = bibtexDatabase.getStringKeySet().iterator();
        while (object.hasNext()) {
            arrayList.add(bibtexDatabase.getString(object.next()));
        }
        Collections.sort(arrayList, new BibtexStringComparator(false));
        object = new HashMap();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            bibtexString = (BibtexString)iterator.next();
            ((HashMap)object).put(bibtexString.getName(), bibtexString);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            bibtexString = (BibtexString)iterator.next();
            if (!((HashMap)object).containsKey(bibtexString.getName())) continue;
            FileActions.writeString(writer, bibtexString, (HashMap)object);
        }
    }

    private static void writeString(Writer writer, BibtexString bibtexString, HashMap hashMap) throws IOException {
        Matcher matcher;
        hashMap.remove(bibtexString.getName());
        String string = bibtexString.getContent();
        while ((matcher = refPat.matcher(string)).find()) {
            String string2 = matcher.group(1);
            int n = string.indexOf(string2) + string2.length();
            string = string.substring(n);
            Object v = hashMap.get(string2.substring(1, string2.length() - 1));
            if (v == null) continue;
            FileActions.writeString(writer, (BibtexString)v, hashMap);
        }
        writer.write("@STRING{" + bibtexString.getName() + " = ");
        if (!bibtexString.getContent().equals("")) {
            writer.write(new LatexFieldFormatter().format(bibtexString.getContent(), "__string"));
        } else {
            writer.write("{}");
        }
        writer.write("}" + Globals.NEWLINE + Globals.NEWLINE);
    }

    private static void writeBibFileHeader(Writer writer, String string) throws IOException {
        writer.write("This file was created with JabRef");
        writer.write(" " + GUIGlobals.version + "." + Globals.NEWLINE + GUIGlobals.encPrefix + string + Globals.NEWLINE + Globals.NEWLINE);
    }

    public static SaveSession saveDatabase(BibtexDatabase bibtexDatabase, MetaData metaData, File file, JabRefPreferences jabRefPreferences, boolean bl, boolean bl2, String string) throws SaveException {
        SaveSession saveSession;
        BibtexEntry bibtexEntry = null;
        TreeMap<String, BibtexEntryType> treeMap = new TreeMap<String, BibtexEntryType>();
        boolean bl3 = jabRefPreferences.getBoolean("backup");
        try {
            saveSession = new SaveSession(file, string, bl3);
        }
        catch (Throwable throwable) {
            System.err.println("Error from encoding: '" + string + "' Len: " + string.length());
            throwable.printStackTrace();
            throw new SaveException(throwable.getMessage());
        }
        try {
            BibtexEntryType bibtexEntryType;
            VerifyingWriter verifyingWriter = saveSession.getWriter();
            FileActions.writeBibFileHeader(verifyingWriter, string);
            FileActions.writePreamble(verifyingWriter, bibtexDatabase.getPreamble());
            FileActions.writeStrings(verifyingWriter, bibtexDatabase);
            List list = FileActions.getSortedEntries(bibtexDatabase, null, true);
            LatexFieldFormatter latexFieldFormatter = new LatexFieldFormatter();
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                bibtexEntry = (BibtexEntry)iterator.next();
                bibtexEntryType = bibtexEntry.getType();
                if (BibtexEntryType.getStandardType(bibtexEntryType.getName()) == null) {
                    treeMap.put(bibtexEntryType.getName(), bibtexEntryType);
                }
                boolean bl4 = true;
                if (bl && !FileActions.nonZeroField(bibtexEntry, "__search")) {
                    bl4 = false;
                }
                if (bl2 && !FileActions.nonZeroField(bibtexEntry, "__groupsearch")) {
                    bl4 = false;
                }
                if (!bl4) continue;
                bibtexEntry.write(verifyingWriter, latexFieldFormatter, true);
                verifyingWriter.write(Globals.NEWLINE);
            }
            if (metaData != null) {
                metaData.writeMetaData(verifyingWriter);
            }
            if (treeMap.size() > 0) {
                iterator = treeMap.keySet().iterator();
                while (iterator.hasNext()) {
                    bibtexEntryType = (CustomEntryType)treeMap.get(iterator.next());
                    ((CustomEntryType)bibtexEntryType).save(verifyingWriter);
                    verifyingWriter.write(Globals.NEWLINE);
                }
            }
            verifyingWriter.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            try {
                saveSession.cancel();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new SaveException(throwable.getMessage() + "\n" + Globals.lang("Warning: could not complete file repair; your file may have been corrupted. Error message: ") + iOException.getMessage());
            }
            throw new SaveException(throwable.getMessage(), bibtexEntry);
        }
        return saveSession;
    }

    public static SaveSession savePartOfDatabase(BibtexDatabase bibtexDatabase, MetaData metaData, File file, JabRefPreferences jabRefPreferences, BibtexEntry[] bibtexEntryArray, String string) throws SaveException {
        SaveSession saveSession;
        TreeMap<String, BibtexEntryType> treeMap = new TreeMap<String, BibtexEntryType>();
        BibtexEntry bibtexEntry = null;
        boolean bl = jabRefPreferences.getBoolean("backup");
        try {
            saveSession = new SaveSession(file, string, bl);
        }
        catch (IOException iOException) {
            throw new SaveException(iOException.getMessage());
        }
        try {
            BibtexEntryType bibtexEntryType;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            String string2;
            String string3;
            String string4;
            VerifyingWriter verifyingWriter = saveSession.getWriter();
            FileActions.writeBibFileHeader(verifyingWriter, string);
            FileActions.writePreamble(verifyingWriter, bibtexDatabase.getPreamble());
            FileActions.writeStrings(verifyingWriter, bibtexDatabase);
            boolean bl5 = false;
            if (!jabRefPreferences.getBoolean("saveInStandardOrder")) {
                bl5 = jabRefPreferences.getBoolean("priBinary");
                string4 = jabRefPreferences.get("priSort");
                string3 = jabRefPreferences.get("secSort");
                string2 = jabRefPreferences.get("terSort");
                bl4 = jabRefPreferences.getBoolean("priDescending");
                bl3 = jabRefPreferences.getBoolean("secDescending");
                bl2 = jabRefPreferences.getBoolean("terDescending");
            } else {
                string4 = "author";
                string3 = "editor";
                string2 = "year";
                bl4 = false;
                bl3 = false;
                bl2 = true;
            }
            ArrayList<Comparator> arrayList = new ArrayList<Comparator>();
            arrayList.add(new CrossRefEntryComparator());
            arrayList.add(new FieldComparator(string4, bl4));
            arrayList.add(new FieldComparator(string3, bl3));
            arrayList.add(new FieldComparator(string2, bl2));
            arrayList.add(new FieldComparator("bibtexkey"));
            BasicEventList basicEventList = new BasicEventList();
            SortedList sortedList = new SortedList(basicEventList, new FieldComparatorStack(arrayList));
            if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
                for (int i = 0; i < bibtexEntryArray.length; ++i) {
                    sortedList.add(bibtexEntryArray[i]);
                }
            }
            LatexFieldFormatter latexFieldFormatter = new LatexFieldFormatter();
            Iterator iterator = sortedList.iterator();
            while (iterator.hasNext()) {
                bibtexEntry = (BibtexEntry)iterator.next();
                bibtexEntryType = bibtexEntry.getType();
                if (BibtexEntryType.getStandardType(bibtexEntryType.getName()) == null) {
                    treeMap.put(bibtexEntryType.getName(), bibtexEntryType);
                }
                bibtexEntry.write(verifyingWriter, latexFieldFormatter, true);
                verifyingWriter.write(Globals.NEWLINE);
            }
            if (metaData != null) {
                metaData.writeMetaData(verifyingWriter);
            }
            if (treeMap.size() > 0) {
                iterator = treeMap.keySet().iterator();
                while (iterator.hasNext()) {
                    bibtexEntryType = (CustomEntryType)treeMap.get(iterator.next());
                    ((CustomEntryType)bibtexEntryType).save(verifyingWriter);
                    verifyingWriter.write(Globals.NEWLINE);
                }
            }
            verifyingWriter.close();
        }
        catch (Throwable throwable) {
            try {
                saveSession.cancel();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new SaveException(throwable.getMessage() + "\n" + Globals.lang("Warning: could not complete file repair; your file may have been corrupted. Error message: ") + iOException.getMessage());
            }
            throw new SaveException(throwable.getMessage(), bibtexEntry);
        }
        return saveSession;
    }

    public static void exportToCSV(BibtexDatabase bibtexDatabase, File file, JabRefPreferences jabRefPreferences) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("default", new RemoveLatexCommands());
        hashMap.put("author", new Object[]{new AuthorLastFirst(), new RemoveLatexCommands()});
        hashMap.put("pdf", new ResolvePDF());
        String string = "\t";
        List list = FileActions.getSortedEntries(bibtexDatabase, null, true);
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = BibtexFields.numberOfPublicFields();
        for (int i = 0; i < n; ++i) {
            treeSet.add(BibtexFields.getFieldName(i));
        }
        Object[] objectArray = treeSet.toArray();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write((String)objectArray[0]);
        for (int i = 1; i < objectArray.length; ++i) {
            fileWriter.write(string + (String)objectArray[i]);
        }
        fileWriter.write(Globals.NEWLINE);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
            FileActions.writeField(bibtexDatabase, bibtexEntry, (String)objectArray[0], hashMap, fileWriter);
            for (int i = 1; i < objectArray.length; ++i) {
                fileWriter.write(string);
                FileActions.writeField(bibtexDatabase, bibtexEntry, (String)objectArray[i], hashMap, fileWriter);
            }
            fileWriter.write(Globals.NEWLINE);
        }
        fileWriter.close();
    }

    private static void writeField(BibtexDatabase bibtexDatabase, BibtexEntry bibtexEntry, String string, HashMap hashMap, Writer writer) throws IOException {
        String string2 = (String)bibtexEntry.getField(string);
        if (string2 == null) {
            return;
        }
        string2 = bibtexDatabase.resolveForStrings(string2);
        Object v = hashMap.get(string);
        if (v == null) {
            v = hashMap.get("default");
        }
        if (v instanceof LayoutFormatter) {
            string2 = ((LayoutFormatter)v).format(string2);
        } else if (v instanceof Object[]) {
            Object[] objectArray = (Object[])v;
            for (int i = 0; i < objectArray.length; ++i) {
                string2 = ((LayoutFormatter)objectArray[i]).format(string2);
            }
        }
        writer.write(string2);
    }

    public static Reader getReader(String string) throws IOException {
        InputStreamReader inputStreamReader = null;
        URL uRL = Globals.class.getResource(string);
        if (uRL != null) {
            try {
                inputStreamReader = new InputStreamReader(uRL.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException(Globals.lang("Could not find layout file") + ": '" + string + "'.");
            }
        }
        File file = new File(string);
        try {
            inputStreamReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(Globals.lang("Could not find layout file") + ": '" + string + "'.");
        }
        return inputStreamReader;
    }

    public static List getSortedEntries(BibtexDatabase bibtexDatabase, Set set, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        FieldComparatorStack fieldComparatorStack = null;
        if (Globals.prefs.getBoolean("saveInOriginalOrder")) {
            object3 = new ArrayList<CrossRefEntryComparator>();
            object3.add(new CrossRefEntryComparator());
            object3.add(new IdComparator());
            fieldComparatorStack = new FieldComparatorStack((List)object3);
        } else {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5 = false;
            if (!bl || !Globals.prefs.getBoolean("saveInStandardOrder")) {
                bl5 = Globals.prefs.getBoolean("priBinary");
                object3 = Globals.prefs.get("priSort");
                object2 = Globals.prefs.get("secSort");
                object = Globals.prefs.get("terSort");
                bl4 = Globals.prefs.getBoolean("priDescending");
                bl3 = Globals.prefs.getBoolean("secDescending");
                bl2 = Globals.prefs.getBoolean("terDescending");
            } else {
                object3 = "author";
                object2 = "editor";
                object = "year";
                bl4 = false;
                bl3 = false;
                bl2 = true;
            }
            ArrayList<Comparator> arrayList = new ArrayList<Comparator>();
            if (bl) {
                arrayList.add(new CrossRefEntryComparator());
            }
            arrayList.add(new FieldComparator((String)object3, bl4));
            arrayList.add(new FieldComparator((String)object2, bl3));
            arrayList.add(new FieldComparator((String)object, bl2));
            arrayList.add(new FieldComparator("bibtexkey"));
            fieldComparatorStack = new FieldComparatorStack(arrayList);
        }
        object3 = new BasicEventList();
        object2 = new SortedList((EventList)object3, fieldComparatorStack);
        if (set == null) {
            set = bibtexDatabase.getKeySet();
        }
        if (set != null) {
            object = set.iterator();
            while (object.hasNext()) {
                ((AbstractEventList)object2).add(bibtexDatabase.getEntryById((String)object.next()));
            }
        }
        return object2;
    }

    private static boolean nonZeroField(BibtexEntry bibtexEntry, String string) {
        String string2 = (String)bibtexEntry.getField(string);
        return string2 != null && !string2.equals("0");
    }
}

