/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JOptionPane;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.export.ExportFormat;
import net.sf.jabref.export.ExportFormats;
import net.sf.jabref.export.RtfSelection;

public class ExportToClipboardAction
extends AbstractWorker {
    String message = null;
    private JabRefFrame frame;
    private BibtexDatabase database;

    public ExportToClipboardAction(JabRefFrame jabRefFrame, BibtexDatabase bibtexDatabase) {
        this.frame = jabRefFrame;
        this.database = bibtexDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BasePanel basePanel = this.frame.basePanel();
        if (basePanel == null) {
            return;
        }
        if (basePanel.getSelectedEntries().length == 0) {
            this.message = Globals.lang("No entries selected") + ".";
            this.getCallBack().update();
            return;
        }
        Map map = ExportFormats.getExportFormats();
        ExportFormat[] exportFormatArray = new ExportFormat[map.size()];
        int n = 0;
        String[] stringArray = map.keySet().iterator();
        while (stringArray.hasNext()) {
            exportFormatArray[n++] = (ExportFormat)map.get(stringArray.next());
        }
        stringArray = new String[exportFormatArray.length];
        for (int i = 0; i < exportFormatArray.length; ++i) {
            stringArray[i] = exportFormatArray[i].getDisplayName();
        }
        JList<String> jList = new JList<String>(stringArray);
        jList.setBorder(BorderFactory.createEtchedBorder());
        jList.setSelectionInterval(0, 0);
        jList.setSelectionMode(0);
        int n2 = JOptionPane.showOptionDialog(this.frame, jList, Globals.lang("Select format"), 0, 3, null, new String[]{Globals.lang("Ok"), Globals.lang("Cancel")}, Globals.lang("Ok"));
        if (n2 == 1) {
            return;
        }
        ExportFormat exportFormat = exportFormatArray[jList.getSelectedIndex()];
        File file = null;
        Reader reader = null;
        try {
            int n3;
            file = File.createTempFile("jabrefCb", ".tmp");
            file.deleteOnExit();
            BibtexEntry[] bibtexEntryArray = basePanel.getSelectedEntries();
            HashSet<String> hashSet = new HashSet<String>(bibtexEntryArray.length);
            for (int i = 0; i < bibtexEntryArray.length; ++i) {
                hashSet.add(bibtexEntryArray[i].getId());
            }
            exportFormat.performExport(this.database, file.getPath(), basePanel.getEncoding(), hashSet);
            StringBuffer stringBuffer = new StringBuffer();
            reader = new InputStreamReader((InputStream)new FileInputStream(file), basePanel.getEncoding());
            while ((n3 = reader.read()) != -1) {
                stringBuffer.append((char)n3);
            }
            ClipboardOwner clipboardOwner = new ClipboardOwner(){

                public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                }
            };
            RtfSelection rtfSelection = new RtfSelection(stringBuffer.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(rtfSelection, clipboardOwner);
            this.message = Globals.lang("Entries exported to clipboard") + ": " + bibtexEntryArray.length;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.message = Globals.lang("Error exporting to clipboard");
            return;
        }
        finally {
            if (file != null) {
                file.delete();
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void update() {
        this.frame.output(this.message);
    }
}

