/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.export.ExportFileFilter;
import net.sf.jabref.export.ExportFormat;
import net.sf.jabref.export.ModsExportFormat;
import net.sf.jabref.export.OpenDocumentSpreadsheetCreator;
import net.sf.jabref.export.OpenOfficeDocumentCreator;

public class ExportFormats {
    private static Map exportFormats = new TreeMap();

    public static void initAllExports() {
        exportFormats.clear();
        ExportFormats.initBuiltinExports();
        TreeMap treeMap = Globals.prefs.customExports.getCustomExportFormats();
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            ExportFormats.putFormat((ExportFormat)treeMap.get(iterator.next()));
        }
    }

    public static void initBuiltinExports() {
        ExportFormats.putFormat(new ExportFormat(Globals.lang("HTML"), "html", "html", null, ".html"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("Simple HTML"), "simplehtml", "simplehtml", null, ".html"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("Docbook"), "docbook", "docbook", null, ".xml"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("BibTeXML"), "bibtexml", "bibtexml", null, ".xml"));
        ExportFormats.putFormat(new ModsExportFormat());
        ExportFormats.putFormat(new ExportFormat(Globals.lang("HTML table"), "tablerefs", "tablerefs", "tablerefs", ".html"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("HTML table (with Abstract & BibTeX)"), "tablerefsabsbib", "tablerefsabsbib", "tablerefsabsbib", ".html"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("Harvard RTF"), "harvard", "harvard", "harvard", ".rtf"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("Endnote"), "endnote", "EndNote", "endnote", ".txt"));
        ExportFormats.putFormat(new OpenOfficeDocumentCreator());
        ExportFormats.putFormat(new OpenDocumentSpreadsheetCreator());
    }

    public static String getConsoleExportList(int n, int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = -n2;
        Iterator iterator = exportFormats.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (stringBuffer.length() + 2 + string2.length() - n3 > n) {
                stringBuffer.append(",\n");
                n3 = stringBuffer.length();
                stringBuffer.append(string);
            } else if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static Map getExportFormats() {
        return Collections.unmodifiableMap(exportFormats);
    }

    public static ExportFormat getExportFormat(String string) {
        return (ExportFormat)exportFormats.get(string);
    }

    public static AbstractAction getExportAction(JabRefFrame jabRefFrame, boolean bl) {
        class ExportAction
        extends MnemonicAwareAction {
            private JabRefFrame frame;
            private boolean selectedOnly;

            public ExportAction(JabRefFrame jabRefFrame, boolean bl) {
                this.frame = jabRefFrame;
                this.selectedOnly = bl;
                this.putValue("Name", bl ? "Export selected entries" : "Export");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ExportFormats.initAllExports();
                JFileChooser jFileChooser = ExportFormats.createExportFileChooser(Globals.prefs.get("exportWorkingDirectory"));
                jFileChooser.showSaveDialog(this.frame);
                File file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                FileFilter fileFilter = jFileChooser.getFileFilter();
                if (fileFilter instanceof ExportFileFilter) {
                    try {
                        ExportFileFilter exportFileFilter = (ExportFileFilter)fileFilter;
                        String string = file.getPath();
                        if (!string.endsWith(exportFileFilter.getExportFormat().getExtension())) {
                            string = string + exportFileFilter.getExportFormat().getExtension();
                        }
                        if ((file = new File(string)).exists() && JOptionPane.showConfirmDialog(this.frame, "'" + file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Export"), 2) != 0) {
                            return;
                        }
                        ExportFormat exportFormat = exportFileFilter.getExportFormat();
                        HashSet<String> hashSet = null;
                        if (this.selectedOnly) {
                            BibtexEntry[] bibtexEntryArray = this.frame.basePanel().getSelectedEntries();
                            hashSet = new HashSet<String>();
                            for (int i = 0; i < bibtexEntryArray.length; ++i) {
                                BibtexEntry bibtexEntry = bibtexEntryArray[i];
                                hashSet.add(bibtexEntry.getId());
                            }
                        }
                        Globals.prefs.put("lastUsedExport", exportFormat.getConsoleName());
                        Globals.prefs.put("exportWorkingDirectory", file.getParent());
                        exportFormat.performExport(this.frame.basePanel().database(), file.getPath(), this.frame.basePanel().getEncoding(), hashSet);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.frame.output(Globals.lang("Could not save file") + " - " + exception.getMessage());
                        JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not save file") + ".\n" + exception.getMessage(), Globals.lang("Save database"), 0);
                    }
                }
            }
        }
        return new ExportAction(jabRefFrame, bl);
    }

    public static JFileChooser createExportFileChooser(String string) {
        String string2 = Globals.prefs.get("lastUsedExport");
        FileFilter fileFilter = null;
        JFileChooser jFileChooser = new JFileChooser(string);
        TreeSet<FileFilter> treeSet = new TreeSet<FileFilter>();
        Iterator<Object> iterator = exportFormats.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            ExportFormat exportFormat = (ExportFormat)exportFormats.get(string3);
            treeSet.add(exportFormat.getFileFilter());
            if (!string3.equals(string2)) continue;
            fileFilter = exportFormat.getFileFilter();
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            jFileChooser.addChoosableFileFilter((ExportFileFilter)iterator.next());
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (fileFilter != null) {
            jFileChooser.setFileFilter(fileFilter);
        }
        return jFileChooser;
    }

    private static void putFormat(ExportFormat exportFormat) {
        exportFormats.put(exportFormat.getConsoleName(), exportFormat);
    }
}

