/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import net.sf.jabref.export.ExportFormat;

public class ExportFileFilter
extends FileFilter
implements Comparable {
    private ExportFormat format;
    private String extension;
    private String name;

    public ExportFileFilter(ExportFormat exportFormat) {
        this.format = exportFormat;
        this.extension = exportFormat.getExtension();
        this.name = exportFormat.getDisplayName() + " (*" + exportFormat.getExtension() + ")";
    }

    public ExportFormat getExportFormat() {
        return this.format;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getPath().toLowerCase().endsWith(this.extension);
    }

    public String getDescription() {
        return this.name;
    }

    public int compareTo(Object object) {
        return this.name.compareTo(((ExportFileFilter)object).name);
    }
}

