/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.util.Comparator;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.export.ExportFormat;

public class CustomExportList
extends TreeSet {
    private TreeMap formats = new TreeMap();
    private Object[] array;
    JabRefPreferences prefs;

    public CustomExportList(JabRefPreferences jabRefPreferences, Comparator comparator) {
        super(comparator);
        this.prefs = jabRefPreferences;
        this.readPrefs();
        this.sort();
    }

    public TreeMap getCustomExportFormats() {
        return this.formats;
    }

    private void readPrefs() {
        int n = 0;
        String[] stringArray = null;
        while ((stringArray = this.prefs.getStringArray("customExportFormat" + n)) != null) {
            ExportFormat exportFormat = this.createFormat(stringArray);
            this.formats.put(exportFormat.getConsoleName(), exportFormat);
            super.add(stringArray);
            ++n;
        }
    }

    private ExportFormat createFormat(String[] stringArray) {
        String string = stringArray[1].endsWith(".layout") ? stringArray[1].substring(0, stringArray[1].length() - 7) : stringArray[1];
        ExportFormat exportFormat = new ExportFormat(stringArray[0], stringArray[0], string, null, stringArray[2]);
        exportFormat.setCustomExport(true);
        return exportFormat;
    }

    public String[] getElementAt(int n) {
        return (String[])this.array[n];
    }

    public void addFormat(String[] stringArray) {
        super.add(stringArray);
        ExportFormat exportFormat = this.createFormat(stringArray);
        this.formats.put(exportFormat.getConsoleName(), exportFormat);
        this.sort();
    }

    public void remove(int n) {
        String[] stringArray = (String[])this.array[n];
        this.formats.remove(stringArray[0]);
        super.remove(this.array[n]);
        this.sort();
    }

    public void sort() {
        this.array = this.toArray();
    }

    public void store() {
        if (this.array.length == 0) {
            this.purge(0);
        } else {
            for (int i = 0; i < this.array.length; ++i) {
                Globals.prefs.putStringArray("customExportFormat" + i, (String[])this.array[i]);
            }
            this.purge(this.array.length);
        }
    }

    private void purge(int n) {
        String[] stringArray = null;
        int n2 = n;
        while ((stringArray = Globals.prefs.getStringArray("customExportFormat" + n2)) != null) {
            Globals.prefs.remove("customExportFormat" + n2);
            ++n2;
        }
    }
}

