/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertString;
import net.sf.jabref.undo.UndoableStringChange;

public class StringChange
extends Change {
    BibtexString string;
    String mem;
    String tmp;
    String disk;
    String label;
    InfoPane tp = new InfoPane();
    JScrollPane sp = new JScrollPane(this.tp);

    public StringChange(BibtexString bibtexString, String string, String string2, String string3, String string4) {
        this.name = Globals.lang("Modified string") + ": '" + string + "'";
        this.string = bibtexString;
        this.label = string;
        this.mem = string2;
        this.tmp = string3;
        this.disk = string4;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML><H2>");
        stringBuffer.append(Globals.lang("Modified string"));
        stringBuffer.append("</H2><H3>");
        stringBuffer.append(Globals.lang("Label")).append(":</H3>");
        stringBuffer.append(string);
        stringBuffer.append("<H3>");
        stringBuffer.append(Globals.lang("New content")).append(":</H3>");
        stringBuffer.append(string4);
        if (bibtexString != null) {
            stringBuffer.append("<H3>");
            stringBuffer.append(Globals.lang("Current content")).append(":</H3>");
            stringBuffer.append(bibtexString.getContent());
        } else {
            stringBuffer.append("<P><I>");
            stringBuffer.append(Globals.lang("Cannot merge this change")).append(": ");
            stringBuffer.append(Globals.lang("The string has been removed locally")).append("</I>");
        }
        stringBuffer.append("</HTML>");
        this.tp.setText(stringBuffer.toString());
    }

    public void makeChange(BasePanel basePanel, NamedCompound namedCompound) {
        if (this.string != null) {
            this.string.setContent(this.disk);
            namedCompound.addEdit(new UndoableStringChange(basePanel, this.string, false, this.mem, this.disk));
        } else {
            String string = Util.createNeutralId();
            BibtexString bibtexString = new BibtexString(string, this.label, this.disk);
            try {
                basePanel.database().addString(bibtexString);
                namedCompound.addEdit(new UndoableInsertString(basePanel, basePanel.database(), bibtexString));
            }
            catch (KeyCollisionException keyCollisionException) {
                Globals.logger("Error: could not add string '" + this.string.getName() + "': " + keyCollisionException.getMessage());
            }
        }
    }

    JComponent description() {
        return this.sp;
    }
}

