/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.Util;
import net.sf.jabref.collab.Change;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableRemoveEntry;

public class EntryDeleteChange
extends Change {
    BibtexEntry memEntry;
    BibtexEntry tmpEntry;
    BibtexEntry diskEntry;
    boolean isModifiedLocally;
    double matchWithTmp;
    PreviewPanel pp;
    JScrollPane sp;

    public EntryDeleteChange(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        super("Deleted entry");
        this.memEntry = bibtexEntry;
        this.tmpEntry = bibtexEntry2;
        this.matchWithTmp = Util.compareEntriesStrictly(bibtexEntry, bibtexEntry2);
        this.isModifiedLocally = !(this.matchWithTmp > 1.0);
        this.pp = new PreviewPanel(bibtexEntry, new MetaData(), Globals.prefs.get("preview0"));
        this.sp = new JScrollPane(this.pp);
    }

    public void makeChange(BasePanel basePanel, NamedCompound namedCompound) {
        basePanel.database().removeEntry(this.memEntry.getId());
        namedCompound.addEdit(new UndoableRemoveEntry(basePanel.database(), this.memEntry, basePanel));
    }

    JComponent description() {
        return this.sp;
    }
}

