/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.bst;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.bst.BstLexer;
import net.sf.jabref.bst.BstParser;
import net.sf.jabref.bst.ChangeCaseFunction;
import net.sf.jabref.bst.FormatNameFunction;
import net.sf.jabref.bst.PurifyFunction;
import net.sf.jabref.bst.TextPrefixFunction;
import net.sf.jabref.bst.VMException;
import net.sf.jabref.bst.Warn;
import net.sf.jabref.bst.WidthFunction;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class VM
implements Warn {
    PrintStream out = System.out;
    public static final Integer FALSE = new Integer(0);
    public static final Integer TRUE = new Integer(1);
    private HashMap buildInFunctions;
    public File file;
    CommonTree tree;
    private StringBuffer bbl;
    String preamble;
    Vector entries;
    Map strings = new HashMap();
    Map integers = new HashMap();
    Map functions = new HashMap();
    Stack stack = new Stack();

    public VM(File file) throws RecognitionException, IOException {
        this(new ANTLRFileStream(file.getPath()));
        this.file = file;
    }

    public VM(String string) throws RecognitionException {
        this(new ANTLRStringStream(string));
    }

    public static CommonTree charStream2CommonTree(CharStream charStream) throws RecognitionException {
        BstLexer bstLexer = new BstLexer(charStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream(bstLexer);
        BstParser bstParser = new BstParser(commonTokenStream);
        BstParser.program_return program_return2 = bstParser.program();
        return (CommonTree)program_return2.getTree();
    }

    public VM(CharStream charStream) throws RecognitionException {
        this(VM.charStream2CommonTree(charStream));
    }

    public VM(CommonTree commonTree) {
        this.tree = commonTree;
        this.buildInFunctions = new HashMap(37);
        this.buildInFunctions.put(">", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation >");
                }
                Object e = VM.this.stack.pop();
                Object e2 = VM.this.stack.pop();
                if (!(e2 instanceof Integer) || !(e instanceof Integer)) {
                    throw new VMException("Can only compare two integers with >");
                }
                if (e2 == null ^ e == null) {
                    VM.this.stack.push(FALSE);
                    return;
                }
                if (e2 == e) {
                    VM.this.stack.push(FALSE);
                    return;
                }
                VM.this.stack.push(((Integer)e2).compareTo((Integer)e) > 0 ? TRUE : FALSE);
            }
        });
        this.buildInFunctions.put("<", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation <");
                }
                Object e = VM.this.stack.pop();
                Object e2 = VM.this.stack.pop();
                if (!(e2 instanceof Integer) || !(e instanceof Integer)) {
                    throw new VMException("Can only compare two integers with <");
                }
                if (e2 == null ^ e == null) {
                    VM.this.stack.push(FALSE);
                    return;
                }
                if (e2 == e) {
                    VM.this.stack.push(FALSE);
                    return;
                }
                VM.this.stack.push(((Integer)e2).compareTo((Integer)e) < 0 ? TRUE : FALSE);
            }
        });
        this.buildInFunctions.put("=", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                Object e;
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation =");
                }
                Object e2 = VM.this.stack.pop();
                if (e2 == null ^ (e = VM.this.stack.pop()) == null) {
                    VM.this.stack.push(FALSE);
                    return;
                }
                if (e2 == e) {
                    VM.this.stack.push(TRUE);
                    return;
                }
                VM.this.stack.push(e2.equals(e) ? TRUE : FALSE);
            }
        });
        this.buildInFunctions.put("+", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation +");
                }
                Object e = VM.this.stack.pop();
                Object e2 = VM.this.stack.pop();
                if (!(e2 instanceof Integer) || !(e instanceof Integer)) {
                    throw new VMException("Can only compare two integers with +");
                }
                VM.this.stack.push(new Integer((Integer)e2 + (Integer)e));
            }
        });
        this.buildInFunctions.put("-", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation -");
                }
                Object e = VM.this.stack.pop();
                Object e2 = VM.this.stack.pop();
                if (!(e2 instanceof Integer) || !(e instanceof Integer)) {
                    throw new VMException("Can only subtract two integers with -");
                }
                VM.this.stack.push(new Integer((Integer)e2 - (Integer)e));
            }
        });
        this.buildInFunctions.put("*", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation *");
                }
                Object e = VM.this.stack.pop();
                Object e2 = VM.this.stack.pop();
                if (!(e2 instanceof String) || !(e instanceof String)) {
                    throw new VMException("Can only concatenate two String with *");
                }
                VM.this.stack.push((String)e2 + (String)e);
            }
        });
        this.buildInFunctions.put(":=", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Invalid call to operation :=");
                }
                Object e = VM.this.stack.pop();
                Object e2 = VM.this.stack.pop();
                VM.this.assign(bstEntry, e, e2);
            }
        });
        this.buildInFunctions.put("add.period$", new BstFunction(){
            Pattern p = Pattern.compile("([^\\.\\?\\!\\}\\s])(\\}|\\s)*$");

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation add.period$");
                }
                Object e = VM.this.stack.pop();
                if (!(e instanceof String)) {
                    throw new VMException("Can only add a period to a string for add.period$");
                }
                String string = (String)e;
                Matcher matcher = this.p.matcher(string);
                if (matcher.find()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    matcher.appendReplacement(stringBuffer, matcher.group(1));
                    stringBuffer.append('.');
                    String string2 = matcher.group(2);
                    if (string2 != null) {
                        stringBuffer.append(matcher.group(2));
                    }
                    VM.this.stack.push(stringBuffer.toString());
                } else {
                    VM.this.stack.push(string);
                }
            }
        });
        this.buildInFunctions.put("call.type$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (bstEntry == null) {
                    throw new VMException("Call.type$ can only be called from within a context (ITERATE or REVERSE).");
                }
                VM.this.execute(bstEntry.entry.getType().getName().toLowerCase(), bstEntry);
            }
        });
        this.buildInFunctions.put("change.case$", new ChangeCaseFunction(this));
        this.buildInFunctions.put("chr.to.int$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation chr.to.int$");
                }
                Object e = VM.this.stack.pop();
                if (!(e instanceof String) || ((String)e).length() != 1) {
                    throw new VMException("Can only perform chr.to.int$ on string with length 1");
                }
                String string = (String)e;
                VM.this.stack.push(new Integer(string.charAt(0)));
            }
        });
        this.buildInFunctions.put("cite$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                VM.this.stack.push(bstEntry.entry.getCiteKey());
            }
        });
        this.buildInFunctions.put("duplicate$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation duplicate$");
                }
                Object e = VM.this.stack.pop();
                VM.this.stack.push(e);
                VM.this.stack.push(e);
            }
        });
        this.buildInFunctions.put("empty$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation empty$");
                }
                Object e = VM.this.stack.pop();
                if (e == null) {
                    VM.this.stack.push(TRUE);
                    return;
                }
                if (!(e instanceof String)) {
                    throw new VMException("Operand does not match function empty$");
                }
                String string = (String)e;
                VM.this.stack.push(string.trim().equals("") ? TRUE : FALSE);
            }
        });
        this.buildInFunctions.put("format.name$", new FormatNameFunction(this));
        this.buildInFunctions.put("if$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 3) {
                    throw new VMException("Not enough operands on stack for operation =");
                }
                Object e = VM.this.stack.pop();
                Object e2 = VM.this.stack.pop();
                Object e3 = VM.this.stack.pop();
                if (!(e instanceof Identifier) && !(e instanceof Tree) && (e2 instanceof Identifier || e2 instanceof Tree) && e3 instanceof Integer) {
                    throw new VMException("Expecting two functions and an integer for if$.");
                }
                Object e4 = (Integer)e3 > 0 ? e2 : e;
                VM.this.executeInContext(e4, bstEntry);
            }
        });
        this.buildInFunctions.put("int.to.chr$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation int.to.chr$");
                }
                Object e = VM.this.stack.pop();
                if (!(e instanceof Integer)) {
                    throw new VMException("Can only perform operation int.to.chr$ on an Integer");
                }
                Integer n = (Integer)e;
                VM.this.stack.push(String.valueOf((char)n.intValue()));
            }
        });
        this.buildInFunctions.put("int.to.str$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation int.to.str$");
                }
                Object e = VM.this.stack.pop();
                if (!(e instanceof Integer)) {
                    throw new VMException("Can only transform an integer to an string using int.to.str$");
                }
                VM.this.stack.push(((Integer)e).toString());
            }
        });
        this.buildInFunctions.put("missing$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation missing$");
                }
                Object e = VM.this.stack.pop();
                if (e == null) {
                    VM.this.stack.push(TRUE);
                    return;
                }
                if (!(e instanceof String)) {
                    VM.this.warn("Not a string or missing field in operation missing$");
                    VM.this.stack.push(TRUE);
                    return;
                }
                VM.this.stack.push(FALSE);
            }
        });
        this.buildInFunctions.put("newline$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                VM.this.bbl.append('\n');
            }
        });
        this.buildInFunctions.put("num.names$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation num.names$");
                }
                Object e = VM.this.stack.pop();
                if (!(e instanceof String)) {
                    throw new VMException("Need a string at the top of the stack for num.names$");
                }
                String string = (String)e;
                VM.this.stack.push(new Integer(AuthorList.getAuthorList(string).size()));
            }
        });
        this.buildInFunctions.put("pop$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                VM.this.stack.pop();
            }
        });
        this.buildInFunctions.put("preamble$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.preamble != null) {
                    VM.this.stack.push(VM.this.preamble);
                } else {
                    VM.this.stack.push("");
                }
            }
        });
        this.buildInFunctions.put("purify$", new PurifyFunction(this));
        this.buildInFunctions.put("quote$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                VM.this.stack.push("\"");
            }
        });
        this.buildInFunctions.put("skip$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
            }
        });
        this.buildInFunctions.put("stack$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                while (!VM.this.stack.empty()) {
                    System.out.println(VM.this.stack.pop());
                }
            }
        });
        this.buildInFunctions.put("substring$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 3) {
                    throw new VMException("Not enough operands on stack for operation substring$");
                }
                Object e = VM.this.stack.pop();
                Object e2 = VM.this.stack.pop();
                Object e3 = VM.this.stack.pop();
                if (!(e instanceof Integer && e2 instanceof Integer && e3 instanceof String)) {
                    throw new VMException("Expecting two integers and a string for substring$");
                }
                Integer n = (Integer)e;
                Integer n2 = (Integer)e2;
                int n3 = n;
                int n4 = n2;
                if (n3 > 0x3FFFFFFF) {
                    n3 = 0x3FFFFFFF;
                }
                if (n4 > 0x3FFFFFFF) {
                    n4 = 0x3FFFFFFF;
                }
                if (n4 < -1073741824) {
                    n4 = -1073741824;
                }
                String string = (String)e3;
                if (n4 < 0) {
                    n4 += string.length() + 1;
                    n4 = Math.max(1, n4 + 1 - n3);
                }
                VM.this.stack.push(string.substring(n4 - 1, Math.min(n4 - 1 + n3, string.length())));
            }
        });
        this.buildInFunctions.put("swap$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation swap$");
                }
                Object e = VM.this.stack.pop();
                Object e2 = VM.this.stack.pop();
                VM.this.stack.push(e);
                VM.this.stack.push(e2);
            }
        });
        this.buildInFunctions.put("text.length$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation text.length$");
                }
                Object e = VM.this.stack.pop();
                if (!(e instanceof String)) {
                    throw new VMException("Can only perform operation on a string text.length$");
                }
                String string = (String)e;
                char[] cArray = string.toCharArray();
                int n = 0;
                int n2 = 0;
                int n3 = string.length();
                int n4 = 0;
                while (n2 < n3) {
                    if (cArray[++n2 - 1] == '{') {
                        if (++n4 != 1 || n2 >= n3 || cArray[n2] != '\\') continue;
                        ++n2;
                        while (n2 < n3 && n4 > 0) {
                            if (cArray[n2] == '}') {
                                --n4;
                            } else if (cArray[n2] == '{') {
                                ++n4;
                            }
                            ++n2;
                        }
                        ++n;
                        continue;
                    }
                    if (cArray[n2 - 1] == '}') {
                        if (n4 <= 0) continue;
                        --n4;
                        continue;
                    }
                    ++n;
                }
                VM.this.stack.push(new Integer(n));
            }
        });
        this.buildInFunctions.put("text.prefix$", new TextPrefixFunction(this));
        this.buildInFunctions.put("top$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                System.out.println(VM.this.stack.pop());
            }
        });
        this.buildInFunctions.put("type$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                VM.this.stack.push(bstEntry.entry.getType().getName());
            }
        });
        this.buildInFunctions.put("warning$", new BstFunction(){
            int warning = 1;

            public void execute(BstEntry bstEntry) {
                VM.this.out.println("Warning (#" + this.warning++ + "): " + VM.this.stack.pop());
            }
        });
        this.buildInFunctions.put("while$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation while$");
                }
                Object e = VM.this.stack.pop();
                Object e2 = VM.this.stack.pop();
                if (!(e2 instanceof Identifier) && !(e2 instanceof Tree) && (e instanceof Identifier || e instanceof Tree)) {
                    throw new VMException("Expecting two functions for while$.");
                }
                while (true) {
                    VM.this.executeInContext(e2, bstEntry);
                    Object e3 = VM.this.stack.pop();
                    if (!(e3 instanceof Integer)) {
                        throw new VMException("First parameter to while has to return an integer but was " + e3);
                    }
                    if ((Integer)e3 <= 0) break;
                    VM.this.executeInContext(e, bstEntry);
                }
            }
        });
        this.buildInFunctions.put("width$", new WidthFunction(this));
        this.buildInFunctions.put("write$", new BstFunction(){

            public void execute(BstEntry bstEntry) {
                String string = (String)VM.this.stack.pop();
                System.out.println(string);
                VM.this.bbl.append(string);
            }
        });
    }

    protected boolean assign(BstEntry bstEntry, Object object, Object object2) {
        if (!(object instanceof Identifier) || !(object2 instanceof String) && !(object2 instanceof Integer)) {
            throw new VMException("Invalid parameters");
        }
        String string = ((Identifier)object).getName();
        if (object2 instanceof String) {
            if (bstEntry != null && bstEntry.strings.containsKey(string)) {
                bstEntry.strings.put(string, (String)object2);
                return true;
            }
            if (this.strings.containsKey(string)) {
                this.strings.put(string, (String)object2);
                return true;
            }
            return false;
        }
        if (object2 instanceof Integer) {
            if (bstEntry != null && bstEntry.integers.containsKey(string)) {
                bstEntry.integers.put(string, (Integer)object2);
                return true;
            }
            if (this.integers.containsKey(string)) {
                this.integers.put(string, (Integer)object2);
                return true;
            }
            return false;
        }
        return false;
    }

    public String run(BibtexDatabase bibtexDatabase) {
        this.preamble = bibtexDatabase.getPreamble();
        return this.run(bibtexDatabase.getEntries());
    }

    public String run(Collection collection) {
        this.reset();
        this.entries = new Vector(collection.size());
        ListIterator<BstEntry> listIterator = this.entries.listIterator();
        Object object = collection.iterator();
        while (object.hasNext()) {
            listIterator.add(new BstEntry((BibtexEntry)object.next()));
        }
        block13: for (int i = 0; i < this.tree.getChildCount(); ++i) {
            object = this.tree.getChild(i);
            switch (object.getType()) {
                case 8: {
                    this.strings((Tree)object);
                    continue block13;
                }
                case 9: {
                    this.integers((Tree)object);
                    continue block13;
                }
                case 10: {
                    this.function((Tree)object);
                    continue block13;
                }
                case 14: {
                    this.execute((Tree)object);
                    continue block13;
                }
                case 17: {
                    this.sort((Tree)object);
                    continue block13;
                }
                case 15: {
                    this.iterate((Tree)object);
                    continue block13;
                }
                case 16: {
                    this.reverse((Tree)object);
                    continue block13;
                }
                case 6: {
                    this.entry((Tree)object);
                    continue block13;
                }
                case 13: {
                    this.read();
                    continue block13;
                }
                case 11: {
                    this.macro((Tree)object);
                }
            }
        }
        return this.bbl.toString();
    }

    private void reset() {
        this.bbl = new StringBuffer();
        this.entries = null;
        this.strings = new HashMap();
        this.integers = new HashMap();
        this.integers.put("entry.max$", new Integer(Integer.MAX_VALUE));
        this.integers.put("global.max$", new Integer(Integer.MAX_VALUE));
        this.functions = new HashMap();
        this.functions.putAll(this.buildInFunctions);
        this.stack = new Stack();
    }

    private void read() {
        BstEntry bstEntry;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            bstEntry = (BstEntry)iterator.next();
            Iterator iterator2 = bstEntry.fields.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry;
                Object object = bstEntry.entry.getField((String)(entry = iterator2.next()).getKey());
                entry.setValue(object == null ? null : object.toString());
            }
        }
        iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            bstEntry = (BstEntry)iterator.next();
            if (bstEntry.fields.containsKey("crossref")) continue;
            bstEntry.fields.put("crossref", null);
        }
    }

    private void macro(Tree tree) {
        String string = tree.getChild(0).getText();
        String string2 = tree.getChild(1).getText();
        this.functions.put(string, new MacroFunction(string2));
    }

    private void entry(Tree tree) {
        BstEntry bstEntry;
        Iterator iterator;
        Object object;
        int n;
        Tree tree2 = tree.getChild(0);
        for (n = 0; n < tree2.getChildCount(); ++n) {
            object = tree2.getChild(n).getText();
            iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                bstEntry = (BstEntry)iterator.next();
                bstEntry.fields.put(object, null);
            }
        }
        tree2 = tree.getChild(1);
        for (n = 0; n < tree2.getChildCount(); ++n) {
            object = tree2.getChild(n).getText();
            iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                bstEntry = (BstEntry)iterator.next();
                bstEntry.integers.put(object, new Integer(0));
            }
        }
        tree2 = tree.getChild(2);
        for (n = 0; n < tree2.getChildCount(); ++n) {
            object = tree2.getChild(n).getText();
            iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                bstEntry = (BstEntry)iterator.next();
                bstEntry.strings.put(object, null);
            }
        }
        Iterator iterator2 = this.entries.iterator();
        while (iterator2.hasNext()) {
            object = (BstEntry)iterator2.next();
            ((BstEntry)object).strings.put("sort.key$", null);
        }
    }

    private void reverse(Tree tree) {
        BstFunction bstFunction = (BstFunction)this.functions.get(tree.getChild(0).getText());
        ListIterator listIterator = this.entries.listIterator(this.entries.size());
        while (listIterator.hasPrevious()) {
            bstFunction.execute((BstEntry)listIterator.previous());
        }
    }

    private void iterate(Tree tree) {
        BstFunction bstFunction = (BstFunction)this.functions.get(tree.getChild(0).getText());
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            bstFunction.execute((BstEntry)iterator.next());
        }
    }

    private void sort(Tree tree) {
        Collections.sort(this.entries, new Comparator(){

            public int compare(Object object, Object object2) {
                BstEntry bstEntry = (BstEntry)object;
                BstEntry bstEntry2 = (BstEntry)object2;
                return ((String)bstEntry.strings.get("sort.key$")).compareTo((String)bstEntry2.strings.get("sort.key$"));
            }
        });
    }

    public void executeInContext(Object object, BstEntry bstEntry) {
        if (object instanceof Tree) {
            Tree tree = (Tree)object;
            new StackFunction(tree).execute(bstEntry);
        } else if (object instanceof Identifier) {
            this.execute(((Identifier)object).getName(), bstEntry);
        }
    }

    public void execute(Tree tree) {
        this.execute(tree.getChild(0).getText(), null);
    }

    private void push(Tree tree) {
        this.stack.push(tree);
    }

    public void execute(String string, BstEntry bstEntry) {
        if (bstEntry != null) {
            if (bstEntry.fields.containsKey(string)) {
                this.stack.push(bstEntry.fields.get(string));
                return;
            }
            if (bstEntry.strings.containsKey(string)) {
                this.stack.push(bstEntry.strings.get(string));
                return;
            }
            if (bstEntry.integers.containsKey(string)) {
                this.stack.push(bstEntry.integers.get(string));
                return;
            }
        }
        if (this.strings.containsKey(string)) {
            this.stack.push(this.strings.get(string));
            return;
        }
        if (this.integers.containsKey(string)) {
            this.stack.push(this.integers.get(string));
            return;
        }
        if (this.functions.containsKey(string)) {
            ((BstFunction)this.functions.get(string)).execute(bstEntry);
            return;
        }
        throw new VMException("No matching identifier found: " + string);
    }

    private void function(Tree tree) {
        String string = tree.getChild(0).getText();
        Tree tree2 = tree.getChild(1);
        this.functions.put(string, new StackFunction(tree2));
    }

    private void integers(Tree tree) {
        Tree tree2 = tree.getChild(0);
        for (int i = 0; i < tree2.getChildCount(); ++i) {
            String string = tree2.getChild(i).getText();
            this.integers.put(string, new Integer(0));
        }
    }

    private void strings(Tree tree) {
        Tree tree2 = tree.getChild(0);
        for (int i = 0; i < tree2.getChildCount(); ++i) {
            String string = tree2.getChild(i).getText();
            this.strings.put(string, null);
        }
    }

    public void push(Integer n) {
        this.stack.push(n);
    }

    public void push(String string) {
        this.stack.push(string);
    }

    public void push(Identifier identifier) {
        this.stack.push(identifier);
    }

    public Map getStrings() {
        return this.strings;
    }

    public Map getIntegers() {
        return this.integers;
    }

    public Vector getEntries() {
        return this.entries;
    }

    public Map getFunctions() {
        return this.functions;
    }

    public Stack getStack() {
        return this.stack;
    }

    public void warn(String string) {
        System.out.println(string);
    }

    public class BstEntry {
        BibtexEntry entry;
        Map strings = new HashMap();
        Map fields = new HashMap();
        Map integers = new HashMap();

        public BstEntry(BibtexEntry bibtexEntry) {
            this.entry = bibtexEntry;
        }

        public Map getFields() {
            return this.fields;
        }

        public BibtexEntry getBibtexEntry() {
            return this.entry;
        }
    }

    public class StackFunction
    implements BstFunction {
        Tree tree;

        public Tree getTree() {
            return this.tree;
        }

        public StackFunction(Tree tree) {
            this.tree = tree;
        }

        public void execute(BstEntry bstEntry) {
            for (int i = 0; i < this.tree.getChildCount(); ++i) {
                Tree tree = this.tree.getChild(i);
                try {
                    switch (tree.getType()) {
                        case 12: {
                            String string = tree.getText();
                            VM.this.push(string.substring(1, string.length() - 1));
                            break;
                        }
                        case 19: {
                            VM.this.push(new Integer(Integer.parseInt(tree.getText().substring(1))));
                            break;
                        }
                        case 20: {
                            VM.this.push(new Identifier(tree.getText().substring(1)));
                            break;
                        }
                        case 5: {
                            VM.this.push(tree);
                            break;
                        }
                        default: {
                            VM.this.execute(tree.getText(), bstEntry);
                            break;
                        }
                    }
                    continue;
                }
                catch (VMException vMException) {
                    if (VM.this.file != null) {
                        System.err.println("ERROR " + vMException.getMessage() + " (" + VM.this.file.getPath() + ":" + tree.getLine() + ")");
                    } else {
                        System.err.println("ERROR " + vMException.getMessage() + " (" + tree.getLine() + ")");
                    }
                    throw vMException;
                }
            }
        }
    }

    public class MacroFunction
    implements BstFunction {
        String replacement;

        public MacroFunction(String string) {
            this.replacement = string;
        }

        public void execute(BstEntry bstEntry) {
            VM.this.push(this.replacement);
        }
    }

    public static interface BstFunction {
        public void execute(BstEntry var1);
    }

    public class Variable {
        public String name;

        public Variable(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }
    }

    public class Identifier {
        public String name;

        public Identifier(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }
    }
}

