/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.bst;

import net.sf.jabref.AuthorList;
import net.sf.jabref.bst.VMException;
import net.sf.jabref.bst.Warn;

public class BibtexNameFormatter {
    public static String formatName(String string, int n, String string2, Warn warn) {
        AuthorList authorList = AuthorList.getAuthorList(string);
        if (n < 1 && n > authorList.size()) {
            warn.warn("AuthorList " + string + " does not contain an author with number " + n);
            return "";
        }
        return BibtexNameFormatter.formatName(authorList.getAuthor(n - 1), string2, warn);
    }

    public static String formatName(AuthorList.Author author, String string, Warn warn) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (cArray[n4] == '{') {
                int n5;
                String string2;
                ++n3;
                int n6 = stringBuffer.length();
                ++n4;
                ++n2;
                StringBuffer stringBuffer2 = new StringBuffer();
                StringBuffer stringBuffer3 = new StringBuffer();
                while (n4 < n && n2 > 0) {
                    stringBuffer3.append(cArray[n4]);
                    if (cArray[n4] == '{') {
                        ++n2;
                        ++n4;
                        continue;
                    }
                    if (cArray[n4] == '}') {
                        --n2;
                        ++n4;
                        continue;
                    }
                    if (n2 == 1 && Character.isLetter(cArray[n4])) {
                        if ("fvlj".indexOf(cArray[n4]) == -1) {
                            if (warn != null) {
                                warn.warn("Format String in format.name$ may only contain fvlj on brace level 1 in group " + n3 + ": " + string);
                            }
                        } else {
                            stringBuffer2.append(cArray[n4]);
                        }
                    }
                    ++n4;
                }
                --n4;
                String string3 = stringBuffer2.toString().toLowerCase();
                if (string3.length() == 0) continue;
                if (string3.length() > 2 && warn != null) {
                    warn.warn("Format String in format.name$ may only be one or two character long on brace level 1 in group " + n3 + ": " + string);
                }
                char c = string3.charAt(0);
                switch (c) {
                    case 'f': {
                        string2 = author.getFirst();
                        break;
                    }
                    case 'v': {
                        string2 = author.getVon();
                        break;
                    }
                    case 'l': {
                        string2 = author.getLast();
                        break;
                    }
                    case 'j': {
                        string2 = author.getJr();
                        break;
                    }
                    default: {
                        throw new VMException("Internal error");
                    }
                }
                if (string2 == null) {
                    ++n4;
                    continue;
                }
                String[] stringArray = string2.split(" ");
                boolean bl = true;
                if (string3.length() == 2) {
                    if (string3.charAt(1) == string3.charAt(0)) {
                        bl = false;
                    } else if (warn != null) {
                        warn.warn("Format String in format.name$ may only contain one type of vlfj on brace level 1 in group " + n3 + ": " + string);
                    }
                }
                if (n2 == 0 && stringBuffer3.charAt(stringBuffer3.length() - 1) == '}') {
                    stringBuffer3.deleteCharAt(stringBuffer3.length() - 1);
                }
                char[] cArray2 = stringBuffer3.toString().toCharArray();
                int n7 = 1;
                String string4 = null;
                for (n5 = 0; n5 < cArray2.length; ++n5) {
                    if (Character.isLetter(cArray2[n5]) && n7 == 1) {
                        n6 = stringBuffer.length();
                        if (!bl) {
                            ++n5;
                        }
                        if (n5 + 1 < cArray2.length && cArray2[n5 + 1] == '{') {
                            StringBuffer stringBuffer4 = new StringBuffer();
                            n5 = BibtexNameFormatter.consumeToMatchingBrace(stringBuffer4, cArray2, n5 + 1);
                            string4 = stringBuffer4.substring(1, stringBuffer4.length() - 1);
                        }
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string5 = stringArray[i];
                            if (bl) {
                                String[] stringArray2 = string5.split("-");
                                StringBuffer stringBuffer5 = new StringBuffer();
                                for (int j = 0; j < stringArray2.length - 1; ++j) {
                                    stringBuffer5.append(BibtexNameFormatter.getFirstCharOfString(stringArray2[j])).append(".-");
                                }
                                if (stringArray2.length > 0) {
                                    stringBuffer5.append(BibtexNameFormatter.getFirstCharOfString(stringArray2[stringArray2.length - 1]));
                                }
                                string5 = stringBuffer5.toString();
                            }
                            stringBuffer.append(string5);
                            if (i >= stringArray.length - 1) continue;
                            if (string4 == null) {
                                if (bl) {
                                    stringBuffer.append(".");
                                }
                                if (i == stringArray.length - 2 || BibtexNameFormatter.numberOfChars(stringBuffer.substring(n6, stringBuffer.length()), 3) < 3) {
                                    stringBuffer.append("~");
                                    continue;
                                }
                                stringBuffer.append(" ");
                                continue;
                            }
                            stringBuffer.append(string4);
                        }
                        continue;
                    }
                    if (cArray2[n5] == '}') {
                        if (--n7 <= 0) continue;
                        stringBuffer.append('}');
                        continue;
                    }
                    if (cArray2[n5] == '{') {
                        ++n7;
                        stringBuffer.append('{');
                        continue;
                    }
                    stringBuffer.append(cArray2[n5]);
                }
                if (stringBuffer.length() > 0) {
                    n5 = 0;
                    if (stringBuffer.charAt(stringBuffer.length() - 1) == '~' && (BibtexNameFormatter.numberOfChars(stringBuffer.substring(n6, stringBuffer.length()), 4) >= 4 || stringBuffer.length() > 1 && (n5 = stringBuffer.charAt(stringBuffer.length() - 2) == '~' ? 1 : 0) != 0)) {
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                        if (n5 == 0) {
                            stringBuffer.append(' ');
                        }
                    }
                }
            } else if (cArray[n4] == '}') {
                if (warn != null) {
                    warn.warn("Unmatched brace in format string: " + string);
                }
            } else {
                stringBuffer.append(cArray[n4]);
            }
            ++n4;
        }
        if (n2 != 0) {
            warn.warn("Unbalanced brace in format string for nameFormat: " + string);
        }
        return stringBuffer.toString();
    }

    public static int consumeToMatchingBrace(StringBuffer stringBuffer, char[] cArray, int n) {
        int n2 = 0;
        for (int i = n; i < cArray.length; ++i) {
            if (cArray[i] == '}') {
                if (--n2 == 0) {
                    stringBuffer.append('}');
                    return i;
                }
            } else if (cArray[i] == '{') {
                ++n2;
            }
            stringBuffer.append(cArray[i]);
        }
        return cArray.length;
    }

    public static String getFirstCharOfString(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isLetter(cArray[i])) {
                return String.valueOf(cArray[i]);
            }
            if (cArray[i] != '{' || i + 1 >= cArray.length || cArray[i + 1] != '\\') continue;
            StringBuffer stringBuffer = new StringBuffer();
            BibtexNameFormatter.consumeToMatchingBrace(stringBuffer, cArray, i);
            return stringBuffer.toString();
        }
        return "";
    }

    public static int numberOfChars(String string, int n) {
        int n2;
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        int n3 = 0;
        char[] cArray = string.toCharArray();
        int n4 = cArray.length;
        int n5 = 0;
        for (n2 = 0; n3 < n4 && n2 < n; ++n2) {
            if (cArray[++n3 - 1] == '{') {
                if (++n5 != 1 || n3 >= n4 || cArray[n3] != '\\') continue;
                ++n3;
                while (n3 < n4 && n5 > 0) {
                    if (cArray[n3] == '}') {
                        --n5;
                    } else if (cArray[n3] == '{') {
                        ++n5;
                    }
                    ++n3;
                }
                continue;
            }
            if (cArray[n3 - 1] != '}') continue;
            --n5;
        }
        return n2;
    }
}

