/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.bst;

import net.sf.jabref.bst.Warn;

public class BibtexCaseChanger {
    String s;
    char format;
    boolean prevColon = true;
    int n;
    Warn warn;
    int braceLevel = 0;
    public static final char TITLE_LOWERS = 't';
    public static final char ALL_LOWERS = 'l';
    public static final char ALL_UPPERS = 'u';

    BibtexCaseChanger(String string, char c, Warn warn) {
        this.s = string;
        this.format = c;
        this.n = string.length();
        this.warn = warn;
    }

    public static String changeCase(String string, char c, Warn warn) {
        return new BibtexCaseChanger(string, c, warn).changeCase();
    }

    private String changeCase() {
        char[] cArray = this.s.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.n) {
            if (cArray[n] == '{') {
                ++this.braceLevel;
                if (this.braceLevel != 1 || n + 4 > this.n || cArray[n + 1] != '\\') {
                    this.prevColon = false;
                    stringBuffer.append(cArray[n]);
                    ++n;
                    continue;
                }
                if (this.format == 't' && (n == 0 || this.prevColon && Character.isWhitespace(cArray[n - 1]))) {
                    stringBuffer.append(cArray[n]);
                    ++n;
                    this.prevColon = false;
                    continue;
                }
                n = this.convertSpecialChar(stringBuffer, cArray, n, this.format);
                continue;
            }
            if (cArray[n] == '}') {
                stringBuffer.append(cArray[n]);
                ++n;
                this.braceLevel = this.decrBraceLevel(this.s, this.braceLevel);
                this.prevColon = false;
                continue;
            }
            if (this.braceLevel == 0) {
                n = this.convertChar0(cArray, n, stringBuffer, this.format);
                continue;
            }
            stringBuffer.append(cArray[n]);
            ++n;
        }
        BibtexCaseChanger.checkBrace(this.s, this.braceLevel);
        return stringBuffer.toString();
    }

    int decrBraceLevel(String string, int n) {
        if (n == 0) {
            BibtexCaseChanger.complain(string);
        } else {
            --n;
        }
        return n;
    }

    static void complain(String string) {
        System.out.println("Warning -- String is not brace-balanced: " + string);
    }

    static void checkBrace(String string, int n) {
        if (n > 0) {
            BibtexCaseChanger.complain(string);
        }
    }

    public int convertSpecialChar(StringBuffer stringBuffer, char[] cArray, int n, char c) {
        stringBuffer.append(cArray[n]);
        ++n;
        while (n < cArray.length && this.braceLevel > 0) {
            stringBuffer.append(cArray[n]);
            String string = BibtexCaseChanger.findSpecialChar(cArray, ++n);
            if (string != null) {
                n = this.convertAccented(cArray, n, string, stringBuffer, c);
            }
            while (n < cArray.length && this.braceLevel > 0 && cArray[n] != '\\') {
                if (cArray[n] == '}') {
                    --this.braceLevel;
                } else if (cArray[n] == '{') {
                    ++this.braceLevel;
                }
                n = this.convertNonControl(cArray, n, stringBuffer, c);
            }
        }
        return n;
    }

    int convertAccented(char[] cArray, int n, String string, StringBuffer stringBuffer, char c) {
        n += string.length();
        switch (c) {
            case 'l': 
            case 't': {
                if ("L O OE AE AA".indexOf(string) != -1) {
                    stringBuffer.append(string.toLowerCase());
                    break;
                }
                stringBuffer.append(string);
                break;
            }
            case 'u': {
                if ("l o oe ae aa".indexOf(string) != -1) {
                    stringBuffer.append(string.toUpperCase());
                    break;
                }
                if ("i j ss".indexOf(string) != -1) {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    stringBuffer.append(string.toUpperCase());
                    while (n < cArray.length && Character.isWhitespace(cArray[n])) {
                        ++n;
                    }
                    break;
                }
                stringBuffer.append(string);
            }
        }
        return n;
    }

    int convertNonControl(char[] cArray, int n, StringBuffer stringBuffer, char c) {
        switch (c) {
            case 'l': 
            case 't': {
                stringBuffer.append(Character.toLowerCase(cArray[n]));
                ++n;
                break;
            }
            case 'u': {
                stringBuffer.append(Character.toUpperCase(cArray[n]));
                ++n;
            }
        }
        return n;
    }

    int convertChar0(char[] cArray, int n, StringBuffer stringBuffer, char c) {
        switch (c) {
            case 't': {
                if (n == 0) {
                    stringBuffer.append(cArray[n]);
                } else if (this.prevColon && Character.isWhitespace(cArray[n - 1])) {
                    stringBuffer.append(cArray[n]);
                } else {
                    stringBuffer.append(Character.toLowerCase(cArray[n]));
                }
                if (cArray[n] == ':') {
                    this.prevColon = true;
                    break;
                }
                if (Character.isWhitespace(cArray[n])) break;
                this.prevColon = false;
                break;
            }
            case 'l': {
                stringBuffer.append(Character.toLowerCase(cArray[n]));
                break;
            }
            case 'u': {
                stringBuffer.append(Character.toUpperCase(cArray[n]));
            }
        }
        return ++n;
    }

    static String findSpecialChar(char[] cArray, int n) {
        if (n + 1 < cArray.length) {
            if (cArray[n] == 'o' && cArray[n + 1] == 'e') {
                return "oe";
            }
            if (cArray[n] == 'O' && cArray[n + 1] == 'E') {
                return "OE";
            }
            if (cArray[n] == 'a' && cArray[n + 1] == 'e') {
                return "ae";
            }
            if (cArray[n] == 'A' && cArray[n + 1] == 'E') {
                return "AE";
            }
            if (cArray[n] == 's' && cArray[n + 1] == 's') {
                return "ss";
            }
            if (cArray[n] == 'A' && cArray[n + 1] == 'A') {
                return "AA";
            }
            if (cArray[n] == 'a' && cArray[n + 1] == 'a') {
                return "aa";
            }
        }
        if (cArray[n] == 'i') {
            return String.valueOf(cArray[n]);
        }
        if (cArray[n] == 'j') {
            return String.valueOf(cArray[n]);
        }
        if (cArray[n] == 'o') {
            return String.valueOf(cArray[n]);
        }
        if (cArray[n] == 'O') {
            return String.valueOf(cArray[n]);
        }
        if (cArray[n] == 'l') {
            return String.valueOf(cArray[n]);
        }
        if (cArray[n] == 'L') {
            return String.valueOf(cArray[n]);
        }
        return null;
    }
}

