/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.about;

import java.awt.Color;
import java.awt.Font;
import java.util.Random;
import javax.swing.UIManager;

public class AboutTextLine {
    private String text;
    private double[] direction;
    private double[] pos;
    private double speed;
    private double accel;
    private int tag;
    private Font font;
    private Color color;
    private boolean visible;

    public AboutTextLine(String string) {
        Random random = new Random(System.currentTimeMillis() * (long)this.hashCode());
        this.text = string;
        this.pos = new double[2];
        this.pos[0] = random.nextDouble() * 100.0;
        this.pos[1] = random.nextDouble() * 100.0;
        this.direction = new double[2];
        this.direction[0] = random.nextDouble();
        this.direction[1] = random.nextDouble();
        this.accel = 0.0;
        this.speed = 1.0;
        this.tag = 0;
        this.color = Color.black;
        this.visible = true;
        this.font = UIManager.getFont("Label.font");
    }

    public void performTimeStep(double d) {
        this.accel *= d;
        this.speed += this.accel;
        double d2 = this.speed * d;
        this.pos[0] = this.pos[0] + d2 * this.direction[0];
        this.pos[1] = this.pos[1] + d2 * this.direction[1];
    }

    public String toString() {
        return this.text + "<" + this.pos[0] + ", " + this.pos[1] + ">" + "<" + this.direction[0] + ", " + this.direction[1] + ">";
    }

    public int getPosX() {
        return (int)this.pos[0];
    }

    public int getPosY() {
        return (int)this.pos[1];
    }

    public double[] getPos() {
        return this.pos;
    }

    public void setPos(double d, double d2) {
        this.pos[0] = d;
        this.pos[1] = d2;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public double[] getDirection() {
        return this.direction;
    }

    public void setDirection(double d, double d2) {
        this.direction[0] = d;
        this.direction[1] = d2;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double d) {
        this.speed = d;
    }

    public double getAccel() {
        return this.accel;
    }

    public void setAccel(double d) {
        this.accel = d;
    }

    public int getTag() {
        return this.tag;
    }

    public void setTag(int n) {
        this.tag = n;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }
}

