/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

class XmpPrefsTab
extends JPanel
implements PrefsTab {
    boolean tableChanged = false;
    int rowCount;
    JTable table;
    JCheckBox privacyFilterCheckBox = new JCheckBox(Globals.lang("Do not write the following fields to XMP Metadata:"));
    Vector tableRows = new Vector(10);
    static /* synthetic */ Class class$java$lang$String;

    public XmpPrefsTab() {
        this.setLayout(new BorderLayout());
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            public int getRowCount() {
                return XmpPrefsTab.this.rowCount;
            }

            public int getColumnCount() {
                return 1;
            }

            public Object getValueAt(int n, int n2) {
                if (n >= XmpPrefsTab.this.tableRows.size()) {
                    return "";
                }
                Object e = XmpPrefsTab.this.tableRows.elementAt(n);
                if (e == null) {
                    return "";
                }
                return e;
            }

            public String getColumnName(int n) {
                return Globals.lang("Field to filter");
            }

            public Class getColumnClass(int n) {
                return class$java$lang$String == null ? (class$java$lang$String = XmpPrefsTab.class$("java.lang.String")) : class$java$lang$String;
            }

            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            public void setValueAt(Object object, int n, int n2) {
                XmpPrefsTab.this.tableChanged = true;
                if (XmpPrefsTab.this.tableRows.size() <= n) {
                    XmpPrefsTab.this.tableRows.setSize(n + 1);
                }
                XmpPrefsTab.this.tableRows.setElementAt(object, n);
            }
        };
        this.table = new JTable(abstractTableModel);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(140);
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.table, 20, 31);
        this.table.setPreferredScrollableViewportSize(new Dimension(250, 200));
        jScrollPane.setMinimumSize(new Dimension(250, 300));
        jPanel2.add((Component)jScrollPane, "Center");
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.setBorder(null);
        jToolBar.add(new AddRowAction());
        jToolBar.add(new DeleteRowAction());
        jPanel2.add((Component)jToolBar, "East");
        defaultFormBuilder.appendSeparator(Globals.lang("XMP Export Privacy Settings"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.privacyFilterCheckBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(jPanel2);
        defaultFormBuilder.nextLine();
        jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
    }

    public void setValues() {
        this.tableRows.clear();
        String[] stringArray = JabRefPreferences.getInstance().getStringArray("xmpPrivacyFilters");
        for (int i = 0; i < stringArray.length; ++i) {
            this.tableRows.add(stringArray[i]);
        }
        this.rowCount = this.tableRows.size() + 5;
        this.privacyFilterCheckBox.setSelected(JabRefPreferences.getInstance().getBoolean("useXmpPrivacyFilter"));
    }

    public void storeSettings() {
        int n;
        if (this.table.isEditing()) {
            n = this.table.getEditingColumn();
            int n2 = this.table.getEditingRow();
            this.table.getCellEditor(n2, n).stopCellEditing();
        }
        if (this.tableChanged) {
            for (n = this.tableRows.size() - 1; n >= 0; --n) {
                if (!this.tableRows.elementAt(n).equals("")) continue;
                this.tableRows.removeElementAt(n);
            }
            JabRefPreferences.getInstance().putStringArray("xmpPrivacyFilters", this.tableRows.toArray(new String[this.tableRows.size()]));
        }
        JabRefPreferences.getInstance().putBoolean("useXmpPrivacyFilter", this.privacyFilterCheckBox.isSelected());
    }

    public boolean readyToClose() {
        return true;
    }

    public String getTabName() {
        return Globals.lang("XMP metadata");
    }

    class AddRowAction
    extends AbstractAction {
        public AddRowAction() {
            super("Add row", GUIGlobals.getImage("add"));
            this.putValue("ShortDescription", Globals.lang("Insert rows"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = XmpPrefsTab.this.table.getSelectedRows();
            if (nArray.length == 0) {
                ++XmpPrefsTab.this.rowCount;
                XmpPrefsTab.this.table.revalidate();
                XmpPrefsTab.this.table.repaint();
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] + i >= XmpPrefsTab.this.tableRows.size()) continue;
                XmpPrefsTab.this.tableRows.add(nArray[i] + i, "");
            }
            XmpPrefsTab.this.rowCount += nArray.length;
            if (nArray.length > 1) {
                XmpPrefsTab.this.table.clearSelection();
            }
            XmpPrefsTab.this.table.revalidate();
            XmpPrefsTab.this.table.repaint();
            XmpPrefsTab.this.tableChanged = true;
        }
    }

    class DeleteRowAction
    extends AbstractAction {
        public DeleteRowAction() {
            super("Delete row", GUIGlobals.getImage("remove"));
            this.putValue("ShortDescription", Globals.lang("Delete rows"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = XmpPrefsTab.this.table.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] >= XmpPrefsTab.this.tableRows.size()) continue;
                XmpPrefsTab.this.tableRows.remove(nArray[i]);
            }
            XmpPrefsTab.this.rowCount -= nArray.length;
            if (nArray.length > 1) {
                XmpPrefsTab.this.table.clearSelection();
            }
            XmpPrefsTab.this.table.revalidate();
            XmpPrefsTab.this.table.repaint();
            XmpPrefsTab.this.tableChanged = true;
        }
    }
}

