/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.ErrorMessageDisplay;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.IncrementalSearcher;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.SearchRule;
import net.sf.jabref.SearchRuleSet;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.search.BasicSearch;
import net.sf.jabref.search.SearchExpression;
import net.sf.jabref.search.SearchExpressionParser;
import net.sf.jabref.search.SearchMatcher;

class SearchManager2
extends SidePaneComponent
implements ActionListener,
KeyListener,
ItemListener,
CaretListener,
ErrorMessageDisplay {
    private JabRefFrame frame;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    IncrementalSearcher incSearcher;
    private JTextField searchField = new JTextField("", 12);
    private JLabel lab = new JLabel(GUIGlobals.getImage("search"));
    private JPopupMenu settings = new JPopupMenu();
    private JButton openset = new JButton(Globals.lang("Settings"));
    private JButton escape = new JButton(Globals.lang("Clear"));
    private JButton help = new JButton(GUIGlobals.getImage("help"));
    private JButton search = new JButton();
    private JCheckBoxMenuItem searchReq;
    private JCheckBoxMenuItem searchOpt;
    private JCheckBoxMenuItem searchGen;
    private JCheckBoxMenuItem searchAll;
    private JCheckBoxMenuItem caseSensitive;
    private JCheckBoxMenuItem regExpSearch;
    private JRadioButton increment;
    private JRadioButton floatSearch;
    private JRadioButton hideSearch;
    private JCheckBoxMenuItem select;
    private ButtonGroup types = new ButtonGroup();
    private boolean incSearch = false;
    private boolean startedFloatSearch = false;
    private boolean startedFilterSearch = false;
    private int incSearchPos = -1;

    public SearchManager2(JabRefFrame jabRefFrame, SidePaneManager sidePaneManager) {
        super(sidePaneManager, GUIGlobals.getIconUrl("search"), Globals.lang("Search"));
        this.frame = jabRefFrame;
        this.incSearcher = new IncrementalSearcher(Globals.prefs);
        this.searchReq = new JCheckBoxMenuItem(Globals.lang("Search required fields"), Globals.prefs.getBoolean("searchReq"));
        this.searchOpt = new JCheckBoxMenuItem(Globals.lang("Search optional fields"), Globals.prefs.getBoolean("searchOpt"));
        this.searchGen = new JCheckBoxMenuItem(Globals.lang("Search general fields"), Globals.prefs.getBoolean("searchGen"));
        this.searchAll = new JCheckBoxMenuItem(Globals.lang("Search all fields"), Globals.prefs.getBoolean("searchAll"));
        this.regExpSearch = new JCheckBoxMenuItem(Globals.lang("Use regular expressions"), Globals.prefs.getBoolean("regExpSearch"));
        this.increment = new JRadioButton(Globals.lang("Incremental"), false);
        this.floatSearch = new JRadioButton(Globals.lang("Float"), true);
        this.hideSearch = new JRadioButton(Globals.lang("Filter"), true);
        this.types.add(this.increment);
        this.types.add(this.floatSearch);
        this.types.add(this.hideSearch);
        this.select = new JCheckBoxMenuItem(Globals.lang("Select matches"), false);
        this.increment.setToolTipText(Globals.lang("Incremental search"));
        this.floatSearch.setToolTipText(Globals.lang("Gray out non-matching entries"));
        this.hideSearch.setToolTipText(Globals.lang("Hide non-matching entries"));
        this.increment.addItemListener(this);
        this.floatSearch.addItemListener(this);
        this.hideSearch.addItemListener(this);
        this.searchField.addFocusListener(Globals.focusListener);
        if (this.searchAll.isSelected()) {
            this.searchReq.setEnabled(false);
            this.searchOpt.setEnabled(false);
            this.searchGen.setEnabled(false);
        }
        this.searchAll.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = !SearchManager2.this.searchAll.isSelected();
                SearchManager2.this.searchReq.setEnabled(bl);
                SearchManager2.this.searchOpt.setEnabled(bl);
                SearchManager2.this.searchGen.setEnabled(bl);
            }
        });
        this.caseSensitive = new JCheckBoxMenuItem(Globals.lang("Case sensitive"), Globals.prefs.getBoolean("caseSensitiveSearch"));
        this.settings.add(this.select);
        this.settings.addSeparator();
        this.settings.add(this.caseSensitive);
        this.settings.add(this.regExpSearch);
        this.searchField.addActionListener(this);
        this.searchField.addCaretListener(this);
        this.search.addActionListener(this);
        this.searchField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (SearchManager2.this.increment.isSelected()) {
                    SearchManager2.this.searchField.setText("");
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                SearchManager2.this.incSearch = false;
                SearchManager2.this.incSearchPos = -1;
                if (SearchManager2.this.increment.isSelected()) {
                    // empty if block
                }
            }
        });
        this.escape.addActionListener(this);
        this.escape.setEnabled(false);
        this.openset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!SearchManager2.this.settings.isVisible()) {
                    JButton jButton = (JButton)actionEvent.getSource();
                    SearchManager2.this.settings.show(jButton, 0, SearchManager2.this.openset.getHeight());
                }
            }
        });
        Insets insets = new Insets(0, 2, 0, 2);
        this.escape.setMargin(insets);
        this.openset.setMargin(insets);
        int n = this.help.getIcon().getIconHeight() + 5;
        Dimension dimension = new Dimension(n, n);
        this.help.setPreferredSize(dimension);
        this.help.setMinimumSize(dimension);
        this.help.setMargin(insets);
        this.help.addActionListener(new HelpAction(Globals.helpDiag, GUIGlobals.searchHelp, "Help"));
        if (Globals.prefs.getBoolean("incrementS")) {
            this.increment.setSelected(true);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.gbl);
        this.con.gridwidth = 0;
        this.con.fill = 1;
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.searchField, this.con);
        jPanel.add(this.searchField);
        this.gbl.setConstraints(this.search, this.con);
        jPanel.add(this.search);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.escape, this.con);
        jPanel.add(this.escape);
        this.con.insets = new Insets(0, 2, 0, 0);
        this.gbl.setConstraints(this.increment, this.con);
        jPanel.add(this.increment);
        this.gbl.setConstraints(this.floatSearch, this.con);
        jPanel.add(this.floatSearch);
        this.gbl.setConstraints(this.hideSearch, this.con);
        jPanel.add(this.hideSearch);
        this.con.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.gbl.setConstraints(jPanel2, this.con);
        jPanel2.setLayout(gridBagLayout);
        this.con.weightx = 1.0;
        this.con.gridwidth = 1;
        gridBagLayout.setConstraints(this.openset, this.con);
        jPanel2.add(this.openset);
        this.con.weightx = 0.0;
        gridBagLayout.setConstraints(this.help, this.con);
        jPanel2.add(this.help);
        jPanel.add(jPanel2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setContent(jPanel);
        this.searchField.getInputMap().put(Globals.prefs.getKey("Repeat incremental search"), "repeat");
        this.searchField.getActionMap().put("repeat", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SearchManager2.this.increment.isSelected()) {
                    SearchManager2.this.repeatIncremental();
                }
            }
        });
        this.searchField.getInputMap().put(Globals.prefs.getKey("Clear search"), "escape");
        this.searchField.getActionMap().put("escape", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchManager2.this.hideAway();
            }
        });
        this.setSearchButtonSizes();
        this.updateSearchButtonText();
    }

    private void setSearchButtonSizes() {
        this.search.setText(Globals.lang("Search Specified Field(s)"));
        Dimension dimension = this.search.getPreferredSize();
        this.search.setText(Globals.lang("Search All Fields"));
        Dimension dimension2 = this.search.getPreferredSize();
        dimension2.width = Math.max(dimension.width, dimension2.width);
        this.search.setMinimumSize(dimension2);
        this.search.setPreferredSize(dimension2);
    }

    public void updatePrefs() {
        Globals.prefs.putBoolean("searchReq", this.searchReq.isSelected());
        Globals.prefs.putBoolean("searchOpt", this.searchOpt.isSelected());
        Globals.prefs.putBoolean("searchGen", this.searchGen.isSelected());
        Globals.prefs.putBoolean("searchAll", this.searchAll.isSelected());
        Globals.prefs.putBoolean("incrementS", this.increment.isSelected());
        Globals.prefs.putBoolean("selectS", this.select.isSelected());
        Globals.prefs.putBoolean("grayOutNonHits", this.floatSearch.isSelected());
        Globals.prefs.putBoolean("caseSensitiveSearch", this.caseSensitive.isSelected());
        Globals.prefs.putBoolean("regExpSearch", this.regExpSearch.isSelected());
    }

    public void startIncrementalSearch() {
        this.increment.setSelected(true);
        this.searchField.setText("");
        this.searchField.requestFocus();
    }

    public void startSearch() {
        if (this.increment.isSelected() && this.incSearch) {
            this.repeatIncremental();
            return;
        }
        if (!this.searchField.hasFocus()) {
            this.searchField.selectAll();
            this.searchField.requestFocus();
        } else {
            if (this.increment.isSelected()) {
                this.floatSearch.setSelected(true);
            } else if (this.floatSearch.isSelected()) {
                this.hideSearch.setSelected(true);
            } else {
                this.increment.setSelected(true);
            }
            this.increment.revalidate();
            this.increment.repaint();
            this.searchField.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.escape) {
            this.incSearch = false;
            if (this.panel != null) {
                Thread thread = new Thread(){

                    public void run() {
                        SearchManager2.this.clearSearch();
                    }
                };
                SwingUtilities.invokeLater(thread);
            }
        } else if (!(actionEvent.getSource() != this.searchField && actionEvent.getSource() != this.search || this.increment.isSelected() || this.panel == null)) {
            this.updatePrefs();
            if (this.searchField.getText().equals("")) {
                this.panel.stopShowingSearchResults();
                return;
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("option", this.searchField.getText());
            SearchRuleSet searchRuleSet = new SearchRuleSet();
            SearchRule searchRule = new BasicSearch(Globals.prefs.getBoolean("caseSensitiveSearch"), Globals.prefs.getBoolean("regExpSearch"));
            try {
                searchRule = new SearchExpression(Globals.prefs, hashtable);
            }
            catch (Exception exception) {
                // empty catch block
            }
            searchRuleSet.addRule(searchRule);
            SearchWorker searchWorker = new SearchWorker(searchRuleSet, hashtable);
            searchWorker.getWorker().run();
            searchWorker.getCallBack().update();
            this.escape.setEnabled(true);
        }
    }

    public void clearSearch() {
        if (this.startedFloatSearch) {
            this.startedFloatSearch = false;
            this.panel.mainTable.stopShowingFloatSearch();
        } else if (this.startedFilterSearch) {
            this.startedFilterSearch = false;
            this.panel.stopShowingSearchResults();
        }
        this.escape.setEnabled(false);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.increment) {
            if (this.startedFilterSearch || this.startedFloatSearch) {
                this.clearSearch();
            }
            this.updateSearchButtonText();
            if (this.increment.isSelected()) {
                this.searchField.addKeyListener(this);
            } else {
                this.searchField.removeKeyListener(this);
            }
        } else {
            this.updateSearchButtonText();
        }
    }

    private void repeatIncremental() {
        ++this.incSearchPos;
        if (this.panel != null) {
            this.goIncremental();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.isControlDown()) {
            return;
        }
        if (this.panel != null) {
            this.goIncremental();
        }
    }

    private void goIncremental() {
        this.incSearch = true;
        this.escape.setEnabled(true);
        SwingUtilities.invokeLater(new Thread(){

            public void run() {
                String string = SearchManager2.this.searchField.getText();
                if (SearchManager2.this.incSearchPos >= SearchManager2.this.panel.getDatabase().getEntryCount()) {
                    SearchManager2.this.panel.output("'" + string + "' : " + Globals.lang("Incremental search failed. Repeat to search from top.") + ".");
                    SearchManager2.this.incSearchPos = -1;
                    return;
                }
                if (SearchManager2.this.searchField.getText().equals("")) {
                    return;
                }
                if (SearchManager2.this.incSearchPos < 0) {
                    SearchManager2.this.incSearchPos = 0;
                }
                BibtexEntry bibtexEntry = SearchManager2.this.panel.mainTable.getEntryAt(SearchManager2.this.incSearchPos);
                while (!SearchManager2.this.incSearcher.search(string, bibtexEntry)) {
                    SearchManager2.this.incSearchPos++;
                    if (SearchManager2.this.incSearchPos < SearchManager2.this.panel.getDatabase().getEntryCount()) {
                        bibtexEntry = SearchManager2.this.panel.mainTable.getEntryAt(SearchManager2.this.incSearchPos);
                        continue;
                    }
                    SearchManager2.this.panel.output("'" + string + "' : " + Globals.lang("Incremental search failed. Repeat to search from top."));
                    SearchManager2.this.incSearchPos = -1;
                    return;
                }
                if (SearchManager2.this.incSearchPos >= 0) {
                    SearchManager2.this.panel.selectSingleEntry(SearchManager2.this.incSearchPos);
                    SearchManager2.this.panel.output("'" + string + "' " + Globals.lang("found") + ".");
                }
            }
        });
    }

    public void componentClosing() {
        this.frame.searchToggle.setSelected(false);
        if (this.panel != null && (this.startedFilterSearch || this.startedFloatSearch)) {
            this.clearSearch();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() == this.searchField) {
            this.updateSearchButtonText();
        }
    }

    private void updateSearchButtonText() {
        this.search.setText(!this.increment.isSelected() && SearchExpressionParser.checkSyntax(this.searchField.getText(), this.caseSensitive.isSelected(), this.regExpSearch.isSelected()) != null ? Globals.lang("Search Specified Field(s)") : Globals.lang("Search All Fields"));
    }

    public void reportError(String string) {
        JOptionPane.showMessageDialog(this.panel, string, Globals.lang("Search error"), 0);
    }

    public void reportError(String string, Exception exception) {
        this.reportError(string);
    }

    class SearchWorker
    extends AbstractWorker {
        private SearchRuleSet rules;
        Hashtable searchTerm;
        int hits = 0;

        public SearchWorker(SearchRuleSet searchRuleSet, Hashtable hashtable) {
            this.rules = searchRuleSet;
            this.searchTerm = hashtable;
        }

        public void run() {
            Collection collection = SearchManager2.this.panel.getDatabase().getEntries();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
                boolean bl = this.rules.applyRule(this.searchTerm, bibtexEntry) > 0;
                bibtexEntry.setSearchHit(bl);
                if (!bl) continue;
                ++this.hits;
            }
        }

        public void update() {
            SearchManager2.this.panel.output(Globals.lang("Searched database. Number of hits") + ": " + this.hits);
            if (SearchManager2.this.hideSearch.isSelected()) {
                if (SearchManager2.this.startedFloatSearch) {
                    SearchManager2.this.panel.mainTable.stopShowingFloatSearch();
                    SearchManager2.this.startedFloatSearch = false;
                }
                SearchManager2.this.startedFilterSearch = true;
                SearchManager2.this.panel.setSearchMatcher(SearchMatcher.INSTANCE);
            } else {
                if (SearchManager2.this.startedFilterSearch) {
                    SearchManager2.this.panel.stopShowingSearchResults();
                    SearchManager2.this.startedFilterSearch = false;
                }
                SearchManager2.this.startedFloatSearch = true;
                SearchManager2.this.panel.mainTable.showFloatSearch(SearchMatcher.INSTANCE);
            }
            SearchManager2.this.searchField.select(0, SearchManager2.this.searchField.getText().length());
        }
    }
}

