/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.AddToGroupAction;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.RemoveFromGroupAction;

public class RightClickMenu
extends JPopupMenu
implements PopupMenuListener {
    BasePanel panel;
    MetaData metaData;
    JMenu groupAddMenu = new JMenu(Globals.lang("Add to group"));
    JMenu groupRemoveMenu = new JMenu(Globals.lang("Remove from group"));
    JMenu groupMoveMenu = new JMenu("Assign exclusively to group");
    JMenu typeMenu = new JMenu(Globals.lang("Change entry type"));
    JCheckBoxMenuItem floatMarked = new JCheckBoxMenuItem(Globals.lang("Float marked entries"), Globals.prefs.getBoolean("floatMarkedEntries"));

    public RightClickMenu(BasePanel basePanel, MetaData metaData) {
        this.panel = basePanel;
        this.metaData = metaData;
        boolean bl = this.panel.mainTable.getSelectedRowCount() > 1;
        BibtexEntry bibtexEntry = null;
        if (this.panel.mainTable.getSelectedRowCount() == 1) {
            bibtexEntry = (BibtexEntry)this.panel.mainTable.getSelected().get(0);
        }
        this.addPopupMenuListener(this);
        this.add(new AbstractAction(Globals.lang("Copy"), GUIGlobals.getImage("copy")){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("copy");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Paste"), GUIGlobals.getImage("paste")){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("paste");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Cut"), GUIGlobals.getImage("cut")){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("cut");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Delete"), GUIGlobals.getImage("delete")){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("delete");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.addSeparator();
        this.add(new AbstractAction(Globals.lang("Export to clipboard")){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("exportToClipboard");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.addSeparator();
        if (bl) {
            this.add(new AbstractAction(Globals.lang("Mark entries"), GUIGlobals.getImage("markEntries")){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        RightClickMenu.this.panel.runCommand("markEntries");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            this.add(new AbstractAction(Globals.lang("Unmark entries"), GUIGlobals.getImage("unmarkEntries")){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        RightClickMenu.this.panel.runCommand("unmarkEntries");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            this.addSeparator();
        } else if (bibtexEntry != null) {
            if (bibtexEntry.getField("__markedentry") == null) {
                this.add(new AbstractAction(Globals.lang("Mark entry"), GUIGlobals.getImage("markEntries")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            RightClickMenu.this.panel.runCommand("markEntries");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            } else {
                this.add(new AbstractAction(Globals.lang("Unmark entry"), GUIGlobals.getImage("unmarkEntries")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            RightClickMenu.this.panel.runCommand("unmarkEntries");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            this.addSeparator();
        }
        this.add(new AbstractAction(Globals.lang("Open PDF or PS"), GUIGlobals.getImage("openFile")){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("openFile");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Open URL or DOI"), GUIGlobals.getImage("www")){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("openUrl");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Copy BibTeX key")){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("copyKey");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.add(new AbstractAction(Globals.lang("Copy") + " \\cite{" + Globals.lang("BibTeX key") + "}"){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("copyCiteKey");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.addSeparator();
        this.populateTypeMenu();
        this.add(this.typeMenu);
        this.add(new AbstractAction(Globals.lang("Plain text import")){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RightClickMenu.this.panel.runCommand("importPlainText");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.addSeparator();
        this.floatMarked.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Globals.prefs.putBoolean("floatMarkedEntries", RightClickMenu.this.floatMarked.isSelected());
                RightClickMenu.this.panel.mainTable.refreshSorting();
            }
        });
    }

    public void populateTypeMenu() {
        this.typeMenu.removeAll();
        Iterator iterator = BibtexEntryType.ALL_TYPES.keySet().iterator();
        while (iterator.hasNext()) {
            this.typeMenu.add(new ChangeTypeAction(BibtexEntryType.getType((String)iterator.next()), this.panel));
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        BibtexEntry[] bibtexEntryArray = this.panel.getSelectedEntries();
        this.panel.storeCurrentEdit();
        GroupTreeNode groupTreeNode = this.metaData.getGroups();
        if (groupTreeNode == null) {
            this.groupAddMenu.setEnabled(false);
            this.groupMoveMenu.setEnabled(false);
            this.groupRemoveMenu.setEnabled(false);
            return;
        }
        this.groupAddMenu.setEnabled(true);
        this.groupMoveMenu.setEnabled(true);
        this.groupRemoveMenu.setEnabled(true);
        this.groupAddMenu.removeAll();
        this.groupMoveMenu.removeAll();
        this.groupRemoveMenu.removeAll();
        if (bibtexEntryArray == null) {
            return;
        }
        this.add(this.groupAddMenu);
        this.add(this.groupMoveMenu);
        this.add(this.groupRemoveMenu);
        this.groupAddMenu.setEnabled(false);
        this.groupMoveMenu.setEnabled(false);
        this.groupRemoveMenu.setEnabled(false);
        this.insertNodes(this.groupAddMenu, this.metaData.getGroups(), bibtexEntryArray, true, false);
        this.insertNodes(this.groupMoveMenu, this.metaData.getGroups(), bibtexEntryArray, true, true);
        this.insertNodes(this.groupRemoveMenu, this.metaData.getGroups(), bibtexEntryArray, false, false);
        this.addSeparator();
        this.floatMarked.setSelected(Globals.prefs.getBoolean("floatMarkedEntries"));
        this.add(this.floatMarked);
    }

    public void insertNodes(JMenu jMenu, GroupTreeNode groupTreeNode, BibtexEntry[] bibtexEntryArray, boolean bl, boolean bl2) {
        AbstractAction abstractAction = this.getAction(groupTreeNode, bibtexEntryArray, bl, bl2);
        if (groupTreeNode.getChildCount() == 0) {
            JMenuItem jMenuItem = new JMenuItem(abstractAction);
            this.setGroupFontAndIcon(jMenuItem, groupTreeNode.getGroup());
            jMenu.add(jMenuItem);
            if (abstractAction.isEnabled()) {
                jMenu.setEnabled(true);
            }
            return;
        }
        JMenu jMenu2 = null;
        if (groupTreeNode.getGroup() instanceof AllEntriesGroup) {
            for (int i = 0; i < groupTreeNode.getChildCount(); ++i) {
                this.insertNodes(jMenu, (GroupTreeNode)groupTreeNode.getChildAt(i), bibtexEntryArray, bl, bl2);
            }
        } else {
            jMenu2 = new JMenu("[" + groupTreeNode.getGroup().getName() + "]");
            this.setGroupFontAndIcon(jMenu2, groupTreeNode.getGroup());
            jMenu2.setEnabled(abstractAction.isEnabled());
            JMenuItem jMenuItem = new JMenuItem(abstractAction);
            this.setGroupFontAndIcon(jMenuItem, groupTreeNode.getGroup());
            jMenu2.add(jMenuItem);
            jMenu2.add(new JPopupMenu.Separator());
            for (int i = 0; i < groupTreeNode.getChildCount(); ++i) {
                this.insertNodes(jMenu2, (GroupTreeNode)groupTreeNode.getChildAt(i), bibtexEntryArray, bl, bl2);
            }
            jMenu.add(jMenu2);
            if (jMenu2.isEnabled()) {
                jMenu.setEnabled(true);
            }
        }
    }

    private void setGroupFontAndIcon(JMenuItem jMenuItem, AbstractGroup abstractGroup) {
        if (Globals.prefs.getBoolean("groupShowDynamic")) {
            jMenuItem.setFont(jMenuItem.getFont().deriveFont(abstractGroup.isDynamic() ? 2 : 0));
        }
        if (Globals.prefs.getBoolean("groupShowIcons")) {
            switch (abstractGroup.getHierarchicalContext()) {
                case 2: {
                    jMenuItem.setIcon(GUIGlobals.getImage("groupIncluding"));
                    break;
                }
                case 1: {
                    jMenuItem.setIcon(GUIGlobals.getImage("groupRefining"));
                    break;
                }
                default: {
                    jMenuItem.setIcon(GUIGlobals.getImage("groupRegular"));
                }
            }
        }
    }

    private AbstractAction getAction(GroupTreeNode groupTreeNode, BibtexEntry[] bibtexEntryArray, boolean bl, boolean bl2) {
        AbstractAction abstractAction = bl ? new AddToGroupAction(groupTreeNode, bl2, this.panel) : new RemoveFromGroupAction(groupTreeNode, this.panel);
        AbstractGroup abstractGroup = groupTreeNode.getGroup();
        if (!bl2) {
            abstractAction.setEnabled(bl ? abstractGroup.supportsAdd() && !abstractGroup.containsAll(bibtexEntryArray) : abstractGroup.supportsRemove() && abstractGroup.containsAny(bibtexEntryArray));
        } else {
            abstractAction.setEnabled(abstractGroup.supportsAdd());
        }
        return abstractAction;
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.remove(this.groupAddMenu);
        this.remove(this.groupMoveMenu);
        this.remove(this.groupRemoveMenu);
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    class ChangeTypeAction
    extends AbstractAction {
        BibtexEntryType type;
        BasePanel panel;

        public ChangeTypeAction(BibtexEntryType bibtexEntryType, BasePanel basePanel) {
            super(bibtexEntryType.getName());
            this.type = bibtexEntryType;
            this.panel = basePanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.panel.changeType(this.type);
        }
    }
}

