/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.export.layout.LayoutHelper;

public class PreviewPanel
extends JEditorPane
implements VetoableChangeListener {
    public String CONTENT_TYPE = "text/html";
    BibtexEntry entry;
    MetaData metaData;
    BibtexDatabase database;
    Layout layout;
    String layoutFile;
    JScrollPane sp;

    public PreviewPanel(BibtexDatabase bibtexDatabase, MetaData metaData, String string) {
        this(metaData, string);
        this.database = bibtexDatabase;
    }

    public PreviewPanel(BibtexDatabase bibtexDatabase, MetaData metaData, BibtexEntry bibtexEntry, String string) {
        this(metaData, string);
        this.database = bibtexDatabase;
        this.setEntry(bibtexEntry);
        try {
            this.readLayout();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.update();
    }

    public PreviewPanel(BibtexEntry bibtexEntry, MetaData metaData, String string) {
        this(null, metaData, bibtexEntry, string);
    }

    public PreviewPanel(MetaData metaData, String string) {
        this.metaData = metaData;
        this.layoutFile = string;
        this.sp = new JScrollPane(this, 20, 31);
        this.sp.setBorder(null);
        this.setEditable(false);
        this.setContentType(this.CONTENT_TYPE);
        this.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        String string = hyperlinkEvent.getURL().toString();
                        Util.openExternalViewer(PreviewPanel.this.metaData, string, "url");
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
    }

    public void setDatabase(BibtexDatabase bibtexDatabase) {
        this.database = bibtexDatabase;
    }

    public JScrollPane getPane() {
        return this.sp;
    }

    public void readLayout(String string) throws Exception {
        this.layoutFile = string;
        this.readLayout();
    }

    public void readLayout() throws Exception {
        StringReader stringReader = new StringReader(this.layoutFile.replaceAll("__NEWLINE__", "\n"));
        this.layout = new LayoutHelper(stringReader).getLayoutFromText("net.sf.jabref.export.layout.format.");
    }

    public void setEntry(BibtexEntry bibtexEntry) {
        if (bibtexEntry != this.entry) {
            if (this.entry != null) {
                this.entry.removePropertyChangeListener(this);
            }
            bibtexEntry.addPropertyChangeListener(this);
        }
        this.entry = bibtexEntry;
        try {
            this.readLayout();
            this.update();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void update() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.layout.doLayout(this.entry, this.database));
        this.setText(stringBuffer.toString());
        this.invalidate();
        this.revalidate();
        final JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jScrollBar.setValue(0);
            }
        });
    }

    public boolean hasEntry() {
        return this.entry != null;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        super.paintComponent(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        this.update();
    }
}

