/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.HelpDialog;
import net.sf.jabref.PrefsTab;

public class NameFormatterTab
extends JPanel
implements PrefsTab {
    public static final String NAME_FORMATTER_VALUE = "nameFormatterFormats";
    public static final String NAME_FORMATER_KEY = "nameFormatterNames";
    private boolean tableChanged = false;
    private JTable table;
    private int rowCount = -1;
    private Vector tableRows = new Vector(10);
    static /* synthetic */ Class class$java$lang$String;

    public static Map getNameFormatters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = Globals.prefs.getStringArray(NAME_FORMATER_KEY);
        String[] stringArray2 = Globals.prefs.getStringArray(NAME_FORMATTER_VALUE);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (i < stringArray2.length) {
                hashMap.put(stringArray[i], stringArray2[i]);
                continue;
            }
            hashMap.put(stringArray[i], "1@*@{ff }{vv }{ll}{, jj}@@*@1@{ff }{vv }{ll}{, jj}@*@, {ff }{vv }{ll}{, jj}");
        }
        return hashMap;
    }

    public NameFormatterTab(HelpDialog helpDialog) {
        this.setLayout(new BorderLayout());
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            public int getRowCount() {
                return NameFormatterTab.this.rowCount;
            }

            public int getColumnCount() {
                return 2;
            }

            public Object getValueAt(int n, int n2) {
                if (n >= NameFormatterTab.this.tableRows.size()) {
                    return "";
                }
                TableRow tableRow = (TableRow)NameFormatterTab.this.tableRows.elementAt(n);
                if (tableRow == null) {
                    return "";
                }
                switch (n2) {
                    case 0: {
                        return tableRow.name;
                    }
                    case 1: {
                        return tableRow.format;
                    }
                }
                return null;
            }

            public String getColumnName(int n) {
                return n == 0 ? Globals.lang("Formatter Name") : Globals.lang("Format String");
            }

            public Class getColumnClass(int n) {
                if (n == 0) {
                    return class$java$lang$String == null ? (class$java$lang$String = NameFormatterTab.class$("java.lang.String")) : class$java$lang$String;
                }
                return class$java$lang$String == null ? (class$java$lang$String = NameFormatterTab.class$("java.lang.String")) : class$java$lang$String;
            }

            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            public void setValueAt(Object object, int n, int n2) {
                NameFormatterTab.this.tableChanged = true;
                while (n >= NameFormatterTab.this.tableRows.size()) {
                    NameFormatterTab.this.tableRows.add(new TableRow());
                }
                TableRow tableRow = (TableRow)NameFormatterTab.this.tableRows.elementAt(n);
                if (n2 == 0) {
                    tableRow.name = object.toString();
                } else {
                    tableRow.format = object.toString();
                }
            }
        };
        this.table = new JTable(abstractTableModel);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(140);
        tableColumnModel.getColumn(1).setPreferredWidth(400);
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.table, 20, 31);
        this.table.setPreferredScrollableViewportSize(new Dimension(250, 200));
        jScrollPane.setMinimumSize(new Dimension(250, 300));
        jScrollPane.setPreferredSize(new Dimension(600, 300));
        jPanel2.add((Component)jScrollPane, "Center");
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.setBorder(null);
        jToolBar.add(new AddRowAction());
        jToolBar.add(new DeleteRowAction());
        jToolBar.add(new HelpAction(helpDialog, GUIGlobals.nameFormatterHelp, "Help on Name Formatting", GUIGlobals.getIconUrl("helpSmall")));
        jPanel2.add((Component)jToolBar, "East");
        defaultFormBuilder.appendSeparator(Globals.lang("Special Name Formatters"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(jPanel2);
        defaultFormBuilder.nextLine();
        jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
    }

    public void setValues() {
        this.tableRows.clear();
        String[] stringArray = Globals.prefs.getStringArray(NAME_FORMATER_KEY);
        String[] stringArray2 = Globals.prefs.getStringArray(NAME_FORMATTER_VALUE);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (i < stringArray2.length) {
                this.tableRows.add(new TableRow(stringArray[i], stringArray2[i]));
                continue;
            }
            this.tableRows.add(new TableRow(stringArray[i]));
        }
        this.rowCount = this.tableRows.size() + 5;
    }

    public void storeSettings() {
        int n;
        if (this.table.isEditing()) {
            n = this.table.getEditingColumn();
            int n2 = this.table.getEditingRow();
            this.table.getCellEditor(n2, n).stopCellEditing();
        }
        if (this.tableChanged) {
            n = 0;
            while (n < this.tableRows.size()) {
                if (((TableRow)this.tableRows.elementAt((int)n)).name.equals("")) {
                    this.tableRows.removeElementAt(n);
                    continue;
                }
                ++n;
            }
            String[] stringArray = new String[this.tableRows.size()];
            String[] stringArray2 = new String[this.tableRows.size()];
            for (n = 0; n < this.tableRows.size(); ++n) {
                TableRow tableRow = (TableRow)this.tableRows.elementAt(n);
                stringArray[n] = tableRow.name;
                stringArray2[n] = tableRow.format;
            }
            Globals.prefs.putStringArray(NAME_FORMATER_KEY, stringArray);
            Globals.prefs.putStringArray(NAME_FORMATTER_VALUE, stringArray2);
        }
    }

    public boolean readyToClose() {
        return true;
    }

    public String getTabName() {
        return Globals.lang("Name formatter");
    }

    class AddRowAction
    extends AbstractAction {
        public AddRowAction() {
            super("Add row", GUIGlobals.getImage("add"));
            this.putValue("ShortDescription", Globals.lang("Insert rows"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = NameFormatterTab.this.table.getSelectedRows();
            if (nArray.length == 0) {
                NameFormatterTab.this.rowCount++;
                NameFormatterTab.this.table.revalidate();
                NameFormatterTab.this.table.repaint();
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] + i - 1 >= NameFormatterTab.this.tableRows.size()) continue;
                NameFormatterTab.this.tableRows.add(Math.max(0, nArray[i] + i - 1), new TableRow());
            }
            NameFormatterTab.this.rowCount += nArray.length;
            if (nArray.length > 1) {
                NameFormatterTab.this.table.clearSelection();
            }
            NameFormatterTab.this.table.revalidate();
            NameFormatterTab.this.table.repaint();
            NameFormatterTab.this.tableChanged = true;
        }
    }

    class DeleteRowAction
    extends AbstractAction {
        public DeleteRowAction() {
            super("Delete row", GUIGlobals.getImage("remove"));
            this.putValue("ShortDescription", Globals.lang("Delete rows"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NameFormatterTab.this.tableChanged = true;
            int[] nArray = NameFormatterTab.this.table.getSelectedRows();
            int n = 0;
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] >= NameFormatterTab.this.tableRows.size()) continue;
                NameFormatterTab.this.tableRows.remove(nArray[i]);
                ++n;
            }
            NameFormatterTab.this.rowCount -= n;
            if (nArray.length > 1) {
                NameFormatterTab.this.table.clearSelection();
            }
            NameFormatterTab.this.table.revalidate();
            NameFormatterTab.this.table.repaint();
        }
    }

    class TableRow {
        String name;
        String format;

        public TableRow() {
            this("");
        }

        public TableRow(String string) {
            this(string, "1@*@{ff }{vv }{ll}{, jj}@@*@1@{ff }{vv }{ll}{, jj}@*@, {ff }{vv }{ll}{, jj}");
        }

        public TableRow(String string, String string2) {
            this.name = string;
            this.format = string2;
        }
    }
}

