/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.layout.Sizes;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import net.sf.jabref.BasePanel;
import net.sf.jabref.ContentSelectorDialog2;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;

public class FieldContentSelector
extends JComponent {
    JComboBox comboBox;
    FieldEditor editor;
    MetaData metaData;
    JabRefFrame frame;
    Window owner;
    BasePanel panel;
    String delimiter;

    public FieldContentSelector(JabRefFrame jabRefFrame, final BasePanel basePanel, Window window, final FieldEditor fieldEditor, final MetaData metaData, final AbstractAction abstractAction, boolean bl, String string) {
        this.frame = jabRefFrame;
        this.editor = fieldEditor;
        this.metaData = metaData;
        this.panel = basePanel;
        this.owner = window;
        this.delimiter = string;
        this.comboBox = new JComboBox(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.width > 240) {
                    dimension.width = 240;
                }
                return dimension;
            }
        };
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.comboBox.setMaximumRowCount(35);
        this.comboBox.putClientProperty("ComboBox.popupPrototypeDisplayValue", "The longest text in the combo popup menu. And even longer.");
        this.rebuildComboBox();
        gridBagConstraints.gridwidth = bl ? 3 : 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.comboBox, gridBagConstraints);
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("comboBoxChanged") && actionEvent.getModifiers() == 0) {
                    return;
                }
                if (FieldContentSelector.this.comboBox.getSelectedIndex() == 0) {
                    return;
                }
                String string = (String)FieldContentSelector.this.comboBox.getSelectedItem();
                if (string == null || string.equals("")) {
                    return;
                }
                if (!fieldEditor.getText().equals("")) {
                    fieldEditor.append(FieldContentSelector.this.delimiter);
                }
                fieldEditor.append(string);
                FieldContentSelector.this.comboBox.setSelectedIndex(0);
                if (abstractAction != null) {
                    abstractAction.actionPerformed(new ActionEvent(fieldEditor, 0, ""));
                }
                fieldEditor.requestFocus();
            }
        });
        this.add(this.comboBox);
        if (bl) {
            this.add(Box.createHorizontalStrut(Sizes.dialogUnitXAsPixel(2, this)));
        }
        JButton jButton = new JButton(Globals.lang("Manage"));
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog2 contentSelectorDialog2 = FieldContentSelector.this.owner instanceof Frame ? new ContentSelectorDialog2((Frame)FieldContentSelector.this.owner, FieldContentSelector.this.frame, basePanel, true, metaData, fieldEditor.getFieldName()) : new ContentSelectorDialog2((Dialog)FieldContentSelector.this.owner, FieldContentSelector.this.frame, basePanel, true, metaData, fieldEditor.getFieldName());
                Util.placeDialog(contentSelectorDialog2, FieldContentSelector.this.frame);
                contentSelectorDialog2.setVisible(true);
                FieldContentSelector.this.rebuildComboBox();
            }
        });
    }

    void rebuildComboBox() {
        this.comboBox.removeAllItems();
        this.comboBox.addItem("");
        Vector vector = this.metaData.getData("selector_" + this.editor.getFieldName());
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                this.comboBox.addItem(iterator.next());
            }
        }
    }
}

