/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Comparator;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Util;

public class FieldComparator
implements Comparator {
    String field;
    boolean isNameField;
    boolean isTypeHeader;
    boolean isYearField;
    boolean isMonthField;
    int multiplier;

    public FieldComparator(String string) {
        this(string, false);
    }

    public FieldComparator(String string, boolean bl) {
        this.field = string;
        this.multiplier = bl ? -1 : 1;
        this.isTypeHeader = string.equals(GUIGlobals.TYPE_HEADER);
        this.isNameField = string.equals("author") || string.equals("editor");
        this.isYearField = string.equals("year");
        this.isMonthField = string.equals("month");
    }

    public int compare(Object object, Object object2) {
        Object object3;
        Object object4;
        BibtexEntry bibtexEntry = (BibtexEntry)object;
        BibtexEntry bibtexEntry2 = (BibtexEntry)object2;
        if (this.isTypeHeader) {
            object4 = bibtexEntry.getType().getName();
            object3 = bibtexEntry2.getType().getName();
        } else {
            object4 = bibtexEntry.getField(this.field);
            object3 = bibtexEntry2.getField(this.field);
        }
        int n = this.multiplier;
        if (this.isMonthField) {
            n = -n;
        }
        if (object4 == null) {
            return object3 == null ? 0 : n;
        }
        if (object3 == null) {
            return -n;
        }
        if (this.isNameField) {
            if (object4 != null) {
                object4 = AuthorList.fixAuthorForAlphabetization((String)object4);
            }
            if (object3 != null) {
                object3 = AuthorList.fixAuthorForAlphabetization((String)object3);
            }
        } else if (this.isYearField) {
            object4 = Util.toFourDigitYear((String)object4);
            object3 = Util.toFourDigitYear((String)object3);
        } else if (this.isMonthField) {
            object4 = new Integer(Util.getMonthNumber((String)object4));
            object3 = new Integer(Util.getMonthNumber((String)object3));
        }
        int n2 = 0;
        if (object4 instanceof Integer && object3 instanceof Integer) {
            n2 = -((Integer)object4).compareTo((Integer)object3);
        } else if (object3 instanceof Integer) {
            Integer n3 = new Integer(object4.toString());
            n2 = -n3.compareTo((Integer)object3);
        } else if (object4 instanceof Integer) {
            Integer n4 = new Integer(object3.toString());
            n2 = -((Integer)object4).compareTo(n4);
        } else {
            String string = ((String)object4).toLowerCase();
            String string2 = ((String)object3).toLowerCase();
            n2 = string.compareTo(string2);
        }
        return n2 * n;
    }

    public String getFieldName() {
        return this.field;
    }
}

