/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;

public class EntryTypeDialog
extends JDialog
implements ActionListener {
    BibtexEntryType type = null;
    CancelAction cancelAction = new CancelAction();
    private final int COLNUM = 3;

    public EntryTypeDialog(JabRefFrame jabRefFrame) {
        super((Frame)jabRefFrame, true);
        this.setTitle(Globals.lang("Select entry type"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EntryTypeDialog.this.cancelAction.actionPerformed(null);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(Globals.lang("Cancel"));
        jButton.addActionListener(this);
        jButton.getInputMap(2).put(jabRefFrame.prefs.getKey("Close dialog"), "close");
        jButton.getActionMap().put("close", this.cancelAction);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(jPanel2);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGridded(jButton);
        buttonBarBuilder.addGlue();
        this.getContentPane().add((Component)jPanel2, "South");
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        int n = 0;
        Iterator iterator = BibtexEntryType.ALL_TYPES.keySet().iterator();
        while (iterator.hasNext()) {
            BibtexEntryType bibtexEntryType = BibtexEntryType.getType((String)iterator.next());
            TypeButton typeButton = new TypeButton(Util.nCase(bibtexEntryType.getName()), bibtexEntryType);
            typeButton.setAlignmentX(2.0f);
            typeButton.addActionListener(this);
            if (++n == 3) {
                n = 0;
                gridBagConstraints.gridwidth = 0;
            } else {
                gridBagConstraints.gridwidth = 1;
            }
            gridBagLayout.setConstraints(typeButton, gridBagConstraints);
            jPanel.add(typeButton);
        }
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Entry types")));
        this.pack();
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof TypeButton) {
            this.type = ((TypeButton)actionEvent.getSource()).type;
        }
        this.dispose();
    }

    public BibtexEntryType getChoice() {
        return this.type;
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EntryTypeDialog.this.dispose();
        }
    }

    class TypeButton
    extends JButton
    implements Comparable {
        BibtexEntryType type;

        public TypeButton(String string, BibtexEntryType bibtexEntryType) {
            super(string);
            this.type = bibtexEntryType;
        }

        public int compareTo(Object object) {
            if (!(object instanceof TypeButton)) {
                throw new ClassCastException();
            }
            return this.type.getName().compareTo(((TypeButton)object).type.getName());
        }
    }
}

