/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.io.IOException;
import java.io.Writer;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;

public class CustomEntryType
extends BibtexEntryType {
    private String name;
    private String[] req;
    private String[] opt;

    public CustomEntryType(String string, String[] stringArray, String[] stringArray2) {
        this.name = string;
        this.req = stringArray;
        this.opt = stringArray2;
    }

    public CustomEntryType(String string, String string2, String string3) {
        this.name = string;
        this.req = string2.length() == 0 ? new String[0] : string2.split(";");
        this.opt = string3.length() == 0 ? new String[0] : string3.split(";");
    }

    public String getName() {
        return this.name;
    }

    public String[] getOptionalFields() {
        return this.opt;
    }

    public String[] getRequiredFields() {
        return this.req;
    }

    public String describeRequiredFields() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.req.length; ++i) {
            stringBuffer.append(this.req[i]);
            stringBuffer.append(i <= this.req.length - 1 && this.req.length > 1 ? ", " : "");
        }
        return stringBuffer.toString();
    }

    public String describeOptionalFields() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.opt.length; ++i) {
            stringBuffer.append(this.opt[i]);
            stringBuffer.append(i <= this.opt.length - 1 && this.opt.length > 1 ? ", " : "");
        }
        return stringBuffer.toString();
    }

    public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
        for (int i = 0; i < this.req.length; ++i) {
            if (bibtexEntry.getField(this.req[i]) != null) continue;
            return false;
        }
        return true;
    }

    public void save(Writer writer) throws IOException {
        int n;
        writer.write("@comment{");
        writer.write(GUIGlobals.ENTRYTYPE_FLAG);
        writer.write(this.getName());
        writer.write(": req[");
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.req.length; ++n) {
            stringBuffer.append(this.req[n]);
            if (n >= this.req.length - 1) continue;
            stringBuffer.append(";");
        }
        writer.write(stringBuffer.toString());
        writer.write("] opt[");
        stringBuffer = new StringBuffer();
        for (n = 0; n < this.opt.length; ++n) {
            stringBuffer.append(this.opt[n]);
            if (n >= this.opt.length - 1) continue;
            stringBuffer.append(";");
        }
        writer.write(stringBuffer.toString());
        writer.write("]}" + Globals.NEWLINE);
    }

    public static CustomEntryType parseEntryType(String string) {
        try {
            String string2 = string.substring(GUIGlobals.ENTRYTYPE_FLAG.length());
            int n = string2.indexOf(58);
            String string3 = string2.substring(0, n);
            string2 = string2.substring(n + 2);
            int n2 = string2.indexOf(93);
            if (n2 < 4) {
                throw new IndexOutOfBoundsException();
            }
            String string4 = string2.substring(4, n2);
            int n3 = string2.indexOf(93, n2 + 1);
            String string5 = string2.substring(n2 + 6, n3);
            return new CustomEntryType(string3, string4, string5);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Globals.logger("Ill-formed entrytype comment in BibTeX file.");
            return null;
        }
    }
}

